/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl;

public final class AtomicLongMap<K>
implements Serializable {
    @MonotonicNonNullDecl
    private transient Map<K, Long> asMap;
    private final ConcurrentHashMap<K, AtomicLong> map;

    private AtomicLongMap(ConcurrentHashMap<K, AtomicLong> concurrentHashMap) {
        this.map = Preconditions.checkNotNull(concurrentHashMap);
    }

    public static <K> AtomicLongMap<K> create() {
        return new AtomicLongMap(new ConcurrentHashMap());
    }

    public static <K> AtomicLongMap<K> create(Map<? extends K, ? extends Long> map) {
        AtomicLongMap<? extends K> atomicLongMap = AtomicLongMap.create();
        atomicLongMap.putAll(map);
        return atomicLongMap;
    }

    private Map<K, Long> createAsMap() {
        return Collections.unmodifiableMap(Maps.transformValues(this.map, new Function<AtomicLong, Long>(){

            @Override
            public Long apply(AtomicLong atomicLong) {
                return atomicLong.get();
            }
        }));
    }

    public long addAndGet(K k2, long l2) {
        long l3;
        block0: while (true) {
            long l4;
            AtomicLong atomicLong;
            AtomicLong atomicLong2 = atomicLong = this.map.get(k2);
            if (atomicLong == null) {
                atomicLong2 = atomicLong = this.map.putIfAbsent(k2, new AtomicLong(l2));
                if (atomicLong == null) {
                    return l2;
                }
            }
            do {
                if ((l4 = atomicLong2.get()) != 0L) continue;
                if (!this.map.replace(k2, atomicLong2, new AtomicLong(l2))) continue block0;
                return l2;
            } while (!atomicLong2.compareAndSet(l4, l3 = l4 + l2));
            break;
        }
        return l3;
    }

    public Map<K, Long> asMap() {
        Map<K, Long> map;
        Map<K, Long> map2 = map = this.asMap;
        if (map == null) {
            this.asMap = map2 = this.createAsMap();
        }
        return map2;
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    public long decrementAndGet(K k2) {
        return this.addAndGet(k2, -1L);
    }

    public long get(K object) {
        long l2 = (object = this.map.get(object)) == null ? 0L : ((AtomicLong)object).get();
        return l2;
    }

    public long getAndAdd(K k2, long l2) {
        long l3;
        block0: while (true) {
            AtomicLong atomicLong;
            AtomicLong atomicLong2 = atomicLong = this.map.get(k2);
            if (atomicLong == null) {
                atomicLong2 = atomicLong = this.map.putIfAbsent(k2, new AtomicLong(l2));
                if (atomicLong == null) {
                    return 0L;
                }
            }
            do {
                if ((l3 = atomicLong2.get()) != 0L) continue;
                if (!this.map.replace(k2, atomicLong2, new AtomicLong(l2))) continue block0;
                return 0L;
            } while (!atomicLong2.compareAndSet(l3, l3 + l2));
            break;
        }
        return l3;
    }

    public long getAndDecrement(K k2) {
        return this.getAndAdd(k2, -1L);
    }

    public long getAndIncrement(K k2) {
        return this.getAndAdd(k2, 1L);
    }

    public long incrementAndGet(K k2) {
        return this.addAndGet(k2, 1L);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public long put(K k2, long l2) {
        long l3;
        block0: while (true) {
            AtomicLong atomicLong;
            AtomicLong atomicLong2 = atomicLong = this.map.get(k2);
            if (atomicLong == null) {
                atomicLong2 = atomicLong = this.map.putIfAbsent(k2, new AtomicLong(l2));
                if (atomicLong == null) {
                    return 0L;
                }
            }
            do {
                if ((l3 = atomicLong2.get()) != 0L) continue;
                if (!this.map.replace(k2, atomicLong2, new AtomicLong(l2))) continue block0;
                return 0L;
            } while (!atomicLong2.compareAndSet(l3, l2));
            break;
        }
        return l3;
    }

    public void putAll(Map<? extends K, ? extends Long> object) {
        for (Map.Entry entry : object.entrySet()) {
            this.put(entry.getKey(), (Long)entry.getValue());
        }
    }

    long putIfAbsent(K k2, long l2) {
        long l3;
        block3: {
            AtomicLong atomicLong;
            do {
                AtomicLong atomicLong2;
                atomicLong = atomicLong2 = this.map.get(k2);
                if (atomicLong2 == null) {
                    atomicLong = atomicLong2 = this.map.putIfAbsent(k2, new AtomicLong(l2));
                    if (atomicLong2 == null) {
                        return 0L;
                    }
                }
                if ((l3 = atomicLong.get()) != 0L) break block3;
            } while (!this.map.replace(k2, atomicLong, new AtomicLong(l2)));
            return 0L;
        }
        return l3;
    }

    public long remove(K k2) {
        long l2;
        AtomicLong atomicLong = this.map.get(k2);
        if (atomicLong == null) {
            return 0L;
        }
        while ((l2 = atomicLong.get()) != 0L && !atomicLong.compareAndSet(l2, 0L)) {
        }
        this.map.remove(k2, atomicLong);
        return l2;
    }

    boolean remove(K k2, long l2) {
        AtomicLong atomicLong = this.map.get(k2);
        if (atomicLong == null) {
            return false;
        }
        long l3 = atomicLong.get();
        if (l3 != l2) {
            return false;
        }
        if (l3 != 0L && !atomicLong.compareAndSet(l3, 0L)) {
            return false;
        }
        this.map.remove(k2, atomicLong);
        return true;
    }

    public void removeAllZeros() {
        Iterator<Map.Entry<K, AtomicLong>> iterator2 = this.map.entrySet().iterator();
        while (iterator2.hasNext()) {
            AtomicLong atomicLong = iterator2.next().getValue();
            if (atomicLong == null || atomicLong.get() != 0L) continue;
            iterator2.remove();
        }
    }

    public boolean removeIfZero(K k2) {
        return this.remove(k2, 0L);
    }

    boolean replace(K object, long l2, long l3) {
        boolean bl = false;
        boolean bl2 = false;
        if (l2 == 0L) {
            if (this.putIfAbsent(object, l3) == 0L) {
                bl2 = true;
            }
            return bl2;
        }
        bl2 = (object = this.map.get(object)) == null ? bl : ((AtomicLong)object).compareAndSet(l2, l3);
        return bl2;
    }

    public int size() {
        return this.map.size();
    }

    public long sum() {
        Iterator<AtomicLong> iterator2 = this.map.values().iterator();
        long l2 = 0L;
        while (iterator2.hasNext()) {
            l2 += iterator2.next().get();
        }
        return l2;
    }

    public String toString() {
        return this.map.toString();
    }
}

