/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class AggregateFutureState {
    private static final AtomicHelper ATOMIC_HELPER;
    private static final Logger log;
    private volatile int remaining;
    private volatile Set<Throwable> seenExceptions = null;

    static {
        Throwable throwable;
        AtomicHelper atomicHelper;
        log = Logger.getLogger(AggregateFutureState.class.getName());
        try {
            atomicHelper = new SafeAtomicHelper(AtomicReferenceFieldUpdater.newUpdater(AggregateFutureState.class, Set.class, "seenExceptions"), AtomicIntegerFieldUpdater.newUpdater(AggregateFutureState.class, "remaining"));
            throwable = null;
        }
        catch (Throwable throwable2) {
            atomicHelper = new SynchronizedAtomicHelper();
        }
        ATOMIC_HELPER = atomicHelper;
        if (throwable != null) {
            log.log(Level.SEVERE, "SafeAtomicHelper is broken!", throwable);
        }
    }

    AggregateFutureState(int n2) {
        this.remaining = n2;
    }

    static /* synthetic */ Set access$202(AggregateFutureState aggregateFutureState, Set set) {
        aggregateFutureState.seenExceptions = set;
        return set;
    }

    static /* synthetic */ int access$310(AggregateFutureState aggregateFutureState) {
        int n2 = aggregateFutureState.remaining;
        aggregateFutureState.remaining = n2 - 1;
        return n2;
    }

    abstract void addInitialException(Set<Throwable> var1);

    final int decrementRemainingAndGet() {
        return ATOMIC_HELPER.decrementAndGetRemainingCount(this);
    }

    final Set<Throwable> getOrInitSeenExceptions() {
        Set<Throwable> set;
        Set<Throwable> set2 = set = this.seenExceptions;
        if (set == null) {
            set2 = Sets.newConcurrentHashSet();
            this.addInitialException(set2);
            ATOMIC_HELPER.compareAndSetSeenExceptions(this, null, set2);
            set2 = this.seenExceptions;
        }
        return set2;
    }

    private static abstract class AtomicHelper {
        private AtomicHelper() {
        }

        abstract void compareAndSetSeenExceptions(AggregateFutureState var1, Set<Throwable> var2, Set<Throwable> var3);

        abstract int decrementAndGetRemainingCount(AggregateFutureState var1);
    }

    private static final class SafeAtomicHelper
    extends AtomicHelper {
        final AtomicIntegerFieldUpdater<AggregateFutureState> remainingCountUpdater;
        final AtomicReferenceFieldUpdater<AggregateFutureState, Set<Throwable>> seenExceptionsUpdater;

        SafeAtomicHelper(AtomicReferenceFieldUpdater atomicReferenceFieldUpdater, AtomicIntegerFieldUpdater atomicIntegerFieldUpdater) {
            this.seenExceptionsUpdater = atomicReferenceFieldUpdater;
            this.remainingCountUpdater = atomicIntegerFieldUpdater;
        }

        @Override
        void compareAndSetSeenExceptions(AggregateFutureState aggregateFutureState, Set<Throwable> set, Set<Throwable> set2) {
            this.seenExceptionsUpdater.compareAndSet(aggregateFutureState, set, set2);
        }

        @Override
        int decrementAndGetRemainingCount(AggregateFutureState aggregateFutureState) {
            return this.remainingCountUpdater.decrementAndGet(aggregateFutureState);
        }
    }

    private static final class SynchronizedAtomicHelper
    extends AtomicHelper {
        private SynchronizedAtomicHelper() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        void compareAndSetSeenExceptions(AggregateFutureState aggregateFutureState, Set<Throwable> set, Set<Throwable> set2) {
            synchronized (aggregateFutureState) {
                if (aggregateFutureState.seenExceptions == set) {
                    AggregateFutureState.access$202(aggregateFutureState, set2);
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        int decrementAndGetRemainingCount(AggregateFutureState aggregateFutureState) {
            synchronized (aggregateFutureState) {
                AggregateFutureState.access$310(aggregateFutureState);
                return aggregateFutureState.remaining;
            }
        }
    }
}

