/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.AggregateFutureState;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

abstract class AggregateFuture<InputT, OutputT>
extends AbstractFuture.TrustedFuture<OutputT> {
    private static final Logger logger = Logger.getLogger(AggregateFuture.class.getName());
    @NullableDecl
    private RunningState runningState;

    AggregateFuture() {
    }

    static /* synthetic */ RunningState access$602(AggregateFuture aggregateFuture, RunningState runningState) {
        aggregateFuture.runningState = runningState;
        return runningState;
    }

    private static boolean addCausalChain(Set<Throwable> set, Throwable throwable) {
        while (throwable != null) {
            if (!set.add(throwable)) {
                return false;
            }
            throwable = throwable.getCause();
        }
        return true;
    }

    @Override
    protected final void afterDone() {
        super.afterDone();
        RunningState runningState = this.runningState;
        if (runningState != null) {
            boolean bl;
            boolean bl2;
            this.runningState = null;
            Object object = runningState.futures;
            boolean bl3 = this.wasInterrupted();
            if (bl3) {
                runningState.interruptTask();
            }
            if ((bl2 = this.isCancelled()) & (bl = object != null)) {
                object = ((ImmutableCollection)object).iterator();
                while (object.hasNext()) {
                    ((ListenableFuture)object.next()).cancel(bl3);
                }
            }
        }
    }

    final void init(RunningState runningState) {
        this.runningState = runningState;
        runningState.init();
    }

    @Override
    protected String pendingToString() {
        Object object = this.runningState;
        if (object == null) {
            return null;
        }
        if ((object = ((RunningState)object).futures) != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("futures=[");
            stringBuilder.append(object);
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
        return null;
    }

    abstract class RunningState
    extends AggregateFutureState
    implements Runnable {
        private final boolean allMustSucceed;
        private final boolean collectsValues;
        private ImmutableCollection<? extends ListenableFuture<? extends InputT>> futures;

        RunningState(ImmutableCollection<? extends ListenableFuture<? extends InputT>> immutableCollection, boolean bl, boolean bl2) {
            super(immutableCollection.size());
            this.futures = Preconditions.checkNotNull(immutableCollection);
            this.allMustSucceed = bl;
            this.collectsValues = bl2;
        }

        private void decrementCountAndMaybeComplete() {
            int n2 = this.decrementRemainingAndGet();
            boolean bl = n2 >= 0;
            Preconditions.checkState(bl, "Less than 0 remaining futures");
            if (n2 == 0) {
                this.processCompleted();
            }
        }

        private void handleException(Throwable throwable) {
            boolean bl;
            boolean bl2;
            block4: {
                block3: {
                    block1: {
                        block2: {
                            Preconditions.checkNotNull(throwable);
                            if (!this.allMustSucceed) break block1;
                            bl2 = AggregateFuture.this.setException(throwable);
                            if (!bl2) break block2;
                            this.releaseResourcesAfterFailure();
                            break block3;
                        }
                        bl = AggregateFuture.addCausalChain(this.getOrInitSeenExceptions(), throwable);
                        break block4;
                    }
                    bl2 = false;
                }
                bl = true;
            }
            boolean bl3 = throwable instanceof Error;
            if ((bl2 ^ true) & this.allMustSucceed & bl | bl3) {
                String string2 = bl3 ? "Input Future failed with Error" : "Got more than one input Future failure. Logging failures after the first";
                logger.log(Level.SEVERE, string2, throwable);
            }
        }

        private void handleOneInputDone(int n2, Future<? extends InputT> future) {
            boolean bl = this.allMustSucceed || !AggregateFuture.this.isDone() || AggregateFuture.this.isCancelled();
            Preconditions.checkState(bl, "Future was done before all dependencies completed");
            try {
                Preconditions.checkState(future.isDone(), "Tried to set value from future which is not done");
                if (this.allMustSucceed) {
                    if (future.isCancelled()) {
                        AggregateFuture.access$602(AggregateFuture.this, null);
                        AggregateFuture.this.cancel(false);
                    } else {
                        future = Futures.getDone(future);
                        if (this.collectsValues) {
                            this.collectOneValue(this.allMustSucceed, n2, future);
                        }
                    }
                } else if (this.collectsValues && !future.isCancelled()) {
                    this.collectOneValue(this.allMustSucceed, n2, Futures.getDone(future));
                }
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
            catch (ExecutionException executionException) {
                this.handleException(executionException.getCause());
            }
        }

        private void init() {
            if (this.futures.isEmpty()) {
                this.handleAllCompleted();
                return;
            }
            if (this.allMustSucceed) {
                final int n2 = 0;
                for (final ListenableFuture listenableFuture : this.futures) {
                    listenableFuture.addListener(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                RunningState.this.handleOneInputDone(n2, listenableFuture);
                                return;
                            }
                            finally {
                                RunningState.this.decrementCountAndMaybeComplete();
                            }
                        }
                    }, MoreExecutors.directExecutor());
                    ++n2;
                }
            } else {
                Iterator iterator2 = this.futures.iterator();
                while (iterator2.hasNext()) {
                    ((ListenableFuture)iterator2.next()).addListener(this, MoreExecutors.directExecutor());
                }
            }
        }

        private void processCompleted() {
            if (this.collectsValues & (this.allMustSucceed ^ true)) {
                int n2 = 0;
                Iterator iterator2 = this.futures.iterator();
                while (iterator2.hasNext()) {
                    this.handleOneInputDone(n2, (ListenableFuture)iterator2.next());
                    ++n2;
                }
            }
            this.handleAllCompleted();
        }

        @Override
        final void addInitialException(Set<Throwable> set) {
            if (!AggregateFuture.this.isCancelled()) {
                AggregateFuture.addCausalChain(set, AggregateFuture.this.tryInternalFastPathGetFailure());
            }
        }

        abstract void collectOneValue(boolean var1, int var2, @NullableDecl InputT var3);

        abstract void handleAllCompleted();

        void interruptTask() {
        }

        void releaseResourcesAfterFailure() {
            this.futures = null;
        }

        @Override
        public final void run() {
            this.decrementCountAndMaybeComplete();
        }
    }
}

