/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenerCallQueue;
import com.google.common.util.concurrent.Monitor;
import com.google.common.util.concurrent.Service;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class AbstractService
implements Service {
    private static final ListenerCallQueue.Event<Service.Listener> RUNNING_EVENT;
    private static final ListenerCallQueue.Event<Service.Listener> STARTING_EVENT;
    private static final ListenerCallQueue.Event<Service.Listener> STOPPING_FROM_RUNNING_EVENT;
    private static final ListenerCallQueue.Event<Service.Listener> STOPPING_FROM_STARTING_EVENT;
    private static final ListenerCallQueue.Event<Service.Listener> TERMINATED_FROM_NEW_EVENT;
    private static final ListenerCallQueue.Event<Service.Listener> TERMINATED_FROM_RUNNING_EVENT;
    private static final ListenerCallQueue.Event<Service.Listener> TERMINATED_FROM_STARTING_EVENT;
    private static final ListenerCallQueue.Event<Service.Listener> TERMINATED_FROM_STOPPING_EVENT;
    private final Monitor.Guard hasReachedRunning;
    private final Monitor.Guard isStartable;
    private final Monitor.Guard isStoppable;
    private final Monitor.Guard isStopped;
    private final ListenerCallQueue<Service.Listener> listeners;
    private final Monitor monitor = new Monitor();
    private volatile StateSnapshot snapshot;

    static {
        STARTING_EVENT = new ListenerCallQueue.Event<Service.Listener>(){

            public void call(Service.Listener listener2) {
                listener2.starting();
            }

            public String toString() {
                return "starting()";
            }
        };
        RUNNING_EVENT = new ListenerCallQueue.Event<Service.Listener>(){

            public void call(Service.Listener listener2) {
                listener2.running();
            }

            public String toString() {
                return "running()";
            }
        };
        STOPPING_FROM_STARTING_EVENT = AbstractService.stoppingEvent(Service.State.STARTING);
        STOPPING_FROM_RUNNING_EVENT = AbstractService.stoppingEvent(Service.State.RUNNING);
        TERMINATED_FROM_NEW_EVENT = AbstractService.terminatedEvent(Service.State.NEW);
        TERMINATED_FROM_STARTING_EVENT = AbstractService.terminatedEvent(Service.State.STARTING);
        TERMINATED_FROM_RUNNING_EVENT = AbstractService.terminatedEvent(Service.State.RUNNING);
        TERMINATED_FROM_STOPPING_EVENT = AbstractService.terminatedEvent(Service.State.STOPPING);
    }

    protected AbstractService() {
        this.isStartable = new IsStartableGuard();
        this.isStoppable = new IsStoppableGuard();
        this.hasReachedRunning = new HasReachedRunningGuard();
        this.isStopped = new IsStoppedGuard();
        this.listeners = new ListenerCallQueue();
        this.snapshot = new StateSnapshot(Service.State.NEW);
    }

    private void checkCurrentState(Service.State state) {
        Object object = this.state();
        if (object != state) {
            if (object == Service.State.FAILED) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Expected the service ");
                ((StringBuilder)object).append(this);
                ((StringBuilder)object).append(" to be ");
                ((StringBuilder)object).append((Object)state);
                ((StringBuilder)object).append(", but the service has FAILED");
                throw new IllegalStateException(((StringBuilder)object).toString(), this.failureCause());
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Expected the service ");
            stringBuilder.append(this);
            stringBuilder.append(" to be ");
            stringBuilder.append((Object)state);
            stringBuilder.append(", but was ");
            stringBuilder.append(object);
            throw new IllegalStateException(stringBuilder.toString());
        }
    }

    private void dispatchListenerEvents() {
        if (!this.monitor.isOccupiedByCurrentThread()) {
            this.listeners.dispatch();
        }
    }

    private void enqueueFailedEvent(final Service.State state, final Throwable throwable) {
        this.listeners.enqueue((ListenerCallQueue.Event)new ListenerCallQueue.Event<Service.Listener>(){

            public void call(Service.Listener listener2) {
                listener2.failed(state, throwable);
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("failed({from = ");
                stringBuilder.append((Object)state);
                stringBuilder.append(", cause = ");
                stringBuilder.append(throwable);
                stringBuilder.append("})");
                return stringBuilder.toString();
            }
        });
    }

    private void enqueueRunningEvent() {
        this.listeners.enqueue(RUNNING_EVENT);
    }

    private void enqueueStartingEvent() {
        this.listeners.enqueue(STARTING_EVENT);
    }

    private void enqueueStoppingEvent(Service.State state) {
        block4: {
            block3: {
                block2: {
                    if (state != Service.State.STARTING) break block2;
                    this.listeners.enqueue(STOPPING_FROM_STARTING_EVENT);
                    break block3;
                }
                if (state != Service.State.RUNNING) break block4;
                this.listeners.enqueue(STOPPING_FROM_RUNNING_EVENT);
            }
            return;
        }
        throw new AssertionError();
    }

    private void enqueueTerminatedEvent(Service.State state) {
        switch (6.$SwitchMap$com$google$common$util$concurrent$Service$State[state.ordinal()]) {
            default: {
                break;
            }
            case 5: 
            case 6: {
                throw new AssertionError();
            }
            case 4: {
                this.listeners.enqueue(TERMINATED_FROM_STOPPING_EVENT);
                break;
            }
            case 3: {
                this.listeners.enqueue(TERMINATED_FROM_RUNNING_EVENT);
                break;
            }
            case 2: {
                this.listeners.enqueue(TERMINATED_FROM_STARTING_EVENT);
                break;
            }
            case 1: {
                this.listeners.enqueue(TERMINATED_FROM_NEW_EVENT);
            }
        }
    }

    private static ListenerCallQueue.Event<Service.Listener> stoppingEvent(final Service.State state) {
        return new ListenerCallQueue.Event<Service.Listener>(){

            public void call(Service.Listener listener2) {
                listener2.stopping(state);
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("stopping({from = ");
                stringBuilder.append((Object)state);
                stringBuilder.append("})");
                return stringBuilder.toString();
            }
        };
    }

    private static ListenerCallQueue.Event<Service.Listener> terminatedEvent(final Service.State state) {
        return new ListenerCallQueue.Event<Service.Listener>(){

            public void call(Service.Listener listener2) {
                listener2.terminated(state);
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("terminated({from = ");
                stringBuilder.append((Object)state);
                stringBuilder.append("})");
                return stringBuilder.toString();
            }
        };
    }

    @Override
    public final void addListener(Service.Listener listener2, Executor executor) {
        this.listeners.addListener((Object)listener2, executor);
    }

    @Override
    public final void awaitRunning() {
        this.monitor.enterWhenUninterruptibly(this.hasReachedRunning);
        try {
            this.checkCurrentState(Service.State.RUNNING);
            return;
        }
        finally {
            this.monitor.leave();
        }
    }

    @Override
    public final void awaitRunning(long l2, TimeUnit object) throws TimeoutException {
        if (this.monitor.enterWhenUninterruptibly(this.hasReachedRunning, l2, (TimeUnit)((Object)object))) {
            try {
                this.checkCurrentState(Service.State.RUNNING);
                return;
            }
            finally {
                this.monitor.leave();
            }
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Timed out waiting for ");
        ((StringBuilder)object).append(this);
        ((StringBuilder)object).append(" to reach the RUNNING state.");
        throw new TimeoutException(((StringBuilder)object).toString());
    }

    @Override
    public final void awaitTerminated() {
        this.monitor.enterWhenUninterruptibly(this.isStopped);
        try {
            this.checkCurrentState(Service.State.TERMINATED);
            return;
        }
        finally {
            this.monitor.leave();
        }
    }

    @Override
    public final void awaitTerminated(long l2, TimeUnit object) throws TimeoutException {
        if (this.monitor.enterWhenUninterruptibly(this.isStopped, l2, (TimeUnit)((Object)object))) {
            try {
                this.checkCurrentState(Service.State.TERMINATED);
                return;
            }
            finally {
                this.monitor.leave();
            }
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Timed out waiting for ");
        ((StringBuilder)object).append(this);
        ((StringBuilder)object).append(" to reach a terminal state. Current state: ");
        ((StringBuilder)object).append((Object)this.state());
        throw new TimeoutException(((StringBuilder)object).toString());
    }

    protected void doCancelStart() {
    }

    protected abstract void doStart();

    protected abstract void doStop();

    @Override
    public final Throwable failureCause() {
        return this.snapshot.failureCause();
    }

    @Override
    public final boolean isRunning() {
        boolean bl = this.state() == Service.State.RUNNING;
        return bl;
    }

    protected final void notifyFailed(Throwable throwable) {
        Service.State state;
        block6: {
            StateSnapshot stateSnapshot;
            block7: {
                Preconditions.checkNotNull(throwable);
                this.monitor.enter();
                state = this.state();
                int n2 = 6.$SwitchMap$com$google$common$util$concurrent$Service$State[state.ordinal()];
                if (n2 == 1) break block6;
                if (n2 == 2 || n2 == 3 || n2 == 4) break block7;
                if (n2 != 5) {
                }
                break block6;
            }
            this.snapshot = stateSnapshot = new StateSnapshot(Service.State.FAILED, false, throwable);
            this.enqueueFailedEvent(state, throwable);
            return;
        }
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Failed while in state:");
            stringBuilder.append((Object)state);
            IllegalStateException illegalStateException = new IllegalStateException(stringBuilder.toString(), throwable);
            throw illegalStateException;
        }
        finally {
            this.monitor.leave();
            this.dispatchListenerEvents();
        }
    }

    protected final void notifyStarted() {
        this.monitor.enter();
        try {
            if (this.snapshot.state == Service.State.STARTING) {
                if (this.snapshot.shutdownWhenStartupFinishes) {
                    StateSnapshot stateSnapshot;
                    this.snapshot = stateSnapshot = new StateSnapshot(Service.State.STOPPING);
                    this.doStop();
                } else {
                    StateSnapshot stateSnapshot;
                    this.snapshot = stateSnapshot = new StateSnapshot(Service.State.RUNNING);
                    this.enqueueRunningEvent();
                }
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Cannot notifyStarted() when the service is ");
            stringBuilder.append((Object)this.snapshot.state);
            IllegalStateException illegalStateException = new IllegalStateException(stringBuilder.toString());
            this.notifyFailed(illegalStateException);
            throw illegalStateException;
        }
        finally {
            this.monitor.leave();
            this.dispatchListenerEvents();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void notifyStopped() {
        this.monitor.enter();
        try {
            Service.State state = this.state();
            switch (6.$SwitchMap$com$google$common$util$concurrent$Service$State[state.ordinal()]) {
                default: {
                    return;
                }
                case 2: 
                case 3: 
                case 4: {
                    StateSnapshot stateSnapshot;
                    this.snapshot = stateSnapshot = new StateSnapshot(Service.State.TERMINATED);
                    this.enqueueTerminatedEvent(state);
                    return;
                }
                case 1: 
                case 5: 
                case 6: {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Cannot notifyStopped() when the service is ");
                    stringBuilder.append((Object)state);
                    IllegalStateException illegalStateException = new IllegalStateException(stringBuilder.toString());
                    throw illegalStateException;
                }
            }
        }
        finally {
            this.monitor.leave();
            this.dispatchListenerEvents();
        }
    }

    @Override
    public final Service startAsync() {
        if (this.monitor.enterIf(this.isStartable)) {
            try {
                StateSnapshot stateSnapshot;
                this.snapshot = stateSnapshot = new StateSnapshot(Service.State.STARTING);
                this.enqueueStartingEvent();
                this.doStart();
            }
            catch (Throwable throwable) {
                this.notifyFailed(throwable);
            }
            return this;
            {
                finally {
                    this.monitor.leave();
                    this.dispatchListenerEvents();
                }
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Service ");
        stringBuilder.append(this);
        stringBuilder.append(" has already been started");
        throw new IllegalStateException(stringBuilder.toString());
    }

    @Override
    public final Service.State state() {
        return this.snapshot.externalState();
    }

    @Override
    public final Service stopAsync() {
        if (this.monitor.enterIf(this.isStoppable)) {
            try {
                Service.State state = this.state();
                switch (6.$SwitchMap$com$google$common$util$concurrent$Service$State[state.ordinal()]) {
                    default: {
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("isStoppable is incorrectly implemented, saw: ");
                        stringBuilder.append((Object)state);
                        AssertionError assertionError = new AssertionError((Object)stringBuilder.toString());
                        throw assertionError;
                    }
                    case 3: {
                        StateSnapshot stateSnapshot;
                        this.snapshot = stateSnapshot = new StateSnapshot(Service.State.STOPPING);
                        this.enqueueStoppingEvent(Service.State.RUNNING);
                        this.doStop();
                        break;
                    }
                    case 2: {
                        StateSnapshot stateSnapshot;
                        this.snapshot = stateSnapshot = new StateSnapshot(Service.State.STARTING, true, null);
                        this.enqueueStoppingEvent(Service.State.STARTING);
                        this.doCancelStart();
                        break;
                    }
                    case 1: {
                        StateSnapshot stateSnapshot;
                        this.snapshot = stateSnapshot = new StateSnapshot(Service.State.TERMINATED);
                        this.enqueueTerminatedEvent(Service.State.NEW);
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    this.notifyFailed(throwable);
                }
                finally {
                    this.monitor.leave();
                    this.dispatchListenerEvents();
                }
            }
        }
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(" [");
        stringBuilder.append((Object)this.state());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private final class HasReachedRunningGuard
    extends Monitor.Guard {
        HasReachedRunningGuard() {
            super(AbstractService.this.monitor);
        }

        @Override
        public boolean isSatisfied() {
            boolean bl = AbstractService.this.state().compareTo(Service.State.RUNNING) >= 0;
            return bl;
        }
    }

    private final class IsStartableGuard
    extends Monitor.Guard {
        IsStartableGuard() {
            super(AbstractService.this.monitor);
        }

        @Override
        public boolean isSatisfied() {
            boolean bl = AbstractService.this.state() == Service.State.NEW;
            return bl;
        }
    }

    private final class IsStoppableGuard
    extends Monitor.Guard {
        IsStoppableGuard() {
            super(AbstractService.this.monitor);
        }

        @Override
        public boolean isSatisfied() {
            boolean bl = AbstractService.this.state().compareTo(Service.State.RUNNING) <= 0;
            return bl;
        }
    }

    private final class IsStoppedGuard
    extends Monitor.Guard {
        IsStoppedGuard() {
            super(AbstractService.this.monitor);
        }

        @Override
        public boolean isSatisfied() {
            return AbstractService.this.state().isTerminal();
        }
    }

    private static final class StateSnapshot {
        @NullableDecl
        final Throwable failure;
        final boolean shutdownWhenStartupFinishes;
        final Service.State state;

        StateSnapshot(Service.State state) {
            this(state, false, null);
        }

        StateSnapshot(Service.State state, boolean bl, @NullableDecl Throwable throwable) {
            boolean bl2 = false;
            boolean bl3 = !bl || state == Service.State.STARTING;
            Preconditions.checkArgument(bl3, "shutdownWhenStartupFinishes can only be set if state is STARTING. Got %s instead.", (Object)state);
            boolean bl4 = throwable != null;
            if (state == Service.State.FAILED) {
                bl2 = true;
            }
            Preconditions.checkArgument(bl2 ^ bl4 ^ true, "A failure cause should be set if and only if the state is failed.  Got %s and %s instead.", (Object)state, (Object)throwable);
            this.state = state;
            this.shutdownWhenStartupFinishes = bl;
            this.failure = throwable;
        }

        Service.State externalState() {
            if (this.shutdownWhenStartupFinishes && this.state == Service.State.STARTING) {
                return Service.State.STOPPING;
            }
            return this.state;
        }

        Throwable failureCause() {
            boolean bl = this.state == Service.State.FAILED;
            Preconditions.checkState(bl, "failureCause() is only valid if the service has failed, service is %s", (Object)this.state);
            return this.failure;
        }
    }
}

