/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.AbstractService;
import com.google.common.util.concurrent.ForwardingFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Service;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class AbstractScheduledService
implements Service {
    private static final Logger logger = Logger.getLogger(AbstractScheduledService.class.getName());
    private final AbstractService delegate = new ServiceDelegate();

    protected AbstractScheduledService() {
    }

    @Override
    public final void addListener(Service.Listener listener2, Executor executor) {
        this.delegate.addListener(listener2, executor);
    }

    @Override
    public final void awaitRunning() {
        this.delegate.awaitRunning();
    }

    @Override
    public final void awaitRunning(long l2, TimeUnit timeUnit) throws TimeoutException {
        this.delegate.awaitRunning(l2, timeUnit);
    }

    @Override
    public final void awaitTerminated() {
        this.delegate.awaitTerminated();
    }

    @Override
    public final void awaitTerminated(long l2, TimeUnit timeUnit) throws TimeoutException {
        this.delegate.awaitTerminated(l2, timeUnit);
    }

    protected ScheduledExecutorService executor() {
        final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new 1ThreadFactoryImpl());
        this.addListener(new Service.Listener(){

            @Override
            public void failed(Service.State state, Throwable throwable) {
                scheduledExecutorService.shutdown();
            }

            @Override
            public void terminated(Service.State state) {
                scheduledExecutorService.shutdown();
            }
        }, MoreExecutors.directExecutor());
        return scheduledExecutorService;
    }

    @Override
    public final Throwable failureCause() {
        return this.delegate.failureCause();
    }

    @Override
    public final boolean isRunning() {
        return this.delegate.isRunning();
    }

    protected abstract void runOneIteration() throws Exception;

    protected abstract Scheduler scheduler();

    protected String serviceName() {
        return this.getClass().getSimpleName();
    }

    protected void shutDown() throws Exception {
    }

    @Override
    public final Service startAsync() {
        this.delegate.startAsync();
        return this;
    }

    protected void startUp() throws Exception {
    }

    @Override
    public final Service.State state() {
        return this.delegate.state();
    }

    @Override
    public final Service stopAsync() {
        this.delegate.stopAsync();
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.serviceName());
        stringBuilder.append(" [");
        stringBuilder.append((Object)this.state());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    class 1ThreadFactoryImpl
    implements ThreadFactory {
        1ThreadFactoryImpl() {
        }

        @Override
        public Thread newThread(Runnable runnable2) {
            return MoreExecutors.newThread((String)AbstractScheduledService.this.serviceName(), (Runnable)runnable2);
        }
    }

    public static abstract class CustomScheduler
    extends Scheduler {
        protected abstract Schedule getNextSchedule() throws Exception;

        @Override
        final Future<?> schedule(AbstractService object, ScheduledExecutorService scheduledExecutorService, Runnable runnable2) {
            object = new ReschedulableCallable((AbstractService)object, scheduledExecutorService, runnable2);
            ((ReschedulableCallable)object).reschedule();
            return object;
        }

        private class ReschedulableCallable
        extends ForwardingFuture<Void>
        implements Callable<Void> {
            @NullableDecl
            private Future<Void> currentFuture;
            private final ScheduledExecutorService executor;
            private final ReentrantLock lock = new ReentrantLock();
            private final AbstractService service;
            private final Runnable wrappedRunnable;

            ReschedulableCallable(AbstractService abstractService, ScheduledExecutorService scheduledExecutorService, Runnable runnable2) {
                this.wrappedRunnable = runnable2;
                this.executor = scheduledExecutorService;
                this.service = abstractService;
            }

            @Override
            public Void call() throws Exception {
                this.wrappedRunnable.run();
                this.reschedule();
                return null;
            }

            @Override
            public boolean cancel(boolean bl) {
                this.lock.lock();
                try {
                    bl = this.currentFuture.cancel(bl);
                    return bl;
                }
                finally {
                    this.lock.unlock();
                }
            }

            @Override
            protected Future<Void> delegate() {
                throw new UnsupportedOperationException("Only cancel and isCancelled is supported by this future");
            }

            @Override
            public boolean isCancelled() {
                this.lock.lock();
                try {
                    boolean bl = this.currentFuture.isCancelled();
                    return bl;
                }
                finally {
                    this.lock.unlock();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void reschedule() {
                Throwable throwable;
                block7: {
                    Throwable throwable2;
                    Schedule schedule2;
                    try {
                        schedule2 = CustomScheduler.this.getNextSchedule();
                        throwable2 = null;
                        this.lock.lock();
                    }
                    catch (Throwable throwable3) {
                        this.service.notifyFailed(throwable3);
                        return;
                    }
                    try {
                        if (this.currentFuture != null) {
                            throwable = throwable2;
                            if (this.currentFuture.isCancelled()) break block7;
                        }
                        this.currentFuture = this.executor.schedule(this, schedule2.delay, schedule2.unit);
                        throwable = throwable2;
                    }
                    catch (Throwable throwable4) {
                        // empty catch block
                    }
                }
                this.lock.unlock();
                if (throwable != null) {
                    this.service.notifyFailed(throwable);
                }
            }
        }

        protected static final class Schedule {
            private final long delay;
            private final TimeUnit unit;

            public Schedule(long l2, TimeUnit timeUnit) {
                this.delay = l2;
                this.unit = Preconditions.checkNotNull(timeUnit);
            }
        }
    }

    public static abstract class Scheduler {
        private Scheduler() {
        }

        public static Scheduler newFixedDelaySchedule(final long l2, final long l3, final TimeUnit timeUnit) {
            Preconditions.checkNotNull(timeUnit);
            boolean bl = l3 > 0L;
            Preconditions.checkArgument(bl, "delay must be > 0, found %s", l3);
            return new Scheduler(){

                @Override
                public Future<?> schedule(AbstractService abstractService, ScheduledExecutorService scheduledExecutorService, Runnable runnable2) {
                    return scheduledExecutorService.scheduleWithFixedDelay(runnable2, l2, l3, timeUnit);
                }
            };
        }

        public static Scheduler newFixedRateSchedule(final long l2, final long l3, final TimeUnit timeUnit) {
            Preconditions.checkNotNull(timeUnit);
            boolean bl = l3 > 0L;
            Preconditions.checkArgument(bl, "period must be > 0, found %s", l3);
            return new Scheduler(){

                @Override
                public Future<?> schedule(AbstractService abstractService, ScheduledExecutorService scheduledExecutorService, Runnable runnable2) {
                    return scheduledExecutorService.scheduleAtFixedRate(runnable2, l2, l3, timeUnit);
                }
            };
        }

        abstract Future<?> schedule(AbstractService var1, ScheduledExecutorService var2, Runnable var3);
    }

    private final class ServiceDelegate
    extends AbstractService {
        @MonotonicNonNullDecl
        private volatile ScheduledExecutorService executorService;
        private final ReentrantLock lock = new ReentrantLock();
        @MonotonicNonNullDecl
        private volatile Future<?> runningTask;
        private final Runnable task = new Task();

        private ServiceDelegate() {
        }

        static /* synthetic */ Future access$302(ServiceDelegate serviceDelegate, Future future) {
            serviceDelegate.runningTask = future;
            return future;
        }

        @Override
        protected final void doStart() {
            this.executorService = MoreExecutors.renamingDecorator((ScheduledExecutorService)AbstractScheduledService.this.executor(), (Supplier)new Supplier<String>(){

                @Override
                public String get() {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(AbstractScheduledService.this.serviceName());
                    stringBuilder.append(" ");
                    stringBuilder.append((Object)ServiceDelegate.this.state());
                    return stringBuilder.toString();
                }
            });
            this.executorService.execute(new Runnable(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    ServiceDelegate.this.lock.lock();
                    try {
                        AbstractScheduledService.this.startUp();
                        ServiceDelegate.access$302(ServiceDelegate.this, AbstractScheduledService.this.scheduler().schedule(AbstractScheduledService.this.delegate, ServiceDelegate.this.executorService, ServiceDelegate.this.task));
                        ServiceDelegate.this.notifyStarted();
                        return;
                    }
                    catch (Throwable throwable) {
                        ServiceDelegate.this.notifyFailed(throwable);
                        if (ServiceDelegate.this.runningTask == null) return;
                        ServiceDelegate.this.runningTask.cancel(false);
                    }
                    return;
                    {
                        finally {
                            ServiceDelegate.this.lock.unlock();
                        }
                    }
                }
            });
        }

        @Override
        protected final void doStop() {
            this.runningTask.cancel(false);
            this.executorService.execute(new Runnable(){

                /*
                 * Loose catch block
                 */
                @Override
                public void run() {
                    block8: {
                        ServiceDelegate.this.lock.lock();
                        Service.State state = ServiceDelegate.this.state();
                        Service.State state2 = Service.State.STOPPING;
                        if (state == state2) break block8;
                        ServiceDelegate.this.lock.unlock();
                        return;
                    }
                    AbstractScheduledService.this.shutDown();
                    ServiceDelegate.this.lock.unlock();
                    ServiceDelegate.this.notifyStopped();
                    catch (Throwable throwable) {
                        try {
                            ServiceDelegate.this.lock.unlock();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            ServiceDelegate.this.notifyFailed(throwable2);
                        }
                    }
                }
            });
        }

        @Override
        public String toString() {
            return AbstractScheduledService.this.toString();
        }

        class Task
        implements Runnable {
            Task() {
            }

            /*
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                Throwable throwable322;
                block9: {
                    ServiceDelegate.this.lock.lock();
                    try {
                        boolean bl = ServiceDelegate.this.runningTask.isCancelled();
                        if (bl) {
                            ServiceDelegate.this.lock.unlock();
                            return;
                        }
                        AbstractScheduledService.this.runOneIteration();
                    }
                    catch (Throwable throwable2) {
                        block8: {
                            try {
                                AbstractScheduledService.this.shutDown();
                                break block8;
                            }
                            catch (Throwable throwable322) {
                                break block9;
                            }
                            catch (Exception exception) {
                                logger.log(Level.WARNING, "Error while attempting to shut down the service after failure.", exception);
                            }
                        }
                        ServiceDelegate.this.notifyFailed(throwable2);
                        ServiceDelegate.this.runningTask.cancel(false);
                    }
                    ServiceDelegate.this.lock.unlock();
                    return;
                }
                ServiceDelegate.this.lock.unlock();
                throw throwable322;
            }
        }
    }
}

