/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.DirectExecutor;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.internal.InternalFutureFailureAccess;
import com.google.common.util.concurrent.internal.InternalFutures;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;
import sun.misc.Unsafe;

public abstract class AbstractFuture<V>
extends InternalFutureFailureAccess
implements ListenableFuture<V> {
    private static final AtomicHelper ATOMIC_HELPER;
    private static final boolean GENERATE_CANCELLATION_CAUSES;
    private static final Object NULL;
    private static final long SPIN_THRESHOLD_NANOS = 1000L;
    private static final Logger log;
    @NullableDecl
    private volatile Listener listeners;
    @NullableDecl
    private volatile Object value;
    @NullableDecl
    private volatile Waiter waiters;

    static {
        Throwable throwable;
        AtomicHelper atomicHelper;
        GENERATE_CANCELLATION_CAUSES = Boolean.parseBoolean(System.getProperty("guava.concurrent.generate_cancellation_cause", "false"));
        log = Logger.getLogger(AbstractFuture.class.getName());
        Throwable throwable2 = null;
        try {
            atomicHelper = new UnsafeAtomicHelper();
            throwable = null;
        }
        catch (Throwable throwable3) {
            try {
                atomicHelper = new SafeAtomicHelper(AtomicReferenceFieldUpdater.newUpdater(Waiter.class, Thread.class, "thread"), AtomicReferenceFieldUpdater.newUpdater(Waiter.class, Waiter.class, "next"), AtomicReferenceFieldUpdater.newUpdater(AbstractFuture.class, Waiter.class, "waiters"), AtomicReferenceFieldUpdater.newUpdater(AbstractFuture.class, Listener.class, "listeners"), AtomicReferenceFieldUpdater.newUpdater(AbstractFuture.class, Object.class, "value"));
            }
            catch (Throwable throwable4) {
                atomicHelper = new SynchronizedHelper();
            }
        }
        ATOMIC_HELPER = atomicHelper;
        if (throwable2 != null) {
            log.log(Level.SEVERE, "UnsafeAtomicHelper is broken!", throwable);
            log.log(Level.SEVERE, "SafeAtomicHelper is broken!", throwable2);
        }
        NULL = new Object();
    }

    protected AbstractFuture() {
    }

    static /* synthetic */ Object access$402(AbstractFuture abstractFuture, Object object) {
        abstractFuture.value = object;
        return object;
    }

    static /* synthetic */ Waiter access$802(AbstractFuture abstractFuture, Waiter waiter) {
        abstractFuture.waiters = waiter;
        return waiter;
    }

    static /* synthetic */ Listener access$902(AbstractFuture abstractFuture, Listener listener2) {
        abstractFuture.listeners = listener2;
        return listener2;
    }

    private void addDoneString(StringBuilder stringBuilder) {
        try {
            V v2 = AbstractFuture.getUninterruptibly(this);
            stringBuilder.append("SUCCESS, result=[");
            stringBuilder.append(this.userObjectToString(v2));
            stringBuilder.append("]");
        }
        catch (RuntimeException runtimeException) {
            stringBuilder.append("UNKNOWN, cause=[");
            stringBuilder.append(runtimeException.getClass());
            stringBuilder.append(" thrown from get()]");
        }
        catch (CancellationException cancellationException) {
            stringBuilder.append("CANCELLED");
        }
        catch (ExecutionException executionException) {
            stringBuilder.append("FAILURE, cause=[");
            stringBuilder.append(executionException.getCause());
            stringBuilder.append("]");
        }
    }

    private static CancellationException cancellationExceptionWithCause(@NullableDecl String object, @NullableDecl Throwable throwable) {
        object = new CancellationException((String)object);
        ((Throwable)object).initCause(throwable);
        return object;
    }

    private Listener clearListeners(Listener listener2) {
        Listener listener3;
        while (!ATOMIC_HELPER.casListeners(this, listener3 = this.listeners, Listener.TOMBSTONE)) {
        }
        Listener listener4 = listener2;
        listener2 = listener3;
        while (listener2 != null) {
            listener3 = listener2.next;
            listener2.next = listener4;
            listener4 = listener2;
            listener2 = listener3;
        }
        return listener4;
    }

    private static void complete(AbstractFuture<?> object) {
        Object object2 = null;
        Object object3 = object;
        object = object2;
        block0: while (true) {
            super.releaseWaiters();
            ((AbstractFuture)object3).afterDone();
            object3 = super.clearListeners((Listener)object);
            while (object3 != null) {
                object = ((Listener)object3).next;
                object2 = ((Listener)object3).task;
                if (object2 instanceof SetFuture) {
                    SetFuture setFuture = (SetFuture)object2;
                    object3 = setFuture.owner;
                    if (((AbstractFuture)object3).value == setFuture && ATOMIC_HELPER.casValue((AbstractFuture<?>)object3, setFuture, object2 = AbstractFuture.getFutureValue(setFuture.future))) {
                        continue block0;
                    }
                } else {
                    AbstractFuture.executeListener((Runnable)object2, ((Listener)object3).executor);
                }
                object3 = object;
            }
            break;
        }
    }

    private static void executeListener(Runnable runnable2, Executor executor) {
        try {
            executor.execute(runnable2);
        }
        catch (RuntimeException runtimeException) {
            Logger logger = log;
            Level level = Level.SEVERE;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("RuntimeException while executing runnable ");
            stringBuilder.append(runnable2);
            stringBuilder.append(" with executor ");
            stringBuilder.append(executor);
            logger.log(level, stringBuilder.toString(), runtimeException);
        }
    }

    private V getDoneValue(Object object) throws ExecutionException {
        if (!(object instanceof Cancellation)) {
            if (!(object instanceof Failure)) {
                Object object2 = object;
                if (object == NULL) {
                    object2 = null;
                }
                return (V)object2;
            }
            throw new ExecutionException(((Failure)object).exception);
        }
        throw AbstractFuture.cancellationExceptionWithCause("Task was cancelled.", ((Cancellation)object).cause);
    }

    private static Object getFutureValue(ListenableFuture<?> object) {
        Object object2;
        Object object3;
        block14: {
            if (object instanceof Trusted) {
                Object object4;
                object = object4 = ((AbstractFuture)object).value;
                if (object4 instanceof Cancellation) {
                    Cancellation cancellation = (Cancellation)object4;
                    object = object4;
                    if (cancellation.wasInterrupted) {
                        object = cancellation.cause != null ? new Cancellation(false, cancellation.cause) : Cancellation.CAUSELESS_CANCELLED;
                    }
                }
                return object;
            }
            if (object instanceof InternalFutureFailureAccess && (object3 = InternalFutures.tryInternalFastPathGetFailure((InternalFutureFailureAccess)((InternalFutureFailureAccess)object))) != null) {
                return new Failure((Throwable)object3);
            }
            boolean bl = object.isCancelled();
            if ((GENERATE_CANCELLATION_CAUSES ^ true) & bl) {
                return Cancellation.CAUSELESS_CANCELLED;
            }
            object2 = AbstractFuture.getUninterruptibly(object);
            if (!bl) break block14;
            try {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("get() did not throw CancellationException, despite reporting isCancelled() == true: ");
                ((StringBuilder)object2).append(object);
                object3 = new IllegalArgumentException(((StringBuilder)object2).toString());
                return new Cancellation(false, (Throwable)object3);
            }
            catch (Throwable throwable) {
                return new Failure(throwable);
            }
            catch (CancellationException cancellationException) {
                if (!bl) {
                    object3 = new StringBuilder();
                    ((StringBuilder)object3).append("get() threw CancellationException, despite reporting isCancelled() == false: ");
                    ((StringBuilder)object3).append(object);
                    return new Failure(new IllegalArgumentException(((StringBuilder)object3).toString(), cancellationException));
                }
                return new Cancellation(false, cancellationException);
            }
            catch (ExecutionException executionException) {
                if (bl) {
                    object3 = new StringBuilder();
                    ((StringBuilder)object3).append("get() did not throw CancellationException, despite reporting isCancelled() == true: ");
                    ((StringBuilder)object3).append(object);
                    return new Cancellation(false, new IllegalArgumentException(((StringBuilder)object3).toString(), executionException));
                }
                return new Failure(executionException.getCause());
            }
        }
        object3 = object2;
        if (object2 == null) {
            object3 = NULL;
        }
        return object3;
    }

    private static <V> V getUninterruptibly(Future<V> future) throws ExecutionException {
        boolean bl = false;
        while (true) {
            V v2;
            block5: {
                try {
                    v2 = future.get();
                    if (!bl) break block5;
                    Thread.currentThread().interrupt();
                }
                catch (Throwable throwable) {
                    if (bl) {
                        Thread.currentThread().interrupt();
                    }
                    throw throwable;
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                    continue;
                }
            }
            return v2;
            break;
        }
    }

    private void releaseWaiters() {
        Waiter waiter;
        while (!ATOMIC_HELPER.casWaiters(this, waiter = this.waiters, Waiter.TOMBSTONE)) {
        }
        while (waiter != null) {
            waiter.unpark();
            waiter = waiter.next;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void removeWaiter(Waiter var1_1) {
        var1_1.thread = null;
        block0: while (true) {
            if ((var1_1 = this.waiters) == Waiter.TOMBSTONE) {
                return;
            }
            var2_2 = null;
            while (var1_1 != null) {
                var3_3 = var1_1.next;
                if (var1_1.thread != null) {
                    var4_4 = var1_1;
                } else if (var2_2 != null) {
                    var2_2.next = var3_3;
                    var4_4 = var2_2;
                    if (var2_2.thread == null) {
                        continue block0;
                    }
                } else {
                    var4_4 = var2_2;
                    if (AbstractFuture.ATOMIC_HELPER.casWaiters(this, var1_1, var3_3)) ** break;
                    continue block0;
                }
                var1_1 = var3_3;
                var2_2 = var4_4;
            }
            break;
        }
    }

    private String userObjectToString(Object object) {
        if (object == this) {
            return "this future";
        }
        return String.valueOf(object);
    }

    @Override
    public void addListener(Runnable runnable2, Executor executor) {
        Listener listener2;
        Preconditions.checkNotNull(runnable2, "Runnable was null.");
        Preconditions.checkNotNull(executor, "Executor was null.");
        if (!this.isDone() && (listener2 = this.listeners) != Listener.TOMBSTONE) {
            Listener listener3;
            Listener listener4 = new Listener(runnable2, executor);
            do {
                listener4.next = listener2;
                if (ATOMIC_HELPER.casListeners(this, listener2, listener4)) {
                    return;
                }
                listener2 = listener3 = this.listeners;
            } while (listener3 != Listener.TOMBSTONE);
        }
        AbstractFuture.executeListener(runnable2, executor);
    }

    protected void afterDone() {
    }

    @Override
    public boolean cancel(boolean bl) {
        boolean bl2;
        Object object = this.value;
        boolean bl3 = true;
        boolean bl4 = object == null;
        if (bl4 | object instanceof SetFuture) {
            Cancellation cancellation = GENERATE_CANCELLATION_CAUSES ? new Cancellation(bl, new CancellationException("Future.cancel() was called.")) : (bl ? Cancellation.CAUSELESS_INTERRUPTED : Cancellation.CAUSELESS_CANCELLED);
            bl2 = false;
            AbstractFuture abstractFuture = this;
            while (true) {
                Object object2;
                if (ATOMIC_HELPER.casValue(abstractFuture, object, cancellation)) {
                    if (bl) {
                        abstractFuture.interruptTask();
                    }
                    AbstractFuture.complete(abstractFuture);
                    bl2 = bl3;
                    if (object instanceof SetFuture) {
                        object = ((SetFuture)object).future;
                        if (object instanceof Trusted) {
                            abstractFuture = (AbstractFuture)object;
                            object = abstractFuture.value;
                            bl4 = object == null;
                            bl2 = bl3;
                            if (bl4 | object instanceof SetFuture) {
                                bl2 = true;
                                continue;
                            }
                        } else {
                            object.cancel(bl);
                            bl2 = bl3;
                        }
                    }
                    break;
                }
                object = object2 = abstractFuture.value;
                if (!(object2 instanceof SetFuture)) break;
            }
        } else {
            bl2 = false;
        }
        return bl2;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        if (!Thread.interrupted()) {
            Object object = this.value;
            boolean bl = object != null;
            if (bl & (object instanceof SetFuture ^ true)) {
                return this.getDoneValue(object);
            }
            object = this.waiters;
            if (object != Waiter.TOMBSTONE) {
                Waiter waiter;
                Waiter waiter2 = new Waiter();
                do {
                    waiter2.setNext((Waiter)object);
                    if (ATOMIC_HELPER.casWaiters(this, (Waiter)object, waiter2)) {
                        block6: {
                            do {
                                LockSupport.park(this);
                                if (Thread.interrupted()) break block6;
                            } while (!((bl = (object = this.value) != null) & (object instanceof SetFuture ^ true)));
                            return this.getDoneValue(object);
                        }
                        this.removeWaiter(waiter2);
                        throw new InterruptedException();
                    }
                    waiter = this.waiters;
                    object = waiter;
                } while (waiter != Waiter.TOMBSTONE);
            }
            return this.getDoneValue(this.value);
        }
        InterruptedException interruptedException = new InterruptedException();
        throw interruptedException;
    }

    @Override
    public V get(long l2, TimeUnit object) throws InterruptedException, TimeoutException, ExecutionException {
        long l3 = ((TimeUnit)((Object)object)).toNanos(l2);
        if (!Thread.interrupted()) {
            Object object2;
            Object object3;
            long l4;
            long l5;
            boolean bl;
            Object object4;
            block17: {
                object4 = this.value;
                bl = object4 != null;
                if (bl & (object4 instanceof SetFuture ^ true)) {
                    return this.getDoneValue(object4);
                }
                l5 = l3 > 0L ? System.nanoTime() + l3 : 0L;
                l4 = l3;
                if (l3 >= 1000L) {
                    object4 = this.waiters;
                    if (object4 != Waiter.TOMBSTONE) {
                        object3 = new Waiter();
                        do {
                            ((Waiter)object3).setNext((Waiter)object4);
                            if (ATOMIC_HELPER.casWaiters(this, (Waiter)object4, (Waiter)object3)) {
                                block16: {
                                    do {
                                        LockSupport.parkNanos(this, l3);
                                        if (Thread.interrupted()) break block16;
                                        object4 = this.value;
                                        bl = object4 != null;
                                        if (bl & (object4 instanceof SetFuture ^ true)) {
                                            return this.getDoneValue(object4);
                                        }
                                        l3 = l4 = l5 - System.nanoTime();
                                    } while (l4 >= 1000L);
                                    this.removeWaiter((Waiter)object3);
                                    break block17;
                                }
                                this.removeWaiter((Waiter)object3);
                                throw new InterruptedException();
                            }
                            object4 = object2 = this.waiters;
                        } while (object2 != Waiter.TOMBSTONE);
                    }
                    return this.getDoneValue(this.value);
                }
            }
            while (l4 > 0L) {
                object4 = this.value;
                bl = object4 != null;
                if (bl & (object4 instanceof SetFuture ^ true)) {
                    return this.getDoneValue(object4);
                }
                if (!Thread.interrupted()) {
                    l4 = l5 - System.nanoTime();
                    continue;
                }
                throw new InterruptedException();
            }
            object3 = this.toString();
            String string2 = ((Enum)object).toString().toLowerCase(Locale.ROOT);
            object4 = new StringBuilder();
            ((StringBuilder)object4).append("Waited ");
            ((StringBuilder)object4).append(l2);
            ((StringBuilder)object4).append(" ");
            ((StringBuilder)object4).append(((Enum)object).toString().toLowerCase(Locale.ROOT));
            object4 = object2 = ((StringBuilder)object4).toString();
            if (l4 + 1000L < 0L) {
                object4 = new StringBuilder();
                ((StringBuilder)object4).append((String)object2);
                ((StringBuilder)object4).append(" (plus ");
                object4 = ((StringBuilder)object4).toString();
                l4 = -l4;
                l2 = ((TimeUnit)((Object)object)).convert(l4, TimeUnit.NANOSECONDS);
                bl = l2 == 0L || (l4 -= ((TimeUnit)((Object)object)).toNanos(l2)) > 1000L;
                object = object4;
                if (l2 > 0L) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append((String)object4);
                    ((StringBuilder)object).append(l2);
                    ((StringBuilder)object).append(" ");
                    ((StringBuilder)object).append(string2);
                    object = object4 = ((StringBuilder)object).toString();
                    if (bl) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append((String)object4);
                        ((StringBuilder)object).append(",");
                        object = ((StringBuilder)object).toString();
                    }
                    object4 = new StringBuilder();
                    ((StringBuilder)object4).append((String)object);
                    ((StringBuilder)object4).append(" ");
                    object = ((StringBuilder)object4).toString();
                }
                object4 = object;
                if (bl) {
                    object4 = new StringBuilder();
                    ((StringBuilder)object4).append((String)object);
                    ((StringBuilder)object4).append(l4);
                    ((StringBuilder)object4).append(" nanoseconds ");
                    object4 = ((StringBuilder)object4).toString();
                }
                object = new StringBuilder();
                ((StringBuilder)object).append((String)object4);
                ((StringBuilder)object).append("delay)");
                object4 = ((StringBuilder)object).toString();
            }
            if (this.isDone()) {
                object = new StringBuilder();
                ((StringBuilder)object).append((String)object4);
                ((StringBuilder)object).append(" but future completed as timeout expired");
                throw new TimeoutException(((StringBuilder)object).toString());
            }
            object = new StringBuilder();
            ((StringBuilder)object).append((String)object4);
            ((StringBuilder)object).append(" for ");
            ((StringBuilder)object).append((String)object3);
            throw new TimeoutException(((StringBuilder)object).toString());
        }
        object = new InterruptedException();
        throw object;
    }

    protected void interruptTask() {
    }

    @Override
    public boolean isCancelled() {
        return this.value instanceof Cancellation;
    }

    @Override
    public boolean isDone() {
        Object object = this.value;
        boolean bl = object != null;
        return (object instanceof SetFuture ^ true) & bl;
    }

    final void maybePropagateCancellationTo(@NullableDecl Future<?> future) {
        boolean bl = future != null;
        if (bl & this.isCancelled()) {
            future.cancel(this.wasInterrupted());
        }
    }

    @NullableDecl
    protected String pendingToString() {
        Object object = this.value;
        if (object instanceof SetFuture) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("setFuture=[");
            stringBuilder.append(this.userObjectToString(((SetFuture)object).future));
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
        if (this instanceof ScheduledFuture) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("remaining delay=[");
            stringBuilder.append(((ScheduledFuture)((Object)this)).getDelay(TimeUnit.MILLISECONDS));
            stringBuilder.append(" ms]");
            return stringBuilder.toString();
        }
        return null;
    }

    protected boolean set(@NullableDecl V v2) {
        Object object = v2;
        if (v2 == null) {
            object = NULL;
        }
        if (ATOMIC_HELPER.casValue(this, null, object)) {
            AbstractFuture.complete(this);
            return true;
        }
        return false;
    }

    protected boolean setException(Throwable object) {
        if (ATOMIC_HELPER.casValue(this, null, object = new Failure(Preconditions.checkNotNull(object)))) {
            AbstractFuture.complete(this);
            return true;
        }
        return false;
    }

    protected boolean setFuture(ListenableFuture<? extends V> object) {
        Preconditions.checkNotNull(object);
        SetFuture setFuture = this.value;
        SetFuture setFuture2 = setFuture;
        if (setFuture == null) {
            if (object.isDone()) {
                if (ATOMIC_HELPER.casValue(this, null, object = AbstractFuture.getFutureValue(object))) {
                    AbstractFuture.complete(this);
                    return true;
                }
                return false;
            }
            setFuture2 = new SetFuture(this, object);
            if (ATOMIC_HELPER.casValue(this, null, setFuture2)) {
                try {
                    object.addListener(setFuture2, (Executor)DirectExecutor.INSTANCE);
                }
                catch (Throwable throwable) {
                    try {
                        object = new Failure(throwable);
                    }
                    catch (Throwable throwable2) {
                        object = Failure.FALLBACK_INSTANCE;
                    }
                    ATOMIC_HELPER.casValue(this, setFuture2, object);
                }
                return true;
            }
            setFuture2 = this.value;
        }
        if (setFuture2 instanceof Cancellation) {
            object.cancel(((Cancellation)((Object)setFuture2)).wasInterrupted);
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("[status=");
        if (this.isCancelled()) {
            stringBuilder.append("CANCELLED");
        } else if (this.isDone()) {
            this.addDoneString(stringBuilder);
        } else {
            String string2;
            try {
                string2 = this.pendingToString();
            }
            catch (RuntimeException runtimeException) {
                StringBuilder stringBuilder2 = new StringBuilder();
                stringBuilder2.append("Exception thrown from implementation: ");
                stringBuilder2.append(runtimeException.getClass());
                string2 = stringBuilder2.toString();
            }
            if (string2 != null && !string2.isEmpty()) {
                stringBuilder.append("PENDING, info=[");
                stringBuilder.append(string2);
                stringBuilder.append("]");
            } else if (this.isDone()) {
                this.addDoneString(stringBuilder);
            } else {
                stringBuilder.append("PENDING");
            }
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    @NullableDecl
    protected final Throwable tryInternalFastPathGetFailure() {
        Object object;
        if (this instanceof Trusted && (object = this.value) instanceof Failure) {
            return ((Failure)object).exception;
        }
        return null;
    }

    protected final boolean wasInterrupted() {
        Object object = this.value;
        boolean bl = object instanceof Cancellation && ((Cancellation)object).wasInterrupted;
        return bl;
    }

    private static abstract class AtomicHelper {
        private AtomicHelper() {
        }

        abstract boolean casListeners(AbstractFuture<?> var1, Listener var2, Listener var3);

        abstract boolean casValue(AbstractFuture<?> var1, Object var2, Object var3);

        abstract boolean casWaiters(AbstractFuture<?> var1, Waiter var2, Waiter var3);

        abstract void putNext(Waiter var1, Waiter var2);

        abstract void putThread(Waiter var1, Thread var2);
    }

    private static final class Cancellation {
        static final Cancellation CAUSELESS_CANCELLED;
        static final Cancellation CAUSELESS_INTERRUPTED;
        @NullableDecl
        final Throwable cause;
        final boolean wasInterrupted;

        static {
            if (GENERATE_CANCELLATION_CAUSES) {
                CAUSELESS_CANCELLED = null;
                CAUSELESS_INTERRUPTED = null;
            } else {
                CAUSELESS_CANCELLED = new Cancellation(false, null);
                CAUSELESS_INTERRUPTED = new Cancellation(true, null);
            }
        }

        Cancellation(boolean bl, @NullableDecl Throwable throwable) {
            this.wasInterrupted = bl;
            this.cause = throwable;
        }
    }

    private static final class Failure {
        static final Failure FALLBACK_INSTANCE = new Failure(new Throwable("Failure occurred while trying to finish a future."){

            /*
             * Enabled aggressive block sorting
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public Throwable fillInStackTrace() {
                // MONITORENTER : this
                // MONITOREXIT : this
                return this;
            }
        });
        final Throwable exception;

        Failure(Throwable throwable) {
            this.exception = Preconditions.checkNotNull(throwable);
        }
    }

    private static final class Listener {
        static final Listener TOMBSTONE = new Listener(null, null);
        final Executor executor;
        @NullableDecl
        Listener next;
        final Runnable task;

        Listener(Runnable runnable2, Executor executor) {
            this.task = runnable2;
            this.executor = executor;
        }
    }

    private static final class SafeAtomicHelper
    extends AtomicHelper {
        final AtomicReferenceFieldUpdater<AbstractFuture, Listener> listenersUpdater;
        final AtomicReferenceFieldUpdater<AbstractFuture, Object> valueUpdater;
        final AtomicReferenceFieldUpdater<Waiter, Waiter> waiterNextUpdater;
        final AtomicReferenceFieldUpdater<Waiter, Thread> waiterThreadUpdater;
        final AtomicReferenceFieldUpdater<AbstractFuture, Waiter> waitersUpdater;

        SafeAtomicHelper(AtomicReferenceFieldUpdater<Waiter, Thread> atomicReferenceFieldUpdater, AtomicReferenceFieldUpdater<Waiter, Waiter> atomicReferenceFieldUpdater2, AtomicReferenceFieldUpdater<AbstractFuture, Waiter> atomicReferenceFieldUpdater3, AtomicReferenceFieldUpdater<AbstractFuture, Listener> atomicReferenceFieldUpdater4, AtomicReferenceFieldUpdater<AbstractFuture, Object> atomicReferenceFieldUpdater5) {
            this.waiterThreadUpdater = atomicReferenceFieldUpdater;
            this.waiterNextUpdater = atomicReferenceFieldUpdater2;
            this.waitersUpdater = atomicReferenceFieldUpdater3;
            this.listenersUpdater = atomicReferenceFieldUpdater4;
            this.valueUpdater = atomicReferenceFieldUpdater5;
        }

        @Override
        boolean casListeners(AbstractFuture<?> abstractFuture, Listener listener2, Listener listener3) {
            return this.listenersUpdater.compareAndSet(abstractFuture, listener2, listener3);
        }

        @Override
        boolean casValue(AbstractFuture<?> abstractFuture, Object object, Object object2) {
            return this.valueUpdater.compareAndSet(abstractFuture, object, object2);
        }

        @Override
        boolean casWaiters(AbstractFuture<?> abstractFuture, Waiter waiter, Waiter waiter2) {
            return this.waitersUpdater.compareAndSet(abstractFuture, waiter, waiter2);
        }

        @Override
        void putNext(Waiter waiter, Waiter waiter2) {
            this.waiterNextUpdater.lazySet(waiter, waiter2);
        }

        @Override
        void putThread(Waiter waiter, Thread thread) {
            this.waiterThreadUpdater.lazySet(waiter, thread);
        }
    }

    private static final class SetFuture<V>
    implements Runnable {
        final ListenableFuture<? extends V> future;
        final AbstractFuture<V> owner;

        SetFuture(AbstractFuture<V> abstractFuture, ListenableFuture<? extends V> listenableFuture) {
            this.owner = abstractFuture;
            this.future = listenableFuture;
        }

        @Override
        public void run() {
            if (((AbstractFuture)this.owner).value != this) {
                return;
            }
            Object object = AbstractFuture.getFutureValue(this.future);
            if (ATOMIC_HELPER.casValue(this.owner, this, object)) {
                AbstractFuture.complete((AbstractFuture)this.owner);
            }
        }
    }

    private static final class SynchronizedHelper
    extends AtomicHelper {
        private SynchronizedHelper() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        boolean casListeners(AbstractFuture<?> abstractFuture, Listener listener2, Listener listener3) {
            synchronized (abstractFuture) {
                if (((AbstractFuture)abstractFuture).listeners == listener2) {
                    AbstractFuture.access$902(abstractFuture, listener3);
                    return true;
                }
                return false;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        boolean casValue(AbstractFuture<?> abstractFuture, Object object, Object object2) {
            synchronized (abstractFuture) {
                if (((AbstractFuture)abstractFuture).value == object) {
                    AbstractFuture.access$402(abstractFuture, object2);
                    return true;
                }
                return false;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        boolean casWaiters(AbstractFuture<?> abstractFuture, Waiter waiter, Waiter waiter2) {
            synchronized (abstractFuture) {
                if (((AbstractFuture)abstractFuture).waiters == waiter) {
                    AbstractFuture.access$802(abstractFuture, waiter2);
                    return true;
                }
                return false;
            }
        }

        @Override
        void putNext(Waiter waiter, Waiter waiter2) {
            waiter.next = waiter2;
        }

        @Override
        void putThread(Waiter waiter, Thread thread) {
            waiter.thread = thread;
        }
    }

    static interface Trusted<V>
    extends ListenableFuture<V> {
    }

    static abstract class TrustedFuture<V>
    extends AbstractFuture<V>
    implements Trusted<V> {
        TrustedFuture() {
        }

        @Override
        public final void addListener(Runnable runnable2, Executor executor) {
            super.addListener(runnable2, executor);
        }

        @Override
        public final boolean cancel(boolean bl) {
            return super.cancel(bl);
        }

        @Override
        public final V get() throws InterruptedException, ExecutionException {
            return super.get();
        }

        @Override
        public final V get(long l2, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            return super.get(l2, timeUnit);
        }

        @Override
        public final boolean isCancelled() {
            return super.isCancelled();
        }

        @Override
        public final boolean isDone() {
            return super.isDone();
        }
    }

    private static final class UnsafeAtomicHelper
    extends AtomicHelper {
        static final long LISTENERS_OFFSET;
        static final Unsafe UNSAFE;
        static final long VALUE_OFFSET;
        static final long WAITERS_OFFSET;
        static final long WAITER_NEXT_OFFSET;
        static final long WAITER_THREAD_OFFSET;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static {
            PrivilegedExceptionAction<Unsafe> privilegedExceptionAction;
            try {
                privilegedExceptionAction = Unsafe.getUnsafe();
            }
            catch (SecurityException securityException) {
                try {
                    privilegedExceptionAction = new PrivilegedExceptionAction<Unsafe>(){

                        @Override
                        public Unsafe run() throws Exception {
                            for (Field field : Unsafe.class.getDeclaredFields()) {
                                field.setAccessible(true);
                                Object object = field.get(null);
                                if (!Unsafe.class.isInstance(object)) continue;
                                return (Unsafe)Unsafe.class.cast(object);
                            }
                            NoSuchFieldError noSuchFieldError = new NoSuchFieldError("the Unsafe");
                            throw noSuchFieldError;
                        }
                    };
                    privilegedExceptionAction = (Unsafe)AccessController.doPrivileged(privilegedExceptionAction);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw new RuntimeException("Could not initialize intrinsics", privilegedActionException.getCause());
                }
            }
            try {
                WAITERS_OFFSET = ((Unsafe)((Object)privilegedExceptionAction)).objectFieldOffset(AbstractFuture.class.getDeclaredField("waiters"));
                LISTENERS_OFFSET = ((Unsafe)((Object)privilegedExceptionAction)).objectFieldOffset(AbstractFuture.class.getDeclaredField("listeners"));
                VALUE_OFFSET = ((Unsafe)((Object)privilegedExceptionAction)).objectFieldOffset(AbstractFuture.class.getDeclaredField("value"));
                WAITER_THREAD_OFFSET = ((Unsafe)((Object)privilegedExceptionAction)).objectFieldOffset(Waiter.class.getDeclaredField("thread"));
                WAITER_NEXT_OFFSET = ((Unsafe)((Object)privilegedExceptionAction)).objectFieldOffset(Waiter.class.getDeclaredField("next"));
                UNSAFE = privilegedExceptionAction;
                return;
            }
            catch (Exception exception) {
                Throwables.throwIfUnchecked(exception);
                throw new RuntimeException(exception);
            }
        }

        private UnsafeAtomicHelper() {
        }

        @Override
        boolean casListeners(AbstractFuture<?> abstractFuture, Listener listener2, Listener listener3) {
            return UNSAFE.compareAndSwapObject(abstractFuture, LISTENERS_OFFSET, listener2, listener3);
        }

        @Override
        boolean casValue(AbstractFuture<?> abstractFuture, Object object, Object object2) {
            return UNSAFE.compareAndSwapObject(abstractFuture, VALUE_OFFSET, object, object2);
        }

        @Override
        boolean casWaiters(AbstractFuture<?> abstractFuture, Waiter waiter, Waiter waiter2) {
            return UNSAFE.compareAndSwapObject(abstractFuture, WAITERS_OFFSET, waiter, waiter2);
        }

        @Override
        void putNext(Waiter waiter, Waiter waiter2) {
            UNSAFE.putObject(waiter, WAITER_NEXT_OFFSET, waiter2);
        }

        @Override
        void putThread(Waiter waiter, Thread thread) {
            UNSAFE.putObject(waiter, WAITER_THREAD_OFFSET, thread);
        }
    }

    private static final class Waiter {
        static final Waiter TOMBSTONE = new Waiter(false);
        @NullableDecl
        volatile Waiter next;
        @NullableDecl
        volatile Thread thread;

        Waiter() {
            ATOMIC_HELPER.putThread(this, Thread.currentThread());
        }

        Waiter(boolean bl) {
        }

        void setNext(Waiter waiter) {
            ATOMIC_HELPER.putNext(this, waiter);
        }

        void unpark() {
            Thread thread = this.thread;
            if (thread != null) {
                this.thread = null;
                LockSupport.unpark(thread);
            }
        }
    }
}

