/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Platform;
import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

abstract class AbstractCatchingFuture<V, X extends Throwable, F, T>
extends FluentFuture.TrustedFuture<V>
implements Runnable {
    @NullableDecl
    Class<X> exceptionType;
    @NullableDecl
    F fallback;
    @NullableDecl
    ListenableFuture<? extends V> inputFuture;

    AbstractCatchingFuture(ListenableFuture<? extends V> listenableFuture, Class<X> clazz, F f2) {
        this.inputFuture = Preconditions.checkNotNull(listenableFuture);
        this.exceptionType = Preconditions.checkNotNull(clazz);
        this.fallback = Preconditions.checkNotNull(f2);
    }

    static <V, X extends Throwable> ListenableFuture<V> create(ListenableFuture<? extends V> listenableFuture, Class<X> object, Function<? super X, ? extends V> function, Executor executor) {
        object = new CatchingFuture<V, X>(listenableFuture, object, function);
        listenableFuture.addListener((Runnable)object, MoreExecutors.rejectionPropagatingExecutor((Executor)executor, (AbstractFuture)object));
        return object;
    }

    static <X extends Throwable, V> ListenableFuture<V> create(ListenableFuture<? extends V> listenableFuture, Class<X> object, AsyncFunction<? super X, ? extends V> asyncFunction, Executor executor) {
        object = new AsyncCatchingFuture<V, X>(listenableFuture, object, asyncFunction);
        listenableFuture.addListener((Runnable)object, MoreExecutors.rejectionPropagatingExecutor((Executor)executor, (AbstractFuture)object));
        return object;
    }

    @Override
    protected final void afterDone() {
        this.maybePropagateCancellationTo(this.inputFuture);
        this.inputFuture = null;
        this.exceptionType = null;
        this.fallback = null;
    }

    @NullableDecl
    abstract T doFallback(F var1, X var2) throws Exception;

    @Override
    protected String pendingToString() {
        Object object = this.inputFuture;
        Serializable serializable = this.exceptionType;
        F f2 = this.fallback;
        CharSequence charSequence = super.pendingToString();
        if (object != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("inputFuture=[");
            stringBuilder.append(object);
            stringBuilder.append("], ");
            object = stringBuilder.toString();
        } else {
            object = "";
        }
        if (serializable != null && f2 != null) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append((String)object);
            ((StringBuilder)charSequence).append("exceptionType=[");
            ((StringBuilder)charSequence).append(serializable);
            ((StringBuilder)charSequence).append("], fallback=[");
            ((StringBuilder)charSequence).append(f2);
            ((StringBuilder)charSequence).append("]");
            return ((StringBuilder)charSequence).toString();
        }
        if (charSequence != null) {
            serializable = new StringBuilder();
            ((StringBuilder)serializable).append((String)object);
            ((StringBuilder)serializable).append((String)charSequence);
            return ((StringBuilder)serializable).toString();
        }
        return null;
    }

    @Override
    public final void run() {
        Throwable throwable;
        V v2;
        F f2;
        Class<X> clazz;
        ListenableFuture<? extends V> listenableFuture;
        block12: {
            listenableFuture = this.inputFuture;
            clazz = this.exceptionType;
            f2 = this.fallback;
            boolean bl = true;
            boolean bl2 = listenableFuture == null;
            boolean bl3 = clazz == null;
            if (f2 != null) {
                bl = false;
            }
            if (bl | (bl2 | bl3) | this.isCancelled()) {
                return;
            }
            this.inputFuture = null;
            try {
                v2 = Futures.getDone(listenableFuture);
                throwable = null;
                break block12;
            }
            catch (Throwable throwable2) {
            }
            catch (ExecutionException executionException) {
                throwable = Preconditions.checkNotNull(executionException.getCause());
            }
            v2 = null;
        }
        if (throwable == null) {
            this.set(v2);
            return;
        }
        if (!Platform.isInstanceOfThrowableClass(throwable, clazz)) {
            this.setFuture(listenableFuture);
            return;
        }
        try {
            throwable = this.doFallback(f2, throwable);
            this.exceptionType = null;
            this.fallback = null;
            this.setResult(throwable);
            return;
        }
        catch (Throwable throwable3) {
            try {
                this.setException(throwable3);
                return;
            }
            finally {
                this.exceptionType = null;
                this.fallback = null;
            }
        }
    }

    abstract void setResult(@NullableDecl T var1);

    private static final class AsyncCatchingFuture<V, X extends Throwable>
    extends AbstractCatchingFuture<V, X, AsyncFunction<? super X, ? extends V>, ListenableFuture<? extends V>> {
        AsyncCatchingFuture(ListenableFuture<? extends V> listenableFuture, Class<X> clazz, AsyncFunction<? super X, ? extends V> asyncFunction) {
            super(listenableFuture, clazz, asyncFunction);
        }

        @Override
        ListenableFuture<? extends V> doFallback(AsyncFunction<? super X, ? extends V> asyncFunction, X object) throws Exception {
            object = asyncFunction.apply(object);
            Preconditions.checkNotNull(object, "AsyncFunction.apply returned null instead of a Future. Did you mean to return immediateFuture(null)? %s", asyncFunction);
            return object;
        }

        @Override
        void setResult(ListenableFuture<? extends V> listenableFuture) {
            this.setFuture(listenableFuture);
        }
    }

    private static final class CatchingFuture<V, X extends Throwable>
    extends AbstractCatchingFuture<V, X, Function<? super X, ? extends V>, V> {
        CatchingFuture(ListenableFuture<? extends V> listenableFuture, Class<X> clazz, Function<? super X, ? extends V> function) {
            super(listenableFuture, clazz, function);
        }

        @Override
        @NullableDecl
        V doFallback(Function<? super X, ? extends V> function, X x2) throws Exception {
            return function.apply(x2);
        }

        @Override
        void setResult(@NullableDecl V v2) {
            this.set(v2);
        }
    }
}

