/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.reflect.Reflection;
import com.google.common.reflect.TypeCapture;
import com.google.common.reflect.TypeVisitor;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.security.AccessControlException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

final class Types {
    private static final Joiner COMMA_JOINER;
    private static final Function<Type, String> TYPE_NAME;

    static {
        TYPE_NAME = new Function<Type, String>(){

            @Override
            public String apply(Type type) {
                return JavaVersion.CURRENT.typeName(type);
            }
        };
        COMMA_JOINER = Joiner.on(", ").useForNull("null");
    }

    private Types() {
    }

    private static void disallowPrimitiveType(Type[] typeArray, String string2) {
        for (Type type : typeArray) {
            if (!(type instanceof Class)) continue;
            type = (Class)type;
            Preconditions.checkArgument(((Class)type).isPrimitive() ^ true, "Primitive type '%s' used as %s", (Object)type, (Object)string2);
        }
    }

    private static Iterable<Type> filterUpperBounds(Iterable<Type> iterable) {
        return Iterables.filter(iterable, Predicates.not(Predicates.equalTo(Object.class)));
    }

    static Class<?> getArrayClass(Class<?> clazz) {
        return Array.newInstance(clazz, 0).getClass();
    }

    @NullableDecl
    static Type getComponentType(Type type) {
        Preconditions.checkNotNull(type);
        final AtomicReference atomicReference = new AtomicReference();
        new TypeVisitor(){

            void visitClass(Class<?> clazz) {
                atomicReference.set(clazz.getComponentType());
            }

            void visitGenericArrayType(GenericArrayType genericArrayType) {
                atomicReference.set(genericArrayType.getGenericComponentType());
            }

            void visitTypeVariable(TypeVariable<?> typeVariable) {
                atomicReference.set(Types.subtypeOfComponentType(typeVariable.getBounds()));
            }

            void visitWildcardType(WildcardType wildcardType) {
                atomicReference.set(Types.subtypeOfComponentType(wildcardType.getUpperBounds()));
            }
        }.visit(new Type[]{type});
        return (Type)atomicReference.get();
    }

    static Type newArrayType(Type typeArray) {
        if (typeArray instanceof WildcardType) {
            typeArray = (WildcardType)typeArray;
            Type[] typeArray2 = typeArray.getLowerBounds();
            int n2 = typeArray2.length;
            boolean bl = true;
            boolean bl2 = n2 <= 1;
            Preconditions.checkArgument(bl2, "Wildcard cannot have more than one lower bounds.");
            if (typeArray2.length == 1) {
                return Types.supertypeOf(Types.newArrayType(typeArray2[0]));
            }
            bl2 = (typeArray = typeArray.getUpperBounds()).length == 1 ? bl : false;
            Preconditions.checkArgument(bl2, "Wildcard should have only one upper bound.");
            return Types.subtypeOf(Types.newArrayType(typeArray[0]));
        }
        return JavaVersion.CURRENT.newArrayType((Type)typeArray);
    }

    static <D extends GenericDeclaration> TypeVariable<D> newArtificialTypeVariable(D d2, String string2, Type ... typeArray) {
        Type[] typeArray2 = typeArray;
        if (typeArray.length == 0) {
            typeArray2 = new Type[]{Object.class};
        }
        return Types.newTypeVariableImpl(d2, string2, typeArray2);
    }

    static ParameterizedType newParameterizedType(Class<?> clazz, Type ... typeArray) {
        return new ParameterizedTypeImpl(ClassOwnership.JVM_BEHAVIOR.getOwnerType(clazz), clazz, typeArray);
    }

    static ParameterizedType newParameterizedTypeWithOwner(@NullableDecl Type type, Class<?> clazz, Type ... typeArray) {
        if (type == null) {
            return Types.newParameterizedType(clazz, typeArray);
        }
        Preconditions.checkNotNull(typeArray);
        boolean bl = clazz.getEnclosingClass() != null;
        Preconditions.checkArgument(bl, "Owner type for unenclosed %s", clazz);
        return new ParameterizedTypeImpl(type, clazz, typeArray);
    }

    private static <D extends GenericDeclaration> TypeVariable<D> newTypeVariableImpl(D d2, String string2, Type[] typeArray) {
        return (TypeVariable)Reflection.newProxy(TypeVariable.class, (InvocationHandler)new TypeVariableInvocationHandler(new TypeVariableImpl<D>(d2, string2, typeArray)));
    }

    static WildcardType subtypeOf(Type type) {
        return new WildcardTypeImpl(new Type[0], new Type[]{type});
    }

    @NullableDecl
    private static Type subtypeOfComponentType(Type[] object) {
        int n2 = ((Type[])object).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Type type = Types.getComponentType(object[i2]);
            if (type == null) continue;
            if (type instanceof Class && ((Class)(object = (Class)type)).isPrimitive()) {
                return object;
            }
            return Types.subtypeOf(type);
        }
        return null;
    }

    static WildcardType supertypeOf(Type type) {
        return new WildcardTypeImpl(new Type[]{type}, new Type[]{Object.class});
    }

    private static Type[] toArray(Collection<Type> collection) {
        return collection.toArray(new Type[collection.size()]);
    }

    static String toString(Type object) {
        object = object instanceof Class ? ((Class)object).getName() : object.toString();
        return object;
    }

    private static enum ClassOwnership {
        OWNED_BY_ENCLOSING_CLASS{

            @Override
            @NullableDecl
            Class<?> getOwnerType(Class<?> clazz) {
                return clazz.getEnclosingClass();
            }
        }
        ,
        LOCAL_CLASS_HAS_NO_OWNER{

            @Override
            @NullableDecl
            Class<?> getOwnerType(Class<?> clazz) {
                if (clazz.isLocalClass()) {
                    return null;
                }
                return clazz.getEnclosingClass();
            }
        };

        static final ClassOwnership JVM_BEHAVIOR = ClassOwnership.detectJvmBehavior();

        private static ClassOwnership detectJvmBehavior() {
            Object object2;
            ParameterizedType parameterizedType = (ParameterizedType)new 1LocalClass<String>(){}.getClass().getGenericSuperclass();
            for (Object object2 : ClassOwnership.values()) {
                if (object2.getOwnerType(1LocalClass.class) != parameterizedType.getOwnerType()) continue;
                return object2;
            }
            object2 = new AssertionError();
            throw object2;
        }

        @NullableDecl
        abstract Class<?> getOwnerType(Class<?> var1);

        class 1LocalClass<T> {
            1LocalClass() {
            }
        }
    }

    private static final class GenericArrayTypeImpl
    implements GenericArrayType,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final Type componentType;

        GenericArrayTypeImpl(Type type) {
            this.componentType = JavaVersion.CURRENT.usedInGenericType(type);
        }

        public boolean equals(Object object) {
            if (object instanceof GenericArrayType) {
                object = (GenericArrayType)object;
                return Objects.equal(this.getGenericComponentType(), object.getGenericComponentType());
            }
            return false;
        }

        @Override
        public Type getGenericComponentType() {
            return this.componentType;
        }

        public int hashCode() {
            return this.componentType.hashCode();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(Types.toString(this.componentType));
            stringBuilder.append("[]");
            return stringBuilder.toString();
        }
    }

    static enum JavaVersion {
        JAVA6{

            @Override
            GenericArrayType newArrayType(Type type) {
                return new GenericArrayTypeImpl(type);
            }

            @Override
            Type usedInGenericType(Type type) {
                Preconditions.checkNotNull(type);
                Type type2 = type;
                if (type instanceof Class) {
                    Class clazz = (Class)type;
                    type2 = type;
                    if (clazz.isArray()) {
                        type2 = new GenericArrayTypeImpl(clazz.getComponentType());
                    }
                }
                return type2;
            }
        }
        ,
        JAVA7{

            @Override
            Type newArrayType(Type type) {
                if (type instanceof Class) {
                    return Types.getArrayClass((Class)type);
                }
                return new GenericArrayTypeImpl(type);
            }

            @Override
            Type usedInGenericType(Type type) {
                return Preconditions.checkNotNull(type);
            }
        }
        ,
        JAVA8{

            @Override
            Type newArrayType(Type type) {
                return JAVA7.newArrayType(type);
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            String typeName(Type object) {
                void var1_4;
                try {
                    return (String)Type.class.getMethod("getTypeName", new Class[0]).invoke(object, new Object[0]);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException((Throwable)var1_4);
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                    throw new RuntimeException((Throwable)var1_4);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new AssertionError((Object)"Type.getTypeName should be available in Java 8");
                }
            }

            @Override
            Type usedInGenericType(Type type) {
                return JAVA7.usedInGenericType(type);
            }
        }
        ,
        JAVA9{

            @Override
            boolean jdkTypeDuplicatesOwnerName() {
                return false;
            }

            @Override
            Type newArrayType(Type type) {
                return JAVA8.newArrayType(type);
            }

            @Override
            String typeName(Type type) {
                return JAVA8.typeName(type);
            }

            @Override
            Type usedInGenericType(Type type) {
                return JAVA8.usedInGenericType(type);
            }
        };

        static final JavaVersion CURRENT = AnnotatedElement.class.isAssignableFrom(TypeVariable.class) ? (new TypeCapture<Map.Entry<String, int[][]>>(){}.capture().toString().contains("java.util.Map.java.util.Map") ? JAVA8 : JAVA9) : (new TypeCapture<int[]>(){}.capture() instanceof Class ? JAVA7 : JAVA6);

        boolean jdkTypeDuplicatesOwnerName() {
            return true;
        }

        abstract Type newArrayType(Type var1);

        String typeName(Type type) {
            return Types.toString(type);
        }

        final ImmutableList<Type> usedInGenericType(Type[] typeArray) {
            ImmutableList.Builder builder = ImmutableList.builder();
            int n2 = typeArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                builder.add(this.usedInGenericType(typeArray[i2]));
            }
            return builder.build();
        }

        abstract Type usedInGenericType(Type var1);
    }

    static final class NativeTypeVariableEquals<X> {
        static final boolean NATIVE_TYPE_VARIABLE_ONLY = NativeTypeVariableEquals.class.getTypeParameters()[0].equals(Types.newArtificialTypeVariable(NativeTypeVariableEquals.class, "X", new Type[0])) ^ true;

        NativeTypeVariableEquals() {
        }
    }

    private static final class ParameterizedTypeImpl
    implements ParameterizedType,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final ImmutableList<Type> argumentsList;
        @NullableDecl
        private final Type ownerType;
        private final Class<?> rawType;

        ParameterizedTypeImpl(@NullableDecl Type type, Class<?> clazz, Type[] typeArray) {
            Preconditions.checkNotNull(clazz);
            boolean bl = typeArray.length == clazz.getTypeParameters().length;
            Preconditions.checkArgument(bl);
            Types.disallowPrimitiveType(typeArray, "type parameter");
            this.ownerType = type;
            this.rawType = clazz;
            this.argumentsList = JavaVersion.CURRENT.usedInGenericType(typeArray);
        }

        public boolean equals(Object object) {
            boolean bl = object instanceof ParameterizedType;
            boolean bl2 = false;
            if (!bl) {
                return false;
            }
            object = (ParameterizedType)object;
            bl = bl2;
            if (this.getRawType().equals(object.getRawType())) {
                bl = bl2;
                if (Objects.equal(this.getOwnerType(), object.getOwnerType())) {
                    bl = bl2;
                    if (Arrays.equals(this.getActualTypeArguments(), object.getActualTypeArguments())) {
                        bl = true;
                    }
                }
            }
            return bl;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return Types.toArray(this.argumentsList);
        }

        @Override
        public Type getOwnerType() {
            return this.ownerType;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        public int hashCode() {
            Type type = this.ownerType;
            int n2 = type == null ? 0 : type.hashCode();
            return n2 ^ this.argumentsList.hashCode() ^ this.rawType.hashCode();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.ownerType != null && JavaVersion.CURRENT.jdkTypeDuplicatesOwnerName()) {
                stringBuilder.append(JavaVersion.CURRENT.typeName(this.ownerType));
                stringBuilder.append('.');
            }
            stringBuilder.append(this.rawType.getName());
            stringBuilder.append('<');
            stringBuilder.append(COMMA_JOINER.join(Iterables.transform(this.argumentsList, TYPE_NAME)));
            stringBuilder.append('>');
            return stringBuilder.toString();
        }
    }

    private static final class TypeVariableImpl<D extends GenericDeclaration> {
        private final ImmutableList<Type> bounds;
        private final D genericDeclaration;
        private final String name;

        TypeVariableImpl(D d2, String string2, Type[] typeArray) {
            Types.disallowPrimitiveType(typeArray, "bound for type variable");
            this.genericDeclaration = (GenericDeclaration)Preconditions.checkNotNull(d2);
            this.name = Preconditions.checkNotNull(string2);
            this.bounds = ImmutableList.copyOf(typeArray);
        }

        public boolean equals(Object object) {
            boolean bl = NativeTypeVariableEquals.NATIVE_TYPE_VARIABLE_ONLY;
            boolean bl2 = true;
            boolean bl3 = true;
            if (bl) {
                if (object != null && Proxy.isProxyClass(object.getClass()) && Proxy.getInvocationHandler(object) instanceof TypeVariableInvocationHandler) {
                    if (!(this.name.equals(((TypeVariableImpl)(object = ((TypeVariableInvocationHandler)Proxy.getInvocationHandler(object)).typeVariableImpl)).getName()) && this.genericDeclaration.equals(((TypeVariableImpl)object).getGenericDeclaration()) && this.bounds.equals(((TypeVariableImpl)object).bounds))) {
                        bl3 = false;
                    }
                    return bl3;
                }
                return false;
            }
            if (object instanceof TypeVariable) {
                bl3 = this.name.equals((object = (TypeVariable)object).getName()) && this.genericDeclaration.equals(object.getGenericDeclaration()) ? bl2 : false;
                return bl3;
            }
            return false;
        }

        public Type[] getBounds() {
            return Types.toArray(this.bounds);
        }

        public D getGenericDeclaration() {
            return this.genericDeclaration;
        }

        public String getName() {
            return this.name;
        }

        public String getTypeName() {
            return this.name;
        }

        public int hashCode() {
            return this.genericDeclaration.hashCode() ^ this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }

    private static final class TypeVariableInvocationHandler
    implements InvocationHandler {
        private static final ImmutableMap<String, Method> typeVariableMethods;
        private final TypeVariableImpl<?> typeVariableImpl;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static {
            ImmutableMap.Builder<String, Method> builder = ImmutableMap.builder();
            Method[] methodArray = TypeVariableImpl.class.getMethods();
            int n2 = methodArray.length;
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    typeVariableMethods = builder.build();
                    return;
                }
                Method method = methodArray[n3];
                if (method.getDeclaringClass().equals(TypeVariableImpl.class)) {
                    try {
                        method.setAccessible(true);
                    }
                    catch (AccessControlException accessControlException) {}
                    builder.put(method.getName(), method);
                }
                ++n3;
            }
        }

        TypeVariableInvocationHandler(TypeVariableImpl<?> typeVariableImpl) {
            this.typeVariableImpl = typeVariableImpl;
        }

        @Override
        public Object invoke(Object object, Method object2, Object[] objectArray) throws Throwable {
            object = typeVariableMethods.get(object2 = ((Method)object2).getName());
            if (object != null) {
                try {
                    object = ((Method)object).invoke(this.typeVariableImpl, objectArray);
                    return object;
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getCause();
                }
            }
            throw new UnsupportedOperationException((String)object2);
        }
    }

    static final class WildcardTypeImpl
    implements WildcardType,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final ImmutableList<Type> lowerBounds;
        private final ImmutableList<Type> upperBounds;

        WildcardTypeImpl(Type[] typeArray, Type[] typeArray2) {
            Types.disallowPrimitiveType(typeArray, "lower bound for wildcard");
            Types.disallowPrimitiveType(typeArray2, "upper bound for wildcard");
            this.lowerBounds = JavaVersion.CURRENT.usedInGenericType(typeArray);
            this.upperBounds = JavaVersion.CURRENT.usedInGenericType(typeArray2);
        }

        public boolean equals(Object object) {
            boolean bl;
            boolean bl2 = object instanceof WildcardType;
            boolean bl3 = bl = false;
            if (bl2) {
                object = (WildcardType)object;
                bl3 = bl;
                if (this.lowerBounds.equals(Arrays.asList(object.getLowerBounds()))) {
                    bl3 = bl;
                    if (this.upperBounds.equals(Arrays.asList(object.getUpperBounds()))) {
                        bl3 = true;
                    }
                }
            }
            return bl3;
        }

        @Override
        public Type[] getLowerBounds() {
            return Types.toArray(this.lowerBounds);
        }

        @Override
        public Type[] getUpperBounds() {
            return Types.toArray(this.upperBounds);
        }

        public int hashCode() {
            return this.lowerBounds.hashCode() ^ this.upperBounds.hashCode();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("?");
            for (Type object : this.lowerBounds) {
                stringBuilder.append(" super ");
                stringBuilder.append(JavaVersion.CURRENT.typeName(object));
            }
            for (Object object : Types.filterUpperBounds(this.upperBounds)) {
                stringBuilder.append(" extends ");
                stringBuilder.append(JavaVersion.CURRENT.typeName((Type)object));
            }
            return stringBuilder.toString();
        }
    }
}

