/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Primitives;
import com.google.common.reflect.Invokable;
import com.google.common.reflect.TypeCapture;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeResolver;
import com.google.common.reflect.TypeVisitor;
import com.google.common.reflect.Types;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class TypeToken<T>
extends TypeCapture<T>
implements Serializable {
    private static final long serialVersionUID = 3637540370352322684L;
    @MonotonicNonNullDecl
    private transient TypeResolver covariantTypeResolver;
    @MonotonicNonNullDecl
    private transient TypeResolver invariantTypeResolver;
    private final Type runtimeType;

    protected TypeToken() {
        Type type = this.runtimeType = this.capture();
        Preconditions.checkState(type instanceof TypeVariable ^ true, "Cannot construct a TypeToken for a type variable.\nYou probably meant to call new TypeToken<%s>(getClass()) that can resolve the type variable for you.\nIf you do need to create a TypeToken of a type variable, please use TypeToken.of() instead.", (Object)type);
    }

    protected TypeToken(Class<?> clazz) {
        Type type = super.capture();
        this.runtimeType = type instanceof Class ? type : TypeResolver.covariantly(clazz).resolveType(type);
    }

    private TypeToken(Type type) {
        this.runtimeType = Preconditions.checkNotNull(type);
    }

    private static Bounds any(Type[] typeArray) {
        return new Bounds(typeArray, true);
    }

    @NullableDecl
    private TypeToken<? super T> boundAsSuperclass(Type object) {
        TypeToken<?> typeToken = TypeToken.of((Type)object);
        object = typeToken;
        if (typeToken.getRawType().isInterface()) {
            object = null;
        }
        return object;
    }

    private ImmutableList<TypeToken<? super T>> boundsAsInterfaces(Type[] typeArray) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int n2 = typeArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            TypeToken<?> typeToken = TypeToken.of(typeArray[i2]);
            if (!typeToken.getRawType().isInterface()) continue;
            builder.add(typeToken);
        }
        return builder.build();
    }

    private static Type canonicalizeTypeArg(TypeVariable<?> type, Type type2) {
        type = type2 instanceof WildcardType ? TypeToken.canonicalizeWildcardType(type, (WildcardType)type2) : TypeToken.canonicalizeWildcardsInType(type2);
        return type;
    }

    /*
     * WARNING - void declaration
     */
    private static WildcardType canonicalizeWildcardType(TypeVariable<?> type2, WildcardType wildcardType) {
        void var1_3;
        Type[] typeArray = type2.getBounds();
        ArrayList<Type> arrayList = new ArrayList<Type>();
        for (Type type : var1_3.getUpperBounds()) {
            if (TypeToken.any(typeArray).isSubtypeOf(type)) continue;
            arrayList.add(TypeToken.canonicalizeWildcardsInType(type));
        }
        return new Types.WildcardTypeImpl(var1_3.getLowerBounds(), arrayList.toArray(new Type[0]));
    }

    private static ParameterizedType canonicalizeWildcardsInParameterizedType(ParameterizedType parameterizedType) {
        Class clazz = (Class)parameterizedType.getRawType();
        TypeVariable<Class<T>>[] typeVariableArray = clazz.getTypeParameters();
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        for (int i2 = 0; i2 < typeArray.length; ++i2) {
            typeArray[i2] = TypeToken.canonicalizeTypeArg(typeVariableArray[i2], typeArray[i2]);
        }
        return Types.newParameterizedTypeWithOwner(parameterizedType.getOwnerType(), clazz, typeArray);
    }

    private static Type canonicalizeWildcardsInType(Type type) {
        if (type instanceof ParameterizedType) {
            return TypeToken.canonicalizeWildcardsInParameterizedType((ParameterizedType)type);
        }
        Type type2 = type;
        if (type instanceof GenericArrayType) {
            type2 = Types.newArrayType(TypeToken.canonicalizeWildcardsInType(((GenericArrayType)type).getGenericComponentType()));
        }
        return type2;
    }

    private static Bounds every(Type[] typeArray) {
        return new Bounds(typeArray, false);
    }

    private TypeToken<? extends T> getArraySubtype(Class<?> clazz) {
        return TypeToken.of(TypeToken.newArrayClassOrGenericArrayType(this.getComponentType().getSubtype(clazz.getComponentType()).runtimeType));
    }

    private TypeToken<? super T> getArraySupertype(Class<? super T> clazz) {
        return TypeToken.of(TypeToken.newArrayClassOrGenericArrayType(Preconditions.checkNotNull(this.getComponentType(), (String)"%s isn't a super type of %s", clazz, (Object)this).getSupertype(clazz.getComponentType()).runtimeType));
    }

    private TypeResolver getCovariantTypeResolver() {
        TypeResolver typeResolver;
        TypeResolver typeResolver2 = typeResolver = this.covariantTypeResolver;
        if (typeResolver == null) {
            this.covariantTypeResolver = typeResolver2 = TypeResolver.covariantly(this.runtimeType);
        }
        return typeResolver2;
    }

    private TypeResolver getInvariantTypeResolver() {
        TypeResolver typeResolver;
        TypeResolver typeResolver2 = typeResolver = this.invariantTypeResolver;
        if (typeResolver == null) {
            this.invariantTypeResolver = typeResolver2 = TypeResolver.invariantly(this.runtimeType);
        }
        return typeResolver2;
    }

    @NullableDecl
    private Type getOwnerTypeIfPresent() {
        Type type = this.runtimeType;
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getOwnerType();
        }
        if (type instanceof Class) {
            return ((Class)type).getEnclosingClass();
        }
        return null;
    }

    private ImmutableSet<Class<? super T>> getRawTypes() {
        final ImmutableSet.Builder builder = ImmutableSet.builder();
        new TypeVisitor(){

            void visitClass(Class<?> clazz) {
                builder.add(clazz);
            }

            void visitGenericArrayType(GenericArrayType genericArrayType) {
                builder.add(Types.getArrayClass(TypeToken.of(genericArrayType.getGenericComponentType()).getRawType()));
            }

            void visitParameterizedType(ParameterizedType parameterizedType) {
                builder.add((Class)parameterizedType.getRawType());
            }

            void visitTypeVariable(TypeVariable<?> typeVariable) {
                this.visit(typeVariable.getBounds());
            }

            void visitWildcardType(WildcardType wildcardType) {
                this.visit(wildcardType.getUpperBounds());
            }
        }.visit(new Type[]{this.runtimeType});
        return builder.build();
    }

    private TypeToken<? extends T> getSubtypeFromLowerBounds(Class<?> clazz, Type[] object) {
        if (((Type[])object).length > 0) {
            return TypeToken.of(object[0]).getSubtype(clazz);
        }
        object = new StringBuilder();
        ((StringBuilder)object).append(clazz);
        ((StringBuilder)object).append(" isn't a subclass of ");
        ((StringBuilder)object).append(this);
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    private TypeToken<? super T> getSupertypeFromUpperBounds(Class<? super T> serializable, Type[] object) {
        int n2 = ((Type[])object).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            TypeToken<?> typeToken = TypeToken.of(object[i2]);
            if (!typeToken.isSubtypeOf((Type)((Object)serializable))) continue;
            return typeToken.getSupertype((Class<?>)serializable);
        }
        object = new StringBuilder();
        ((StringBuilder)object).append(serializable);
        ((StringBuilder)object).append(" isn't a super type of ");
        ((StringBuilder)object).append(this);
        serializable = new IllegalArgumentException(((StringBuilder)object).toString());
        throw serializable;
    }

    private boolean is(Type type, TypeVariable<?> typeVariable) {
        boolean bl = this.runtimeType.equals(type);
        boolean bl2 = true;
        if (bl) {
            return true;
        }
        if (type instanceof WildcardType) {
            if (!TypeToken.every((type = TypeToken.canonicalizeWildcardType(typeVariable, (WildcardType)type)).getUpperBounds()).isSupertypeOf(this.runtimeType) || !TypeToken.every(type.getLowerBounds()).isSubtypeOf(this.runtimeType)) {
                bl2 = false;
            }
            return bl2;
        }
        return TypeToken.canonicalizeWildcardsInType(this.runtimeType).equals(TypeToken.canonicalizeWildcardsInType(type));
    }

    private boolean isOwnedBySubtypeOf(Type type) {
        Iterator iterator2 = this.getTypes().iterator();
        while (iterator2.hasNext()) {
            Type type2 = ((TypeToken)iterator2.next()).getOwnerTypeIfPresent();
            if (type2 == null || !TypeToken.of(type2).isSubtypeOf(type)) continue;
            return true;
        }
        return false;
    }

    private boolean isSubtypeOfArrayType(GenericArrayType genericArrayType) {
        Type type = this.runtimeType;
        if (type instanceof Class) {
            if (!((Class)(type = (Class)type)).isArray()) {
                return false;
            }
            return TypeToken.of(((Class)type).getComponentType()).isSubtypeOf(genericArrayType.getGenericComponentType());
        }
        if (type instanceof GenericArrayType) {
            return TypeToken.of(((GenericArrayType)type).getGenericComponentType()).isSubtypeOf(genericArrayType.getGenericComponentType());
        }
        return false;
    }

    private boolean isSubtypeOfParameterizedType(ParameterizedType parameterizedType) {
        TypeVariable<Class<?>>[] typeVariableArray = TypeToken.of(parameterizedType).getRawType();
        boolean bl = this.someRawTypeIsSubclassOf((Class<?>)typeVariableArray);
        boolean bl2 = false;
        if (!bl) {
            return false;
        }
        typeVariableArray = typeVariableArray.getTypeParameters();
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        for (int i2 = 0; i2 < typeVariableArray.length; ++i2) {
            if (super.is(typeArray[i2], typeVariableArray[i2])) continue;
            return false;
        }
        if (Modifier.isStatic(((Class)parameterizedType.getRawType()).getModifiers()) || parameterizedType.getOwnerType() == null || this.isOwnedBySubtypeOf(parameterizedType.getOwnerType())) {
            bl2 = true;
        }
        return bl2;
    }

    private boolean isSupertypeOfArray(GenericArrayType genericArrayType) {
        Type type = this.runtimeType;
        if (type instanceof Class) {
            if (!((Class)(type = (Class)type)).isArray()) {
                return ((Class)type).isAssignableFrom(Object[].class);
            }
            return TypeToken.of(genericArrayType.getGenericComponentType()).isSubtypeOf(((Class)type).getComponentType());
        }
        if (type instanceof GenericArrayType) {
            return TypeToken.of(genericArrayType.getGenericComponentType()).isSubtypeOf(((GenericArrayType)this.runtimeType).getGenericComponentType());
        }
        return false;
    }

    private boolean isWrapper() {
        return Primitives.allWrapperTypes().contains(this.runtimeType);
    }

    private static Type newArrayClassOrGenericArrayType(Type type) {
        return Types.JavaVersion.JAVA7.newArrayType(type);
    }

    public static <T> TypeToken<T> of(Class<T> clazz) {
        return new SimpleTypeToken((Type)clazz);
    }

    public static TypeToken<?> of(Type type) {
        return new SimpleTypeToken(type);
    }

    private TypeToken<?> resolveSupertype(Type object) {
        object = TypeToken.of(this.getCovariantTypeResolver().resolveType((Type)object));
        ((TypeToken)object).covariantTypeResolver = this.covariantTypeResolver;
        ((TypeToken)object).invariantTypeResolver = this.invariantTypeResolver;
        return object;
    }

    private Type resolveTypeArgsForSubclass(Class<?> type) {
        if (this.runtimeType instanceof Class && (type.getTypeParameters().length == 0 || this.getRawType().getTypeParameters().length != 0)) {
            return type;
        }
        TypeToken<?> typeToken = TypeToken.toGenericType(type);
        type = typeToken.getSupertype(this.getRawType()).runtimeType;
        return new TypeResolver().where(type, this.runtimeType).resolveType(typeToken.runtimeType);
    }

    private boolean someRawTypeIsSubclassOf(Class<?> clazz) {
        Iterator iterator2 = this.getRawTypes().iterator();
        while (iterator2.hasNext()) {
            if (!clazz.isAssignableFrom((Class)iterator2.next())) continue;
            return true;
        }
        return false;
    }

    static <T> TypeToken<? extends T> toGenericType(Class<T> clazz) {
        if (clazz.isArray()) {
            return TypeToken.of(Types.newArrayType(TypeToken.toGenericType(clazz.getComponentType()).runtimeType));
        }
        Type[] typeArray = clazz.getTypeParameters();
        Type type = clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers()) ? TypeToken.toGenericType(clazz.getEnclosingClass()).runtimeType : null;
        if (typeArray.length <= 0 && (type == null || type == clazz.getEnclosingClass())) {
            return TypeToken.of(clazz);
        }
        return TypeToken.of(Types.newParameterizedTypeWithOwner(type, clazz, typeArray));
    }

    public final Invokable<T, T> constructor(Constructor<?> constructor) {
        boolean bl = constructor.getDeclaringClass() == this.getRawType();
        Preconditions.checkArgument(bl, "%s not declared by %s", constructor, this.getRawType());
        return new Invokable.ConstructorInvokable<T>(constructor){

            @Override
            Type[] getGenericExceptionTypes() {
                return TypeToken.this.getCovariantTypeResolver().resolveTypesInPlace(super.getGenericExceptionTypes());
            }

            @Override
            Type[] getGenericParameterTypes() {
                return TypeToken.this.getInvariantTypeResolver().resolveTypesInPlace(super.getGenericParameterTypes());
            }

            @Override
            Type getGenericReturnType() {
                return TypeToken.this.getCovariantTypeResolver().resolveType(super.getGenericReturnType());
            }

            @Override
            public TypeToken<T> getOwnerType() {
                return TypeToken.this;
            }

            @Override
            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.getOwnerType());
                stringBuilder.append("(");
                stringBuilder.append(Joiner.on(", ").join(this.getGenericParameterTypes()));
                stringBuilder.append(")");
                return stringBuilder.toString();
            }
        };
    }

    public boolean equals(@NullableDecl Object object) {
        if (object instanceof TypeToken) {
            object = (TypeToken)object;
            return this.runtimeType.equals(((TypeToken)object).runtimeType);
        }
        return false;
    }

    @NullableDecl
    public final TypeToken<?> getComponentType() {
        Type type = Types.getComponentType(this.runtimeType);
        if (type == null) {
            return null;
        }
        return TypeToken.of(type);
    }

    final ImmutableList<TypeToken<? super T>> getGenericInterfaces() {
        Type[] typeArray = this.runtimeType;
        if (typeArray instanceof TypeVariable) {
            return this.boundsAsInterfaces(((TypeVariable)typeArray).getBounds());
        }
        if (typeArray instanceof WildcardType) {
            return this.boundsAsInterfaces(((WildcardType)typeArray).getUpperBounds());
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        typeArray = this.getRawType().getGenericInterfaces();
        int n2 = typeArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            builder.add(this.resolveSupertype(typeArray[i2]));
        }
        return builder.build();
    }

    @NullableDecl
    final TypeToken<? super T> getGenericSuperclass() {
        Type type = this.runtimeType;
        if (type instanceof TypeVariable) {
            return this.boundAsSuperclass(((TypeVariable)type).getBounds()[0]);
        }
        if (type instanceof WildcardType) {
            return this.boundAsSuperclass(((WildcardType)type).getUpperBounds()[0]);
        }
        type = this.getRawType().getGenericSuperclass();
        if (type == null) {
            return null;
        }
        return this.resolveSupertype(type);
    }

    public final Class<? super T> getRawType() {
        return (Class)this.getRawTypes().iterator().next();
    }

    public final TypeToken<? extends T> getSubtype(Class<?> serializable) {
        Preconditions.checkArgument(this.runtimeType instanceof TypeVariable ^ true, "Cannot get subtype of type variable <%s>", (Object)this);
        Type type = this.runtimeType;
        if (type instanceof WildcardType) {
            return this.getSubtypeFromLowerBounds((Class<?>)serializable, ((WildcardType)type).getLowerBounds());
        }
        if (this.isArray()) {
            return this.getArraySubtype((Class<?>)serializable);
        }
        Preconditions.checkArgument(this.getRawType().isAssignableFrom((Class<?>)serializable), "%s isn't a subclass of %s", serializable, (Object)this);
        serializable = TypeToken.of(this.resolveTypeArgsForSubclass((Class<?>)serializable));
        Preconditions.checkArgument(((TypeToken)serializable).isSubtypeOf(this), "%s does not appear to be a subtype of %s", (Object)serializable, (Object)this);
        return serializable;
    }

    public final TypeToken<? super T> getSupertype(Class<? super T> clazz) {
        Preconditions.checkArgument(this.someRawTypeIsSubclassOf(clazz), "%s is not a super class of %s", clazz, (Object)this);
        Type type = this.runtimeType;
        if (type instanceof TypeVariable) {
            return this.getSupertypeFromUpperBounds(clazz, ((TypeVariable)type).getBounds());
        }
        if (type instanceof WildcardType) {
            return this.getSupertypeFromUpperBounds(clazz, ((WildcardType)type).getUpperBounds());
        }
        if (clazz.isArray()) {
            return this.getArraySupertype(clazz);
        }
        return this.resolveSupertype(TypeToken.toGenericType(clazz).runtimeType);
    }

    public final Type getType() {
        return this.runtimeType;
    }

    public final TypeSet getTypes() {
        return new TypeSet();
    }

    public int hashCode() {
        return this.runtimeType.hashCode();
    }

    public final boolean isArray() {
        boolean bl = this.getComponentType() != null;
        return bl;
    }

    public final boolean isPrimitive() {
        Type type = this.runtimeType;
        boolean bl = type instanceof Class && ((Class)type).isPrimitive();
        return bl;
    }

    public final boolean isSubtypeOf(TypeToken<?> typeToken) {
        return this.isSubtypeOf(typeToken.getType());
    }

    public final boolean isSubtypeOf(Type type) {
        Preconditions.checkNotNull(type);
        if (type instanceof WildcardType) {
            return TypeToken.any(((WildcardType)type).getLowerBounds()).isSupertypeOf(this.runtimeType);
        }
        Type type2 = this.runtimeType;
        if (type2 instanceof WildcardType) {
            return TypeToken.any(((WildcardType)type2).getUpperBounds()).isSubtypeOf(type);
        }
        boolean bl = type2 instanceof TypeVariable;
        boolean bl2 = false;
        if (bl) {
            if (type2.equals(type) || TypeToken.any(((TypeVariable)this.runtimeType).getBounds()).isSubtypeOf(type)) {
                bl2 = true;
            }
            return bl2;
        }
        if (type2 instanceof GenericArrayType) {
            return super.isSupertypeOfArray((GenericArrayType)this.runtimeType);
        }
        if (type instanceof Class) {
            return this.someRawTypeIsSubclassOf((Class)type);
        }
        if (type instanceof ParameterizedType) {
            return this.isSubtypeOfParameterizedType((ParameterizedType)type);
        }
        if (type instanceof GenericArrayType) {
            return this.isSubtypeOfArrayType((GenericArrayType)type);
        }
        return false;
    }

    public final boolean isSupertypeOf(TypeToken<?> typeToken) {
        return typeToken.isSubtypeOf(this.getType());
    }

    public final boolean isSupertypeOf(Type type) {
        return TypeToken.of(type).isSubtypeOf(this.getType());
    }

    public final Invokable<T, Object> method(Method method) {
        Preconditions.checkArgument(this.someRawTypeIsSubclassOf(method.getDeclaringClass()), "%s not declared by %s", (Object)method, (Object)this);
        return new Invokable.MethodInvokable<T>(method){

            @Override
            Type[] getGenericExceptionTypes() {
                return TypeToken.this.getCovariantTypeResolver().resolveTypesInPlace(super.getGenericExceptionTypes());
            }

            @Override
            Type[] getGenericParameterTypes() {
                return TypeToken.this.getInvariantTypeResolver().resolveTypesInPlace(super.getGenericParameterTypes());
            }

            @Override
            Type getGenericReturnType() {
                return TypeToken.this.getCovariantTypeResolver().resolveType(super.getGenericReturnType());
            }

            @Override
            public TypeToken<T> getOwnerType() {
                return TypeToken.this;
            }

            @Override
            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.getOwnerType());
                stringBuilder.append(".");
                stringBuilder.append(super.toString());
                return stringBuilder.toString();
            }
        };
    }

    final TypeToken<T> rejectTypeVariables() {
        new TypeVisitor(){

            void visitGenericArrayType(GenericArrayType genericArrayType) {
                this.visit(new Type[]{genericArrayType.getGenericComponentType()});
            }

            void visitParameterizedType(ParameterizedType parameterizedType) {
                this.visit(parameterizedType.getActualTypeArguments());
                this.visit(new Type[]{parameterizedType.getOwnerType()});
            }

            void visitTypeVariable(TypeVariable<?> object) {
                object = new StringBuilder();
                ((StringBuilder)object).append(TypeToken.this.runtimeType);
                ((StringBuilder)object).append("contains a type variable and is not safe for the operation");
                throw new IllegalArgumentException(((StringBuilder)object).toString());
            }

            void visitWildcardType(WildcardType wildcardType) {
                this.visit(wildcardType.getLowerBounds());
                this.visit(wildcardType.getUpperBounds());
            }
        }.visit(new Type[]{this.runtimeType});
        return this;
    }

    public final TypeToken<?> resolveType(Type type) {
        Preconditions.checkNotNull(type);
        return TypeToken.of(this.getInvariantTypeResolver().resolveType(type));
    }

    public String toString() {
        return Types.toString(this.runtimeType);
    }

    public final TypeToken<T> unwrap() {
        if (this.isWrapper()) {
            return TypeToken.of(Primitives.unwrap((Class)((Class)this.runtimeType)));
        }
        return this;
    }

    public final <X> TypeToken<T> where(TypeParameter<X> typeParameter, TypeToken<X> typeToken) {
        return new SimpleTypeToken(new TypeResolver().where(ImmutableMap.of(new TypeResolver.TypeVariableKey(typeParameter.typeVariable), typeToken.runtimeType)).resolveType(this.runtimeType));
    }

    public final <X> TypeToken<T> where(TypeParameter<X> typeParameter, Class<X> clazz) {
        return this.where(typeParameter, TypeToken.of(clazz));
    }

    public final TypeToken<T> wrap() {
        if (this.isPrimitive()) {
            return TypeToken.of(Primitives.wrap((Class)((Class)this.runtimeType)));
        }
        return this;
    }

    protected Object writeReplace() {
        return TypeToken.of(new TypeResolver().resolveType(this.runtimeType));
    }

    private static class Bounds {
        private final Type[] bounds;
        private final boolean target;

        Bounds(Type[] typeArray, boolean bl) {
            this.bounds = typeArray;
            this.target = bl;
        }

        boolean isSubtypeOf(Type type) {
            Type[] typeArray = this.bounds;
            int n2 = typeArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                boolean bl;
                boolean bl2 = TypeToken.of(typeArray[i2]).isSubtypeOf(type);
                if (bl2 != (bl = this.target)) continue;
                return bl;
            }
            return this.target ^ true;
        }

        boolean isSupertypeOf(Type typeArray) {
            TypeToken<?> typeToken = TypeToken.of((Type)typeArray);
            typeArray = this.bounds;
            int n2 = typeArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                boolean bl;
                boolean bl2 = typeToken.isSubtypeOf(typeArray[i2]);
                if (bl2 != (bl = this.target)) continue;
                return bl;
            }
            return this.target ^ true;
        }
    }

    private final class ClassSet
    extends TypeSet {
        private static final long serialVersionUID = 0L;
        @MonotonicNonNullDecl
        private transient ImmutableSet<TypeToken<? super T>> classes;

        private ClassSet() {
        }

        private Object readResolve() {
            return TypeToken.this.getTypes().classes();
        }

        @Override
        public TypeSet classes() {
            return this;
        }

        @Override
        protected Set<TypeToken<? super T>> delegate() {
            ImmutableSet immutableSet;
            ImmutableSet immutableSet2 = immutableSet = this.classes;
            if (immutableSet == null) {
                immutableSet2 = FluentIterable.from(TypeCollector.FOR_GENERIC_TYPE.classesOnly().collectTypes(TypeToken.this)).filter(TypeFilter.IGNORE_TYPE_VARIABLE_OR_WILDCARD).toSet();
                this.classes = immutableSet2;
            }
            return immutableSet2;
        }

        @Override
        public TypeSet interfaces() {
            throw new UnsupportedOperationException("classes().interfaces() not supported.");
        }

        @Override
        public Set<Class<? super T>> rawTypes() {
            return ImmutableSet.copyOf(TypeCollector.FOR_RAW_TYPE.classesOnly().collectTypes((Class<?>)((Object)TypeToken.this.getRawTypes())));
        }
    }

    private final class InterfaceSet
    extends TypeSet {
        private static final long serialVersionUID = 0L;
        private final transient TypeSet allTypes;
        @MonotonicNonNullDecl
        private transient ImmutableSet<TypeToken<? super T>> interfaces;

        InterfaceSet(TypeSet typeSet) {
            this.allTypes = typeSet;
        }

        private Object readResolve() {
            return TypeToken.this.getTypes().interfaces();
        }

        @Override
        public TypeSet classes() {
            throw new UnsupportedOperationException("interfaces().classes() not supported.");
        }

        @Override
        protected Set<TypeToken<? super T>> delegate() {
            ImmutableSet immutableSet;
            ImmutableSet<TypeToken<Object>> immutableSet2 = immutableSet = this.interfaces;
            if (immutableSet == null) {
                immutableSet2 = FluentIterable.from(this.allTypes).filter(TypeFilter.INTERFACE_ONLY).toSet();
                this.interfaces = immutableSet2;
            }
            return immutableSet2;
        }

        @Override
        public TypeSet interfaces() {
            return this;
        }

        @Override
        public Set<Class<? super T>> rawTypes() {
            return FluentIterable.from(TypeCollector.FOR_RAW_TYPE.collectTypes((Class<?>)((Object)TypeToken.this.getRawTypes()))).filter(new Predicate<Class<?>>(){

                @Override
                public boolean apply(Class<?> clazz) {
                    return clazz.isInterface();
                }
            }).toSet();
        }
    }

    private static final class SimpleTypeToken<T>
    extends TypeToken<T> {
        private static final long serialVersionUID = 0L;

        SimpleTypeToken(Type type) {
            super(type);
        }
    }

    private static abstract class TypeCollector<K> {
        static final TypeCollector<TypeToken<?>> FOR_GENERIC_TYPE = new TypeCollector<TypeToken<?>>(){

            @Override
            Iterable<? extends TypeToken<?>> getInterfaces(TypeToken<?> typeToken) {
                return typeToken.getGenericInterfaces();
            }

            @Override
            Class<?> getRawType(TypeToken<?> typeToken) {
                return typeToken.getRawType();
            }

            @Override
            @NullableDecl
            TypeToken<?> getSuperclass(TypeToken<?> typeToken) {
                return typeToken.getGenericSuperclass();
            }
        };
        static final TypeCollector<Class<?>> FOR_RAW_TYPE = new TypeCollector<Class<?>>(){

            @Override
            Iterable<? extends Class<?>> getInterfaces(Class<?> clazz) {
                return Arrays.asList(clazz.getInterfaces());
            }

            @Override
            Class<?> getRawType(Class<?> clazz) {
                return clazz;
            }

            @Override
            @NullableDecl
            Class<?> getSuperclass(Class<?> clazz) {
                return clazz.getSuperclass();
            }
        };

        private TypeCollector() {
        }

        private int collectTypes(K k2, Map<? super K, Integer> map) {
            int n2;
            Object object = map.get(k2);
            if (object != null) {
                return (Integer)object;
            }
            boolean n22 = this.getRawType(k2).isInterface();
            object = this.getInterfaces(k2).iterator();
            while (object.hasNext()) {
                n2 = Math.max(n2, this.collectTypes(object.next(), map));
            }
            object = this.getSuperclass(k2);
            int n3 = n2;
            if (object != null) {
                n3 = Math.max(n2, this.collectTypes(object, map));
            }
            void var4_6 = n3 + true;
            map.put(k2, (int)var4_6);
            return (int)var4_6;
        }

        private static <K, V> ImmutableList<K> sortKeysByValue(final Map<K, V> map, final Comparator<? super V> comparator) {
            return new Ordering<K>(){

                @Override
                public int compare(K k2, K k3) {
                    return comparator.compare(map.get(k2), map.get(k3));
                }
            }.immutableSortedCopy(map.keySet());
        }

        final TypeCollector<K> classesOnly() {
            return new ForwardingTypeCollector<K>(this){

                @Override
                ImmutableList<K> collectTypes(Iterable<? extends K> iterable2) {
                    ImmutableList.Builder builder = ImmutableList.builder();
                    for (Iterable iterable2 : iterable2) {
                        if (this.getRawType(iterable2).isInterface()) continue;
                        builder.add(iterable2);
                    }
                    return super.collectTypes(builder.build());
                }

                @Override
                Iterable<? extends K> getInterfaces(K k2) {
                    return ImmutableSet.of();
                }
            };
        }

        ImmutableList<K> collectTypes(Iterable<? extends K> object) {
            HashMap hashMap = Maps.newHashMap();
            object = object.iterator();
            while (object.hasNext()) {
                this.collectTypes(object.next(), hashMap);
            }
            return TypeCollector.sortKeysByValue(hashMap, Ordering.natural().reverse());
        }

        final ImmutableList<K> collectTypes(K k2) {
            return this.collectTypes((K)ImmutableList.of(k2));
        }

        abstract Iterable<? extends K> getInterfaces(K var1);

        abstract Class<?> getRawType(K var1);

        @NullableDecl
        abstract K getSuperclass(K var1);

        private static class ForwardingTypeCollector<K>
        extends TypeCollector<K> {
            private final TypeCollector<K> delegate;

            ForwardingTypeCollector(TypeCollector<K> typeCollector) {
                this.delegate = typeCollector;
            }

            @Override
            Iterable<? extends K> getInterfaces(K k2) {
                return this.delegate.getInterfaces(k2);
            }

            @Override
            Class<?> getRawType(K k2) {
                return this.delegate.getRawType(k2);
            }

            @Override
            K getSuperclass(K k2) {
                return this.delegate.getSuperclass(k2);
            }
        }
    }

    private static enum TypeFilter implements Predicate<TypeToken<?>>
    {
        IGNORE_TYPE_VARIABLE_OR_WILDCARD{

            @Override
            public boolean apply(TypeToken<?> typeToken) {
                boolean bl = !(((TypeToken)typeToken).runtimeType instanceof TypeVariable) && !(((TypeToken)typeToken).runtimeType instanceof WildcardType);
                return bl;
            }
        }
        ,
        INTERFACE_ONLY{

            @Override
            public boolean apply(TypeToken<?> typeToken) {
                return typeToken.getRawType().isInterface();
            }
        };

    }

    public class TypeSet
    extends ForwardingSet<TypeToken<? super T>>
    implements Serializable {
        private static final long serialVersionUID = 0L;
        @MonotonicNonNullDecl
        private transient ImmutableSet<TypeToken<? super T>> types;

        TypeSet() {
        }

        public TypeSet classes() {
            return new ClassSet();
        }

        @Override
        protected Set<TypeToken<? super T>> delegate() {
            ImmutableSet immutableSet;
            ImmutableSet immutableSet2 = immutableSet = this.types;
            if (immutableSet == null) {
                immutableSet2 = FluentIterable.from(TypeCollector.FOR_GENERIC_TYPE.collectTypes(TypeToken.this)).filter(TypeFilter.IGNORE_TYPE_VARIABLE_OR_WILDCARD).toSet();
                this.types = immutableSet2;
            }
            return immutableSet2;
        }

        public TypeSet interfaces() {
            return new InterfaceSet(this);
        }

        public Set<Class<? super T>> rawTypes() {
            return ImmutableSet.copyOf(TypeCollector.FOR_RAW_TYPE.collectTypes((Class<?>)((Object)TypeToken.this.getRawTypes())));
        }
    }
}

