/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeVisitor;
import com.google.common.reflect.Types;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class TypeResolver {
    private final TypeTable typeTable;

    public TypeResolver() {
        this.typeTable = new TypeTable();
    }

    private TypeResolver(TypeTable typeTable) {
        this.typeTable = typeTable;
    }

    static TypeResolver covariantly(Type type) {
        return new TypeResolver().where(TypeMappingIntrospector.getTypeMappings(type));
    }

    private static <T> T expectArgument(Class<T> clazz, Object object) {
        T t2;
        try {
            t2 = clazz.cast(object);
        }
        catch (ClassCastException classCastException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(object);
            stringBuilder.append(" is not a ");
            stringBuilder.append(clazz.getSimpleName());
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        return t2;
    }

    static TypeResolver invariantly(Type type) {
        type = WildcardCapturer.INSTANCE.capture(type);
        return new TypeResolver().where(TypeMappingIntrospector.getTypeMappings(type));
    }

    private static void populateTypeMappings(final Map<TypeVariableKey, Type> map, Type type, final Type type2) {
        if (type.equals(type2)) {
            return;
        }
        new TypeVisitor(){

            void visitClass(Class<?> clazz) {
                if (type2 instanceof WildcardType) {
                    return;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("No type mapping from ");
                stringBuilder.append(clazz);
                stringBuilder.append(" to ");
                stringBuilder.append(type2);
                throw new IllegalArgumentException(stringBuilder.toString());
            }

            void visitGenericArrayType(GenericArrayType genericArrayType) {
                Type type = type2;
                if (type instanceof WildcardType) {
                    return;
                }
                boolean bl = (type = Types.getComponentType(type)) != null;
                Preconditions.checkArgument(bl, "%s is not an array type.", (Object)type2);
                TypeResolver.populateTypeMappings(map, genericArrayType.getGenericComponentType(), type);
            }

            void visitParameterizedType(ParameterizedType parameterizedType) {
                Type[] typeArray = type2;
                if (typeArray instanceof WildcardType) {
                    return;
                }
                ParameterizedType parameterizedType2 = (ParameterizedType)TypeResolver.expectArgument(ParameterizedType.class, typeArray);
                if (parameterizedType.getOwnerType() != null && parameterizedType2.getOwnerType() != null) {
                    TypeResolver.populateTypeMappings(map, parameterizedType.getOwnerType(), parameterizedType2.getOwnerType());
                }
                Preconditions.checkArgument(parameterizedType.getRawType().equals(parameterizedType2.getRawType()), "Inconsistent raw type: %s vs. %s", (Object)parameterizedType, (Object)type2);
                Type[] typeArray2 = parameterizedType.getActualTypeArguments();
                typeArray = parameterizedType2.getActualTypeArguments();
                int n2 = typeArray2.length;
                int n3 = typeArray.length;
                boolean bl = n2 == n3;
                Preconditions.checkArgument(bl, "%s not compatible with %s", (Object)parameterizedType, (Object)parameterizedType2);
                for (int i2 = 0; i2 < typeArray2.length; ++i2) {
                    TypeResolver.populateTypeMappings(map, typeArray2[i2], typeArray[i2]);
                }
            }

            void visitTypeVariable(TypeVariable<?> typeVariable) {
                map.put(new TypeVariableKey(typeVariable), type2);
            }

            void visitWildcardType(WildcardType wildcardType) {
                Type[] typeArray = type2;
                if (!(typeArray instanceof WildcardType)) {
                    return;
                }
                Type[] typeArray2 = typeArray;
                Type[] typeArray3 = wildcardType.getUpperBounds();
                Type[] typeArray4 = typeArray2.getUpperBounds();
                typeArray = wildcardType.getLowerBounds();
                typeArray2 = typeArray2.getLowerBounds();
                int n2 = typeArray3.length;
                int n3 = typeArray4.length;
                int n4 = 0;
                boolean bl = n2 == n3 && typeArray.length == typeArray2.length;
                Preconditions.checkArgument(bl, "Incompatible type: %s vs. %s", (Object)wildcardType, (Object)type2);
                n2 = 0;
                while (true) {
                    if (n2 >= typeArray3.length) break;
                    TypeResolver.populateTypeMappings(map, typeArray3[n2], typeArray4[n2]);
                    ++n2;
                }
                for (n3 = n4; n3 < typeArray.length; ++n3) {
                    TypeResolver.populateTypeMappings(map, typeArray[n3], typeArray2[n3]);
                }
            }
        }.visit(new Type[]{type});
    }

    private Type resolveGenericArrayType(GenericArrayType genericArrayType) {
        return Types.newArrayType(this.resolveType(genericArrayType.getGenericComponentType()));
    }

    private ParameterizedType resolveParameterizedType(ParameterizedType typeArray) {
        Type type = typeArray.getOwnerType();
        type = type == null ? null : this.resolveType(type);
        Type type2 = this.resolveType(typeArray.getRawType());
        typeArray = this.resolveTypes(typeArray.getActualTypeArguments());
        return Types.newParameterizedTypeWithOwner(type, (Class)type2, typeArray);
    }

    private Type[] resolveTypes(Type[] typeArray) {
        Type[] typeArray2 = new Type[typeArray.length];
        for (int i2 = 0; i2 < typeArray.length; ++i2) {
            typeArray2[i2] = this.resolveType(typeArray[i2]);
        }
        return typeArray2;
    }

    private WildcardType resolveWildcardType(WildcardType typeArray) {
        Type[] typeArray2 = typeArray.getLowerBounds();
        typeArray = typeArray.getUpperBounds();
        return new Types.WildcardTypeImpl(this.resolveTypes(typeArray2), this.resolveTypes(typeArray));
    }

    public Type resolveType(Type type) {
        Preconditions.checkNotNull(type);
        if (type instanceof TypeVariable) {
            return this.typeTable.resolve((TypeVariable)type);
        }
        if (type instanceof ParameterizedType) {
            return this.resolveParameterizedType((ParameterizedType)type);
        }
        if (type instanceof GenericArrayType) {
            return this.resolveGenericArrayType((GenericArrayType)type);
        }
        Type type2 = type;
        if (type instanceof WildcardType) {
            type2 = this.resolveWildcardType((WildcardType)type);
        }
        return type2;
    }

    Type[] resolveTypesInPlace(Type[] typeArray) {
        for (int i2 = 0; i2 < typeArray.length; ++i2) {
            typeArray[i2] = this.resolveType(typeArray[i2]);
        }
        return typeArray;
    }

    public TypeResolver where(Type type, Type type2) {
        HashMap<TypeVariableKey, Type> hashMap = Maps.newHashMap();
        TypeResolver.populateTypeMappings(hashMap, Preconditions.checkNotNull(type), Preconditions.checkNotNull(type2));
        return this.where(hashMap);
    }

    TypeResolver where(Map<TypeVariableKey, ? extends Type> map) {
        return new TypeResolver(this.typeTable.where(map));
    }

    private static final class TypeMappingIntrospector
    extends TypeVisitor {
        private final Map<TypeVariableKey, Type> mappings = Maps.newHashMap();

        private TypeMappingIntrospector() {
        }

        static ImmutableMap<TypeVariableKey, Type> getTypeMappings(Type type) {
            Preconditions.checkNotNull(type);
            TypeMappingIntrospector typeMappingIntrospector = new TypeMappingIntrospector();
            typeMappingIntrospector.visit(new Type[]{type});
            return ImmutableMap.copyOf(typeMappingIntrospector.mappings);
        }

        private void map(TypeVariableKey typeVariableKey, Type type) {
            if (this.mappings.containsKey(typeVariableKey)) {
                return;
            }
            Type type2 = type;
            while (type2 != null) {
                if (typeVariableKey.equalsType(type2)) {
                    while (type != null) {
                        type = this.mappings.remove(TypeVariableKey.forLookup(type));
                    }
                    return;
                }
                type2 = this.mappings.get(TypeVariableKey.forLookup(type2));
            }
            this.mappings.put(typeVariableKey, type);
        }

        void visitClass(Class<?> clazz) {
            this.visit(new Type[]{clazz.getGenericSuperclass()});
            this.visit(clazz.getGenericInterfaces());
        }

        void visitParameterizedType(ParameterizedType parameterizedType) {
            Type[] typeArray;
            Class clazz = (Class)parameterizedType.getRawType();
            TypeVariable<Class<T>>[] typeVariableArray = clazz.getTypeParameters();
            boolean bl = typeVariableArray.length == (typeArray = parameterizedType.getActualTypeArguments()).length;
            Preconditions.checkState(bl);
            for (int i2 = 0; i2 < typeVariableArray.length; ++i2) {
                this.map(new TypeVariableKey(typeVariableArray[i2]), typeArray[i2]);
            }
            this.visit(new Type[]{clazz});
            this.visit(new Type[]{parameterizedType.getOwnerType()});
        }

        void visitTypeVariable(TypeVariable<?> typeVariable) {
            this.visit(typeVariable.getBounds());
        }

        void visitWildcardType(WildcardType wildcardType) {
            this.visit(wildcardType.getUpperBounds());
        }
    }

    private static class TypeTable {
        private final ImmutableMap<TypeVariableKey, Type> map;

        TypeTable() {
            this.map = ImmutableMap.of();
        }

        private TypeTable(ImmutableMap<TypeVariableKey, Type> immutableMap) {
            this.map = immutableMap;
        }

        final Type resolve(final TypeVariable<?> typeVariable) {
            return this.resolveInternal(typeVariable, new TypeTable(){

                @Override
                public Type resolveInternal(TypeVariable<?> typeVariable2, TypeTable typeTable) {
                    if (typeVariable2.getGenericDeclaration().equals(typeVariable.getGenericDeclaration())) {
                        return typeVariable2;
                    }
                    return this.resolveInternal(typeVariable2, typeTable);
                }
            });
        }

        Type resolveInternal(TypeVariable<?> typeVariable, TypeTable objectArray) {
            Object[] objectArray2 = this.map.get(new TypeVariableKey(typeVariable));
            if (objectArray2 == null) {
                objectArray2 = typeVariable.getBounds();
                if (objectArray2.length == 0) {
                    return typeVariable;
                }
                objectArray = new TypeResolver((TypeTable)objectArray).resolveTypes((Type[])objectArray2);
                if (Types.NativeTypeVariableEquals.NATIVE_TYPE_VARIABLE_ONLY && Arrays.equals(objectArray2, objectArray)) {
                    return typeVariable;
                }
                return Types.newArtificialTypeVariable(typeVariable.getGenericDeclaration(), typeVariable.getName(), (Type[])objectArray);
            }
            return new TypeResolver((TypeTable)objectArray).resolveType((Type)objectArray2);
        }

        final TypeTable where(Map<TypeVariableKey, ? extends Type> object) {
            ImmutableMap.Builder<TypeVariableKey, Type> builder = ImmutableMap.builder();
            builder.putAll(this.map);
            for (Map.Entry entry : object.entrySet()) {
                TypeVariableKey typeVariableKey = (TypeVariableKey)entry.getKey();
                Type object2 = (Type)entry.getValue();
                Preconditions.checkArgument(typeVariableKey.equalsType(object2) ^ true, "Type variable %s bound to itself", (Object)typeVariableKey);
                builder.put(typeVariableKey, object2);
            }
            return new TypeTable(builder.build());
        }
    }

    static final class TypeVariableKey {
        private final TypeVariable<?> var;

        TypeVariableKey(TypeVariable<?> typeVariable) {
            this.var = Preconditions.checkNotNull(typeVariable);
        }

        private boolean equalsTypeVariable(TypeVariable<?> typeVariable) {
            boolean bl = this.var.getGenericDeclaration().equals(typeVariable.getGenericDeclaration()) && this.var.getName().equals(typeVariable.getName());
            return bl;
        }

        static TypeVariableKey forLookup(Type type) {
            if (type instanceof TypeVariable) {
                return new TypeVariableKey((TypeVariable)type);
            }
            return null;
        }

        public boolean equals(Object object) {
            if (object instanceof TypeVariableKey) {
                return this.equalsTypeVariable(((TypeVariableKey)object).var);
            }
            return false;
        }

        boolean equalsType(Type type) {
            if (type instanceof TypeVariable) {
                return this.equalsTypeVariable((TypeVariable)type);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.var.getGenericDeclaration(), this.var.getName());
        }

        public String toString() {
            return this.var.toString();
        }
    }

    private static class WildcardCapturer {
        static final WildcardCapturer INSTANCE = new WildcardCapturer();
        private final AtomicInteger id;

        private WildcardCapturer() {
            this(new AtomicInteger());
        }

        private WildcardCapturer(AtomicInteger atomicInteger) {
            this.id = atomicInteger;
        }

        private Type captureNullable(@NullableDecl Type type) {
            if (type == null) {
                return null;
            }
            return this.capture(type);
        }

        private WildcardCapturer forTypeVariable(final TypeVariable<?> typeVariable) {
            return new WildcardCapturer(this.id){

                @Override
                TypeVariable<?> captureAsTypeVariable(Type[] object) {
                    object = new LinkedHashSet<Type>(Arrays.asList(object));
                    object.addAll(Arrays.asList(typeVariable.getBounds()));
                    if (object.size() > 1) {
                        object.remove(Object.class);
                    }
                    return super.captureAsTypeVariable(object.toArray(new Type[0]));
                }
            };
        }

        private WildcardCapturer notForTypeVariable() {
            return new WildcardCapturer(this.id);
        }

        final Type capture(Type object) {
            Preconditions.checkNotNull(object);
            if (object instanceof Class) {
                return object;
            }
            if (object instanceof TypeVariable) {
                return object;
            }
            if (object instanceof GenericArrayType) {
                object = (GenericArrayType)object;
                return Types.newArrayType(this.notForTypeVariable().capture(object.getGenericComponentType()));
            }
            if (object instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)object;
                Class clazz = (Class)parameterizedType.getRawType();
                object = clazz.getTypeParameters();
                Type[] typeArray = parameterizedType.getActualTypeArguments();
                for (int i2 = 0; i2 < typeArray.length; ++i2) {
                    typeArray[i2] = this.forTypeVariable(object[i2]).capture(typeArray[i2]);
                }
                return Types.newParameterizedTypeWithOwner(this.notForTypeVariable().captureNullable(parameterizedType.getOwnerType()), clazz, typeArray);
            }
            if (object instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)object;
                if (wildcardType.getLowerBounds().length == 0) {
                    object = this.captureAsTypeVariable(wildcardType.getUpperBounds());
                }
                return object;
            }
            object = new AssertionError((Object)"must have been one of the known types");
            throw object;
        }

        TypeVariable<?> captureAsTypeVariable(Type[] typeArray) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("capture#");
            stringBuilder.append(this.id.incrementAndGet());
            stringBuilder.append("-of ? extends ");
            stringBuilder.append(Joiner.on('&').join(typeArray));
            return Types.newArtificialTypeVariable(WildcardCapturer.class, stringBuilder.toString(), typeArray);
        }
    }
}

