/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Parameter
implements AnnotatedElement {
    private final ImmutableList<Annotation> annotations;
    private final Invokable<?, ?> declaration;
    private final int position;
    private final TypeToken<?> type;

    Parameter(Invokable<?, ?> invokable, int n2, TypeToken<?> typeToken, Annotation[] annotationArray) {
        this.declaration = invokable;
        this.position = n2;
        this.type = typeToken;
        this.annotations = ImmutableList.copyOf(annotationArray);
    }

    public boolean equals(@NullableDecl Object object) {
        boolean bl;
        boolean bl2 = object instanceof Parameter;
        boolean bl3 = bl = false;
        if (bl2) {
            object = (Parameter)object;
            bl3 = bl;
            if (this.position == ((Parameter)object).position) {
                bl3 = bl;
                if (this.declaration.equals(((Parameter)object).declaration)) {
                    bl3 = true;
                }
            }
        }
        return bl3;
    }

    @NullableDecl
    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        Preconditions.checkNotNull(clazz);
        for (Annotation annotation : this.annotations) {
            if (!clazz.isInstance(annotation)) continue;
            return (A)((Annotation)clazz.cast(annotation));
        }
        return null;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.getDeclaredAnnotations();
    }

    public <A extends Annotation> A[] getAnnotationsByType(Class<A> clazz) {
        return this.getDeclaredAnnotationsByType(clazz);
    }

    @NullableDecl
    public <A extends Annotation> A getDeclaredAnnotation(Class<A> clazz) {
        Preconditions.checkNotNull(clazz);
        return (A)((Annotation)FluentIterable.from(this.annotations).filter(clazz).first().orNull());
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        ImmutableList<Annotation> immutableList = this.annotations;
        return immutableList.toArray(new Annotation[immutableList.size()]);
    }

    public <A extends Annotation> A[] getDeclaredAnnotationsByType(Class<A> clazz) {
        return (Annotation[])FluentIterable.from(this.annotations).filter(clazz).toArray(clazz);
    }

    public Invokable<?, ?> getDeclaringInvokable() {
        return this.declaration;
    }

    public TypeToken<?> getType() {
        return this.type;
    }

    public int hashCode() {
        return this.position;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> clazz) {
        boolean bl = this.getAnnotation((Class)clazz) != null;
        return bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.type);
        stringBuilder.append(" arg");
        stringBuilder.append(this.position);
        return stringBuilder.toString();
    }
}

