/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Element;
import com.google.common.reflect.Parameter;
import com.google.common.reflect.TypeToken;
import com.google.common.reflect.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class Invokable<T, R>
extends Element
implements GenericDeclaration {
    <M extends AccessibleObject> Invokable(M m2) {
        super(m2);
    }

    public static <T> Invokable<T, T> from(Constructor<T> constructor) {
        return new ConstructorInvokable(constructor);
    }

    public static Invokable<?, Object> from(Method method) {
        return new MethodInvokable(method);
    }

    public final Class<? super T> getDeclaringClass() {
        return super.getDeclaringClass();
    }

    public final ImmutableList<TypeToken<? extends Throwable>> getExceptionTypes() {
        ImmutableList.Builder builder = ImmutableList.builder();
        Type[] typeArray = this.getGenericExceptionTypes();
        int n2 = typeArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            builder.add(TypeToken.of(typeArray[i2]));
        }
        return builder.build();
    }

    abstract Type[] getGenericExceptionTypes();

    abstract Type[] getGenericParameterTypes();

    abstract Type getGenericReturnType();

    public TypeToken<T> getOwnerType() {
        return TypeToken.of(this.getDeclaringClass());
    }

    abstract Annotation[][] getParameterAnnotations();

    public final ImmutableList<Parameter> getParameters() {
        Type[] typeArray = this.getGenericParameterTypes();
        Annotation[][] annotationArray = this.getParameterAnnotations();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i2 = 0; i2 < typeArray.length; ++i2) {
            builder.add(new Parameter(this, i2, TypeToken.of(typeArray[i2]), annotationArray[i2]));
        }
        return builder.build();
    }

    public final TypeToken<? extends R> getReturnType() {
        return TypeToken.of(this.getGenericReturnType());
    }

    public final R invoke(@NullableDecl T t2, Object ... objectArray) throws InvocationTargetException, IllegalAccessException {
        return (R)this.invokeInternal(t2, Preconditions.checkNotNull(objectArray));
    }

    abstract Object invokeInternal(@NullableDecl Object var1, Object[] var2) throws InvocationTargetException, IllegalAccessException;

    public abstract boolean isOverridable();

    public abstract boolean isVarArgs();

    public final <R1 extends R> Invokable<T, R1> returning(TypeToken<R1> typeToken) {
        if (typeToken.isSupertypeOf(this.getReturnType())) {
            return this;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Invokable is known to return ");
        stringBuilder.append(this.getReturnType());
        stringBuilder.append(", not ");
        stringBuilder.append(typeToken);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public final <R1 extends R> Invokable<T, R1> returning(Class<R1> clazz) {
        return this.returning(TypeToken.of(clazz));
    }

    static class ConstructorInvokable<T>
    extends Invokable<T, T> {
        final Constructor<?> constructor;

        ConstructorInvokable(Constructor<?> constructor) {
            super(constructor);
            this.constructor = constructor;
        }

        private boolean mayNeedHiddenThis() {
            Class<?> clazz = this.constructor.getDeclaringClass();
            Executable executable = clazz.getEnclosingConstructor();
            boolean bl = true;
            if (executable != null) {
                return true;
            }
            executable = clazz.getEnclosingMethod();
            if (executable != null) {
                return Modifier.isStatic(((Method)executable).getModifiers()) ^ true;
            }
            if (clazz.getEnclosingClass() == null || Modifier.isStatic(clazz.getModifiers())) {
                bl = false;
            }
            return bl;
        }

        @Override
        Type[] getGenericExceptionTypes() {
            return this.constructor.getGenericExceptionTypes();
        }

        @Override
        Type[] getGenericParameterTypes() {
            Type[] typeArray;
            Type[] typeArray2 = typeArray = this.constructor.getGenericParameterTypes();
            if (typeArray.length > 0) {
                typeArray2 = typeArray;
                if (this.mayNeedHiddenThis()) {
                    Class<?>[] classArray = this.constructor.getParameterTypes();
                    typeArray2 = typeArray;
                    if (typeArray.length == classArray.length) {
                        typeArray2 = typeArray;
                        if (classArray[0] == this.getDeclaringClass().getEnclosingClass()) {
                            typeArray2 = Arrays.copyOfRange(typeArray, 1, typeArray.length);
                        }
                    }
                }
            }
            return typeArray2;
        }

        @Override
        Type getGenericReturnType() {
            Class clazz = this.getDeclaringClass();
            Type[] typeArray = clazz.getTypeParameters();
            Type type = clazz;
            if (typeArray.length > 0) {
                type = Types.newParameterizedType(clazz, typeArray);
            }
            return type;
        }

        @Override
        final Annotation[][] getParameterAnnotations() {
            return this.constructor.getParameterAnnotations();
        }

        @Override
        public final TypeVariable<?>[] getTypeParameters() {
            TypeVariable<Class<T>>[] typeVariableArray = this.getDeclaringClass().getTypeParameters();
            TypeVariable<Constructor<?>>[] typeVariableArray2 = this.constructor.getTypeParameters();
            TypeVariable[] typeVariableArray3 = new TypeVariable[typeVariableArray.length + typeVariableArray2.length];
            System.arraycopy(typeVariableArray, 0, typeVariableArray3, 0, typeVariableArray.length);
            System.arraycopy(typeVariableArray2, 0, typeVariableArray3, typeVariableArray.length, typeVariableArray2.length);
            return typeVariableArray3;
        }

        @Override
        final Object invokeInternal(@NullableDecl Object object, Object[] objectArray) throws InvocationTargetException, IllegalAccessException {
            try {
                object = this.constructor.newInstance(objectArray);
                return object;
            }
            catch (InstantiationException instantiationException) {
                object = new StringBuilder();
                ((StringBuilder)object).append(this.constructor);
                ((StringBuilder)object).append(" failed.");
                throw new RuntimeException(((StringBuilder)object).toString(), instantiationException);
            }
        }

        @Override
        public final boolean isOverridable() {
            return false;
        }

        @Override
        public final boolean isVarArgs() {
            return this.constructor.isVarArgs();
        }
    }

    static class MethodInvokable<T>
    extends Invokable<T, Object> {
        final Method method;

        MethodInvokable(Method method) {
            super(method);
            this.method = method;
        }

        @Override
        Type[] getGenericExceptionTypes() {
            return this.method.getGenericExceptionTypes();
        }

        @Override
        Type[] getGenericParameterTypes() {
            return this.method.getGenericParameterTypes();
        }

        @Override
        Type getGenericReturnType() {
            return this.method.getGenericReturnType();
        }

        @Override
        final Annotation[][] getParameterAnnotations() {
            return this.method.getParameterAnnotations();
        }

        @Override
        public final TypeVariable<?>[] getTypeParameters() {
            return this.method.getTypeParameters();
        }

        @Override
        final Object invokeInternal(@NullableDecl Object object, Object[] objectArray) throws InvocationTargetException, IllegalAccessException {
            return this.method.invoke(object, objectArray);
        }

        @Override
        public final boolean isOverridable() {
            boolean bl = !this.isFinal() && !this.isPrivate() && !this.isStatic() && !Modifier.isFinal(this.getDeclaringClass().getModifiers());
            return bl;
        }

        @Override
        public final boolean isVarArgs() {
            return this.method.isVarArgs();
        }
    }
}

