/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import com.google.common.reflect.Reflection;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class ClassPath {
    private static final String CLASS_FILE_NAME_EXTENSION = ".class";
    private static final Splitter CLASS_PATH_ATTRIBUTE_SEPARATOR;
    private static final Predicate<ClassInfo> IS_TOP_LEVEL;
    private static final Logger logger;
    private final ImmutableSet<ResourceInfo> resources;

    static {
        logger = Logger.getLogger(ClassPath.class.getName());
        IS_TOP_LEVEL = new Predicate<ClassInfo>(){

            @Override
            public boolean apply(ClassInfo classInfo) {
                boolean bl = classInfo.className.indexOf(36) == -1;
                return bl;
            }
        };
        CLASS_PATH_ATTRIBUTE_SEPARATOR = Splitter.on(" ").omitEmptyStrings();
    }

    private ClassPath(ImmutableSet<ResourceInfo> immutableSet) {
        this.resources = immutableSet;
    }

    public static ClassPath from(ClassLoader classLoader) throws IOException {
        DefaultScanner defaultScanner = new DefaultScanner();
        defaultScanner.scan(classLoader);
        return new ClassPath(defaultScanner.getResources());
    }

    static String getClassName(String string2) {
        return string2.substring(0, string2.length() - 6).replace('/', '.');
    }

    static File toFile(URL uRL) {
        Preconditions.checkArgument(uRL.getProtocol().equals("file"));
        try {
            File file = new File(uRL.toURI());
            return file;
        }
        catch (URISyntaxException uRISyntaxException) {
            return new File(uRL.getPath());
        }
    }

    public ImmutableSet<ClassInfo> getAllClasses() {
        return FluentIterable.from(this.resources).filter(ClassInfo.class).toSet();
    }

    public ImmutableSet<ResourceInfo> getResources() {
        return this.resources;
    }

    public ImmutableSet<ClassInfo> getTopLevelClasses() {
        return FluentIterable.from(this.resources).filter(ClassInfo.class).filter(IS_TOP_LEVEL).toSet();
    }

    public ImmutableSet<ClassInfo> getTopLevelClasses(String string2) {
        Preconditions.checkNotNull(string2);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ClassInfo classInfo : this.getTopLevelClasses()) {
            if (!classInfo.getPackageName().equals(string2)) continue;
            builder.add(classInfo);
        }
        return builder.build();
    }

    public ImmutableSet<ClassInfo> getTopLevelClassesRecursive(String string2) {
        Preconditions.checkNotNull(string2);
        StringBuilder object2 = new StringBuilder();
        object2.append(string2);
        object2.append('.');
        string2 = object2.toString();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ClassInfo classInfo : this.getTopLevelClasses()) {
            if (!classInfo.getName().startsWith(string2)) continue;
            builder.add(classInfo);
        }
        return builder.build();
    }

    public static final class ClassInfo
    extends ResourceInfo {
        private final String className;

        ClassInfo(String string2, ClassLoader classLoader) {
            super(string2, classLoader);
            this.className = ClassPath.getClassName(string2);
        }

        public String getName() {
            return this.className;
        }

        public String getPackageName() {
            return Reflection.getPackageName((String)this.className);
        }

        public String getSimpleName() {
            int n2 = this.className.lastIndexOf(36);
            if (n2 != -1) {
                String string2 = this.className.substring(n2 + 1);
                return CharMatcher.digit().trimLeadingFrom(string2);
            }
            String string3 = this.getPackageName();
            if (string3.isEmpty()) {
                return this.className;
            }
            return this.className.substring(string3.length() + 1);
        }

        public Class<?> load() {
            try {
                Class<?> clazz = this.loader.loadClass(this.className);
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalStateException(classNotFoundException);
            }
        }

        @Override
        public String toString() {
            return this.className;
        }
    }

    static final class DefaultScanner
    extends Scanner {
        private final SetMultimap<ClassLoader, String> resources = MultimapBuilder.hashKeys().linkedHashSetValues().build();

        DefaultScanner() {
        }

        private void scanDirectory(File object, ClassLoader object2, String object3, Set<File> set) throws IOException {
            File[] fileArray = ((File)object).listFiles();
            if (fileArray == null) {
                object3 = logger;
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("Cannot read directory ");
                ((StringBuilder)object2).append(object);
                ((Logger)object3).warning(((StringBuilder)object2).toString());
                return;
            }
            for (File file : fileArray) {
                object = file.getName();
                if (file.isDirectory()) {
                    File file2 = file.getCanonicalFile();
                    if (!set.add(file2)) continue;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append((String)object3);
                    stringBuilder.append((String)object);
                    stringBuilder.append("/");
                    this.scanDirectory(file2, (ClassLoader)object2, stringBuilder.toString(), set);
                    set.remove(file2);
                    continue;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append((String)object3);
                stringBuilder.append((String)object);
                object = stringBuilder.toString();
                if (((String)object).equals("META-INF/MANIFEST.MF")) continue;
                this.resources.get((ClassLoader)object2).add((String)object);
            }
        }

        ImmutableSet<ResourceInfo> getResources() {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (Map.Entry<ClassLoader, String> entry : this.resources.entries()) {
                builder.add(ResourceInfo.of(entry.getValue(), entry.getKey()));
            }
            return builder.build();
        }

        @Override
        protected void scanDirectory(ClassLoader classLoader, File file) throws IOException {
            HashSet<File> hashSet = new HashSet<File>();
            hashSet.add(file.getCanonicalFile());
            this.scanDirectory(file, classLoader, "", hashSet);
        }

        @Override
        protected void scanJarFile(ClassLoader classLoader, JarFile object) {
            object = ((JarFile)object).entries();
            while (object.hasMoreElements()) {
                JarEntry jarEntry = (JarEntry)object.nextElement();
                if (jarEntry.isDirectory() || jarEntry.getName().equals("META-INF/MANIFEST.MF")) continue;
                this.resources.get(classLoader).add(jarEntry.getName());
            }
        }
    }

    public static class ResourceInfo {
        final ClassLoader loader;
        private final String resourceName;

        ResourceInfo(String string2, ClassLoader classLoader) {
            this.resourceName = Preconditions.checkNotNull(string2);
            this.loader = Preconditions.checkNotNull(classLoader);
        }

        static ResourceInfo of(String string2, ClassLoader classLoader) {
            if (string2.endsWith(ClassPath.CLASS_FILE_NAME_EXTENSION)) {
                return new ClassInfo(string2, classLoader);
            }
            return new ResourceInfo(string2, classLoader);
        }

        public final ByteSource asByteSource() {
            return Resources.asByteSource((URL)this.url());
        }

        public final CharSource asCharSource(Charset charset) {
            return Resources.asCharSource((URL)this.url(), (Charset)charset);
        }

        public boolean equals(Object object) {
            boolean bl;
            boolean bl2 = object instanceof ResourceInfo;
            boolean bl3 = bl = false;
            if (bl2) {
                object = (ResourceInfo)object;
                bl3 = bl;
                if (this.resourceName.equals(((ResourceInfo)object).resourceName)) {
                    bl3 = bl;
                    if (this.loader == ((ResourceInfo)object).loader) {
                        bl3 = true;
                    }
                }
            }
            return bl3;
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        public int hashCode() {
            return this.resourceName.hashCode();
        }

        public String toString() {
            return this.resourceName;
        }

        public final URL url() {
            URL uRL = this.loader.getResource(this.resourceName);
            if (uRL != null) {
                return uRL;
            }
            throw new NoSuchElementException(this.resourceName);
        }
    }

    static abstract class Scanner {
        private final Set<File> scannedUris = Sets.newHashSet();

        Scanner() {
        }

        private static ImmutableList<URL> getClassLoaderUrls(ClassLoader classLoader) {
            if (classLoader instanceof URLClassLoader) {
                return ImmutableList.copyOf(((URLClassLoader)classLoader).getURLs());
            }
            if (classLoader.equals(ClassLoader.getSystemClassLoader())) {
                return Scanner.parseJavaClassPath();
            }
            return ImmutableList.of();
        }

        static ImmutableMap<File, ClassLoader> getClassPathEntries(ClassLoader classLoader) {
            LinkedHashMap<Serializable, ClassLoader> linkedHashMap = Maps.newLinkedHashMap();
            ClassLoader classLoader2 = classLoader.getParent();
            if (classLoader2 != null) {
                linkedHashMap.putAll(Scanner.getClassPathEntries(classLoader2));
            }
            for (Serializable serializable : Scanner.getClassLoaderUrls(classLoader)) {
                if (!serializable.getProtocol().equals("file") || linkedHashMap.containsKey(serializable = ClassPath.toFile(serializable))) continue;
                linkedHashMap.put(serializable, classLoader);
            }
            return ImmutableMap.copyOf(linkedHashMap);
        }

        static URL getClassPathEntry(File file, String string2) throws MalformedURLException {
            return new URL(file.toURI().toURL(), string2);
        }

        static ImmutableSet<File> getClassPathFromManifest(File file, @NullableDecl Manifest iterator2) {
            if (iterator2 == null) {
                return ImmutableSet.of();
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            if ((iterator2 = ((Manifest)((Object)iterator2)).getMainAttributes().getValue(Attributes.Name.CLASS_PATH.toString())) != null) {
                for (String string2 : CLASS_PATH_ATTRIBUTE_SEPARATOR.split((CharSequence)((Object)iterator2))) {
                    Object object;
                    try {
                        object = Scanner.getClassPathEntry(file, string2);
                        if (!((URL)object).getProtocol().equals("file")) continue;
                        builder.add(ClassPath.toFile((URL)object));
                    }
                    catch (MalformedURLException malformedURLException) {
                        object = logger;
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("Invalid Class-Path entry: ");
                        stringBuilder.append(string2);
                        ((Logger)object).warning(stringBuilder.toString());
                    }
                }
            }
            return builder.build();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static ImmutableList<URL> parseJavaClassPath() {
            ImmutableList.Builder builder = ImmutableList.builder();
            Iterator<String> iterator2 = Splitter.on(StandardSystemProperty.PATH_SEPARATOR.value()).split(StandardSystemProperty.JAVA_CLASS_PATH.value()).iterator();
            while (iterator2.hasNext()) {
                Serializable serializable;
                Object object;
                String string2 = iterator2.next();
                try {
                    try {
                        object = new File(string2);
                        builder.add(((File)object).toURI().toURL());
                    }
                    catch (SecurityException securityException) {
                        object = new File(string2);
                        serializable = new URL("file", null, ((File)object).getAbsolutePath());
                        builder.add(serializable);
                    }
                    continue;
                }
                catch (MalformedURLException malformedURLException) {}
                object = logger;
                serializable = Level.WARNING;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("malformed classpath entry: ");
                stringBuilder.append(string2);
                ((Logger)object).log((Level)serializable, stringBuilder.toString(), malformedURLException);
            }
            return builder.build();
        }

        private void scanFrom(File file, ClassLoader object) throws IOException {
            block4: {
                try {
                    boolean bl = file.exists();
                    if (bl) break block4;
                    return;
                }
                catch (SecurityException securityException) {
                    object = logger;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Cannot access ");
                    stringBuilder.append(file);
                    stringBuilder.append(": ");
                    stringBuilder.append(securityException);
                    ((Logger)object).warning(stringBuilder.toString());
                    return;
                }
            }
            if (file.isDirectory()) {
                this.scanDirectory((ClassLoader)object, file);
            } else {
                this.scanJar(file, (ClassLoader)object);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void scanJar(File object, ClassLoader classLoader) throws IOException {
            JarFile jarFile;
            try {
                jarFile = new JarFile((File)object);
            }
            catch (IOException iOException) {
                return;
            }
            try {
                object = Scanner.getClassPathFromManifest((File)object, jarFile.getManifest()).iterator();
                while (object.hasNext()) {
                    this.scan((File)object.next(), classLoader);
                }
                this.scanJarFile(classLoader, jarFile);
                return;
            }
            finally {
                jarFile.close();
            }
        }

        final void scan(File file, ClassLoader classLoader) throws IOException {
            if (this.scannedUris.add(file.getCanonicalFile())) {
                this.scanFrom(file, classLoader);
            }
        }

        public final void scan(ClassLoader object2) throws IOException {
            for (Object object2 : Scanner.getClassPathEntries((ClassLoader)object2).entrySet()) {
                this.scan((File)object2.getKey(), (ClassLoader)object2.getValue());
            }
        }

        protected abstract void scanDirectory(ClassLoader var1, File var2) throws IOException;

        protected abstract void scanJarFile(ClassLoader var1, JarFile var2) throws IOException;
    }
}

