/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class AbstractInvocationHandler
implements InvocationHandler {
    private static final Object[] NO_ARGS = new Object[0];

    private static boolean isProxyOfSameInterfaces(Object object, Class<?> clazz) {
        boolean bl = clazz.isInstance(object) || Proxy.isProxyClass(object.getClass()) && Arrays.equals(object.getClass().getInterfaces(), clazz.getInterfaces());
        return bl;
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    protected abstract Object handleInvocation(Object var1, Method var2, Object[] var3) throws Throwable;

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public final Object invoke(Object object, Method object2, @NullableDecl Object[] objectArray) throws Throwable {
        Object[] objectArray2 = objectArray;
        if (objectArray == null) {
            objectArray2 = NO_ARGS;
        }
        if (objectArray2.length == 0 && ((Method)object2).getName().equals("hashCode")) {
            return this.hashCode();
        }
        int n2 = objectArray2.length;
        boolean bl = true;
        if (n2 == 1 && ((Method)object2).getName().equals("equals") && ((Method)object2).getParameterTypes()[0] == Object.class) {
            object2 = objectArray2[0];
            if (object2 == null) {
                return false;
            }
            if (object == object2) {
                return true;
            }
            if (!AbstractInvocationHandler.isProxyOfSameInterfaces(object2, object.getClass()) || !this.equals(Proxy.getInvocationHandler(object2))) {
                bl = false;
            }
            return bl;
        }
        if (objectArray2.length == 0 && ((Method)object2).getName().equals("toString")) {
            return this.toString();
        }
        return this.handleInvocation(object, (Method)object2, objectArray2);
    }

    public String toString() {
        return super.toString();
    }
}

