/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import com.google.common.primitives.UnsignedLongs;
import java.io.Serializable;
import java.math.BigInteger;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class UnsignedLong
extends Number
implements Comparable<UnsignedLong>,
Serializable {
    public static final UnsignedLong MAX_VALUE;
    public static final UnsignedLong ONE;
    private static final long UNSIGNED_MASK = Long.MAX_VALUE;
    public static final UnsignedLong ZERO;
    private final long value;

    static {
        ZERO = new UnsignedLong(0L);
        ONE = new UnsignedLong(1L);
        MAX_VALUE = new UnsignedLong(-1L);
    }

    private UnsignedLong(long l2) {
        this.value = l2;
    }

    public static UnsignedLong fromLongBits(long l2) {
        return new UnsignedLong(l2);
    }

    public static UnsignedLong valueOf(long l2) {
        boolean bl = l2 >= 0L;
        Preconditions.checkArgument(bl, "value (%s) is outside the range for an unsigned long value", l2);
        return UnsignedLong.fromLongBits(l2);
    }

    public static UnsignedLong valueOf(String string2) {
        return UnsignedLong.valueOf(string2, 10);
    }

    public static UnsignedLong valueOf(String string2, int n2) {
        return UnsignedLong.fromLongBits(UnsignedLongs.parseUnsignedLong((String)string2, (int)n2));
    }

    public static UnsignedLong valueOf(BigInteger bigInteger) {
        Preconditions.checkNotNull(bigInteger);
        boolean bl = bigInteger.signum() >= 0 && bigInteger.bitLength() <= 64;
        Preconditions.checkArgument(bl, "value (%s) is outside the range for an unsigned long value", (Object)bigInteger);
        return UnsignedLong.fromLongBits(bigInteger.longValue());
    }

    public BigInteger bigIntegerValue() {
        BigInteger bigInteger;
        BigInteger bigInteger2 = bigInteger = BigInteger.valueOf(this.value & Long.MAX_VALUE);
        if (this.value < 0L) {
            bigInteger2 = bigInteger.setBit(63);
        }
        return bigInteger2;
    }

    @Override
    public int compareTo(UnsignedLong unsignedLong) {
        Preconditions.checkNotNull(unsignedLong);
        return UnsignedLongs.compare((long)this.value, (long)unsignedLong.value);
    }

    public UnsignedLong dividedBy(UnsignedLong unsignedLong) {
        return UnsignedLong.fromLongBits(UnsignedLongs.divide((long)this.value, (long)Preconditions.checkNotNull(unsignedLong).value));
    }

    @Override
    public double doubleValue() {
        double d2;
        long l2 = this.value;
        double d3 = d2 = (double)(Long.MAX_VALUE & l2);
        if (l2 < 0L) {
            Double.isNaN(d2);
            d3 = d2 + 9.223372036854776E18;
        }
        return d3;
    }

    public boolean equals(@NullableDecl Object object) {
        boolean bl;
        boolean bl2 = object instanceof UnsignedLong;
        boolean bl3 = bl = false;
        if (bl2) {
            object = (UnsignedLong)object;
            bl3 = bl;
            if (this.value == ((UnsignedLong)object).value) {
                bl3 = true;
            }
        }
        return bl3;
    }

    @Override
    public float floatValue() {
        float f2;
        long l2 = this.value;
        float f3 = f2 = (float)(Long.MAX_VALUE & l2);
        if (l2 < 0L) {
            f3 = f2 + 9.223372E18f;
        }
        return f3;
    }

    public int hashCode() {
        return Longs.hashCode(this.value);
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    public UnsignedLong minus(UnsignedLong unsignedLong) {
        return UnsignedLong.fromLongBits(this.value - Preconditions.checkNotNull(unsignedLong).value);
    }

    public UnsignedLong mod(UnsignedLong unsignedLong) {
        return UnsignedLong.fromLongBits(UnsignedLongs.remainder((long)this.value, (long)Preconditions.checkNotNull(unsignedLong).value));
    }

    public UnsignedLong plus(UnsignedLong unsignedLong) {
        return UnsignedLong.fromLongBits(this.value + Preconditions.checkNotNull(unsignedLong).value);
    }

    public UnsignedLong times(UnsignedLong unsignedLong) {
        return UnsignedLong.fromLongBits(this.value * Preconditions.checkNotNull(unsignedLong).value);
    }

    public String toString() {
        return UnsignedLongs.toString((long)this.value);
    }

    public String toString(int n2) {
        return UnsignedLongs.toString((long)this.value, (int)n2);
    }
}

