/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Shorts {
    public static final int BYTES = 2;
    public static final short MAX_POWER_OF_TWO = 16384;

    private Shorts() {
    }

    public static List<Short> asList(short ... sArray) {
        if (sArray.length == 0) {
            return Collections.emptyList();
        }
        return new ShortArrayAsList(sArray);
    }

    public static short checkedCast(long l2) {
        short s2 = (short)l2;
        boolean bl = (long)s2 == l2;
        Preconditions.checkArgument(bl, "Out of range: %s", l2);
        return s2;
    }

    public static int compare(short s2, short s3) {
        return s2 - s3;
    }

    public static short[] concat(short[] ... sArray) {
        int n2;
        int n3 = sArray.length;
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            n4 += sArray[n2].length;
        }
        short[] sArray2 = new short[n4];
        n3 = sArray.length;
        n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            short[] sArray3 = sArray[n2];
            System.arraycopy(sArray3, 0, sArray2, n4, sArray3.length);
            n4 += sArray3.length;
        }
        return sArray2;
    }

    public static short constrainToRange(short s2, short s3, short s4) {
        boolean bl = s3 <= s4;
        Preconditions.checkArgument(bl, "min (%s) must be less than or equal to max (%s)", (int)s3, (int)s4);
        short s5 = s2 < s3 ? s3 : (s2 < s4 ? s2 : s4);
        return s5;
    }

    public static boolean contains(short[] sArray, short s2) {
        int n2 = sArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (sArray[i2] != s2) continue;
            return true;
        }
        return false;
    }

    public static short[] ensureCapacity(short[] sArray, int n2, int n3) {
        boolean bl = true;
        boolean bl2 = n2 >= 0;
        Preconditions.checkArgument(bl2, "Invalid minLength: %s", n2);
        bl2 = n3 >= 0 ? bl : false;
        Preconditions.checkArgument(bl2, "Invalid padding: %s", n3);
        short[] sArray2 = sArray;
        if (sArray.length < n2) {
            sArray2 = Arrays.copyOf(sArray, n2 + n3);
        }
        return sArray2;
    }

    public static short fromByteArray(byte[] byArray) {
        boolean bl = byArray.length >= 2;
        Preconditions.checkArgument(bl, "array too small: %s < %s", byArray.length, 2);
        return Shorts.fromBytes(byArray[0], byArray[1]);
    }

    public static short fromBytes(byte by2, byte by3) {
        return (short)(by2 << 8 | by3 & 0xFF);
    }

    public static int hashCode(short s2) {
        return s2;
    }

    public static int indexOf(short[] sArray, short s2) {
        return Shorts.indexOf(sArray, s2, 0, sArray.length);
    }

    private static int indexOf(short[] sArray, short s2, int n2, int n3) {
        while (n2 < n3) {
            if (sArray[n2] == s2) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static int indexOf(short[] sArray, short[] sArray2) {
        Preconditions.checkNotNull(sArray, "array");
        Preconditions.checkNotNull(sArray2, "target");
        if (sArray2.length == 0) {
            return 0;
        }
        block0: for (int i2 = 0; i2 < sArray.length - sArray2.length + 1; ++i2) {
            for (int i3 = 0; i3 < sArray2.length; ++i3) {
                if (sArray[i2 + i3] == sArray2[i3]) continue;
                continue block0;
            }
            return i2;
        }
        return -1;
    }

    public static String join(String string2, short ... sArray) {
        Preconditions.checkNotNull(string2);
        if (sArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(sArray.length * 6);
        stringBuilder.append(sArray[0]);
        for (int i2 = 1; i2 < sArray.length; ++i2) {
            stringBuilder.append(string2);
            stringBuilder.append(sArray[i2]);
        }
        return stringBuilder.toString();
    }

    public static int lastIndexOf(short[] sArray, short s2) {
        return Shorts.lastIndexOf(sArray, s2, 0, sArray.length);
    }

    private static int lastIndexOf(short[] sArray, short s2, int n2, int n3) {
        --n3;
        while (n3 >= n2) {
            if (sArray[n3] == s2) {
                return n3;
            }
            --n3;
        }
        return -1;
    }

    public static Comparator<short[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static short max(short ... sArray) {
        short s2 = sArray.length;
        boolean bl = s2 > 0;
        Preconditions.checkArgument(bl);
        short s3 = s2 = sArray[0];
        for (int i2 = 1; i2 < sArray.length; ++i2) {
            s2 = s3;
            if (sArray[i2] > s3) {
                s2 = sArray[i2];
            }
            s3 = s2;
        }
        return s3;
    }

    public static short min(short ... sArray) {
        short s2 = sArray.length;
        boolean bl = s2 > 0;
        Preconditions.checkArgument(bl);
        short s3 = s2 = sArray[0];
        for (int i2 = 1; i2 < sArray.length; ++i2) {
            s2 = s3;
            if (sArray[i2] < s3) {
                s2 = sArray[i2];
            }
            s3 = s2;
        }
        return s3;
    }

    public static void reverse(short[] sArray) {
        Preconditions.checkNotNull(sArray);
        Shorts.reverse(sArray, 0, sArray.length);
    }

    public static void reverse(short[] sArray, int n2, int n3) {
        Preconditions.checkNotNull(sArray);
        Preconditions.checkPositionIndexes(n2, n3, sArray.length);
        --n3;
        while (n2 < n3) {
            short s2 = sArray[n2];
            sArray[n2] = sArray[n3];
            sArray[n3] = s2;
            ++n2;
            --n3;
        }
    }

    public static short saturatedCast(long l2) {
        if (l2 > 32767L) {
            return Short.MAX_VALUE;
        }
        if (l2 < -32768L) {
            return Short.MIN_VALUE;
        }
        return (short)l2;
    }

    public static void sortDescending(short[] sArray) {
        Preconditions.checkNotNull(sArray);
        Shorts.sortDescending(sArray, 0, sArray.length);
    }

    public static void sortDescending(short[] sArray, int n2, int n3) {
        Preconditions.checkNotNull(sArray);
        Preconditions.checkPositionIndexes(n2, n3, sArray.length);
        Arrays.sort(sArray, n2, n3);
        Shorts.reverse(sArray, n2, n3);
    }

    public static Converter<String, Short> stringConverter() {
        return ShortConverter.INSTANCE;
    }

    public static short[] toArray(Collection<? extends Number> object) {
        if (object instanceof ShortArrayAsList) {
            return ((ShortArrayAsList)object).toShortArray();
        }
        Object[] objectArray = object.toArray();
        int n2 = objectArray.length;
        object = new short[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            object[i2] = ((Number)Preconditions.checkNotNull(objectArray[i2])).shortValue();
        }
        return object;
    }

    public static byte[] toByteArray(short s2) {
        return new byte[]{(byte)(s2 >> 8), (byte)s2};
    }

    private static enum LexicographicalComparator implements Comparator<short[]>
    {
        INSTANCE;


        @Override
        public int compare(short[] sArray, short[] sArray2) {
            int n2 = Math.min(sArray.length, sArray2.length);
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = Shorts.compare(sArray[i2], sArray2[i2]);
                if (n3 == 0) continue;
                return n3;
            }
            return sArray.length - sArray2.length;
        }

        public String toString() {
            return "Shorts.lexicographicalComparator()";
        }
    }

    private static class ShortArrayAsList
    extends AbstractList<Short>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 0L;
        final short[] array;
        final int end;
        final int start;

        ShortArrayAsList(short[] sArray) {
            this(sArray, 0, sArray.length);
        }

        ShortArrayAsList(short[] sArray, int n2, int n3) {
            this.array = sArray;
            this.start = n2;
            this.end = n3;
        }

        @Override
        public boolean contains(@NullableDecl Object object) {
            boolean bl = object instanceof Short && Shorts.indexOf(this.array, (Short)object, this.start, this.end) != -1;
            return bl;
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof ShortArrayAsList) {
                object = (ShortArrayAsList)object;
                int n2 = this.size();
                if (((ShortArrayAsList)object).size() != n2) {
                    return false;
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (this.array[this.start + i2] == ((ShortArrayAsList)object).array[((ShortArrayAsList)object).start + i2]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public Short get(int n2) {
            Preconditions.checkElementIndex(n2, this.size());
            return this.array[this.start + n2];
        }

        @Override
        public int hashCode() {
            int n2 = 1;
            for (int i2 = this.start; i2 < this.end; ++i2) {
                n2 = n2 * 31 + Shorts.hashCode(this.array[i2]);
            }
            return n2;
        }

        @Override
        public int indexOf(@NullableDecl Object object) {
            int n2;
            if (object instanceof Short && (n2 = Shorts.indexOf(this.array, (Short)object, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int lastIndexOf(@NullableDecl Object object) {
            int n2;
            if (object instanceof Short && (n2 = Shorts.lastIndexOf(this.array, (Short)object, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public Short set(int n2, Short s2) {
            Preconditions.checkElementIndex(n2, this.size());
            short[] sArray = this.array;
            int n3 = this.start;
            short s3 = sArray[n3 + n2];
            sArray[n3 + n2] = Preconditions.checkNotNull(s2);
            return s3;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public List<Short> subList(int n2, int n3) {
            Preconditions.checkPositionIndexes(n2, n3, this.size());
            if (n2 == n3) {
                return Collections.emptyList();
            }
            short[] sArray = this.array;
            int n4 = this.start;
            return new ShortArrayAsList(sArray, n2 + n4, n4 + n3);
        }

        short[] toShortArray() {
            return Arrays.copyOfRange(this.array, this.start, this.end);
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.size() * 6);
            stringBuilder.append('[');
            stringBuilder.append(this.array[this.start]);
            int n2 = this.start;
            while (++n2 < this.end) {
                stringBuilder.append(", ");
                stringBuilder.append(this.array[n2]);
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }

    private static final class ShortConverter
    extends Converter<String, Short>
    implements Serializable {
        static final ShortConverter INSTANCE = new ShortConverter();
        private static final long serialVersionUID = 1L;

        private ShortConverter() {
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        protected String doBackward(Short s2) {
            return s2.toString();
        }

        @Override
        protected Short doForward(String string2) {
            return Short.decode(string2);
        }

        public String toString() {
            return "Shorts.stringConverter()";
        }
    }
}

