/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Longs {
    public static final int BYTES = 8;
    public static final long MAX_POWER_OF_TWO = 0x4000000000000000L;

    private Longs() {
    }

    public static List<Long> asList(long ... lArray) {
        if (lArray.length == 0) {
            return Collections.emptyList();
        }
        return new LongArrayAsList(lArray);
    }

    public static int compare(long l2, long l3) {
        int n2 = l2 < l3 ? -1 : (l2 > l3 ? 1 : 0);
        return n2;
    }

    public static long[] concat(long[] ... lArray) {
        int n2;
        int n3 = lArray.length;
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            n4 += lArray[n2].length;
        }
        long[] lArray2 = new long[n4];
        n3 = lArray.length;
        n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            long[] lArray3 = lArray[n2];
            System.arraycopy(lArray3, 0, lArray2, n4, lArray3.length);
            n4 += lArray3.length;
        }
        return lArray2;
    }

    public static long constrainToRange(long l2, long l3, long l4) {
        boolean bl = l3 <= l4;
        Preconditions.checkArgument(bl, "min (%s) must be less than or equal to max (%s)", l3, l4);
        return Math.min(Math.max(l2, l3), l4);
    }

    public static boolean contains(long[] lArray, long l2) {
        int n2 = lArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (lArray[i2] != l2) continue;
            return true;
        }
        return false;
    }

    public static long[] ensureCapacity(long[] lArray, int n2, int n3) {
        boolean bl = true;
        boolean bl2 = n2 >= 0;
        Preconditions.checkArgument(bl2, "Invalid minLength: %s", n2);
        bl2 = n3 >= 0 ? bl : false;
        Preconditions.checkArgument(bl2, "Invalid padding: %s", n3);
        long[] lArray2 = lArray;
        if (lArray.length < n2) {
            lArray2 = Arrays.copyOf(lArray, n2 + n3);
        }
        return lArray2;
    }

    public static long fromByteArray(byte[] byArray) {
        boolean bl = byArray.length >= 8;
        Preconditions.checkArgument(bl, "array too small: %s < %s", byArray.length, 8);
        return Longs.fromBytes(byArray[0], byArray[1], byArray[2], byArray[3], byArray[4], byArray[5], byArray[6], byArray[7]);
    }

    public static long fromBytes(byte by2, byte by3, byte by4, byte by5, byte by6, byte by7, byte by8, byte by9) {
        long l2 = by2;
        return ((long)by3 & 0xFFL) << 48 | (l2 & 0xFFL) << 56 | ((long)by4 & 0xFFL) << 40 | ((long)by5 & 0xFFL) << 32 | ((long)by6 & 0xFFL) << 24 | ((long)by7 & 0xFFL) << 16 | ((long)by8 & 0xFFL) << 8 | (long)by9 & 0xFFL;
    }

    public static int hashCode(long l2) {
        return (int)(l2 ^ l2 >>> 32);
    }

    public static int indexOf(long[] lArray, long l2) {
        return Longs.indexOf(lArray, l2, 0, lArray.length);
    }

    private static int indexOf(long[] lArray, long l2, int n2, int n3) {
        while (n2 < n3) {
            if (lArray[n2] == l2) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static int indexOf(long[] lArray, long[] lArray2) {
        Preconditions.checkNotNull(lArray, "array");
        Preconditions.checkNotNull(lArray2, "target");
        if (lArray2.length == 0) {
            return 0;
        }
        block0: for (int i2 = 0; i2 < lArray.length - lArray2.length + 1; ++i2) {
            for (int i3 = 0; i3 < lArray2.length; ++i3) {
                if (lArray[i2 + i3] == lArray2[i3]) continue;
                continue block0;
            }
            return i2;
        }
        return -1;
    }

    public static String join(String string2, long ... lArray) {
        Preconditions.checkNotNull(string2);
        if (lArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(lArray.length * 10);
        stringBuilder.append(lArray[0]);
        for (int i2 = 1; i2 < lArray.length; ++i2) {
            stringBuilder.append(string2);
            stringBuilder.append(lArray[i2]);
        }
        return stringBuilder.toString();
    }

    public static int lastIndexOf(long[] lArray, long l2) {
        return Longs.lastIndexOf(lArray, l2, 0, lArray.length);
    }

    private static int lastIndexOf(long[] lArray, long l2, int n2, int n3) {
        --n3;
        while (n3 >= n2) {
            if (lArray[n3] == l2) {
                return n3;
            }
            --n3;
        }
        return -1;
    }

    public static Comparator<long[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static long max(long ... lArray) {
        int n2 = lArray.length;
        boolean bl = n2 > 0;
        Preconditions.checkArgument(bl);
        long l2 = lArray[0];
        for (int i2 = 1; i2 < lArray.length; ++i2) {
            long l3 = l2;
            if (lArray[i2] > l2) {
                l3 = lArray[i2];
            }
            l2 = l3;
        }
        return l2;
    }

    public static long min(long ... lArray) {
        int n2 = lArray.length;
        boolean bl = n2 > 0;
        Preconditions.checkArgument(bl);
        long l2 = lArray[0];
        for (int i2 = 1; i2 < lArray.length; ++i2) {
            long l3 = l2;
            if (lArray[i2] < l2) {
                l3 = lArray[i2];
            }
            l2 = l3;
        }
        return l2;
    }

    public static void reverse(long[] lArray) {
        Preconditions.checkNotNull(lArray);
        Longs.reverse(lArray, 0, lArray.length);
    }

    public static void reverse(long[] lArray, int n2, int n3) {
        Preconditions.checkNotNull(lArray);
        Preconditions.checkPositionIndexes(n2, n3, lArray.length);
        --n3;
        while (n2 < n3) {
            long l2 = lArray[n2];
            lArray[n2] = lArray[n3];
            lArray[n3] = l2;
            ++n2;
            --n3;
        }
    }

    public static void sortDescending(long[] lArray) {
        Preconditions.checkNotNull(lArray);
        Longs.sortDescending(lArray, 0, lArray.length);
    }

    public static void sortDescending(long[] lArray, int n2, int n3) {
        Preconditions.checkNotNull(lArray);
        Preconditions.checkPositionIndexes(n2, n3, lArray.length);
        Arrays.sort(lArray, n2, n3);
        Longs.reverse(lArray, n2, n3);
    }

    public static Converter<String, Long> stringConverter() {
        return LongConverter.INSTANCE;
    }

    public static long[] toArray(Collection<? extends Number> objectArray) {
        if (objectArray instanceof LongArrayAsList) {
            return ((LongArrayAsList)objectArray).toLongArray();
        }
        objectArray = objectArray.toArray();
        int n2 = objectArray.length;
        long[] lArray = new long[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            lArray[i2] = ((Number)Preconditions.checkNotNull(objectArray[i2])).longValue();
        }
        return lArray;
    }

    public static byte[] toByteArray(long l2) {
        byte[] byArray = new byte[8];
        for (int i2 = 7; i2 >= 0; --i2) {
            byArray[i2] = (byte)(0xFFL & l2);
            l2 >>= 8;
        }
        return byArray;
    }

    @NullableDecl
    public static Long tryParse(String string2) {
        return Longs.tryParse(string2, 10);
    }

    @NullableDecl
    public static Long tryParse(String object, int n2) {
        if (Preconditions.checkNotNull(object).isEmpty()) {
            return null;
        }
        if (n2 >= 2 && n2 <= 36) {
            int n3 = 0;
            if (((String)object).charAt(0) == '-') {
                n3 = 1;
            }
            if (n3 == ((String)object).length()) {
                return null;
            }
            int n4 = AsciiDigits.digit(((String)object).charAt(n3));
            if (n4 >= 0 && n4 < n2) {
                long l2 = -n4;
                long l3 = n2;
                long l4 = Long.MIN_VALUE / l3;
                for (int i2 = n3 + 1; i2 < ((String)object).length(); ++i2) {
                    n4 = AsciiDigits.digit(((String)object).charAt(i2));
                    if (n4 >= 0 && n4 < n2 && l2 >= l4) {
                        long l5 = n4;
                        if ((l2 *= l3) < l5 - Long.MIN_VALUE) {
                            return null;
                        }
                        l2 -= l5;
                        continue;
                    }
                    return null;
                }
                if (n3 != 0) {
                    return l2;
                }
                if (l2 == Long.MIN_VALUE) {
                    return null;
                }
                return -l2;
            }
            return null;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("radix must be between MIN_RADIX and MAX_RADIX but was ");
        ((StringBuilder)object).append(n2);
        object = new IllegalArgumentException(((StringBuilder)object).toString());
        throw object;
    }

    static final class AsciiDigits {
        private static final byte[] asciiDigits;

        static {
            byte[] byArray = new byte[128];
            Arrays.fill(byArray, (byte)-1);
            int n2 = 0;
            int n3 = 0;
            while (true) {
                if (n3 > 9) break;
                byArray[n3 + 48] = (byte)n3;
                ++n3;
            }
            for (int i2 = n2; i2 <= 26; ++i2) {
                n3 = (byte)(i2 + 10);
                byArray[i2 + 65] = (byte)n3;
                byArray[i2 + 97] = (byte)n3;
            }
            asciiDigits = byArray;
        }

        private AsciiDigits() {
        }

        static int digit(char c2) {
            c2 = c2 < '\u0080' ? asciiDigits[c2] : (char)-1;
            return c2;
        }
    }

    private static enum LexicographicalComparator implements Comparator<long[]>
    {
        INSTANCE;


        @Override
        public int compare(long[] lArray, long[] lArray2) {
            int n2 = Math.min(lArray.length, lArray2.length);
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = Longs.compare(lArray[i2], lArray2[i2]);
                if (n3 == 0) continue;
                return n3;
            }
            return lArray.length - lArray2.length;
        }

        public String toString() {
            return "Longs.lexicographicalComparator()";
        }
    }

    private static class LongArrayAsList
    extends AbstractList<Long>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 0L;
        final long[] array;
        final int end;
        final int start;

        LongArrayAsList(long[] lArray) {
            this(lArray, 0, lArray.length);
        }

        LongArrayAsList(long[] lArray, int n2, int n3) {
            this.array = lArray;
            this.start = n2;
            this.end = n3;
        }

        @Override
        public boolean contains(Object object) {
            boolean bl = object instanceof Long && Longs.indexOf(this.array, (Long)object, this.start, this.end) != -1;
            return bl;
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof LongArrayAsList) {
                object = (LongArrayAsList)object;
                int n2 = this.size();
                if (((LongArrayAsList)object).size() != n2) {
                    return false;
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (this.array[this.start + i2] == ((LongArrayAsList)object).array[((LongArrayAsList)object).start + i2]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public Long get(int n2) {
            Preconditions.checkElementIndex(n2, this.size());
            return this.array[this.start + n2];
        }

        @Override
        public int hashCode() {
            int n2 = 1;
            for (int i2 = this.start; i2 < this.end; ++i2) {
                n2 = n2 * 31 + Longs.hashCode(this.array[i2]);
            }
            return n2;
        }

        @Override
        public int indexOf(Object object) {
            int n2;
            if (object instanceof Long && (n2 = Longs.indexOf(this.array, (Long)object, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int lastIndexOf(Object object) {
            int n2;
            if (object instanceof Long && (n2 = Longs.lastIndexOf(this.array, (Long)object, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public Long set(int n2, Long l2) {
            Preconditions.checkElementIndex(n2, this.size());
            long[] lArray = this.array;
            int n3 = this.start;
            long l3 = lArray[n3 + n2];
            lArray[n3 + n2] = Preconditions.checkNotNull(l2);
            return l3;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public List<Long> subList(int n2, int n3) {
            Preconditions.checkPositionIndexes(n2, n3, this.size());
            if (n2 == n3) {
                return Collections.emptyList();
            }
            long[] lArray = this.array;
            int n4 = this.start;
            return new LongArrayAsList(lArray, n2 + n4, n4 + n3);
        }

        long[] toLongArray() {
            return Arrays.copyOfRange(this.array, this.start, this.end);
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.size() * 10);
            stringBuilder.append('[');
            stringBuilder.append(this.array[this.start]);
            int n2 = this.start;
            while (++n2 < this.end) {
                stringBuilder.append(", ");
                stringBuilder.append(this.array[n2]);
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }

    private static final class LongConverter
    extends Converter<String, Long>
    implements Serializable {
        static final LongConverter INSTANCE = new LongConverter();
        private static final long serialVersionUID = 1L;

        private LongConverter() {
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        protected String doBackward(Long l2) {
            return l2.toString();
        }

        @Override
        protected Long doForward(String string2) {
            return Long.decode(string2);
        }

        public String toString() {
            return "Longs.stringConverter()";
        }
    }
}

