/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Ints {
    public static final int BYTES = 4;
    public static final int MAX_POWER_OF_TWO = 0x40000000;

    private Ints() {
    }

    public static List<Integer> asList(int ... nArray) {
        if (nArray.length == 0) {
            return Collections.emptyList();
        }
        return new IntArrayAsList(nArray);
    }

    public static int checkedCast(long l2) {
        int n2 = (int)l2;
        boolean bl = (long)n2 == l2;
        Preconditions.checkArgument(bl, "Out of range: %s", l2);
        return n2;
    }

    public static int compare(int n2, int n3) {
        n2 = n2 < n3 ? -1 : (n2 > n3 ? 1 : 0);
        return n2;
    }

    public static int[] concat(int[] ... nArray) {
        int n2;
        int n3 = nArray.length;
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            n4 += nArray[n2].length;
        }
        int[] nArray2 = new int[n4];
        n3 = nArray.length;
        n2 = 0;
        for (n4 = 0; n4 < n3; ++n4) {
            int[] nArray3 = nArray[n4];
            System.arraycopy(nArray3, 0, nArray2, n2, nArray3.length);
            n2 += nArray3.length;
        }
        return nArray2;
    }

    public static int constrainToRange(int n2, int n3, int n4) {
        boolean bl = n3 <= n4;
        Preconditions.checkArgument(bl, "min (%s) must be less than or equal to max (%s)", n3, n4);
        return Math.min(Math.max(n2, n3), n4);
    }

    public static boolean contains(int[] nArray, int n2) {
        int n3 = nArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (nArray[i2] != n2) continue;
            return true;
        }
        return false;
    }

    public static int[] ensureCapacity(int[] nArray, int n2, int n3) {
        boolean bl = true;
        boolean bl2 = n2 >= 0;
        Preconditions.checkArgument(bl2, "Invalid minLength: %s", n2);
        bl2 = n3 >= 0 ? bl : false;
        Preconditions.checkArgument(bl2, "Invalid padding: %s", n3);
        int[] nArray2 = nArray;
        if (nArray.length < n2) {
            nArray2 = Arrays.copyOf(nArray, n2 + n3);
        }
        return nArray2;
    }

    public static int fromByteArray(byte[] byArray) {
        boolean bl = byArray.length >= 4;
        Preconditions.checkArgument(bl, "array too small: %s < %s", byArray.length, 4);
        return Ints.fromBytes(byArray[0], byArray[1], byArray[2], byArray[3]);
    }

    public static int fromBytes(byte by2, byte by3, byte by4, byte by5) {
        return by2 << 24 | (by3 & 0xFF) << 16 | (by4 & 0xFF) << 8 | by5 & 0xFF;
    }

    public static int hashCode(int n2) {
        return n2;
    }

    public static int indexOf(int[] nArray, int n2) {
        return Ints.indexOf(nArray, n2, 0, nArray.length);
    }

    private static int indexOf(int[] nArray, int n2, int n3, int n4) {
        while (n3 < n4) {
            if (nArray[n3] == n2) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public static int indexOf(int[] nArray, int[] nArray2) {
        Preconditions.checkNotNull(nArray, "array");
        Preconditions.checkNotNull(nArray2, "target");
        if (nArray2.length == 0) {
            return 0;
        }
        block0: for (int i2 = 0; i2 < nArray.length - nArray2.length + 1; ++i2) {
            for (int i3 = 0; i3 < nArray2.length; ++i3) {
                if (nArray[i2 + i3] == nArray2[i3]) continue;
                continue block0;
            }
            return i2;
        }
        return -1;
    }

    public static String join(String string2, int ... nArray) {
        Preconditions.checkNotNull(string2);
        if (nArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(nArray.length * 5);
        stringBuilder.append(nArray[0]);
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            stringBuilder.append(string2);
            stringBuilder.append(nArray[i2]);
        }
        return stringBuilder.toString();
    }

    public static int lastIndexOf(int[] nArray, int n2) {
        return Ints.lastIndexOf(nArray, n2, 0, nArray.length);
    }

    private static int lastIndexOf(int[] nArray, int n2, int n3, int n4) {
        --n4;
        while (n4 >= n3) {
            if (nArray[n4] == n2) {
                return n4;
            }
            --n4;
        }
        return -1;
    }

    public static Comparator<int[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static int max(int ... nArray) {
        int n2 = nArray.length;
        boolean bl = n2 > 0;
        Preconditions.checkArgument(bl);
        int n3 = nArray[0];
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            n2 = n3;
            if (nArray[i2] > n3) {
                n2 = nArray[i2];
            }
            n3 = n2;
        }
        return n3;
    }

    public static int min(int ... nArray) {
        int n2 = nArray.length;
        boolean bl = n2 > 0;
        Preconditions.checkArgument(bl);
        n2 = nArray[0];
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            int n3 = n2;
            if (nArray[i2] < n2) {
                n3 = nArray[i2];
            }
            n2 = n3;
        }
        return n2;
    }

    public static void reverse(int[] nArray) {
        Preconditions.checkNotNull(nArray);
        Ints.reverse(nArray, 0, nArray.length);
    }

    public static void reverse(int[] nArray, int n2, int n3) {
        Preconditions.checkNotNull(nArray);
        Preconditions.checkPositionIndexes(n2, n3, nArray.length);
        --n3;
        while (n2 < n3) {
            int n4 = nArray[n2];
            nArray[n2] = nArray[n3];
            nArray[n3] = n4;
            ++n2;
            --n3;
        }
    }

    public static int saturatedCast(long l2) {
        if (l2 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (l2 < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)l2;
    }

    public static void sortDescending(int[] nArray) {
        Preconditions.checkNotNull(nArray);
        Ints.sortDescending(nArray, 0, nArray.length);
    }

    public static void sortDescending(int[] nArray, int n2, int n3) {
        Preconditions.checkNotNull(nArray);
        Preconditions.checkPositionIndexes(n2, n3, nArray.length);
        Arrays.sort(nArray, n2, n3);
        Ints.reverse(nArray, n2, n3);
    }

    public static Converter<String, Integer> stringConverter() {
        return IntConverter.INSTANCE;
    }

    public static int[] toArray(Collection<? extends Number> objectArray) {
        if (objectArray instanceof IntArrayAsList) {
            return ((IntArrayAsList)objectArray).toIntArray();
        }
        objectArray = objectArray.toArray();
        int n2 = objectArray.length;
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = ((Number)Preconditions.checkNotNull(objectArray[i2])).intValue();
        }
        return nArray;
    }

    public static byte[] toByteArray(int n2) {
        return new byte[]{(byte)(n2 >> 24), (byte)(n2 >> 16), (byte)(n2 >> 8), (byte)n2};
    }

    @NullableDecl
    public static Integer tryParse(String string2) {
        return Ints.tryParse(string2, 10);
    }

    @NullableDecl
    public static Integer tryParse(String object, int n2) {
        if ((object = Longs.tryParse((String)object, n2)) != null && (Long)object == (long)((Long)object).intValue()) {
            return ((Long)object).intValue();
        }
        return null;
    }

    private static class IntArrayAsList
    extends AbstractList<Integer>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 0L;
        final int[] array;
        final int end;
        final int start;

        IntArrayAsList(int[] nArray) {
            this(nArray, 0, nArray.length);
        }

        IntArrayAsList(int[] nArray, int n2, int n3) {
            this.array = nArray;
            this.start = n2;
            this.end = n3;
        }

        @Override
        public boolean contains(Object object) {
            boolean bl = object instanceof Integer && Ints.indexOf(this.array, (Integer)object, this.start, this.end) != -1;
            return bl;
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof IntArrayAsList) {
                object = (IntArrayAsList)object;
                int n2 = this.size();
                if (((IntArrayAsList)object).size() != n2) {
                    return false;
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (this.array[this.start + i2] == ((IntArrayAsList)object).array[((IntArrayAsList)object).start + i2]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public Integer get(int n2) {
            Preconditions.checkElementIndex(n2, this.size());
            return this.array[this.start + n2];
        }

        @Override
        public int hashCode() {
            int n2 = 1;
            for (int i2 = this.start; i2 < this.end; ++i2) {
                n2 = n2 * 31 + Ints.hashCode(this.array[i2]);
            }
            return n2;
        }

        @Override
        public int indexOf(Object object) {
            int n2;
            if (object instanceof Integer && (n2 = Ints.indexOf(this.array, (Integer)object, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int lastIndexOf(Object object) {
            int n2;
            if (object instanceof Integer && (n2 = Ints.lastIndexOf(this.array, (Integer)object, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public Integer set(int n2, Integer n3) {
            Preconditions.checkElementIndex(n2, this.size());
            int[] nArray = this.array;
            int n4 = this.start;
            int n5 = nArray[n4 + n2];
            nArray[n4 + n2] = Preconditions.checkNotNull(n3);
            return n5;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public List<Integer> subList(int n2, int n3) {
            Preconditions.checkPositionIndexes(n2, n3, this.size());
            if (n2 == n3) {
                return Collections.emptyList();
            }
            int[] nArray = this.array;
            int n4 = this.start;
            return new IntArrayAsList(nArray, n2 + n4, n4 + n3);
        }

        int[] toIntArray() {
            return Arrays.copyOfRange(this.array, this.start, this.end);
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.size() * 5);
            stringBuilder.append('[');
            stringBuilder.append(this.array[this.start]);
            int n2 = this.start;
            while (++n2 < this.end) {
                stringBuilder.append(", ");
                stringBuilder.append(this.array[n2]);
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }

    private static final class IntConverter
    extends Converter<String, Integer>
    implements Serializable {
        static final IntConverter INSTANCE = new IntConverter();
        private static final long serialVersionUID = 1L;

        private IntConverter() {
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        protected String doBackward(Integer n2) {
            return n2.toString();
        }

        @Override
        protected Integer doForward(String string2) {
            return Integer.decode(string2);
        }

        public String toString() {
            return "Ints.stringConverter()";
        }
    }

    private static enum LexicographicalComparator implements Comparator<int[]>
    {
        INSTANCE;


        @Override
        public int compare(int[] nArray, int[] nArray2) {
            int n2 = Math.min(nArray.length, nArray2.length);
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = Ints.compare(nArray[i2], nArray2[i2]);
                if (n3 == 0) continue;
                return n3;
            }
            return nArray.length - nArray2.length;
        }

        public String toString() {
            return "Ints.lexicographicalComparator()";
        }
    }
}

