/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

@Immutable
public final class ImmutableLongArray
implements Serializable {
    private static final ImmutableLongArray EMPTY = new ImmutableLongArray(new long[0]);
    private final long[] array;
    private final int end;
    private final transient int start;

    private ImmutableLongArray(long[] lArray) {
        this(lArray, 0, lArray.length);
    }

    private ImmutableLongArray(long[] lArray, int n2, int n3) {
        this.array = lArray;
        this.start = n2;
        this.end = n3;
    }

    public static Builder builder() {
        return new Builder(10);
    }

    public static Builder builder(int n2) {
        boolean bl = n2 >= 0;
        Preconditions.checkArgument(bl, "Invalid initialCapacity: %s", n2);
        return new Builder(n2);
    }

    public static ImmutableLongArray copyOf(Iterable<Long> iterable) {
        if (iterable instanceof Collection) {
            return ImmutableLongArray.copyOf((Collection)iterable);
        }
        return ImmutableLongArray.builder().addAll(iterable).build();
    }

    public static ImmutableLongArray copyOf(Collection<Long> object) {
        object = object.isEmpty() ? EMPTY : new ImmutableLongArray(Longs.toArray((Collection<? extends Number>)object));
        return object;
    }

    public static ImmutableLongArray copyOf(long[] object) {
        object = ((long[])object).length == 0 ? (Object)EMPTY : (Object)new ImmutableLongArray(Arrays.copyOf((long[])object, ((long[])object).length));
        return object;
    }

    private boolean isPartialView() {
        boolean bl = this.start > 0 || this.end < this.array.length;
        return bl;
    }

    public static ImmutableLongArray of() {
        return EMPTY;
    }

    public static ImmutableLongArray of(long l2) {
        return new ImmutableLongArray(new long[]{l2});
    }

    public static ImmutableLongArray of(long l2, long l3) {
        return new ImmutableLongArray(new long[]{l2, l3});
    }

    public static ImmutableLongArray of(long l2, long l3, long l4) {
        return new ImmutableLongArray(new long[]{l2, l3, l4});
    }

    public static ImmutableLongArray of(long l2, long l3, long l4, long l5) {
        return new ImmutableLongArray(new long[]{l2, l3, l4, l5});
    }

    public static ImmutableLongArray of(long l2, long l3, long l4, long l5, long l6) {
        return new ImmutableLongArray(new long[]{l2, l3, l4, l5, l6});
    }

    public static ImmutableLongArray of(long l2, long l3, long l4, long l5, long l6, long l7) {
        return new ImmutableLongArray(new long[]{l2, l3, l4, l5, l6, l7});
    }

    public static ImmutableLongArray of(long l2, long ... lArray) {
        boolean bl = lArray.length <= 0x7FFFFFFE;
        Preconditions.checkArgument(bl, "the total number of elements must fit in an int");
        long[] lArray2 = new long[lArray.length + 1];
        lArray2[0] = l2;
        System.arraycopy(lArray, 0, lArray2, 1, lArray.length);
        return new ImmutableLongArray(lArray2);
    }

    public List<Long> asList() {
        return new AsList(this);
    }

    public boolean contains(long l2) {
        boolean bl = this.indexOf(l2) >= 0;
        return bl;
    }

    public boolean equals(@NullableDecl Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ImmutableLongArray)) {
            return false;
        }
        object = (ImmutableLongArray)object;
        if (this.length() != ((ImmutableLongArray)object).length()) {
            return false;
        }
        for (int i2 = 0; i2 < this.length(); ++i2) {
            if (this.get(i2) == ((ImmutableLongArray)object).get(i2)) continue;
            return false;
        }
        return true;
    }

    public long get(int n2) {
        Preconditions.checkElementIndex(n2, this.length());
        return this.array[this.start + n2];
    }

    public int hashCode() {
        int n2 = 1;
        for (int i2 = this.start; i2 < this.end; ++i2) {
            n2 = n2 * 31 + Longs.hashCode(this.array[i2]);
        }
        return n2;
    }

    public int indexOf(long l2) {
        for (int i2 = this.start; i2 < this.end; ++i2) {
            if (this.array[i2] != l2) continue;
            return i2 - this.start;
        }
        return -1;
    }

    public boolean isEmpty() {
        boolean bl = this.end == this.start;
        return bl;
    }

    public int lastIndexOf(long l2) {
        int n2;
        for (int i2 = this.end - 1; i2 >= (n2 = this.start); --i2) {
            if (this.array[i2] != l2) continue;
            return i2 - n2;
        }
        return -1;
    }

    public int length() {
        return this.end - this.start;
    }

    Object readResolve() {
        ImmutableLongArray immutableLongArray = this.isEmpty() ? EMPTY : this;
        return immutableLongArray;
    }

    public ImmutableLongArray subArray(int n2, int n3) {
        Object object;
        Preconditions.checkPositionIndexes(n2, n3, this.length());
        if (n2 == n3) {
            object = EMPTY;
        } else {
            object = this.array;
            int n4 = this.start;
            object = new ImmutableLongArray((long[])object, n2 + n4, n4 + n3);
        }
        return object;
    }

    public long[] toArray() {
        return Arrays.copyOfRange(this.array, this.start, this.end);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(this.length() * 5);
        stringBuilder.append('[');
        stringBuilder.append(this.array[this.start]);
        int n2 = this.start;
        while (++n2 < this.end) {
            stringBuilder.append(", ");
            stringBuilder.append(this.array[n2]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public ImmutableLongArray trimmed() {
        ImmutableLongArray immutableLongArray = this.isPartialView() ? new ImmutableLongArray(this.toArray()) : this;
        return immutableLongArray;
    }

    Object writeReplace() {
        return this.trimmed();
    }

    static class AsList
    extends AbstractList<Long>
    implements RandomAccess,
    Serializable {
        private final ImmutableLongArray parent;

        private AsList(ImmutableLongArray immutableLongArray) {
            this.parent = immutableLongArray;
        }

        @Override
        public boolean contains(Object object) {
            boolean bl = this.indexOf(object) >= 0;
            return bl;
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object instanceof AsList) {
                object = (AsList)object;
                return this.parent.equals(((AsList)object).parent);
            }
            if (!(object instanceof List)) {
                return false;
            }
            object = (List)object;
            if (this.size() != object.size()) {
                return false;
            }
            int n2 = this.parent.start;
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                object = iterator2.next();
                if (object instanceof Long && this.parent.array[n2] == (Long)object) {
                    ++n2;
                    continue;
                }
                return false;
            }
            return true;
        }

        @Override
        public Long get(int n2) {
            return this.parent.get(n2);
        }

        @Override
        public int hashCode() {
            return this.parent.hashCode();
        }

        @Override
        public int indexOf(Object object) {
            int n2 = object instanceof Long ? this.parent.indexOf((Long)object) : -1;
            return n2;
        }

        @Override
        public int lastIndexOf(Object object) {
            int n2 = object instanceof Long ? this.parent.lastIndexOf((Long)object) : -1;
            return n2;
        }

        @Override
        public int size() {
            return this.parent.length();
        }

        @Override
        public List<Long> subList(int n2, int n3) {
            return this.parent.subArray(n2, n3).asList();
        }

        @Override
        public String toString() {
            return this.parent.toString();
        }
    }

    public static final class Builder {
        private long[] array;
        private int count = 0;

        Builder(int n2) {
            this.array = new long[n2];
        }

        private void ensureRoomFor(int n2) {
            long[] lArray = this.array;
            if ((n2 = this.count + n2) > lArray.length) {
                lArray = new long[Builder.expandedCapacity(lArray.length, n2)];
                System.arraycopy(this.array, 0, lArray, 0, this.count);
                this.array = lArray;
            }
        }

        private static int expandedCapacity(int n2, int n3) {
            if (n3 >= 0) {
                int n4;
                n2 = n4 = n2 + (n2 >> 1) + 1;
                if (n4 < n3) {
                    n2 = Integer.highestOneBit(n3 - 1) << 1;
                }
                n3 = n2;
                if (n2 < 0) {
                    n3 = Integer.MAX_VALUE;
                }
                return n3;
            }
            throw new AssertionError((Object)"cannot store more than MAX_VALUE elements");
        }

        public Builder add(long l2) {
            this.ensureRoomFor(1);
            long[] lArray = this.array;
            int n2 = this.count;
            lArray[n2] = l2;
            this.count = n2 + 1;
            return this;
        }

        public Builder addAll(ImmutableLongArray immutableLongArray) {
            this.ensureRoomFor(immutableLongArray.length());
            System.arraycopy(immutableLongArray.array, immutableLongArray.start, this.array, this.count, immutableLongArray.length());
            this.count += immutableLongArray.length();
            return this;
        }

        public Builder addAll(Iterable<Long> object) {
            if (object instanceof Collection) {
                return this.addAll((Collection)object);
            }
            object = object.iterator();
            while (object.hasNext()) {
                this.add((Long)object.next());
            }
            return this;
        }

        public Builder addAll(Collection<Long> object) {
            this.ensureRoomFor(object.size());
            Iterator<Long> iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                Long l2 = iterator2.next();
                object = this.array;
                int n2 = this.count;
                this.count = n2 + 1;
                object[n2] = l2;
            }
            return this;
        }

        public Builder addAll(long[] lArray) {
            this.ensureRoomFor(lArray.length);
            System.arraycopy(lArray, 0, this.array, this.count, lArray.length);
            this.count += lArray.length;
            return this;
        }

        @CheckReturnValue
        public ImmutableLongArray build() {
            int n2 = this.count;
            ImmutableLongArray immutableLongArray = n2 == 0 ? EMPTY : new ImmutableLongArray(this.array, 0, n2);
            return immutableLongArray;
        }
    }
}

