/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

@Immutable
public final class ImmutableIntArray
implements Serializable {
    private static final ImmutableIntArray EMPTY = new ImmutableIntArray(new int[0]);
    private final int[] array;
    private final int end;
    private final transient int start;

    private ImmutableIntArray(int[] nArray) {
        this(nArray, 0, nArray.length);
    }

    private ImmutableIntArray(int[] nArray, int n2, int n3) {
        this.array = nArray;
        this.start = n2;
        this.end = n3;
    }

    public static Builder builder() {
        return new Builder(10);
    }

    public static Builder builder(int n2) {
        boolean bl = n2 >= 0;
        Preconditions.checkArgument(bl, "Invalid initialCapacity: %s", n2);
        return new Builder(n2);
    }

    public static ImmutableIntArray copyOf(Iterable<Integer> iterable) {
        if (iterable instanceof Collection) {
            return ImmutableIntArray.copyOf((Collection)iterable);
        }
        return ImmutableIntArray.builder().addAll(iterable).build();
    }

    public static ImmutableIntArray copyOf(Collection<Integer> object) {
        object = object.isEmpty() ? EMPTY : new ImmutableIntArray(Ints.toArray((Collection<? extends Number>)object));
        return object;
    }

    public static ImmutableIntArray copyOf(int[] object) {
        object = ((int[])object).length == 0 ? (Object)EMPTY : (Object)new ImmutableIntArray(Arrays.copyOf((int[])object, ((int[])object).length));
        return object;
    }

    private boolean isPartialView() {
        boolean bl = this.start > 0 || this.end < this.array.length;
        return bl;
    }

    public static ImmutableIntArray of() {
        return EMPTY;
    }

    public static ImmutableIntArray of(int n2) {
        return new ImmutableIntArray(new int[]{n2});
    }

    public static ImmutableIntArray of(int n2, int n3) {
        return new ImmutableIntArray(new int[]{n2, n3});
    }

    public static ImmutableIntArray of(int n2, int n3, int n4) {
        return new ImmutableIntArray(new int[]{n2, n3, n4});
    }

    public static ImmutableIntArray of(int n2, int n3, int n4, int n5) {
        return new ImmutableIntArray(new int[]{n2, n3, n4, n5});
    }

    public static ImmutableIntArray of(int n2, int n3, int n4, int n5, int n6) {
        return new ImmutableIntArray(new int[]{n2, n3, n4, n5, n6});
    }

    public static ImmutableIntArray of(int n2, int n3, int n4, int n5, int n6, int n7) {
        return new ImmutableIntArray(new int[]{n2, n3, n4, n5, n6, n7});
    }

    public static ImmutableIntArray of(int n2, int ... nArray) {
        boolean bl = nArray.length <= 0x7FFFFFFE;
        Preconditions.checkArgument(bl, "the total number of elements must fit in an int");
        int[] nArray2 = new int[nArray.length + 1];
        nArray2[0] = n2;
        System.arraycopy(nArray, 0, nArray2, 1, nArray.length);
        return new ImmutableIntArray(nArray2);
    }

    public List<Integer> asList() {
        return new AsList(this);
    }

    public boolean contains(int n2) {
        boolean bl = this.indexOf(n2) >= 0;
        return bl;
    }

    public boolean equals(@NullableDecl Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ImmutableIntArray)) {
            return false;
        }
        object = (ImmutableIntArray)object;
        if (this.length() != ((ImmutableIntArray)object).length()) {
            return false;
        }
        for (int i2 = 0; i2 < this.length(); ++i2) {
            if (this.get(i2) == ((ImmutableIntArray)object).get(i2)) continue;
            return false;
        }
        return true;
    }

    public int get(int n2) {
        Preconditions.checkElementIndex(n2, this.length());
        return this.array[this.start + n2];
    }

    public int hashCode() {
        int n2 = 1;
        for (int i2 = this.start; i2 < this.end; ++i2) {
            n2 = n2 * 31 + Ints.hashCode(this.array[i2]);
        }
        return n2;
    }

    public int indexOf(int n2) {
        for (int i2 = this.start; i2 < this.end; ++i2) {
            if (this.array[i2] != n2) continue;
            return i2 - this.start;
        }
        return -1;
    }

    public boolean isEmpty() {
        boolean bl = this.end == this.start;
        return bl;
    }

    public int lastIndexOf(int n2) {
        int n3;
        for (int i2 = this.end - 1; i2 >= (n3 = this.start); --i2) {
            if (this.array[i2] != n2) continue;
            return i2 - n3;
        }
        return -1;
    }

    public int length() {
        return this.end - this.start;
    }

    Object readResolve() {
        ImmutableIntArray immutableIntArray = this.isEmpty() ? EMPTY : this;
        return immutableIntArray;
    }

    public ImmutableIntArray subArray(int n2, int n3) {
        Object object;
        Preconditions.checkPositionIndexes(n2, n3, this.length());
        if (n2 == n3) {
            object = EMPTY;
        } else {
            object = this.array;
            int n4 = this.start;
            object = new ImmutableIntArray((int[])object, n2 + n4, n4 + n3);
        }
        return object;
    }

    public int[] toArray() {
        return Arrays.copyOfRange(this.array, this.start, this.end);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(this.length() * 5);
        stringBuilder.append('[');
        stringBuilder.append(this.array[this.start]);
        int n2 = this.start;
        while (++n2 < this.end) {
            stringBuilder.append(", ");
            stringBuilder.append(this.array[n2]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public ImmutableIntArray trimmed() {
        ImmutableIntArray immutableIntArray = this.isPartialView() ? new ImmutableIntArray(this.toArray()) : this;
        return immutableIntArray;
    }

    Object writeReplace() {
        return this.trimmed();
    }

    static class AsList
    extends AbstractList<Integer>
    implements RandomAccess,
    Serializable {
        private final ImmutableIntArray parent;

        private AsList(ImmutableIntArray immutableIntArray) {
            this.parent = immutableIntArray;
        }

        @Override
        public boolean contains(Object object) {
            boolean bl = this.indexOf(object) >= 0;
            return bl;
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object instanceof AsList) {
                object = (AsList)object;
                return this.parent.equals(((AsList)object).parent);
            }
            if (!(object instanceof List)) {
                return false;
            }
            object = (List)object;
            if (this.size() != object.size()) {
                return false;
            }
            int n2 = this.parent.start;
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                object = iterator2.next();
                if (object instanceof Integer && this.parent.array[n2] == (Integer)object) {
                    ++n2;
                    continue;
                }
                return false;
            }
            return true;
        }

        @Override
        public Integer get(int n2) {
            return this.parent.get(n2);
        }

        @Override
        public int hashCode() {
            return this.parent.hashCode();
        }

        @Override
        public int indexOf(Object object) {
            int n2 = object instanceof Integer ? this.parent.indexOf((Integer)object) : -1;
            return n2;
        }

        @Override
        public int lastIndexOf(Object object) {
            int n2 = object instanceof Integer ? this.parent.lastIndexOf((Integer)object) : -1;
            return n2;
        }

        @Override
        public int size() {
            return this.parent.length();
        }

        @Override
        public List<Integer> subList(int n2, int n3) {
            return this.parent.subArray(n2, n3).asList();
        }

        @Override
        public String toString() {
            return this.parent.toString();
        }
    }

    public static final class Builder {
        private int[] array;
        private int count = 0;

        Builder(int n2) {
            this.array = new int[n2];
        }

        private void ensureRoomFor(int n2) {
            int[] nArray = this.array;
            if ((n2 = this.count + n2) > nArray.length) {
                nArray = new int[Builder.expandedCapacity(nArray.length, n2)];
                System.arraycopy(this.array, 0, nArray, 0, this.count);
                this.array = nArray;
            }
        }

        private static int expandedCapacity(int n2, int n3) {
            if (n3 >= 0) {
                int n4;
                n2 = n4 = n2 + (n2 >> 1) + 1;
                if (n4 < n3) {
                    n2 = Integer.highestOneBit(n3 - 1) << 1;
                }
                n3 = n2;
                if (n2 < 0) {
                    n3 = Integer.MAX_VALUE;
                }
                return n3;
            }
            throw new AssertionError((Object)"cannot store more than MAX_VALUE elements");
        }

        public Builder add(int n2) {
            this.ensureRoomFor(1);
            int[] nArray = this.array;
            int n3 = this.count;
            nArray[n3] = n2;
            this.count = n3 + 1;
            return this;
        }

        public Builder addAll(ImmutableIntArray immutableIntArray) {
            this.ensureRoomFor(immutableIntArray.length());
            System.arraycopy(immutableIntArray.array, immutableIntArray.start, this.array, this.count, immutableIntArray.length());
            this.count += immutableIntArray.length();
            return this;
        }

        public Builder addAll(Iterable<Integer> object) {
            if (object instanceof Collection) {
                return this.addAll((Collection)object);
            }
            object = object.iterator();
            while (object.hasNext()) {
                this.add((Integer)object.next());
            }
            return this;
        }

        public Builder addAll(Collection<Integer> object) {
            this.ensureRoomFor(object.size());
            Iterator<Integer> iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                Integer n2 = iterator2.next();
                object = this.array;
                int n3 = this.count;
                this.count = n3 + 1;
                object[n3] = n2;
            }
            return this;
        }

        public Builder addAll(int[] nArray) {
            this.ensureRoomFor(nArray.length);
            System.arraycopy(nArray, 0, this.array, this.count, nArray.length);
            this.count += nArray.length;
            return this;
        }

        @CheckReturnValue
        public ImmutableIntArray build() {
            int n2 = this.count;
            ImmutableIntArray immutableIntArray = n2 == 0 ? EMPTY : new ImmutableIntArray(this.array, 0, n2);
            return immutableIntArray;
        }
    }
}

