/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

@Immutable
public final class ImmutableDoubleArray
implements Serializable {
    private static final ImmutableDoubleArray EMPTY = new ImmutableDoubleArray(new double[0]);
    private final double[] array;
    private final int end;
    private final transient int start;

    private ImmutableDoubleArray(double[] dArray) {
        this(dArray, 0, dArray.length);
    }

    private ImmutableDoubleArray(double[] dArray, int n2, int n3) {
        this.array = dArray;
        this.start = n2;
        this.end = n3;
    }

    private static boolean areEqual(double d2, double d3) {
        boolean bl = Double.doubleToLongBits(d2) == Double.doubleToLongBits(d3);
        return bl;
    }

    public static Builder builder() {
        return new Builder(10);
    }

    public static Builder builder(int n2) {
        boolean bl = n2 >= 0;
        Preconditions.checkArgument(bl, "Invalid initialCapacity: %s", n2);
        return new Builder(n2);
    }

    public static ImmutableDoubleArray copyOf(Iterable<Double> iterable) {
        if (iterable instanceof Collection) {
            return ImmutableDoubleArray.copyOf((Collection)iterable);
        }
        return ImmutableDoubleArray.builder().addAll(iterable).build();
    }

    public static ImmutableDoubleArray copyOf(Collection<Double> object) {
        object = object.isEmpty() ? EMPTY : new ImmutableDoubleArray(Doubles.toArray((Collection<? extends Number>)object));
        return object;
    }

    public static ImmutableDoubleArray copyOf(double[] object) {
        object = ((double[])object).length == 0 ? (Object)EMPTY : (Object)new ImmutableDoubleArray(Arrays.copyOf((double[])object, ((double[])object).length));
        return object;
    }

    private boolean isPartialView() {
        boolean bl = this.start > 0 || this.end < this.array.length;
        return bl;
    }

    public static ImmutableDoubleArray of() {
        return EMPTY;
    }

    public static ImmutableDoubleArray of(double d2) {
        return new ImmutableDoubleArray(new double[]{d2});
    }

    public static ImmutableDoubleArray of(double d2, double d3) {
        return new ImmutableDoubleArray(new double[]{d2, d3});
    }

    public static ImmutableDoubleArray of(double d2, double d3, double d4) {
        return new ImmutableDoubleArray(new double[]{d2, d3, d4});
    }

    public static ImmutableDoubleArray of(double d2, double d3, double d4, double d5) {
        return new ImmutableDoubleArray(new double[]{d2, d3, d4, d5});
    }

    public static ImmutableDoubleArray of(double d2, double d3, double d4, double d5, double d6) {
        return new ImmutableDoubleArray(new double[]{d2, d3, d4, d5, d6});
    }

    public static ImmutableDoubleArray of(double d2, double d3, double d4, double d5, double d6, double d7) {
        return new ImmutableDoubleArray(new double[]{d2, d3, d4, d5, d6, d7});
    }

    public static ImmutableDoubleArray of(double d2, double ... dArray) {
        boolean bl = dArray.length <= 0x7FFFFFFE;
        Preconditions.checkArgument(bl, "the total number of elements must fit in an int");
        double[] dArray2 = new double[dArray.length + 1];
        dArray2[0] = d2;
        System.arraycopy(dArray, 0, dArray2, 1, dArray.length);
        return new ImmutableDoubleArray(dArray2);
    }

    public List<Double> asList() {
        return new AsList(this);
    }

    public boolean contains(double d2) {
        boolean bl = this.indexOf(d2) >= 0;
        return bl;
    }

    public boolean equals(@NullableDecl Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ImmutableDoubleArray)) {
            return false;
        }
        object = (ImmutableDoubleArray)object;
        if (this.length() != ((ImmutableDoubleArray)object).length()) {
            return false;
        }
        for (int i2 = 0; i2 < this.length(); ++i2) {
            if (ImmutableDoubleArray.areEqual(this.get(i2), ((ImmutableDoubleArray)object).get(i2))) continue;
            return false;
        }
        return true;
    }

    public double get(int n2) {
        Preconditions.checkElementIndex(n2, this.length());
        return this.array[this.start + n2];
    }

    public int hashCode() {
        int n2 = 1;
        for (int i2 = this.start; i2 < this.end; ++i2) {
            n2 = n2 * 31 + Doubles.hashCode(this.array[i2]);
        }
        return n2;
    }

    public int indexOf(double d2) {
        for (int i2 = this.start; i2 < this.end; ++i2) {
            if (!ImmutableDoubleArray.areEqual(this.array[i2], d2)) continue;
            return i2 - this.start;
        }
        return -1;
    }

    public boolean isEmpty() {
        boolean bl = this.end == this.start;
        return bl;
    }

    public int lastIndexOf(double d2) {
        for (int i2 = this.end - 1; i2 >= this.start; --i2) {
            if (!ImmutableDoubleArray.areEqual(this.array[i2], d2)) continue;
            return i2 - this.start;
        }
        return -1;
    }

    public int length() {
        return this.end - this.start;
    }

    Object readResolve() {
        ImmutableDoubleArray immutableDoubleArray = this.isEmpty() ? EMPTY : this;
        return immutableDoubleArray;
    }

    public ImmutableDoubleArray subArray(int n2, int n3) {
        Object object;
        Preconditions.checkPositionIndexes(n2, n3, this.length());
        if (n2 == n3) {
            object = EMPTY;
        } else {
            object = this.array;
            int n4 = this.start;
            object = new ImmutableDoubleArray((double[])object, n2 + n4, n4 + n3);
        }
        return object;
    }

    public double[] toArray() {
        return Arrays.copyOfRange(this.array, this.start, this.end);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(this.length() * 5);
        stringBuilder.append('[');
        stringBuilder.append(this.array[this.start]);
        int n2 = this.start;
        while (++n2 < this.end) {
            stringBuilder.append(", ");
            stringBuilder.append(this.array[n2]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public ImmutableDoubleArray trimmed() {
        ImmutableDoubleArray immutableDoubleArray = this.isPartialView() ? new ImmutableDoubleArray(this.toArray()) : this;
        return immutableDoubleArray;
    }

    Object writeReplace() {
        return this.trimmed();
    }

    static class AsList
    extends AbstractList<Double>
    implements RandomAccess,
    Serializable {
        private final ImmutableDoubleArray parent;

        private AsList(ImmutableDoubleArray immutableDoubleArray) {
            this.parent = immutableDoubleArray;
        }

        @Override
        public boolean contains(Object object) {
            boolean bl = this.indexOf(object) >= 0;
            return bl;
        }

        @Override
        public boolean equals(@NullableDecl Object iterator2) {
            if (iterator2 instanceof AsList) {
                iterator2 = (AsList)((Object)iterator2);
                return this.parent.equals(((AsList)((Object)iterator2)).parent);
            }
            if (!(iterator2 instanceof List)) {
                return false;
            }
            iterator2 = (List)((Object)iterator2);
            if (this.size() != iterator2.size()) {
                return false;
            }
            int n2 = this.parent.start;
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                Object e2 = iterator2.next();
                if (e2 instanceof Double && ImmutableDoubleArray.areEqual(this.parent.array[n2], (Double)e2)) {
                    ++n2;
                    continue;
                }
                return false;
            }
            return true;
        }

        @Override
        public Double get(int n2) {
            return this.parent.get(n2);
        }

        @Override
        public int hashCode() {
            return this.parent.hashCode();
        }

        @Override
        public int indexOf(Object object) {
            int n2 = object instanceof Double ? this.parent.indexOf((Double)object) : -1;
            return n2;
        }

        @Override
        public int lastIndexOf(Object object) {
            int n2 = object instanceof Double ? this.parent.lastIndexOf((Double)object) : -1;
            return n2;
        }

        @Override
        public int size() {
            return this.parent.length();
        }

        @Override
        public List<Double> subList(int n2, int n3) {
            return this.parent.subArray(n2, n3).asList();
        }

        @Override
        public String toString() {
            return this.parent.toString();
        }
    }

    public static final class Builder {
        private double[] array;
        private int count = 0;

        Builder(int n2) {
            this.array = new double[n2];
        }

        private void ensureRoomFor(int n2) {
            double[] dArray = this.array;
            if ((n2 = this.count + n2) > dArray.length) {
                dArray = new double[Builder.expandedCapacity(dArray.length, n2)];
                System.arraycopy(this.array, 0, dArray, 0, this.count);
                this.array = dArray;
            }
        }

        private static int expandedCapacity(int n2, int n3) {
            if (n3 >= 0) {
                int n4;
                n2 = n4 = n2 + (n2 >> 1) + 1;
                if (n4 < n3) {
                    n2 = Integer.highestOneBit(n3 - 1) << 1;
                }
                n3 = n2;
                if (n2 < 0) {
                    n3 = Integer.MAX_VALUE;
                }
                return n3;
            }
            throw new AssertionError((Object)"cannot store more than MAX_VALUE elements");
        }

        public Builder add(double d2) {
            this.ensureRoomFor(1);
            double[] dArray = this.array;
            int n2 = this.count;
            dArray[n2] = d2;
            this.count = n2 + 1;
            return this;
        }

        public Builder addAll(ImmutableDoubleArray immutableDoubleArray) {
            this.ensureRoomFor(immutableDoubleArray.length());
            System.arraycopy(immutableDoubleArray.array, immutableDoubleArray.start, this.array, this.count, immutableDoubleArray.length());
            this.count += immutableDoubleArray.length();
            return this;
        }

        public Builder addAll(Iterable<Double> object) {
            if (object instanceof Collection) {
                return this.addAll((Collection)object);
            }
            object = object.iterator();
            while (object.hasNext()) {
                this.add((Double)object.next());
            }
            return this;
        }

        public Builder addAll(Collection<Double> object) {
            this.ensureRoomFor(object.size());
            object = object.iterator();
            while (object.hasNext()) {
                Double d2 = (Double)object.next();
                double[] dArray = this.array;
                int n2 = this.count;
                this.count = n2 + 1;
                dArray[n2] = d2;
            }
            return this;
        }

        public Builder addAll(double[] dArray) {
            this.ensureRoomFor(dArray.length);
            System.arraycopy(dArray, 0, this.array, this.count, dArray.length);
            this.count += dArray.length;
            return this;
        }

        @CheckReturnValue
        public ImmutableDoubleArray build() {
            int n2 = this.count;
            ImmutableDoubleArray immutableDoubleArray = n2 == 0 ? EMPTY : new ImmutableDoubleArray(this.array, 0, n2);
            return immutableDoubleArray;
        }
    }
}

