/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Floats {
    public static final int BYTES = 4;

    private Floats() {
    }

    public static List<Float> asList(float ... fArray) {
        if (fArray.length == 0) {
            return Collections.emptyList();
        }
        return new FloatArrayAsList(fArray);
    }

    public static int compare(float f2, float f3) {
        return Float.compare(f2, f3);
    }

    public static float[] concat(float[] ... fArray) {
        int n2;
        int n3 = fArray.length;
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            n4 += fArray[n2].length;
        }
        float[] fArray2 = new float[n4];
        n3 = fArray.length;
        n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            float[] fArray3 = fArray[n2];
            System.arraycopy(fArray3, 0, fArray2, n4, fArray3.length);
            n4 += fArray3.length;
        }
        return fArray2;
    }

    public static float constrainToRange(float f2, float f3, float f4) {
        boolean bl = f3 <= f4;
        Preconditions.checkArgument(bl, "min (%s) must be less than or equal to max (%s)", (Object)Float.valueOf(f3), (Object)Float.valueOf(f4));
        return Math.min(Math.max(f2, f3), f4);
    }

    public static boolean contains(float[] fArray, float f2) {
        int n2 = fArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (fArray[i2] != f2) continue;
            return true;
        }
        return false;
    }

    public static float[] ensureCapacity(float[] fArray, int n2, int n3) {
        boolean bl = true;
        boolean bl2 = n2 >= 0;
        Preconditions.checkArgument(bl2, "Invalid minLength: %s", n2);
        bl2 = n3 >= 0 ? bl : false;
        Preconditions.checkArgument(bl2, "Invalid padding: %s", n3);
        float[] fArray2 = fArray;
        if (fArray.length < n2) {
            fArray2 = Arrays.copyOf(fArray, n2 + n3);
        }
        return fArray2;
    }

    public static int hashCode(float f2) {
        return Float.valueOf(f2).hashCode();
    }

    public static int indexOf(float[] fArray, float f2) {
        return Floats.indexOf(fArray, f2, 0, fArray.length);
    }

    private static int indexOf(float[] fArray, float f2, int n2, int n3) {
        while (n2 < n3) {
            if (fArray[n2] == f2) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static int indexOf(float[] fArray, float[] fArray2) {
        Preconditions.checkNotNull(fArray, "array");
        Preconditions.checkNotNull(fArray2, "target");
        if (fArray2.length == 0) {
            return 0;
        }
        block0: for (int i2 = 0; i2 < fArray.length - fArray2.length + 1; ++i2) {
            for (int i3 = 0; i3 < fArray2.length; ++i3) {
                if (fArray[i2 + i3] == fArray2[i3]) continue;
                continue block0;
            }
            return i2;
        }
        return -1;
    }

    public static boolean isFinite(float f2) {
        boolean bl = Float.NEGATIVE_INFINITY < f2 && f2 < Float.POSITIVE_INFINITY;
        return bl;
    }

    public static String join(String string2, float ... fArray) {
        Preconditions.checkNotNull(string2);
        if (fArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(fArray.length * 12);
        stringBuilder.append(fArray[0]);
        for (int i2 = 1; i2 < fArray.length; ++i2) {
            stringBuilder.append(string2);
            stringBuilder.append(fArray[i2]);
        }
        return stringBuilder.toString();
    }

    public static int lastIndexOf(float[] fArray, float f2) {
        return Floats.lastIndexOf(fArray, f2, 0, fArray.length);
    }

    private static int lastIndexOf(float[] fArray, float f2, int n2, int n3) {
        --n3;
        while (n3 >= n2) {
            if (fArray[n3] == f2) {
                return n3;
            }
            --n3;
        }
        return -1;
    }

    public static Comparator<float[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static float max(float ... fArray) {
        int n2 = fArray.length;
        boolean bl = n2 > 0;
        Preconditions.checkArgument(bl);
        float f2 = fArray[0];
        for (int i2 = 1; i2 < fArray.length; ++i2) {
            f2 = Math.max(f2, fArray[i2]);
        }
        return f2;
    }

    public static float min(float ... fArray) {
        int n2 = fArray.length;
        boolean bl = n2 > 0;
        Preconditions.checkArgument(bl);
        float f2 = fArray[0];
        for (int i2 = 1; i2 < fArray.length; ++i2) {
            f2 = Math.min(f2, fArray[i2]);
        }
        return f2;
    }

    public static void reverse(float[] fArray) {
        Preconditions.checkNotNull(fArray);
        Floats.reverse(fArray, 0, fArray.length);
    }

    public static void reverse(float[] fArray, int n2, int n3) {
        Preconditions.checkNotNull(fArray);
        Preconditions.checkPositionIndexes(n2, n3, fArray.length);
        --n3;
        while (n2 < n3) {
            float f2 = fArray[n2];
            fArray[n2] = fArray[n3];
            fArray[n3] = f2;
            ++n2;
            --n3;
        }
    }

    public static void sortDescending(float[] fArray) {
        Preconditions.checkNotNull(fArray);
        Floats.sortDescending(fArray, 0, fArray.length);
    }

    public static void sortDescending(float[] fArray, int n2, int n3) {
        Preconditions.checkNotNull(fArray);
        Preconditions.checkPositionIndexes(n2, n3, fArray.length);
        Arrays.sort(fArray, n2, n3);
        Floats.reverse(fArray, n2, n3);
    }

    public static Converter<String, Float> stringConverter() {
        return FloatConverter.INSTANCE;
    }

    public static float[] toArray(Collection<? extends Number> object) {
        if (object instanceof FloatArrayAsList) {
            return ((FloatArrayAsList)object).toFloatArray();
        }
        Object[] objectArray = object.toArray();
        int n2 = objectArray.length;
        object = new float[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            object[i2] = ((Number)Preconditions.checkNotNull(objectArray[i2])).floatValue();
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NullableDecl
    public static Float tryParse(String string2) {
        if (!Doubles.FLOATING_POINT_PATTERN.matcher(string2).matches()) return null;
        try {
            float f2 = Float.parseFloat(string2);
            return Float.valueOf(f2);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static class FloatArrayAsList
    extends AbstractList<Float>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 0L;
        final float[] array;
        final int end;
        final int start;

        FloatArrayAsList(float[] fArray) {
            this(fArray, 0, fArray.length);
        }

        FloatArrayAsList(float[] fArray, int n2, int n3) {
            this.array = fArray;
            this.start = n2;
            this.end = n3;
        }

        @Override
        public boolean contains(Object object) {
            boolean bl = object instanceof Float && Floats.indexOf(this.array, ((Float)object).floatValue(), this.start, this.end) != -1;
            return bl;
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof FloatArrayAsList) {
                object = (FloatArrayAsList)object;
                int n2 = this.size();
                if (((FloatArrayAsList)object).size() != n2) {
                    return false;
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (this.array[this.start + i2] == ((FloatArrayAsList)object).array[((FloatArrayAsList)object).start + i2]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public Float get(int n2) {
            Preconditions.checkElementIndex(n2, this.size());
            return Float.valueOf(this.array[this.start + n2]);
        }

        @Override
        public int hashCode() {
            int n2 = 1;
            for (int i2 = this.start; i2 < this.end; ++i2) {
                n2 = n2 * 31 + Floats.hashCode(this.array[i2]);
            }
            return n2;
        }

        @Override
        public int indexOf(Object object) {
            int n2;
            if (object instanceof Float && (n2 = Floats.indexOf(this.array, ((Float)object).floatValue(), this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int lastIndexOf(Object object) {
            int n2;
            if (object instanceof Float && (n2 = Floats.lastIndexOf(this.array, ((Float)object).floatValue(), this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public Float set(int n2, Float f2) {
            Preconditions.checkElementIndex(n2, this.size());
            float[] fArray = this.array;
            int n3 = this.start;
            float f3 = fArray[n3 + n2];
            fArray[n3 + n2] = Preconditions.checkNotNull(f2).floatValue();
            return Float.valueOf(f3);
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public List<Float> subList(int n2, int n3) {
            Preconditions.checkPositionIndexes(n2, n3, this.size());
            if (n2 == n3) {
                return Collections.emptyList();
            }
            float[] fArray = this.array;
            int n4 = this.start;
            return new FloatArrayAsList(fArray, n2 + n4, n4 + n3);
        }

        float[] toFloatArray() {
            return Arrays.copyOfRange(this.array, this.start, this.end);
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.size() * 12);
            stringBuilder.append('[');
            stringBuilder.append(this.array[this.start]);
            int n2 = this.start;
            while (++n2 < this.end) {
                stringBuilder.append(", ");
                stringBuilder.append(this.array[n2]);
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }

    private static final class FloatConverter
    extends Converter<String, Float>
    implements Serializable {
        static final FloatConverter INSTANCE = new FloatConverter();
        private static final long serialVersionUID = 1L;

        private FloatConverter() {
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        protected String doBackward(Float f2) {
            return f2.toString();
        }

        @Override
        protected Float doForward(String string2) {
            return Float.valueOf(string2);
        }

        public String toString() {
            return "Floats.stringConverter()";
        }
    }

    private static enum LexicographicalComparator implements Comparator<float[]>
    {
        INSTANCE;


        @Override
        public int compare(float[] fArray, float[] fArray2) {
            int n2 = Math.min(fArray.length, fArray2.length);
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = Float.compare(fArray[i2], fArray2[i2]);
                if (n3 == 0) continue;
                return n3;
            }
            return fArray.length - fArray2.length;
        }

        public String toString() {
            return "Floats.lexicographicalComparator()";
        }
    }
}

