/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Doubles {
    public static final int BYTES = 8;
    static final Pattern FLOATING_POINT_PATTERN = Doubles.fpPattern();

    private Doubles() {
    }

    public static List<Double> asList(double ... dArray) {
        if (dArray.length == 0) {
            return Collections.emptyList();
        }
        return new DoubleArrayAsList(dArray);
    }

    public static int compare(double d2, double d3) {
        return Double.compare(d2, d3);
    }

    public static double[] concat(double[] ... dArray) {
        int n2;
        int n3 = dArray.length;
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            n4 += dArray[n2].length;
        }
        double[] dArray2 = new double[n4];
        n3 = dArray.length;
        n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            double[] dArray3 = dArray[n2];
            System.arraycopy(dArray3, 0, dArray2, n4, dArray3.length);
            n4 += dArray3.length;
        }
        return dArray2;
    }

    public static double constrainToRange(double d2, double d3, double d4) {
        boolean bl = d3 <= d4;
        Preconditions.checkArgument(bl, "min (%s) must be less than or equal to max (%s)", (Object)d3, (Object)d4);
        return Math.min(Math.max(d2, d3), d4);
    }

    public static boolean contains(double[] dArray, double d2) {
        int n2 = dArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (dArray[i2] != d2) continue;
            return true;
        }
        return false;
    }

    public static double[] ensureCapacity(double[] dArray, int n2, int n3) {
        boolean bl = true;
        boolean bl2 = n2 >= 0;
        Preconditions.checkArgument(bl2, "Invalid minLength: %s", n2);
        bl2 = n3 >= 0 ? bl : false;
        Preconditions.checkArgument(bl2, "Invalid padding: %s", n3);
        double[] dArray2 = dArray;
        if (dArray.length < n2) {
            dArray2 = Arrays.copyOf(dArray, n2 + n3);
        }
        return dArray2;
    }

    private static Pattern fpPattern() {
        CharSequence charSequence = new StringBuilder();
        charSequence.append("(?:\\d+#(?:\\.\\d*#)?|\\.\\d+#)");
        charSequence.append("(?:[eE][+-]?\\d+#)?[fFdD]?");
        charSequence = charSequence.toString();
        CharSequence charSequence2 = new StringBuilder();
        charSequence2.append("0[xX]");
        charSequence2.append("(?:[0-9a-fA-F]+#(?:\\.[0-9a-fA-F]*#)?|\\.[0-9a-fA-F]+#)");
        charSequence2.append("[pP][+-]?\\d+#[fFdD]?");
        charSequence2 = charSequence2.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[+-]?(?:NaN|Infinity|");
        stringBuilder.append((String)charSequence);
        stringBuilder.append("|");
        stringBuilder.append((String)charSequence2);
        stringBuilder.append(")");
        return Pattern.compile(stringBuilder.toString().replace("#", "+"));
    }

    public static int hashCode(double d2) {
        return Double.valueOf(d2).hashCode();
    }

    public static int indexOf(double[] dArray, double d2) {
        return Doubles.indexOf(dArray, d2, 0, dArray.length);
    }

    private static int indexOf(double[] dArray, double d2, int n2, int n3) {
        while (n2 < n3) {
            if (dArray[n2] == d2) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static int indexOf(double[] dArray, double[] dArray2) {
        Preconditions.checkNotNull(dArray, "array");
        Preconditions.checkNotNull(dArray2, "target");
        if (dArray2.length == 0) {
            return 0;
        }
        block0: for (int i2 = 0; i2 < dArray.length - dArray2.length + 1; ++i2) {
            for (int i3 = 0; i3 < dArray2.length; ++i3) {
                if (dArray[i2 + i3] == dArray2[i3]) continue;
                continue block0;
            }
            return i2;
        }
        return -1;
    }

    public static boolean isFinite(double d2) {
        boolean bl = Double.NEGATIVE_INFINITY < d2 && d2 < Double.POSITIVE_INFINITY;
        return bl;
    }

    public static String join(String string2, double ... dArray) {
        Preconditions.checkNotNull(string2);
        if (dArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(dArray.length * 12);
        stringBuilder.append(dArray[0]);
        for (int i2 = 1; i2 < dArray.length; ++i2) {
            stringBuilder.append(string2);
            stringBuilder.append(dArray[i2]);
        }
        return stringBuilder.toString();
    }

    public static int lastIndexOf(double[] dArray, double d2) {
        return Doubles.lastIndexOf(dArray, d2, 0, dArray.length);
    }

    private static int lastIndexOf(double[] dArray, double d2, int n2, int n3) {
        --n3;
        while (n3 >= n2) {
            if (dArray[n3] == d2) {
                return n3;
            }
            --n3;
        }
        return -1;
    }

    public static Comparator<double[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static double max(double ... dArray) {
        int n2 = dArray.length;
        boolean bl = n2 > 0;
        Preconditions.checkArgument(bl);
        double d2 = dArray[0];
        for (int i2 = 1; i2 < dArray.length; ++i2) {
            d2 = Math.max(d2, dArray[i2]);
        }
        return d2;
    }

    public static double min(double ... dArray) {
        int n2 = dArray.length;
        boolean bl = n2 > 0;
        Preconditions.checkArgument(bl);
        double d2 = dArray[0];
        for (int i2 = 1; i2 < dArray.length; ++i2) {
            d2 = Math.min(d2, dArray[i2]);
        }
        return d2;
    }

    public static void reverse(double[] dArray) {
        Preconditions.checkNotNull(dArray);
        Doubles.reverse(dArray, 0, dArray.length);
    }

    public static void reverse(double[] dArray, int n2, int n3) {
        Preconditions.checkNotNull(dArray);
        Preconditions.checkPositionIndexes(n2, n3, dArray.length);
        --n3;
        while (n2 < n3) {
            double d2 = dArray[n2];
            dArray[n2] = dArray[n3];
            dArray[n3] = d2;
            ++n2;
            --n3;
        }
    }

    public static void sortDescending(double[] dArray) {
        Preconditions.checkNotNull(dArray);
        Doubles.sortDescending(dArray, 0, dArray.length);
    }

    public static void sortDescending(double[] dArray, int n2, int n3) {
        Preconditions.checkNotNull(dArray);
        Preconditions.checkPositionIndexes(n2, n3, dArray.length);
        Arrays.sort(dArray, n2, n3);
        Doubles.reverse(dArray, n2, n3);
    }

    public static Converter<String, Double> stringConverter() {
        return DoubleConverter.INSTANCE;
    }

    public static double[] toArray(Collection<? extends Number> object) {
        if (object instanceof DoubleArrayAsList) {
            return ((DoubleArrayAsList)object).toDoubleArray();
        }
        Object[] objectArray = object.toArray();
        int n2 = objectArray.length;
        object = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            object[i2] = ((Number)Preconditions.checkNotNull(objectArray[i2])).doubleValue();
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NullableDecl
    public static Double tryParse(String string2) {
        if (!FLOATING_POINT_PATTERN.matcher(string2).matches()) return null;
        try {
            double d2 = Double.parseDouble(string2);
            return d2;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static class DoubleArrayAsList
    extends AbstractList<Double>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 0L;
        final double[] array;
        final int end;
        final int start;

        DoubleArrayAsList(double[] dArray) {
            this(dArray, 0, dArray.length);
        }

        DoubleArrayAsList(double[] dArray, int n2, int n3) {
            this.array = dArray;
            this.start = n2;
            this.end = n3;
        }

        @Override
        public boolean contains(Object object) {
            boolean bl = object instanceof Double && Doubles.indexOf(this.array, (Double)object, this.start, this.end) != -1;
            return bl;
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof DoubleArrayAsList) {
                object = (DoubleArrayAsList)object;
                int n2 = this.size();
                if (((DoubleArrayAsList)object).size() != n2) {
                    return false;
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (this.array[this.start + i2] == ((DoubleArrayAsList)object).array[((DoubleArrayAsList)object).start + i2]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public Double get(int n2) {
            Preconditions.checkElementIndex(n2, this.size());
            return this.array[this.start + n2];
        }

        @Override
        public int hashCode() {
            int n2 = 1;
            for (int i2 = this.start; i2 < this.end; ++i2) {
                n2 = n2 * 31 + Doubles.hashCode(this.array[i2]);
            }
            return n2;
        }

        @Override
        public int indexOf(Object object) {
            int n2;
            if (object instanceof Double && (n2 = Doubles.indexOf(this.array, (Double)object, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int lastIndexOf(Object object) {
            int n2;
            if (object instanceof Double && (n2 = Doubles.lastIndexOf(this.array, (Double)object, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public Double set(int n2, Double d2) {
            Preconditions.checkElementIndex(n2, this.size());
            double[] dArray = this.array;
            int n3 = this.start;
            double d3 = dArray[n3 + n2];
            dArray[n3 + n2] = Preconditions.checkNotNull(d2);
            return d3;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public List<Double> subList(int n2, int n3) {
            Preconditions.checkPositionIndexes(n2, n3, this.size());
            if (n2 == n3) {
                return Collections.emptyList();
            }
            double[] dArray = this.array;
            int n4 = this.start;
            return new DoubleArrayAsList(dArray, n2 + n4, n4 + n3);
        }

        double[] toDoubleArray() {
            return Arrays.copyOfRange(this.array, this.start, this.end);
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.size() * 12);
            stringBuilder.append('[');
            stringBuilder.append(this.array[this.start]);
            int n2 = this.start;
            while (++n2 < this.end) {
                stringBuilder.append(", ");
                stringBuilder.append(this.array[n2]);
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }

    private static final class DoubleConverter
    extends Converter<String, Double>
    implements Serializable {
        static final DoubleConverter INSTANCE = new DoubleConverter();
        private static final long serialVersionUID = 1L;

        private DoubleConverter() {
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        protected String doBackward(Double d2) {
            return d2.toString();
        }

        @Override
        protected Double doForward(String string2) {
            return Double.valueOf(string2);
        }

        public String toString() {
            return "Doubles.stringConverter()";
        }
    }

    private static enum LexicographicalComparator implements Comparator<double[]>
    {
        INSTANCE;


        @Override
        public int compare(double[] dArray, double[] dArray2) {
            int n2 = Math.min(dArray.length, dArray2.length);
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = Double.compare(dArray[i2], dArray2[i2]);
                if (n3 == 0) continue;
                return n3;
            }
            return dArray.length - dArray2.length;
        }

        public String toString() {
            return "Doubles.lexicographicalComparator()";
        }
    }
}

