/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Chars {
    public static final int BYTES = 2;

    private Chars() {
    }

    public static List<Character> asList(char ... cArray) {
        if (cArray.length == 0) {
            return Collections.emptyList();
        }
        return new CharArrayAsList(cArray);
    }

    public static char checkedCast(long l2) {
        char c2 = (char)l2;
        boolean bl = (long)c2 == l2;
        Preconditions.checkArgument(bl, "Out of range: %s", l2);
        return c2;
    }

    public static int compare(char c2, char c3) {
        return c2 - c3;
    }

    public static char[] concat(char[] ... cArray) {
        int n2;
        int n3 = cArray.length;
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            n4 += cArray[n2].length;
        }
        char[] cArray2 = new char[n4];
        n3 = cArray.length;
        n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            char[] cArray3 = cArray[n2];
            System.arraycopy(cArray3, 0, cArray2, n4, cArray3.length);
            n4 += cArray3.length;
        }
        return cArray2;
    }

    public static char constrainToRange(char c2, char c3, char c4) {
        boolean bl = c3 <= c4;
        Preconditions.checkArgument(bl, "min (%s) must be less than or equal to max (%s)", c3, c4);
        c3 = c2 < c3 ? (c2 = c3) : (c2 < c4 ? c2 : (c2 = c4));
        return c3;
    }

    public static boolean contains(char[] cArray, char c2) {
        int n2 = cArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (cArray[i2] != c2) continue;
            return true;
        }
        return false;
    }

    public static char[] ensureCapacity(char[] cArray, int n2, int n3) {
        boolean bl = true;
        boolean bl2 = n2 >= 0;
        Preconditions.checkArgument(bl2, "Invalid minLength: %s", n2);
        bl2 = n3 >= 0 ? bl : false;
        Preconditions.checkArgument(bl2, "Invalid padding: %s", n3);
        char[] cArray2 = cArray;
        if (cArray.length < n2) {
            cArray2 = Arrays.copyOf(cArray, n2 + n3);
        }
        return cArray2;
    }

    public static char fromByteArray(byte[] byArray) {
        boolean bl = byArray.length >= 2;
        Preconditions.checkArgument(bl, "array too small: %s < %s", byArray.length, 2);
        return Chars.fromBytes(byArray[0], byArray[1]);
    }

    public static char fromBytes(byte by2, byte by3) {
        return (char)(by2 << 8 | by3 & 0xFF);
    }

    public static int hashCode(char c2) {
        return c2;
    }

    public static int indexOf(char[] cArray, char c2) {
        return Chars.indexOf(cArray, c2, 0, cArray.length);
    }

    private static int indexOf(char[] cArray, char c2, int n2, int n3) {
        while (n2 < n3) {
            if (cArray[n2] == c2) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static int indexOf(char[] cArray, char[] cArray2) {
        Preconditions.checkNotNull(cArray, "array");
        Preconditions.checkNotNull(cArray2, "target");
        if (cArray2.length == 0) {
            return 0;
        }
        block0: for (int i2 = 0; i2 < cArray.length - cArray2.length + 1; ++i2) {
            for (int i3 = 0; i3 < cArray2.length; ++i3) {
                if (cArray[i2 + i3] == cArray2[i3]) continue;
                continue block0;
            }
            return i2;
        }
        return -1;
    }

    public static String join(String string2, char ... cArray) {
        Preconditions.checkNotNull(string2);
        int n2 = cArray.length;
        if (n2 == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(string2.length() * (n2 - 1) + n2);
        stringBuilder.append(cArray[0]);
        for (int i2 = 1; i2 < n2; ++i2) {
            stringBuilder.append(string2);
            stringBuilder.append(cArray[i2]);
        }
        return stringBuilder.toString();
    }

    public static int lastIndexOf(char[] cArray, char c2) {
        return Chars.lastIndexOf(cArray, c2, 0, cArray.length);
    }

    private static int lastIndexOf(char[] cArray, char c2, int n2, int n3) {
        --n3;
        while (n3 >= n2) {
            if (cArray[n3] == c2) {
                return n3;
            }
            --n3;
        }
        return -1;
    }

    public static Comparator<char[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static char max(char ... cArray) {
        char c2 = cArray.length;
        boolean bl = c2 > '\u0000';
        Preconditions.checkArgument(bl);
        char c3 = c2 = cArray[0];
        for (int i2 = 1; i2 < cArray.length; ++i2) {
            c2 = c3;
            if (cArray[i2] > c3) {
                c2 = cArray[i2];
            }
            c3 = c2;
        }
        return c3;
    }

    public static char min(char ... cArray) {
        char c2 = cArray.length;
        boolean bl = c2 > '\u0000';
        Preconditions.checkArgument(bl);
        char c3 = c2 = cArray[0];
        for (int i2 = 1; i2 < cArray.length; ++i2) {
            c2 = c3;
            if (cArray[i2] < c3) {
                c2 = cArray[i2];
            }
            c3 = c2;
        }
        return c3;
    }

    public static void reverse(char[] cArray) {
        Preconditions.checkNotNull(cArray);
        Chars.reverse(cArray, 0, cArray.length);
    }

    public static void reverse(char[] cArray, int n2, int n3) {
        Preconditions.checkNotNull(cArray);
        Preconditions.checkPositionIndexes(n2, n3, cArray.length);
        --n3;
        while (n2 < n3) {
            char c2 = cArray[n2];
            cArray[n2] = cArray[n3];
            cArray[n3] = c2;
            ++n2;
            --n3;
        }
    }

    public static char saturatedCast(long l2) {
        if (l2 > 65535L) {
            return '\uffff';
        }
        if (l2 < 0L) {
            return '\u0000';
        }
        return (char)l2;
    }

    public static void sortDescending(char[] cArray) {
        Preconditions.checkNotNull(cArray);
        Chars.sortDescending(cArray, 0, cArray.length);
    }

    public static void sortDescending(char[] cArray, int n2, int n3) {
        Preconditions.checkNotNull(cArray);
        Preconditions.checkPositionIndexes(n2, n3, cArray.length);
        Arrays.sort(cArray, n2, n3);
        Chars.reverse(cArray, n2, n3);
    }

    public static char[] toArray(Collection<Character> object) {
        if (object instanceof CharArrayAsList) {
            return ((CharArrayAsList)object).toCharArray();
        }
        Object[] objectArray = object.toArray();
        int n2 = objectArray.length;
        object = new char[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            object[i2] = ((Character)Preconditions.checkNotNull(objectArray[i2])).charValue();
        }
        return object;
    }

    public static byte[] toByteArray(char c2) {
        return new byte[]{(byte)(c2 >> 8), (byte)c2};
    }

    private static class CharArrayAsList
    extends AbstractList<Character>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 0L;
        final char[] array;
        final int end;
        final int start;

        CharArrayAsList(char[] cArray) {
            this(cArray, 0, cArray.length);
        }

        CharArrayAsList(char[] cArray, int n2, int n3) {
            this.array = cArray;
            this.start = n2;
            this.end = n3;
        }

        @Override
        public boolean contains(Object object) {
            boolean bl = object instanceof Character && Chars.indexOf(this.array, ((Character)object).charValue(), this.start, this.end) != -1;
            return bl;
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof CharArrayAsList) {
                object = (CharArrayAsList)object;
                int n2 = this.size();
                if (((CharArrayAsList)object).size() != n2) {
                    return false;
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (this.array[this.start + i2] == ((CharArrayAsList)object).array[((CharArrayAsList)object).start + i2]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public Character get(int n2) {
            Preconditions.checkElementIndex(n2, this.size());
            return Character.valueOf(this.array[this.start + n2]);
        }

        @Override
        public int hashCode() {
            int n2 = 1;
            for (int i2 = this.start; i2 < this.end; ++i2) {
                n2 = n2 * 31 + Chars.hashCode(this.array[i2]);
            }
            return n2;
        }

        @Override
        public int indexOf(Object object) {
            int n2;
            if (object instanceof Character && (n2 = Chars.indexOf(this.array, ((Character)object).charValue(), this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int lastIndexOf(Object object) {
            int n2;
            if (object instanceof Character && (n2 = Chars.lastIndexOf(this.array, ((Character)object).charValue(), this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public Character set(int n2, Character c2) {
            Preconditions.checkElementIndex(n2, this.size());
            char[] cArray = this.array;
            int n3 = this.start;
            char c3 = cArray[n3 + n2];
            cArray[n3 + n2] = Preconditions.checkNotNull(c2).charValue();
            return Character.valueOf(c3);
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public List<Character> subList(int n2, int n3) {
            Preconditions.checkPositionIndexes(n2, n3, this.size());
            if (n2 == n3) {
                return Collections.emptyList();
            }
            char[] cArray = this.array;
            int n4 = this.start;
            return new CharArrayAsList(cArray, n2 + n4, n4 + n3);
        }

        char[] toCharArray() {
            return Arrays.copyOfRange(this.array, this.start, this.end);
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.size() * 3);
            stringBuilder.append('[');
            stringBuilder.append(this.array[this.start]);
            int n2 = this.start;
            while (++n2 < this.end) {
                stringBuilder.append(", ");
                stringBuilder.append(this.array[n2]);
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }

    private static enum LexicographicalComparator implements Comparator<char[]>
    {
        INSTANCE;


        @Override
        public int compare(char[] cArray, char[] cArray2) {
            int n2 = Math.min(cArray.length, cArray2.length);
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = Chars.compare(cArray[i2], cArray2[i2]);
                if (n3 == 0) continue;
                return n3;
            }
            return cArray.length - cArray2.length;
        }

        public String toString() {
            return "Chars.lexicographicalComparator()";
        }
    }
}

