/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Bytes {
    private Bytes() {
    }

    public static List<Byte> asList(byte ... byArray) {
        if (byArray.length == 0) {
            return Collections.emptyList();
        }
        return new ByteArrayAsList(byArray);
    }

    public static byte[] concat(byte[] ... byArray) {
        int n2;
        int n3 = byArray.length;
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            n4 += byArray[n2].length;
        }
        byte[] byArray2 = new byte[n4];
        n3 = byArray.length;
        n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            byte[] byArray3 = byArray[n2];
            System.arraycopy(byArray3, 0, byArray2, n4, byArray3.length);
            n4 += byArray3.length;
        }
        return byArray2;
    }

    public static boolean contains(byte[] byArray, byte by2) {
        int n2 = byArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (byArray[i2] != by2) continue;
            return true;
        }
        return false;
    }

    public static byte[] ensureCapacity(byte[] byArray, int n2, int n3) {
        boolean bl = true;
        boolean bl2 = n2 >= 0;
        Preconditions.checkArgument(bl2, "Invalid minLength: %s", n2);
        bl2 = n3 >= 0 ? bl : false;
        Preconditions.checkArgument(bl2, "Invalid padding: %s", n3);
        byte[] byArray2 = byArray;
        if (byArray.length < n2) {
            byArray2 = Arrays.copyOf(byArray, n2 + n3);
        }
        return byArray2;
    }

    public static int hashCode(byte by2) {
        return by2;
    }

    public static int indexOf(byte[] byArray, byte by2) {
        return Bytes.indexOf(byArray, by2, 0, byArray.length);
    }

    private static int indexOf(byte[] byArray, byte by2, int n2, int n3) {
        while (n2 < n3) {
            if (byArray[n2] == by2) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static int indexOf(byte[] byArray, byte[] byArray2) {
        Preconditions.checkNotNull(byArray, "array");
        Preconditions.checkNotNull(byArray2, "target");
        if (byArray2.length == 0) {
            return 0;
        }
        block0: for (int i2 = 0; i2 < byArray.length - byArray2.length + 1; ++i2) {
            for (int i3 = 0; i3 < byArray2.length; ++i3) {
                if (byArray[i2 + i3] == byArray2[i3]) continue;
                continue block0;
            }
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(byte[] byArray, byte by2) {
        return Bytes.lastIndexOf(byArray, by2, 0, byArray.length);
    }

    private static int lastIndexOf(byte[] byArray, byte by2, int n2, int n3) {
        --n3;
        while (n3 >= n2) {
            if (byArray[n3] == by2) {
                return n3;
            }
            --n3;
        }
        return -1;
    }

    public static void reverse(byte[] byArray) {
        Preconditions.checkNotNull(byArray);
        Bytes.reverse(byArray, 0, byArray.length);
    }

    public static void reverse(byte[] byArray, int n2, int n3) {
        Preconditions.checkNotNull(byArray);
        Preconditions.checkPositionIndexes(n2, n3, byArray.length);
        --n3;
        while (n2 < n3) {
            byte by2 = byArray[n2];
            byArray[n2] = byArray[n3];
            byArray[n3] = by2;
            ++n2;
            --n3;
        }
    }

    public static byte[] toArray(Collection<? extends Number> objectArray) {
        if (objectArray instanceof ByteArrayAsList) {
            return ((ByteArrayAsList)objectArray).toByteArray();
        }
        objectArray = objectArray.toArray();
        int n2 = objectArray.length;
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[i2] = ((Number)Preconditions.checkNotNull(objectArray[i2])).byteValue();
        }
        return byArray;
    }

    private static class ByteArrayAsList
    extends AbstractList<Byte>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 0L;
        final byte[] array;
        final int end;
        final int start;

        ByteArrayAsList(byte[] byArray) {
            this(byArray, 0, byArray.length);
        }

        ByteArrayAsList(byte[] byArray, int n2, int n3) {
            this.array = byArray;
            this.start = n2;
            this.end = n3;
        }

        @Override
        public boolean contains(Object object) {
            boolean bl = object instanceof Byte && Bytes.indexOf(this.array, (Byte)object, this.start, this.end) != -1;
            return bl;
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof ByteArrayAsList) {
                object = (ByteArrayAsList)object;
                int n2 = this.size();
                if (((ByteArrayAsList)object).size() != n2) {
                    return false;
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (this.array[this.start + i2] == ((ByteArrayAsList)object).array[((ByteArrayAsList)object).start + i2]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public Byte get(int n2) {
            Preconditions.checkElementIndex(n2, this.size());
            return this.array[this.start + n2];
        }

        @Override
        public int hashCode() {
            int n2 = 1;
            for (int i2 = this.start; i2 < this.end; ++i2) {
                n2 = n2 * 31 + Bytes.hashCode(this.array[i2]);
            }
            return n2;
        }

        @Override
        public int indexOf(Object object) {
            int n2;
            if (object instanceof Byte && (n2 = Bytes.indexOf(this.array, (Byte)object, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int lastIndexOf(Object object) {
            int n2;
            if (object instanceof Byte && (n2 = Bytes.lastIndexOf(this.array, (Byte)object, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public Byte set(int n2, Byte by2) {
            Preconditions.checkElementIndex(n2, this.size());
            byte[] byArray = this.array;
            int n3 = this.start;
            byte by3 = byArray[n3 + n2];
            byArray[n3 + n2] = Preconditions.checkNotNull(by2);
            return by3;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public List<Byte> subList(int n2, int n3) {
            Preconditions.checkPositionIndexes(n2, n3, this.size());
            if (n2 == n3) {
                return Collections.emptyList();
            }
            byte[] byArray = this.array;
            int n4 = this.start;
            return new ByteArrayAsList(byArray, n2 + n4, n4 + n3);
        }

        byte[] toByteArray() {
            return Arrays.copyOfRange(this.array, this.start, this.end);
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.size() * 5);
            stringBuilder.append('[');
            stringBuilder.append(this.array[this.start]);
            int n2 = this.start;
            while (++n2 < this.end) {
                stringBuilder.append(", ");
                stringBuilder.append(this.array[n2]);
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }
}

