/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Booleans {
    private Booleans() {
    }

    public static List<Boolean> asList(boolean ... blArray) {
        if (blArray.length == 0) {
            return Collections.emptyList();
        }
        return new BooleanArrayAsList(blArray);
    }

    public static int compare(boolean bl, boolean bl2) {
        int n2 = bl == bl2 ? 0 : (bl ? 1 : -1);
        return n2;
    }

    public static boolean[] concat(boolean[] ... blArray) {
        int n2;
        int n3 = blArray.length;
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            n4 += blArray[n2].length;
        }
        boolean[] blArray2 = new boolean[n4];
        n3 = blArray.length;
        n2 = 0;
        for (n4 = 0; n4 < n3; ++n4) {
            boolean[] blArray3 = blArray[n4];
            System.arraycopy(blArray3, 0, blArray2, n2, blArray3.length);
            n2 += blArray3.length;
        }
        return blArray2;
    }

    public static boolean contains(boolean[] blArray, boolean bl) {
        int n2 = blArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (blArray[i2] != bl) continue;
            return true;
        }
        return false;
    }

    public static int countTrue(boolean ... blArray) {
        int n2 = blArray.length;
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = n3;
            if (blArray[i2]) {
                n4 = n3 + 1;
            }
            n3 = n4;
        }
        return n3;
    }

    public static boolean[] ensureCapacity(boolean[] blArray, int n2, int n3) {
        boolean bl = true;
        boolean bl2 = n2 >= 0;
        Preconditions.checkArgument(bl2, "Invalid minLength: %s", n2);
        bl2 = n3 >= 0 ? bl : false;
        Preconditions.checkArgument(bl2, "Invalid padding: %s", n3);
        boolean[] blArray2 = blArray;
        if (blArray.length < n2) {
            blArray2 = Arrays.copyOf(blArray, n2 + n3);
        }
        return blArray2;
    }

    public static Comparator<Boolean> falseFirst() {
        return BooleanComparator.FALSE_FIRST;
    }

    public static int hashCode(boolean bl) {
        int n2 = bl ? 1231 : 1237;
        return n2;
    }

    public static int indexOf(boolean[] blArray, boolean bl) {
        return Booleans.indexOf(blArray, bl, 0, blArray.length);
    }

    private static int indexOf(boolean[] blArray, boolean bl, int n2, int n3) {
        while (n2 < n3) {
            if (blArray[n2] == bl) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static int indexOf(boolean[] blArray, boolean[] blArray2) {
        Preconditions.checkNotNull(blArray, "array");
        Preconditions.checkNotNull(blArray2, "target");
        if (blArray2.length == 0) {
            return 0;
        }
        block0: for (int i2 = 0; i2 < blArray.length - blArray2.length + 1; ++i2) {
            for (int i3 = 0; i3 < blArray2.length; ++i3) {
                if (blArray[i2 + i3] == blArray2[i3]) continue;
                continue block0;
            }
            return i2;
        }
        return -1;
    }

    public static String join(String string2, boolean ... blArray) {
        Preconditions.checkNotNull(string2);
        if (blArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(blArray.length * 7);
        stringBuilder.append(blArray[0]);
        for (int i2 = 1; i2 < blArray.length; ++i2) {
            stringBuilder.append(string2);
            stringBuilder.append(blArray[i2]);
        }
        return stringBuilder.toString();
    }

    public static int lastIndexOf(boolean[] blArray, boolean bl) {
        return Booleans.lastIndexOf(blArray, bl, 0, blArray.length);
    }

    private static int lastIndexOf(boolean[] blArray, boolean bl, int n2, int n3) {
        --n3;
        while (n3 >= n2) {
            if (blArray[n3] == bl) {
                return n3;
            }
            --n3;
        }
        return -1;
    }

    public static Comparator<boolean[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void reverse(boolean[] blArray) {
        Preconditions.checkNotNull(blArray);
        Booleans.reverse(blArray, 0, blArray.length);
    }

    public static void reverse(boolean[] blArray, int n2, int n3) {
        Preconditions.checkNotNull(blArray);
        Preconditions.checkPositionIndexes(n2, n3, blArray.length);
        --n3;
        while (n2 < n3) {
            boolean bl = blArray[n2];
            blArray[n2] = blArray[n3];
            blArray[n3] = bl;
            ++n2;
            --n3;
        }
    }

    public static boolean[] toArray(Collection<Boolean> object) {
        if (object instanceof BooleanArrayAsList) {
            return ((BooleanArrayAsList)object).toBooleanArray();
        }
        Object[] objectArray = object.toArray();
        int n2 = objectArray.length;
        object = new boolean[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            object[i2] = (Boolean)Preconditions.checkNotNull(objectArray[i2]);
        }
        return object;
    }

    public static Comparator<Boolean> trueFirst() {
        return BooleanComparator.TRUE_FIRST;
    }

    private static class BooleanArrayAsList
    extends AbstractList<Boolean>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 0L;
        final boolean[] array;
        final int end;
        final int start;

        BooleanArrayAsList(boolean[] blArray) {
            this(blArray, 0, blArray.length);
        }

        BooleanArrayAsList(boolean[] blArray, int n2, int n3) {
            this.array = blArray;
            this.start = n2;
            this.end = n3;
        }

        @Override
        public boolean contains(Object object) {
            boolean bl = object instanceof Boolean && Booleans.indexOf(this.array, (Boolean)object, this.start, this.end) != -1;
            return bl;
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof BooleanArrayAsList) {
                object = (BooleanArrayAsList)object;
                int n2 = this.size();
                if (((BooleanArrayAsList)object).size() != n2) {
                    return false;
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (this.array[this.start + i2] == ((BooleanArrayAsList)object).array[((BooleanArrayAsList)object).start + i2]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public Boolean get(int n2) {
            Preconditions.checkElementIndex(n2, this.size());
            return this.array[this.start + n2];
        }

        @Override
        public int hashCode() {
            int n2 = 1;
            for (int i2 = this.start; i2 < this.end; ++i2) {
                n2 = n2 * 31 + Booleans.hashCode(this.array[i2]);
            }
            return n2;
        }

        @Override
        public int indexOf(Object object) {
            int n2;
            if (object instanceof Boolean && (n2 = Booleans.indexOf(this.array, (Boolean)object, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int lastIndexOf(Object object) {
            int n2;
            if (object instanceof Boolean && (n2 = Booleans.lastIndexOf(this.array, (Boolean)object, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public Boolean set(int n2, Boolean bl) {
            Preconditions.checkElementIndex(n2, this.size());
            boolean[] blArray = this.array;
            int n3 = this.start;
            boolean bl2 = blArray[n3 + n2];
            blArray[n3 + n2] = Preconditions.checkNotNull(bl);
            return bl2;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public List<Boolean> subList(int n2, int n3) {
            Preconditions.checkPositionIndexes(n2, n3, this.size());
            if (n2 == n3) {
                return Collections.emptyList();
            }
            boolean[] blArray = this.array;
            int n4 = this.start;
            return new BooleanArrayAsList(blArray, n2 + n4, n4 + n3);
        }

        boolean[] toBooleanArray() {
            return Arrays.copyOfRange(this.array, this.start, this.end);
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.size() * 7);
            String string2 = this.array[this.start] ? "[true" : "[false";
            stringBuilder.append(string2);
            int n2 = this.start;
            while (++n2 < this.end) {
                string2 = this.array[n2] ? ", true" : ", false";
                stringBuilder.append(string2);
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }

    private static enum BooleanComparator implements Comparator<Boolean>
    {
        TRUE_FIRST(1, "Booleans.trueFirst()"),
        FALSE_FIRST(-1, "Booleans.falseFirst()");

        private final String toString;
        private final int trueValue;

        private BooleanComparator(int n3, String string3) {
            this.trueValue = n3;
            this.toString = string3;
        }

        @Override
        public int compare(Boolean bl, Boolean bl2) {
            boolean bl3 = bl;
            int n2 = 0;
            int n3 = bl3 ? this.trueValue : 0;
            if (bl2.booleanValue()) {
                n2 = this.trueValue;
            }
            return n2 - n3;
        }

        public String toString() {
            return this.toString;
        }
    }

    private static enum LexicographicalComparator implements Comparator<boolean[]>
    {
        INSTANCE;


        @Override
        public int compare(boolean[] blArray, boolean[] blArray2) {
            int n2 = Math.min(blArray.length, blArray2.length);
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = Booleans.compare(blArray[i2], blArray2[i2]);
                if (n3 == 0) continue;
                return n3;
            }
            return blArray.length - blArray2.length;
        }

        public String toString() {
            return "Booleans.lexicographicalComparator()";
        }
    }
}

