/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.net;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteStreams;
import com.google.common.primitives.Ints;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class InetAddresses {
    private static final Inet4Address ANY4;
    private static final int IPV4_PART_COUNT = 4;
    private static final Splitter IPV4_SPLITTER;
    private static final int IPV6_PART_COUNT = 8;
    private static final Splitter IPV6_SPLITTER;
    private static final Inet4Address LOOPBACK4;

    static {
        IPV4_SPLITTER = Splitter.on('.').limit(4);
        IPV6_SPLITTER = Splitter.on(':').limit(10);
        LOOPBACK4 = (Inet4Address)InetAddresses.forString("127.0.0.1");
        ANY4 = (Inet4Address)InetAddresses.forString("0.0.0.0");
    }

    private InetAddresses() {
    }

    private static InetAddress bytesToInetAddress(byte[] object) {
        try {
            object = InetAddress.getByAddress(object);
            return object;
        }
        catch (UnknownHostException unknownHostException) {
            throw new AssertionError((Object)unknownHostException);
        }
    }

    public static int coerceToInteger(InetAddress inetAddress) {
        return ByteStreams.newDataInput((byte[])InetAddresses.getCoercedIPv4Address(inetAddress).getAddress()).readInt();
    }

    private static void compressLongestRunOfZeroes(int[] nArray) {
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        for (int i2 = 0; i2 < nArray.length + 1; ++i2) {
            int n5;
            int n6;
            int n7;
            if (i2 < nArray.length && nArray[i2] == 0) {
                n7 = n2;
                n6 = n3;
                n5 = n4;
                if (n4 < 0) {
                    n5 = i2;
                    n7 = n2;
                    n6 = n3;
                }
            } else {
                n7 = n2;
                n6 = n3;
                n5 = n4;
                if (n4 >= 0) {
                    n5 = i2 - n4;
                    n7 = n2;
                    if (n5 > n2) {
                        n7 = n5;
                        n3 = n4;
                    }
                    n5 = -1;
                    n6 = n3;
                }
            }
            n2 = n7;
            n3 = n6;
            n4 = n5;
        }
        if (n2 >= 2) {
            Arrays.fill(nArray, n3, n2 + n3, -1);
        }
    }

    @NullableDecl
    private static String convertDottedQuadToHex(String string2) {
        int n2 = string2.lastIndexOf(58) + 1;
        String string3 = string2.substring(0, n2);
        Object object = InetAddresses.textToNumericFormatV4(string2.substring(n2));
        if (object == null) {
            return null;
        }
        string2 = Integer.toHexString((object[0] & 0xFF) << 8 | object[1] & 0xFF);
        n2 = object[2];
        object = Integer.toHexString(object[3] & 0xFF | (n2 & 0xFF) << 8);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string3);
        stringBuilder.append(string2);
        stringBuilder.append(":");
        stringBuilder.append((String)object);
        return stringBuilder.toString();
    }

    public static InetAddress decrement(InetAddress inetAddress) {
        int n2;
        byte[] byArray = inetAddress.getAddress();
        for (n2 = byArray.length - 1; n2 >= 0 && byArray[n2] == 0; --n2) {
            byArray[n2] = (byte)-1;
        }
        boolean bl = n2 >= 0;
        Preconditions.checkArgument(bl, "Decrementing %s would wrap.", (Object)inetAddress);
        byArray[n2] = (byte)(byArray[n2] - 1);
        return InetAddresses.bytesToInetAddress(byArray);
    }

    public static InetAddress forString(String string2) {
        byte[] byArray = InetAddresses.ipStringToBytes(string2);
        if (byArray != null) {
            return InetAddresses.bytesToInetAddress(byArray);
        }
        throw InetAddresses.formatIllegalArgumentException("'%s' is not an IP string literal.", string2);
    }

    public static InetAddress forUriString(String string2) {
        InetAddress inetAddress = InetAddresses.forUriStringNoThrow(string2);
        if (inetAddress != null) {
            return inetAddress;
        }
        throw InetAddresses.formatIllegalArgumentException("Not a valid URI IP literal: '%s'", string2);
    }

    @NullableDecl
    private static InetAddress forUriStringNoThrow(String object) {
        int n2;
        Preconditions.checkNotNull(object);
        if (((String)object).startsWith("[") && ((String)object).endsWith("]")) {
            object = ((String)object).substring(1, ((String)object).length() - 1);
            n2 = 16;
        } else {
            n2 = 4;
        }
        object = InetAddresses.ipStringToBytes((String)object);
        if (object != null && ((Object)object).length == n2) {
            return InetAddresses.bytesToInetAddress((byte[])object);
        }
        return null;
    }

    private static IllegalArgumentException formatIllegalArgumentException(String string2, Object ... objectArray) {
        return new IllegalArgumentException(String.format(Locale.ROOT, string2, objectArray));
    }

    public static Inet4Address fromInteger(int n2) {
        return InetAddresses.getInet4Address(Ints.toByteArray(n2));
    }

    public static InetAddress fromLittleEndianByteArray(byte[] byArray) throws UnknownHostException {
        byte[] byArray2 = new byte[byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray2[i2] = byArray[byArray.length - i2 - 1];
        }
        return InetAddress.getByAddress(byArray2);
    }

    public static Inet4Address get6to4IPv4Address(Inet6Address inet6Address) {
        Preconditions.checkArgument(InetAddresses.is6to4Address(inet6Address), "Address '%s' is not a 6to4 address.", (Object)InetAddresses.toAddrString(inet6Address));
        return InetAddresses.getInet4Address(Arrays.copyOfRange(inet6Address.getAddress(), 2, 6));
    }

    public static Inet4Address getCoercedIPv4Address(InetAddress inetAddress) {
        int n2;
        int n3;
        byte[] byArray;
        block5: {
            if (inetAddress instanceof Inet4Address) {
                return (Inet4Address)inetAddress;
            }
            byArray = inetAddress.getAddress();
            for (n3 = 0; n3 < 15; ++n3) {
                if (byArray[n3] == 0) continue;
                n3 = 0;
                break block5;
            }
            n3 = 1;
        }
        if (n3 != 0 && byArray[15] == 1) {
            return LOOPBACK4;
        }
        if (n3 != 0 && byArray[15] == 0) {
            return ANY4;
        }
        long l2 = InetAddresses.hasEmbeddedIPv4ClientAddress((Inet6Address)(inetAddress = (Inet6Address)inetAddress)) ? (long)InetAddresses.getEmbeddedIPv4ClientAddress((Inet6Address)inetAddress).hashCode() : ByteBuffer.wrap(((Inet6Address)inetAddress).getAddress(), 0, 8).getLong();
        n3 = n2 = Hashing.murmur3_32().hashLong(l2).asInt() | 0xE0000000;
        if (n2 == -1) {
            n3 = -2;
        }
        return InetAddresses.getInet4Address(Ints.toByteArray(n3));
    }

    public static Inet4Address getCompatIPv4Address(Inet6Address inet6Address) {
        Preconditions.checkArgument(InetAddresses.isCompatIPv4Address(inet6Address), "Address '%s' is not IPv4-compatible.", (Object)InetAddresses.toAddrString(inet6Address));
        return InetAddresses.getInet4Address(Arrays.copyOfRange(inet6Address.getAddress(), 12, 16));
    }

    public static Inet4Address getEmbeddedIPv4ClientAddress(Inet6Address inet6Address) {
        if (InetAddresses.isCompatIPv4Address(inet6Address)) {
            return InetAddresses.getCompatIPv4Address(inet6Address);
        }
        if (InetAddresses.is6to4Address(inet6Address)) {
            return InetAddresses.get6to4IPv4Address(inet6Address);
        }
        if (InetAddresses.isTeredoAddress(inet6Address)) {
            return InetAddresses.getTeredoInfo(inet6Address).getClient();
        }
        throw InetAddresses.formatIllegalArgumentException("'%s' has no embedded IPv4 address.", InetAddresses.toAddrString(inet6Address));
    }

    private static Inet4Address getInet4Address(byte[] byArray) {
        boolean bl = byArray.length == 4;
        Preconditions.checkArgument(bl, "Byte array has invalid length for an IPv4 address: %s != 4.", byArray.length);
        return (Inet4Address)InetAddresses.bytesToInetAddress(byArray);
    }

    public static Inet4Address getIsatapIPv4Address(Inet6Address inet6Address) {
        Preconditions.checkArgument(InetAddresses.isIsatapAddress(inet6Address), "Address '%s' is not an ISATAP address.", (Object)InetAddresses.toAddrString(inet6Address));
        return InetAddresses.getInet4Address(Arrays.copyOfRange(inet6Address.getAddress(), 12, 16));
    }

    public static TeredoInfo getTeredoInfo(Inet6Address inetAddress) {
        Preconditions.checkArgument(InetAddresses.isTeredoAddress(inetAddress), "Address '%s' is not a Teredo address.", (Object)InetAddresses.toAddrString(inetAddress));
        byte[] byArray = inetAddress.getAddress();
        inetAddress = InetAddresses.getInet4Address(Arrays.copyOfRange(byArray, 4, 8));
        short s2 = ByteStreams.newDataInput((byte[])byArray, (int)8).readShort();
        short s3 = ByteStreams.newDataInput((byte[])byArray, (int)10).readShort();
        byArray = Arrays.copyOfRange(byArray, 12, 16);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = ~byArray[i2];
        }
        return new TeredoInfo((Inet4Address)inetAddress, InetAddresses.getInet4Address(byArray), 0xFFFF & ~s3, s2 & 0xFFFF);
    }

    public static boolean hasEmbeddedIPv4ClientAddress(Inet6Address inet6Address) {
        boolean bl = InetAddresses.isCompatIPv4Address(inet6Address) || InetAddresses.is6to4Address(inet6Address) || InetAddresses.isTeredoAddress(inet6Address);
        return bl;
    }

    private static String hextetsToIPv6String(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder(39);
        boolean bl = false;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            boolean bl2 = nArray[i2] >= 0;
            if (bl2) {
                if (bl) {
                    stringBuilder.append(':');
                }
                stringBuilder.append(Integer.toHexString(nArray[i2]));
            } else if (i2 == 0 || bl) {
                stringBuilder.append("::");
            }
            bl = bl2;
        }
        return stringBuilder.toString();
    }

    public static InetAddress increment(InetAddress inetAddress) {
        boolean bl;
        byte[] byArray = inetAddress.getAddress();
        int n2 = byArray.length - 1;
        while (true) {
            bl = false;
            if (n2 < 0 || byArray[n2] != -1) break;
            byArray[n2] = (byte)0;
            --n2;
        }
        if (n2 >= 0) {
            bl = true;
        }
        Preconditions.checkArgument(bl, "Incrementing %s would wrap.", (Object)inetAddress);
        byArray[n2] = (byte)(byArray[n2] + 1);
        return InetAddresses.bytesToInetAddress(byArray);
    }

    @NullableDecl
    private static byte[] ipStringToBytes(String string2) {
        boolean bl = false;
        boolean bl2 = false;
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            char c2 = string2.charAt(i2);
            if (c2 == '.') {
                bl2 = true;
                continue;
            }
            if (c2 == ':') {
                if (bl2) {
                    return null;
                }
                bl = true;
                continue;
            }
            if (Character.digit(c2, 16) != -1) continue;
            return null;
        }
        if (bl) {
            String string3 = string2;
            if (bl2) {
                string3 = string2 = InetAddresses.convertDottedQuadToHex(string2);
                if (string2 == null) {
                    return null;
                }
            }
            return InetAddresses.textToNumericFormatV6(string3);
        }
        if (bl2) {
            return InetAddresses.textToNumericFormatV4(string2);
        }
        return null;
    }

    public static boolean is6to4Address(Inet6Address object) {
        boolean bl;
        object = ((Inet6Address)object).getAddress();
        boolean bl2 = bl = false;
        if (object[0] == 32) {
            bl2 = bl;
            if (object[1] == 2) {
                bl2 = true;
            }
        }
        return bl2;
    }

    public static boolean isCompatIPv4Address(Inet6Address object) {
        if (!((Inet6Address)object).isIPv4CompatibleAddress()) {
            return false;
        }
        return (object = (Object)((Inet6Address)object).getAddress())[12] != false || object[13] != false || object[14] != false || object[15] != false && object[15] != true;
    }

    public static boolean isInetAddress(String string2) {
        boolean bl = InetAddresses.ipStringToBytes(string2) != null;
        return bl;
    }

    public static boolean isIsatapAddress(Inet6Address object) {
        boolean bl = InetAddresses.isTeredoAddress((Inet6Address)object);
        boolean bl2 = false;
        if (bl) {
            return false;
        }
        if (((object = (Object)((Inet6Address)object).getAddress())[8] | 3) != 3) {
            return false;
        }
        bl = bl2;
        if (object[9] == false) {
            bl = bl2;
            if (object[10] == 94) {
                bl = bl2;
                if (object[11] == -2) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public static boolean isMappedIPv4Address(String object) {
        if ((object = (Object)InetAddresses.ipStringToBytes((String)object)) != null && ((Object)object).length == 16) {
            int n2 = 0;
            while (true) {
                if (n2 >= 10) break;
                if (object[n2] != false) {
                    return false;
                }
                ++n2;
            }
            for (int i2 = 10; i2 < 12; ++i2) {
                if (object[i2] == -1) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isMaximum(InetAddress object) {
        object = ((InetAddress)object).getAddress();
        for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
            if (object[i2] == -1) continue;
            return false;
        }
        return true;
    }

    public static boolean isTeredoAddress(Inet6Address object) {
        boolean bl;
        object = ((Inet6Address)object).getAddress();
        boolean bl2 = bl = false;
        if (object[0] == 32) {
            bl2 = bl;
            if (object[1] == true) {
                bl2 = bl;
                if (object[2] == false) {
                    bl2 = bl;
                    if (object[3] == false) {
                        bl2 = true;
                    }
                }
            }
        }
        return bl2;
    }

    public static boolean isUriInetAddress(String string2) {
        boolean bl = InetAddresses.forUriStringNoThrow(string2) != null;
        return bl;
    }

    private static short parseHextet(String string2) {
        int n2 = Integer.parseInt(string2, 16);
        if (n2 <= 65535) {
            return (short)n2;
        }
        throw new NumberFormatException();
    }

    private static byte parseOctet(String string2) {
        int n2 = Integer.parseInt(string2);
        if (!(n2 > 255 || string2.startsWith("0") && string2.length() > 1)) {
            return (byte)n2;
        }
        throw new NumberFormatException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NullableDecl
    private static byte[] textToNumericFormatV4(String object) {
        byte[] byArray = new byte[4];
        try {
            object = IPV4_SPLITTER.split((CharSequence)object).iterator();
            int n2 = 0;
            while (object.hasNext()) {
                byArray[n2] = InetAddresses.parseOctet(object.next());
                ++n2;
            }
            if (n2 != 4) return null;
            return byArray;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @NullableDecl
    private static byte[] textToNumericFormatV6(String object) {
        List<String> list = IPV6_SPLITTER.splitToList((CharSequence)object);
        if (list.size() >= 3 && list.size() <= 9) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6 = -1;
            for (n5 = 1; n5 < list.size() - 1; ++n5) {
                n4 = n6;
                if (list.get(n5).length() == 0) {
                    if (n6 >= 0) {
                        return null;
                    }
                    n4 = n5;
                }
                n6 = n4;
            }
            if (n6 >= 0) {
                n3 = list.size() - n6 - 1;
                if (list.get(0).length() == 0) {
                    n4 = n5 = n6 - 1;
                    if (n5 != 0) {
                        return null;
                    }
                } else {
                    n4 = n6;
                }
                n5 = n3--;
                n2 = n4;
                if (Iterables.getLast(list).length() == 0) {
                    n5 = n3;
                    n2 = n4;
                    if (n3 != 0) {
                        return null;
                    }
                }
            } else {
                n2 = list.size();
                n5 = 0;
            }
            n3 = 8 - (n2 + n5);
            if (!(n6 < 0 ? n3 == 0 : n3 >= 1)) {
                return null;
            }
            object = ByteBuffer.allocate(16);
            for (n6 = 0; n6 < n2; ++n6) {
                ((ByteBuffer)object).putShort(InetAddresses.parseHextet(list.get(n6)));
                continue;
            }
            n4 = 0;
            while (true) {
                if (n4 >= n3) break;
                ((ByteBuffer)object).putShort((short)0);
                ++n4;
                continue;
                break;
            }
            for (n6 = n5; n6 > 0; --n6) {
                try {
                    ((ByteBuffer)object).putShort(InetAddresses.parseHextet(list.get(list.size() - n6)));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            return ((ByteBuffer)object).array();
        }
        return null;
    }

    public static String toAddrString(InetAddress object) {
        Preconditions.checkNotNull(object);
        if (object instanceof Inet4Address) {
            return ((InetAddress)object).getHostAddress();
        }
        Preconditions.checkArgument(object instanceof Inet6Address);
        object = ((InetAddress)object).getAddress();
        int[] nArray = new int[8];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = i2 * 2;
            nArray[i2] = Ints.fromBytes((byte)0, (byte)0, (byte)object[n2], (byte)object[n2 + 1]);
        }
        InetAddresses.compressLongestRunOfZeroes(nArray);
        return InetAddresses.hextetsToIPv6String(nArray);
    }

    public static String toUriString(InetAddress inetAddress) {
        if (inetAddress instanceof Inet6Address) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            stringBuilder.append(InetAddresses.toAddrString(inetAddress));
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
        return InetAddresses.toAddrString(inetAddress);
    }

    public static final class TeredoInfo {
        private final Inet4Address client;
        private final int flags;
        private final int port;
        private final Inet4Address server;

        public TeredoInfo(@NullableDecl Inet4Address inet4Address, @NullableDecl Inet4Address inet4Address2, int n2, int n3) {
            boolean bl = true;
            boolean bl2 = n2 >= 0 && n2 <= 65535;
            Preconditions.checkArgument(bl2, "port '%s' is out of range (0 <= port <= 0xffff)", n2);
            bl2 = n3 >= 0 && n3 <= 65535 ? bl : false;
            Preconditions.checkArgument(bl2, "flags '%s' is out of range (0 <= flags <= 0xffff)", n3);
            this.server = MoreObjects.firstNonNull(inet4Address, ANY4);
            this.client = MoreObjects.firstNonNull(inet4Address2, ANY4);
            this.port = n2;
            this.flags = n3;
        }

        public Inet4Address getClient() {
            return this.client;
        }

        public int getFlags() {
            return this.flags;
        }

        public int getPort() {
            return this.port;
        }

        public Inet4Address getServer() {
            return this.server;
        }
    }
}

