/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.math.DoubleUtils;
import com.google.common.math.StatsAccumulator;
import com.google.common.primitives.Doubles;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Stats
implements Serializable {
    static final int BYTES = 40;
    private static final long serialVersionUID = 0L;
    private final long count;
    private final double max;
    private final double mean;
    private final double min;
    private final double sumOfSquaresOfDeltas;

    Stats(long l2, double d2, double d3, double d4, double d5) {
        this.count = l2;
        this.mean = d2;
        this.sumOfSquaresOfDeltas = d3;
        this.min = d4;
        this.max = d5;
    }

    public static Stats fromByteArray(byte[] byArray) {
        Preconditions.checkNotNull(byArray);
        boolean bl = byArray.length == 40;
        Preconditions.checkArgument(bl, "Expected Stats.BYTES = %s remaining , got %s", 40, byArray.length);
        return Stats.readFrom(ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN));
    }

    public static double meanOf(Iterable<? extends Number> iterable) {
        return Stats.meanOf(iterable.iterator());
    }

    public static double meanOf(Iterator<? extends Number> iterator2) {
        Preconditions.checkArgument(iterator2.hasNext());
        double d2 = iterator2.next().doubleValue();
        long l2 = 1L;
        while (iterator2.hasNext()) {
            double d3 = iterator2.next().doubleValue();
            ++l2;
            if (Doubles.isFinite(d3) && Doubles.isFinite(d2)) {
                double d4 = l2;
                Double.isNaN(d4);
                d2 += (d3 - d2) / d4;
                continue;
            }
            d2 = StatsAccumulator.calculateNewMeanNonFinite((double)d2, (double)d3);
        }
        return d2;
    }

    public static double meanOf(double ... dArray) {
        int n2 = dArray.length;
        boolean bl = n2 > 0;
        Preconditions.checkArgument(bl);
        double d2 = dArray[0];
        for (int i2 = 1; i2 < dArray.length; ++i2) {
            double d3 = dArray[i2];
            if (Doubles.isFinite(d3) && Doubles.isFinite(d2)) {
                double d4 = i2 + 1;
                Double.isNaN(d4);
                d2 += (d3 - d2) / d4;
                continue;
            }
            d2 = StatsAccumulator.calculateNewMeanNonFinite((double)d2, (double)d3);
        }
        return d2;
    }

    public static double meanOf(int ... nArray) {
        int n2 = nArray.length;
        boolean bl = n2 > 0;
        Preconditions.checkArgument(bl);
        double d2 = nArray[0];
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            double d3 = nArray[i2];
            if (Doubles.isFinite(d3) && Doubles.isFinite(d2)) {
                Double.isNaN(d3);
                double d4 = i2 + 1;
                Double.isNaN(d4);
                d2 += (d3 - d2) / d4;
                continue;
            }
            d2 = StatsAccumulator.calculateNewMeanNonFinite((double)d2, (double)d3);
        }
        return d2;
    }

    public static double meanOf(long ... lArray) {
        int n2 = lArray.length;
        boolean bl = n2 > 0;
        Preconditions.checkArgument(bl);
        double d2 = lArray[0];
        for (int i2 = 1; i2 < lArray.length; ++i2) {
            double d3 = lArray[i2];
            if (Doubles.isFinite(d3) && Doubles.isFinite(d2)) {
                Double.isNaN(d3);
                double d4 = i2 + 1;
                Double.isNaN(d4);
                d2 += (d3 - d2) / d4;
                continue;
            }
            d2 = StatsAccumulator.calculateNewMeanNonFinite((double)d2, (double)d3);
        }
        return d2;
    }

    public static Stats of(Iterable<? extends Number> iterable) {
        StatsAccumulator statsAccumulator = new StatsAccumulator();
        statsAccumulator.addAll(iterable);
        return statsAccumulator.snapshot();
    }

    public static Stats of(Iterator<? extends Number> iterator2) {
        StatsAccumulator statsAccumulator = new StatsAccumulator();
        statsAccumulator.addAll(iterator2);
        return statsAccumulator.snapshot();
    }

    public static Stats of(double ... dArray) {
        StatsAccumulator statsAccumulator = new StatsAccumulator();
        statsAccumulator.addAll(dArray);
        return statsAccumulator.snapshot();
    }

    public static Stats of(int ... nArray) {
        StatsAccumulator statsAccumulator = new StatsAccumulator();
        statsAccumulator.addAll(nArray);
        return statsAccumulator.snapshot();
    }

    public static Stats of(long ... lArray) {
        StatsAccumulator statsAccumulator = new StatsAccumulator();
        statsAccumulator.addAll(lArray);
        return statsAccumulator.snapshot();
    }

    static Stats readFrom(ByteBuffer byteBuffer) {
        Preconditions.checkNotNull(byteBuffer);
        boolean bl = byteBuffer.remaining() >= 40;
        Preconditions.checkArgument(bl, "Expected at least Stats.BYTES = %s remaining , got %s", 40, byteBuffer.remaining());
        return new Stats(byteBuffer.getLong(), byteBuffer.getDouble(), byteBuffer.getDouble(), byteBuffer.getDouble(), byteBuffer.getDouble());
    }

    public long count() {
        return this.count;
    }

    public boolean equals(@NullableDecl Object object) {
        boolean bl = false;
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (Stats)object;
        boolean bl2 = bl;
        if (this.count == ((Stats)object).count) {
            bl2 = bl;
            if (Double.doubleToLongBits(this.mean) == Double.doubleToLongBits(((Stats)object).mean)) {
                bl2 = bl;
                if (Double.doubleToLongBits(this.sumOfSquaresOfDeltas) == Double.doubleToLongBits(((Stats)object).sumOfSquaresOfDeltas)) {
                    bl2 = bl;
                    if (Double.doubleToLongBits(this.min) == Double.doubleToLongBits(((Stats)object).min)) {
                        bl2 = bl;
                        if (Double.doubleToLongBits(this.max) == Double.doubleToLongBits(((Stats)object).max)) {
                            bl2 = true;
                        }
                    }
                }
            }
        }
        return bl2;
    }

    public int hashCode() {
        return Objects.hashCode(this.count, this.mean, this.sumOfSquaresOfDeltas, this.min, this.max);
    }

    public double max() {
        boolean bl = this.count != 0L;
        Preconditions.checkState(bl);
        return this.max;
    }

    public double mean() {
        boolean bl = this.count != 0L;
        Preconditions.checkState(bl);
        return this.mean;
    }

    public double min() {
        boolean bl = this.count != 0L;
        Preconditions.checkState(bl);
        return this.min;
    }

    public double populationStandardDeviation() {
        return Math.sqrt(this.populationVariance());
    }

    public double populationVariance() {
        boolean bl = this.count > 0L;
        Preconditions.checkState(bl);
        if (Double.isNaN(this.sumOfSquaresOfDeltas)) {
            return Double.NaN;
        }
        if (this.count == 1L) {
            return 0.0;
        }
        double d2 = DoubleUtils.ensureNonNegative(this.sumOfSquaresOfDeltas);
        double d3 = this.count();
        Double.isNaN(d3);
        return d2 / d3;
    }

    public double sampleStandardDeviation() {
        return Math.sqrt(this.sampleVariance());
    }

    public double sampleVariance() {
        boolean bl = this.count > 1L;
        Preconditions.checkState(bl);
        if (Double.isNaN(this.sumOfSquaresOfDeltas)) {
            return Double.NaN;
        }
        double d2 = DoubleUtils.ensureNonNegative(this.sumOfSquaresOfDeltas);
        double d3 = this.count - 1L;
        Double.isNaN(d3);
        return d2 / d3;
    }

    public double sum() {
        double d2 = this.mean;
        double d3 = this.count;
        Double.isNaN(d3);
        return d2 * d3;
    }

    double sumOfSquaresOfDeltas() {
        return this.sumOfSquaresOfDeltas;
    }

    public byte[] toByteArray() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(40).order(ByteOrder.LITTLE_ENDIAN);
        this.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    public String toString() {
        if (this.count() > 0L) {
            return MoreObjects.toStringHelper(this).add("count", this.count).add("mean", this.mean).add("populationStandardDeviation", this.populationStandardDeviation()).add("min", this.min).add("max", this.max).toString();
        }
        return MoreObjects.toStringHelper(this).add("count", this.count).toString();
    }

    void writeTo(ByteBuffer byteBuffer) {
        Preconditions.checkNotNull(byteBuffer);
        boolean bl = byteBuffer.remaining() >= 40;
        Preconditions.checkArgument(bl, "Expected at least Stats.BYTES = %s remaining , got %s", 40, byteBuffer.remaining());
        byteBuffer.putLong(this.count).putDouble(this.mean).putDouble(this.sumOfSquaresOfDeltas).putDouble(this.min).putDouble(this.max);
    }
}

