/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.base.Preconditions;
import com.google.common.math.DoubleUtils;
import com.google.errorprone.annotations.concurrent.LazyInit;

public abstract class LinearTransformation {
    public static LinearTransformation forNaN() {
        return NaNLinearTransformation.INSTANCE;
    }

    public static LinearTransformation horizontal(double d2) {
        Preconditions.checkArgument(DoubleUtils.isFinite(d2));
        return new RegularLinearTransformation(0.0, d2);
    }

    public static LinearTransformationBuilder mapping(double d2, double d3) {
        boolean bl = DoubleUtils.isFinite(d2) && DoubleUtils.isFinite(d3);
        Preconditions.checkArgument(bl);
        return new LinearTransformationBuilder(d2, d3);
    }

    public static LinearTransformation vertical(double d2) {
        Preconditions.checkArgument(DoubleUtils.isFinite(d2));
        return new VerticalLinearTransformation(d2);
    }

    public abstract LinearTransformation inverse();

    public abstract boolean isHorizontal();

    public abstract boolean isVertical();

    public abstract double slope();

    public abstract double transform(double var1);

    public static final class LinearTransformationBuilder {
        private final double x1;
        private final double y1;

        private LinearTransformationBuilder(double d2, double d3) {
            this.x1 = d2;
            this.y1 = d3;
        }

        public LinearTransformation and(double d2, double d3) {
            boolean bl = DoubleUtils.isFinite(d2);
            boolean bl2 = true;
            bl = bl && DoubleUtils.isFinite(d3);
            Preconditions.checkArgument(bl);
            double d4 = this.x1;
            if (d2 == d4) {
                bl = d3 != this.y1 ? bl2 : false;
                Preconditions.checkArgument(bl);
                return new VerticalLinearTransformation(this.x1);
            }
            return this.withSlope((d3 - this.y1) / (d2 - d4));
        }

        public LinearTransformation withSlope(double d2) {
            Preconditions.checkArgument(Double.isNaN(d2) ^ true);
            if (DoubleUtils.isFinite(d2)) {
                return new RegularLinearTransformation(d2, this.y1 - this.x1 * d2);
            }
            return new VerticalLinearTransformation(this.x1);
        }
    }

    private static final class NaNLinearTransformation
    extends LinearTransformation {
        static final NaNLinearTransformation INSTANCE = new NaNLinearTransformation();

        private NaNLinearTransformation() {
        }

        @Override
        public LinearTransformation inverse() {
            return this;
        }

        @Override
        public boolean isHorizontal() {
            return false;
        }

        @Override
        public boolean isVertical() {
            return false;
        }

        @Override
        public double slope() {
            return Double.NaN;
        }

        public String toString() {
            return "NaN";
        }

        @Override
        public double transform(double d2) {
            return Double.NaN;
        }
    }

    private static final class RegularLinearTransformation
    extends LinearTransformation {
        @LazyInit
        LinearTransformation inverse;
        final double slope;
        final double yIntercept;

        RegularLinearTransformation(double d2, double d3) {
            this.slope = d2;
            this.yIntercept = d3;
            this.inverse = null;
        }

        RegularLinearTransformation(double d2, double d3, LinearTransformation linearTransformation) {
            this.slope = d2;
            this.yIntercept = d3;
            this.inverse = linearTransformation;
        }

        private LinearTransformation createInverse() {
            double d2 = this.slope;
            if (d2 != 0.0) {
                return new RegularLinearTransformation(1.0 / d2, this.yIntercept * -1.0 / d2, this);
            }
            return new VerticalLinearTransformation(this.yIntercept, this);
        }

        @Override
        public LinearTransformation inverse() {
            LinearTransformation linearTransformation;
            LinearTransformation linearTransformation2 = linearTransformation = this.inverse;
            if (linearTransformation == null) {
                this.inverse = linearTransformation2 = this.createInverse();
            }
            return linearTransformation2;
        }

        @Override
        public boolean isHorizontal() {
            boolean bl = this.slope == 0.0;
            return bl;
        }

        @Override
        public boolean isVertical() {
            return false;
        }

        @Override
        public double slope() {
            return this.slope;
        }

        public String toString() {
            return String.format("y = %g * x + %g", this.slope, this.yIntercept);
        }

        @Override
        public double transform(double d2) {
            return d2 * this.slope + this.yIntercept;
        }
    }

    private static final class VerticalLinearTransformation
    extends LinearTransformation {
        @LazyInit
        LinearTransformation inverse;
        final double x;

        VerticalLinearTransformation(double d2) {
            this.x = d2;
            this.inverse = null;
        }

        VerticalLinearTransformation(double d2, LinearTransformation linearTransformation) {
            this.x = d2;
            this.inverse = linearTransformation;
        }

        private LinearTransformation createInverse() {
            return new RegularLinearTransformation(0.0, this.x, this);
        }

        @Override
        public LinearTransformation inverse() {
            LinearTransformation linearTransformation;
            LinearTransformation linearTransformation2 = linearTransformation = this.inverse;
            if (linearTransformation == null) {
                this.inverse = linearTransformation2 = this.createInverse();
            }
            return linearTransformation2;
        }

        @Override
        public boolean isHorizontal() {
            return false;
        }

        @Override
        public boolean isVertical() {
            return true;
        }

        @Override
        public double slope() {
            throw new IllegalStateException();
        }

        public String toString() {
            return String.format("x = %g", this.x);
        }

        @Override
        public double transform(double d2) {
            throw new IllegalStateException();
        }
    }
}

