/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.base.Preconditions;
import java.math.BigInteger;

final class DoubleUtils {
    static final int EXPONENT_BIAS = 1023;
    static final long EXPONENT_MASK = 0x7FF0000000000000L;
    static final long IMPLICIT_BIT = 0x10000000000000L;
    static final long ONE_BITS = 0x3FF0000000000000L;
    static final int SIGNIFICAND_BITS = 52;
    static final long SIGNIFICAND_MASK = 0xFFFFFFFFFFFFFL;
    static final long SIGN_MASK = Long.MIN_VALUE;

    private DoubleUtils() {
    }

    /*
     * Exception decompiling
     */
    static double bigToDouble(BigInteger var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static double ensureNonNegative(double d2) {
        Preconditions.checkArgument(Double.isNaN(d2) ^ true);
        if (d2 > 0.0) {
            return d2;
        }
        return 0.0;
    }

    static long getSignificand(double d2) {
        Preconditions.checkArgument(DoubleUtils.isFinite(d2), "not a normal value");
        int n2 = Math.getExponent(d2);
        long l2 = Double.doubleToRawLongBits(d2) & 0xFFFFFFFFFFFFFL;
        l2 = n2 == -1023 ? (l2 <<= 1) : (l2 |= 0x10000000000000L);
        return l2;
    }

    static boolean isFinite(double d2) {
        boolean bl = Math.getExponent(d2) <= 1023;
        return bl;
    }

    static boolean isNormal(double d2) {
        boolean bl = Math.getExponent(d2) >= -1022;
        return bl;
    }

    static double nextDown(double d2) {
        return -Math.nextUp(-d2);
    }

    static double scaleNormalize(double d2) {
        return Double.longBitsToDouble(Double.doubleToRawLongBits(d2) & 0xFFFFFFFFFFFFFL | 0x3FF0000000000000L);
    }
}

