/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.Preconditions;
import com.google.common.io.CharSource;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

class MultiReader
extends Reader {
    @NullableDecl
    private Reader current;
    private final Iterator<? extends CharSource> it;

    MultiReader(Iterator<? extends CharSource> iterator2) throws IOException {
        this.it = iterator2;
        this.advance();
    }

    private void advance() throws IOException {
        this.close();
        if (this.it.hasNext()) {
            this.current = this.it.next().openStream();
        }
    }

    @Override
    public void close() throws IOException {
        Reader reader = this.current;
        if (reader != null) {
            try {
                reader.close();
            }
            finally {
                this.current = null;
            }
        }
    }

    @Override
    public int read(@NullableDecl char[] cArray, int n2, int n3) throws IOException {
        Reader reader = this.current;
        if (reader == null) {
            return -1;
        }
        int n4 = reader.read(cArray, n2, n3);
        if (n4 == -1) {
            this.advance();
            return this.read(cArray, n2, n3);
        }
        return n4;
    }

    @Override
    public boolean ready() throws IOException {
        Reader reader = this.current;
        boolean bl = reader != null && reader.ready();
        return bl;
    }

    @Override
    public long skip(long l2) throws IOException {
        boolean bl = l2 >= 0L;
        Preconditions.checkArgument(bl, "n is negative");
        if (l2 > 0L) {
            Reader reader;
            while ((reader = this.current) != null) {
                long l3 = reader.skip(l2);
                if (l3 > 0L) {
                    return l3;
                }
                this.advance();
            }
        }
        return 0L;
    }
}

