/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

final class MultiInputStream
extends InputStream {
    @NullableDecl
    private InputStream in;
    private Iterator<? extends ByteSource> it;

    public MultiInputStream(Iterator<? extends ByteSource> iterator2) throws IOException {
        this.it = Preconditions.checkNotNull(iterator2);
        this.advance();
    }

    private void advance() throws IOException {
        this.close();
        if (this.it.hasNext()) {
            this.in = this.it.next().openStream();
        }
    }

    @Override
    public int available() throws IOException {
        InputStream inputStream = this.in;
        if (inputStream == null) {
            return 0;
        }
        return inputStream.available();
    }

    @Override
    public void close() throws IOException {
        InputStream inputStream = this.in;
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            finally {
                this.in = null;
            }
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        InputStream inputStream;
        while ((inputStream = this.in) != null) {
            int n2 = inputStream.read();
            if (n2 != -1) {
                return n2;
            }
            this.advance();
        }
        return -1;
    }

    @Override
    public int read(@NullableDecl byte[] byArray, int n2, int n3) throws IOException {
        InputStream inputStream;
        while ((inputStream = this.in) != null) {
            int n4 = inputStream.read(byArray, n2, n3);
            if (n4 != -1) {
                return n4;
            }
            this.advance();
        }
        return -1;
    }

    @Override
    public long skip(long l2) throws IOException {
        InputStream inputStream = this.in;
        if (inputStream != null && l2 > 0L) {
            long l3 = inputStream.skip(l2);
            if (l3 != 0L) {
                return l3;
            }
            if (this.read() == -1) {
                return 0L;
            }
            return this.in.skip(l2 - 1L) + 1L;
        }
        return 0L;
    }
}

