/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.Preconditions;
import com.google.common.io.CharStreams;
import com.google.common.io.LineBuffer;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.LinkedList;
import java.util.Queue;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class LineReader {
    private final char[] buf;
    private final CharBuffer cbuf = CharStreams.createBuffer();
    private final LineBuffer lineBuf;
    private final Queue<String> lines;
    private final Readable readable;
    @NullableDecl
    private final Reader reader;

    public LineReader(Readable readable) {
        this.buf = this.cbuf.array();
        this.lines = new LinkedList<String>();
        this.lineBuf = new LineBuffer(){

            protected void handleLine(String string2, String string3) {
                LineReader.this.lines.add(string2);
            }
        };
        this.readable = Preconditions.checkNotNull(readable);
        readable = readable instanceof Reader ? (Reader)readable : null;
        this.reader = readable;
    }

    public String readLine() throws IOException {
        while (this.lines.peek() == null) {
            int n2;
            this.cbuf.clear();
            Reader reader = this.reader;
            if (reader != null) {
                char[] cArray = this.buf;
                n2 = reader.read(cArray, 0, cArray.length);
            } else {
                n2 = this.readable.read(this.cbuf);
            }
            if (n2 == -1) {
                this.lineBuf.finish();
                break;
            }
            this.lineBuf.add(this.buf, 0, n2);
        }
        return this.lines.poll();
    }
}

