/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.TreeTraverser;
import com.google.common.graph.SuccessorsFunction;
import com.google.common.graph.Traverser;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.io.ByteProcessor;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.common.io.Closer;
import com.google.common.io.FileWriteMode;
import com.google.common.io.LineProcessor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class Files {
    private static final SuccessorsFunction<File> FILE_TREE;
    private static final TreeTraverser<File> FILE_TREE_TRAVERSER;
    private static final int TEMP_DIR_ATTEMPTS = 10000;

    static {
        FILE_TREE_TRAVERSER = new TreeTraverser<File>(){

            public Iterable<File> children(File file) {
                return Files.fileTreeChildren(file);
            }

            public String toString() {
                return "Files.fileTreeTraverser()";
            }
        };
        FILE_TREE = new SuccessorsFunction<File>(){

            @Override
            public Iterable<File> successors(File file) {
                return Files.fileTreeChildren(file);
            }
        };
    }

    private Files() {
    }

    @Deprecated
    public static void append(CharSequence charSequence, File file, Charset charset) throws IOException {
        Files.asCharSink(file, charset, FileWriteMode.APPEND).write(charSequence);
    }

    public static ByteSink asByteSink(File file, FileWriteMode ... fileWriteModeArray) {
        return new FileByteSink(file, fileWriteModeArray);
    }

    public static ByteSource asByteSource(File file) {
        return new FileByteSource(file);
    }

    public static CharSink asCharSink(File file, Charset charset, FileWriteMode ... fileWriteModeArray) {
        return Files.asByteSink(file, fileWriteModeArray).asCharSink(charset);
    }

    public static CharSource asCharSource(File file, Charset charset) {
        return Files.asByteSource(file).asCharSource(charset);
    }

    public static void copy(File file, File file2) throws IOException {
        Preconditions.checkArgument(file.equals(file2) ^ true, "Source %s and destination %s must be different", (Object)file, (Object)file2);
        Files.asByteSource(file).copyTo(Files.asByteSink(file2, new FileWriteMode[0]));
    }

    public static void copy(File file, OutputStream outputStream) throws IOException {
        Files.asByteSource(file).copyTo(outputStream);
    }

    @Deprecated
    public static void copy(File file, Charset charset, Appendable appendable) throws IOException {
        Files.asCharSource(file, charset).copyTo(appendable);
    }

    public static void createParentDirs(File file) throws IOException {
        Preconditions.checkNotNull(file);
        Comparable<File> comparable = file.getCanonicalFile().getParentFile();
        if (comparable == null) {
            return;
        }
        ((File)comparable).mkdirs();
        if (((File)comparable).isDirectory()) {
            return;
        }
        comparable = new StringBuilder();
        ((StringBuilder)comparable).append("Unable to create parent directories of ");
        ((StringBuilder)comparable).append(file);
        throw new IOException(((StringBuilder)comparable).toString());
    }

    public static File createTempDir() {
        Serializable serializable = new File(System.getProperty("java.io.tmpdir"));
        CharSequence charSequence = new StringBuilder();
        charSequence.append(System.currentTimeMillis());
        charSequence.append("-");
        charSequence = charSequence.toString();
        for (int i2 = 0; i2 < 10000; ++i2) {
            Comparable<StringBuilder> comparable = new StringBuilder();
            ((StringBuilder)comparable).append((String)charSequence);
            ((StringBuilder)comparable).append(i2);
            comparable = new File((File)serializable, ((StringBuilder)comparable).toString());
            if (!((File)comparable).mkdir()) continue;
            return comparable;
        }
        serializable = new StringBuilder();
        ((StringBuilder)serializable).append("Failed to create directory within 10000 attempts (tried ");
        ((StringBuilder)serializable).append((String)charSequence);
        ((StringBuilder)serializable).append("0 to ");
        ((StringBuilder)serializable).append((String)charSequence);
        ((StringBuilder)serializable).append(9999);
        ((StringBuilder)serializable).append(')');
        serializable = new IllegalStateException(((StringBuilder)serializable).toString());
        throw serializable;
    }

    public static boolean equal(File file, File file2) throws IOException {
        Preconditions.checkNotNull(file);
        Preconditions.checkNotNull(file2);
        if (file != file2 && !file.equals(file2)) {
            long l2 = file.length();
            long l3 = file2.length();
            if (l2 != 0L && l3 != 0L && l2 != l3) {
                return false;
            }
            return Files.asByteSource(file).contentEquals(Files.asByteSource(file2));
        }
        return true;
    }

    public static Traverser<File> fileTraverser() {
        return Traverser.forTree(FILE_TREE);
    }

    private static Iterable<File> fileTreeChildren(File fileArray) {
        if (fileArray.isDirectory() && (fileArray = fileArray.listFiles()) != null) {
            return Collections.unmodifiableList(Arrays.asList(fileArray));
        }
        return Collections.emptyList();
    }

    @Deprecated
    static TreeTraverser<File> fileTreeTraverser() {
        return FILE_TREE_TRAVERSER;
    }

    public static String getFileExtension(String string2) {
        Preconditions.checkNotNull(string2);
        string2 = new File(string2).getName();
        int n2 = string2.lastIndexOf(46);
        string2 = n2 == -1 ? "" : string2.substring(n2 + 1);
        return string2;
    }

    public static String getNameWithoutExtension(String string2) {
        Preconditions.checkNotNull(string2);
        string2 = new File(string2).getName();
        int n2 = string2.lastIndexOf(46);
        if (n2 != -1) {
            string2 = string2.substring(0, n2);
        }
        return string2;
    }

    @Deprecated
    public static HashCode hash(File file, HashFunction hashFunction) throws IOException {
        return Files.asByteSource(file).hash(hashFunction);
    }

    public static Predicate<File> isDirectory() {
        return FilePredicate.IS_DIRECTORY;
    }

    public static Predicate<File> isFile() {
        return FilePredicate.IS_FILE;
    }

    public static MappedByteBuffer map(File file) throws IOException {
        Preconditions.checkNotNull(file);
        return Files.map(file, FileChannel.MapMode.READ_ONLY);
    }

    public static MappedByteBuffer map(File file, FileChannel.MapMode mapMode) throws IOException {
        return Files.mapInternal(file, mapMode, -1L);
    }

    public static MappedByteBuffer map(File file, FileChannel.MapMode mapMode, long l2) throws IOException {
        boolean bl = l2 >= 0L;
        Preconditions.checkArgument(bl, "size (%s) may not be negative", l2);
        return Files.mapInternal(file, mapMode, l2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static MappedByteBuffer mapInternal(File object, FileChannel.MapMode mapMode, long l2) throws IOException {
        Preconditions.checkNotNull(object);
        Preconditions.checkNotNull(mapMode);
        Closer closer = Closer.create();
        try {
            String string2 = mapMode == FileChannel.MapMode.READ_ONLY ? "r" : "rw";
            RandomAccessFile randomAccessFile = new RandomAccessFile((File)object, string2);
            object = closer.register(closer.register(randomAccessFile).getChannel());
            long l3 = l2;
            if (l2 == -1L) {
                l3 = ((FileChannel)object).size();
            }
            object = ((FileChannel)object).map(mapMode, 0L, l3);
        }
        catch (Throwable throwable) {
            try {
                throw closer.rethrow(throwable);
            }
            catch (Throwable throwable2) {
                closer.close();
                throw throwable2;
            }
        }
        closer.close();
        return object;
    }

    public static void move(File comparable, File comparable2) throws IOException {
        Preconditions.checkNotNull(comparable);
        Preconditions.checkNotNull(comparable2);
        Preconditions.checkArgument(((File)comparable).equals(comparable2) ^ true, "Source %s and destination %s must be different", (Object)comparable, (Object)comparable2);
        if (!((File)comparable).renameTo((File)comparable2)) {
            Files.copy((File)comparable, (File)comparable2);
            if (!((File)comparable).delete()) {
                if (!((File)comparable2).delete()) {
                    comparable = new StringBuilder();
                    ((StringBuilder)comparable).append("Unable to delete ");
                    ((StringBuilder)comparable).append(comparable2);
                    throw new IOException(((StringBuilder)comparable).toString());
                }
                comparable2 = new StringBuilder();
                ((StringBuilder)comparable2).append("Unable to delete ");
                ((StringBuilder)comparable2).append(comparable);
                throw new IOException(((StringBuilder)comparable2).toString());
            }
        }
    }

    public static BufferedReader newReader(File file, Charset charset) throws FileNotFoundException {
        Preconditions.checkNotNull(file);
        Preconditions.checkNotNull(charset);
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));
    }

    public static BufferedWriter newWriter(File file, Charset charset) throws FileNotFoundException {
        Preconditions.checkNotNull(file);
        Preconditions.checkNotNull(charset);
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset));
    }

    @Deprecated
    public static <T> T readBytes(File file, ByteProcessor<T> byteProcessor) throws IOException {
        return (T)Files.asByteSource(file).read(byteProcessor);
    }

    @Deprecated
    public static String readFirstLine(File file, Charset charset) throws IOException {
        return Files.asCharSource(file, charset).readFirstLine();
    }

    @Deprecated
    public static <T> T readLines(File file, Charset charset, LineProcessor<T> lineProcessor) throws IOException {
        return Files.asCharSource(file, charset).readLines(lineProcessor);
    }

    public static List<String> readLines(File file, Charset charset) throws IOException {
        return Files.asCharSource(file, charset).readLines(new LineProcessor<List<String>>(){
            final List<String> result = Lists.newArrayList();

            public List<String> getResult() {
                return this.result;
            }

            public boolean processLine(String string2) {
                this.result.add(string2);
                return true;
            }
        });
    }

    public static String simplifyPath(String object) {
        Preconditions.checkNotNull(object);
        if (((String)object).length() == 0) {
            return ".";
        }
        Object object2 = Splitter.on('/').omitEmptyStrings().split((CharSequence)object);
        Object object3 = new ArrayList();
        object2 = object2.iterator();
        while (true) {
            String string2;
            int n2;
            block15: {
                block14: {
                    block13: {
                        boolean bl = object2.hasNext();
                        n2 = 0;
                        if (!bl) break;
                        string2 = (String)object2.next();
                        int n3 = string2.hashCode();
                        if (n3 == 46) break block13;
                        if (n3 != 1472 || !string2.equals("..")) break block14;
                        n2 = 1;
                        break block15;
                    }
                    if (string2.equals(".")) break block15;
                }
                n2 = -1;
            }
            if (n2 == 0) continue;
            if (n2 != 1) {
                object3.add(string2);
                continue;
            }
            if (object3.size() > 0 && !((String)object3.get(object3.size() - 1)).equals("..")) {
                object3.remove(object3.size() - 1);
                continue;
            }
            object3.add("..");
        }
        object3 = Joiner.on('/').join((Iterable<?>)object3);
        if (((String)object).charAt(0) == '/') {
            object = new StringBuilder();
            ((StringBuilder)object).append("/");
            ((StringBuilder)object).append((String)object3);
            object = ((StringBuilder)object).toString();
        } else {
            object = object3;
        }
        while (((String)object).startsWith("/../")) {
            object = ((String)object).substring(3);
        }
        if (((String)object).equals("/..")) {
            object3 = "/";
        } else {
            object3 = object;
            if ("".equals(object)) {
                object3 = ".";
            }
        }
        return object3;
    }

    public static byte[] toByteArray(File file) throws IOException {
        return Files.asByteSource(file).read();
    }

    @Deprecated
    public static String toString(File file, Charset charset) throws IOException {
        return Files.asCharSource(file, charset).read();
    }

    public static void touch(File file) throws IOException {
        Preconditions.checkNotNull(file);
        if (!file.createNewFile() && !file.setLastModified(System.currentTimeMillis())) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Unable to update modification time of ");
            stringBuilder.append(file);
            throw new IOException(stringBuilder.toString());
        }
    }

    @Deprecated
    public static void write(CharSequence charSequence, File file, Charset charset) throws IOException {
        Files.asCharSink(file, charset, new FileWriteMode[0]).write(charSequence);
    }

    public static void write(byte[] byArray, File file) throws IOException {
        Files.asByteSink(file, new FileWriteMode[0]).write(byArray);
    }

    private static final class FileByteSink
    extends ByteSink {
        private final File file;
        private final ImmutableSet<FileWriteMode> modes;

        private FileByteSink(File file, FileWriteMode ... fileWriteModeArray) {
            this.file = Preconditions.checkNotNull(file);
            this.modes = ImmutableSet.copyOf(fileWriteModeArray);
        }

        @Override
        public FileOutputStream openStream() throws IOException {
            return new FileOutputStream(this.file, this.modes.contains(FileWriteMode.APPEND));
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Files.asByteSink(");
            stringBuilder.append(this.file);
            stringBuilder.append(", ");
            stringBuilder.append(this.modes);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }

    private static final class FileByteSource
    extends ByteSource {
        private final File file;

        private FileByteSource(File file) {
            this.file = Preconditions.checkNotNull(file);
        }

        public FileInputStream openStream() throws IOException {
            return new FileInputStream(this.file);
        }

        public byte[] read() throws IOException {
            Object object;
            Closer closer = Closer.create();
            try {
                object = closer.register(this.openStream());
                object = ByteStreams.toByteArray((InputStream)object, (long)((FileInputStream)object).getChannel().size());
            }
            catch (Throwable throwable) {
                try {
                    throw closer.rethrow(throwable);
                }
                catch (Throwable throwable2) {
                    closer.close();
                    throw throwable2;
                }
            }
            closer.close();
            return object;
        }

        public long size() throws IOException {
            if (this.file.isFile()) {
                return this.file.length();
            }
            throw new FileNotFoundException(this.file.toString());
        }

        public Optional<Long> sizeIfKnown() {
            if (this.file.isFile()) {
                return Optional.of(this.file.length());
            }
            return Optional.absent();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Files.asByteSource(");
            stringBuilder.append(this.file);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }

    private static enum FilePredicate implements Predicate<File>
    {
        IS_DIRECTORY{

            @Override
            public boolean apply(File file) {
                return file.isDirectory();
            }

            public String toString() {
                return "Files.isDirectory()";
            }
        }
        ,
        IS_FILE{

            @Override
            public boolean apply(File file) {
                return file.isFile();
            }

            public String toString() {
                return "Files.isFile()";
            }
        };

    }
}

