/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.io.ByteSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class FileBackedOutputStream
extends OutputStream {
    @NullableDecl
    private File file;
    private final int fileThreshold;
    private MemoryOutput memory;
    private OutputStream out;
    private final boolean resetOnFinalize;
    private final ByteSource source;

    public FileBackedOutputStream(int n2) {
        this(n2, false);
    }

    public FileBackedOutputStream(int n2, boolean bl) {
        this.fileThreshold = n2;
        this.resetOnFinalize = bl;
        this.memory = new MemoryOutput();
        this.out = this.memory;
        this.source = bl ? new ByteSource(){

            protected void finalize() {
                try {
                    FileBackedOutputStream.this.reset();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.err);
                }
            }

            public InputStream openStream() throws IOException {
                return FileBackedOutputStream.this.openInputStream();
            }
        } : new ByteSource(){

            public InputStream openStream() throws IOException {
                return FileBackedOutputStream.this.openInputStream();
            }
        };
    }

    private InputStream openInputStream() throws IOException {
        synchronized (this) {
            block4: {
                if (this.file == null) break block4;
                FileInputStream fileInputStream = new FileInputStream(this.file);
                return fileInputStream;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.memory.getBuffer(), 0, this.memory.getCount());
            return byteArrayInputStream;
        }
    }

    private void update(int n2) throws IOException {
        if (this.file == null && this.memory.getCount() + n2 > this.fileThreshold) {
            File file = File.createTempFile("FileBackedOutputStream", null);
            if (this.resetOnFinalize) {
                file.deleteOnExit();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(this.memory.getBuffer(), 0, this.memory.getCount());
            fileOutputStream.flush();
            this.out = fileOutputStream;
            this.file = file;
            this.memory = null;
        }
    }

    public ByteSource asByteSource() {
        return this.source;
    }

    @Override
    public void close() throws IOException {
        synchronized (this) {
            this.out.close();
            return;
        }
    }

    @Override
    public void flush() throws IOException {
        synchronized (this) {
            this.out.flush();
            return;
        }
    }

    File getFile() {
        synchronized (this) {
            File file = this.file;
            return file;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reset() throws IOException {
        synchronized (this) {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                Object object;
                if (this.memory == null) {
                    object = new MemoryOutput();
                    this.memory = object;
                } else {
                    this.memory.reset();
                }
                this.out = this.memory;
                if (this.file != null) {
                    object = this.file;
                    this.file = null;
                    if (!((File)object).delete()) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("Could not delete: ");
                        stringBuilder.append(object);
                        IOException iOException = new IOException(stringBuilder.toString());
                        throw iOException;
                    }
                }
                throw throwable;
            }
            try {
                Object object;
                if (this.memory == null) {
                    object = new MemoryOutput();
                    this.memory = object;
                } else {
                    this.memory.reset();
                }
                this.out = this.memory;
                if (this.file != null) {
                    File file = this.file;
                    this.file = null;
                    if (!file.delete()) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("Could not delete: ");
                        stringBuilder.append(file);
                        object = new IOException(stringBuilder.toString());
                        throw object;
                    }
                }
                return;
            }
            catch (Throwable throwable) {}
            throw throwable;
        }
    }

    @Override
    public void write(int n2) throws IOException {
        synchronized (this) {
            this.update(1);
            this.out.write(n2);
            return;
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        synchronized (this) {
            this.write(byArray, 0, byArray.length);
            return;
        }
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        synchronized (this) {
            this.update(n3);
            this.out.write(byArray, n2, n3);
            return;
        }
    }

    private static class MemoryOutput
    extends ByteArrayOutputStream {
        private MemoryOutput() {
        }

        byte[] getBuffer() {
            return this.buf;
        }

        int getCount() {
            return this.count;
        }
    }
}

