/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Closeables {
    static final Logger logger = Logger.getLogger(Closeables.class.getName());

    private Closeables() {
    }

    public static void close(@NullableDecl Closeable closeable, boolean bl) throws IOException {
        IOException iOException2;
        block3: {
            if (closeable == null) {
                return;
            }
            try {
                closeable.close();
            }
            catch (IOException iOException2) {
                if (!bl) break block3;
                logger.log(Level.WARNING, "IOException thrown while closing Closeable.", iOException2);
            }
            return;
        }
        throw iOException2;
    }

    public static void closeQuietly(@NullableDecl InputStream inputStream) {
        try {
            Closeables.close(inputStream, true);
            return;
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public static void closeQuietly(@NullableDecl Reader reader) {
        try {
            Closeables.close(reader, true);
            return;
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }
}

