/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.Ascii;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSequenceReader;
import com.google.common.io.CharSink;
import com.google.common.io.CharStreams;
import com.google.common.io.Closer;
import com.google.common.io.LineProcessor;
import com.google.common.io.MultiReader;
import com.google.common.io.ReaderInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class CharSource {
    protected CharSource() {
    }

    public static CharSource concat(Iterable<? extends CharSource> iterable) {
        return new ConcatenatedCharSource(iterable);
    }

    public static CharSource concat(Iterator<? extends CharSource> iterator2) {
        return CharSource.concat(ImmutableList.copyOf(iterator2));
    }

    public static CharSource concat(CharSource ... charSourceArray) {
        return CharSource.concat(ImmutableList.copyOf(charSourceArray));
    }

    private long countBySkipping(Reader reader) throws IOException {
        long l2;
        long l3 = 0L;
        while ((l2 = reader.skip(Long.MAX_VALUE)) != 0L) {
            l3 += l2;
        }
        return l3;
    }

    public static CharSource empty() {
        return EmptyCharSource.INSTANCE;
    }

    public static CharSource wrap(CharSequence object) {
        object = object instanceof String ? new StringCharSource((String)object) : new CharSequenceCharSource((CharSequence)object);
        return object;
    }

    public ByteSource asByteSource(Charset charset) {
        return new AsByteSource(charset);
    }

    public long copyTo(CharSink charSink) throws IOException {
        long l2;
        Preconditions.checkNotNull(charSink);
        Closer closer = Closer.create();
        try {
            l2 = CharStreams.copy((Readable)closer.register(this.openStream()), (Appendable)closer.register(charSink.openStream()));
        }
        catch (Throwable throwable) {
            try {
                throw closer.rethrow(throwable);
            }
            catch (Throwable throwable2) {
                closer.close();
                throw throwable2;
            }
        }
        closer.close();
        return l2;
    }

    public long copyTo(Appendable appendable) throws IOException {
        long l2;
        Preconditions.checkNotNull(appendable);
        Closer closer = Closer.create();
        try {
            l2 = CharStreams.copy((Readable)closer.register(this.openStream()), (Appendable)appendable);
        }
        catch (Throwable throwable) {
            try {
                throw closer.rethrow(throwable);
            }
            catch (Throwable throwable2) {
                closer.close();
                throw throwable2;
            }
        }
        closer.close();
        return l2;
    }

    public boolean isEmpty() throws IOException {
        Object object = this.lengthIfKnown();
        boolean bl = ((Optional)object).isPresent();
        boolean bl2 = true;
        boolean bl3 = true;
        if (bl) {
            if (((Optional)object).get() != 0L) {
                bl3 = false;
            }
            return bl3;
        }
        object = Closer.create();
        try {
            int n2 = ((Closer)object).register(this.openStream()).read();
            bl3 = n2 == -1 ? bl2 : false;
        }
        catch (Throwable throwable) {
            try {
                throw ((Closer)object).rethrow(throwable);
            }
            catch (Throwable throwable2) {
                ((Closer)object).close();
                throw throwable2;
            }
        }
        ((Closer)object).close();
        return bl3;
    }

    public long length() throws IOException {
        long l2;
        Optional<Long> optional = this.lengthIfKnown();
        if (optional.isPresent()) {
            return optional.get();
        }
        optional = Closer.create();
        try {
            l2 = this.countBySkipping(((Closer)((Object)optional)).register(this.openStream()));
        }
        catch (Throwable throwable) {
            try {
                throw ((Closer)((Object)optional)).rethrow(throwable);
            }
            catch (Throwable throwable2) {
                ((Closer)((Object)optional)).close();
                throw throwable2;
            }
        }
        ((Closer)((Object)optional)).close();
        return l2;
    }

    public Optional<Long> lengthIfKnown() {
        return Optional.absent();
    }

    public BufferedReader openBufferedStream() throws IOException {
        Reader reader = this.openStream();
        reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        return reader;
    }

    public abstract Reader openStream() throws IOException;

    public String read() throws IOException {
        String string2;
        Closer closer = Closer.create();
        try {
            string2 = CharStreams.toString((Readable)closer.register(this.openStream()));
        }
        catch (Throwable throwable) {
            try {
                throw closer.rethrow(throwable);
            }
            catch (Throwable throwable2) {
                closer.close();
                throw throwable2;
            }
        }
        closer.close();
        return string2;
    }

    @NullableDecl
    public String readFirstLine() throws IOException {
        String string2;
        Closer closer = Closer.create();
        try {
            string2 = closer.register(this.openBufferedStream()).readLine();
        }
        catch (Throwable throwable) {
            try {
                throw closer.rethrow(throwable);
            }
            catch (Throwable throwable2) {
                closer.close();
                throw throwable2;
            }
        }
        closer.close();
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ImmutableList<String> readLines() throws IOException {
        Object object;
        Closer closer = Closer.create();
        try {
            BufferedReader bufferedReader = closer.register(this.openBufferedStream());
            ArrayList<String> arrayList = Lists.newArrayList();
            while ((object = bufferedReader.readLine()) != null) {
                arrayList.add((String)object);
            }
            object = ImmutableList.copyOf(arrayList);
        }
        catch (Throwable throwable) {
            try {
                throw closer.rethrow(throwable);
            }
            catch (Throwable throwable2) {
                closer.close();
                throw throwable2;
            }
        }
        closer.close();
        return object;
    }

    public <T> T readLines(LineProcessor<T> object) throws IOException {
        Preconditions.checkNotNull(object);
        Closer closer = Closer.create();
        try {
            object = CharStreams.readLines((Readable)closer.register(this.openStream()), object);
        }
        catch (Throwable throwable) {
            try {
                throw closer.rethrow(throwable);
            }
            catch (Throwable throwable2) {
                closer.close();
                throw throwable2;
            }
        }
        closer.close();
        return (T)object;
    }

    private final class AsByteSource
    extends ByteSource {
        final Charset charset;

        AsByteSource(Charset charset) {
            this.charset = Preconditions.checkNotNull(charset);
        }

        public CharSource asCharSource(Charset charset) {
            if (charset.equals(this.charset)) {
                return CharSource.this;
            }
            return super.asCharSource(charset);
        }

        public InputStream openStream() throws IOException {
            return new ReaderInputStream(CharSource.this.openStream(), this.charset, 8192);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(CharSource.this.toString());
            stringBuilder.append(".asByteSource(");
            stringBuilder.append(this.charset);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }

    private static class CharSequenceCharSource
    extends CharSource {
        private static final Splitter LINE_SPLITTER = Splitter.onPattern("\r\n|\n|\r");
        protected final CharSequence seq;

        protected CharSequenceCharSource(CharSequence charSequence) {
            this.seq = Preconditions.checkNotNull(charSequence);
        }

        private Iterator<String> linesIterator() {
            return new AbstractIterator<String>(){
                Iterator<String> lines;
                {
                    this.lines = LINE_SPLITTER.split(CharSequenceCharSource.this.seq).iterator();
                }

                @Override
                protected String computeNext() {
                    if (this.lines.hasNext()) {
                        String string2 = this.lines.next();
                        if (this.lines.hasNext() || !string2.isEmpty()) {
                            return string2;
                        }
                    }
                    return (String)this.endOfData();
                }
            };
        }

        @Override
        public boolean isEmpty() {
            boolean bl = this.seq.length() == 0;
            return bl;
        }

        @Override
        public long length() {
            return this.seq.length();
        }

        @Override
        public Optional<Long> lengthIfKnown() {
            return Optional.of(Long.valueOf(this.seq.length()));
        }

        @Override
        public Reader openStream() {
            return new CharSequenceReader(this.seq);
        }

        @Override
        public String read() {
            return this.seq.toString();
        }

        @Override
        public String readFirstLine() {
            Iterator<String> iterator2 = this.linesIterator();
            iterator2 = iterator2.hasNext() ? iterator2.next() : null;
            return iterator2;
        }

        @Override
        public ImmutableList<String> readLines() {
            return ImmutableList.copyOf(this.linesIterator());
        }

        @Override
        public <T> T readLines(LineProcessor<T> lineProcessor) throws IOException {
            Iterator<String> iterator2 = this.linesIterator();
            while (iterator2.hasNext() && lineProcessor.processLine(iterator2.next())) {
            }
            return (T)lineProcessor.getResult();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("CharSource.wrap(");
            stringBuilder.append(Ascii.truncate((CharSequence)this.seq, (int)30, (String)"..."));
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }

    private static final class ConcatenatedCharSource
    extends CharSource {
        private final Iterable<? extends CharSource> sources;

        ConcatenatedCharSource(Iterable<? extends CharSource> iterable) {
            this.sources = Preconditions.checkNotNull(iterable);
        }

        @Override
        public boolean isEmpty() throws IOException {
            Iterator<? extends CharSource> iterator2 = this.sources.iterator();
            while (iterator2.hasNext()) {
                if (iterator2.next().isEmpty()) continue;
                return false;
            }
            return true;
        }

        @Override
        public long length() throws IOException {
            Iterator<? extends CharSource> iterator2 = this.sources.iterator();
            long l2 = 0L;
            while (iterator2.hasNext()) {
                l2 += iterator2.next().length();
            }
            return l2;
        }

        @Override
        public Optional<Long> lengthIfKnown() {
            Iterator<? extends CharSource> iterator2 = this.sources.iterator();
            long l2 = 0L;
            while (iterator2.hasNext()) {
                Optional<Long> optional = iterator2.next().lengthIfKnown();
                if (!optional.isPresent()) {
                    return Optional.absent();
                }
                l2 += optional.get().longValue();
            }
            return Optional.of(l2);
        }

        @Override
        public Reader openStream() throws IOException {
            return new MultiReader(this.sources.iterator());
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("CharSource.concat(");
            stringBuilder.append(this.sources);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }

    private static final class EmptyCharSource
    extends StringCharSource {
        private static final EmptyCharSource INSTANCE = new EmptyCharSource();

        private EmptyCharSource() {
            super("");
        }

        @Override
        public String toString() {
            return "CharSource.empty()";
        }
    }

    private static class StringCharSource
    extends CharSequenceCharSource {
        protected StringCharSource(String string2) {
            super(string2);
        }

        @Override
        public long copyTo(CharSink charSink) throws IOException {
            int n2;
            Preconditions.checkNotNull(charSink);
            Closer closer = Closer.create();
            try {
                closer.register(charSink.openStream()).write((String)this.seq);
                n2 = this.seq.length();
            }
            catch (Throwable throwable) {
                try {
                    throw closer.rethrow(throwable);
                }
                catch (Throwable throwable2) {
                    closer.close();
                    throw throwable2;
                }
            }
            long l2 = n2;
            closer.close();
            return l2;
        }

        @Override
        public long copyTo(Appendable appendable) throws IOException {
            appendable.append(this.seq);
            return this.seq.length();
        }

        @Override
        public Reader openStream() {
            return new StringReader((String)this.seq);
        }
    }
}

