/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharSink;
import com.google.common.io.Closer;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;

public abstract class ByteSink {
    protected ByteSink() {
    }

    public CharSink asCharSink(Charset charset) {
        return new AsCharSink(charset);
    }

    public OutputStream openBufferedStream() throws IOException {
        OutputStream outputStream = this.openStream();
        outputStream = outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream);
        return outputStream;
    }

    public abstract OutputStream openStream() throws IOException;

    public void write(byte[] byArray) throws IOException {
        Preconditions.checkNotNull(byArray);
        Closer closer = Closer.create();
        try {
            OutputStream outputStream = closer.register(this.openStream());
            outputStream.write(byArray);
            outputStream.flush();
        }
        catch (Throwable throwable) {
            try {
                throw closer.rethrow(throwable);
            }
            catch (Throwable throwable2) {
                closer.close();
                throw throwable2;
            }
        }
        closer.close();
    }

    public long writeFrom(InputStream inputStream) throws IOException {
        long l2;
        Preconditions.checkNotNull(inputStream);
        Closer closer = Closer.create();
        try {
            OutputStream outputStream = closer.register(this.openStream());
            l2 = ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
            outputStream.flush();
        }
        catch (Throwable throwable) {
            try {
                throw closer.rethrow(throwable);
            }
            catch (Throwable throwable2) {
                closer.close();
                throw throwable2;
            }
        }
        closer.close();
        return l2;
    }

    private final class AsCharSink
    extends CharSink {
        private final Charset charset;

        private AsCharSink(Charset charset) {
            this.charset = Preconditions.checkNotNull(charset);
        }

        public Writer openStream() throws IOException {
            return new OutputStreamWriter(ByteSink.this.openStream(), this.charset);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(ByteSink.this.toString());
            stringBuilder.append(".asCharSink(");
            stringBuilder.append(this.charset);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }
}

