/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.Ascii;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.common.math.IntMath;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.math.RoundingMode;
import java.util.Arrays;
import org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class BaseEncoding {
    private static final BaseEncoding BASE16;
    private static final BaseEncoding BASE32;
    private static final BaseEncoding BASE32_HEX;
    private static final BaseEncoding BASE64;
    private static final BaseEncoding BASE64_URL;

    static {
        Character c2 = Character.valueOf('=');
        BASE64 = new Base64Encoding("base64()", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/", c2);
        BASE64_URL = new Base64Encoding("base64Url()", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_", c2);
        BASE32 = new StandardBaseEncoding("base32()", "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567", c2);
        BASE32_HEX = new StandardBaseEncoding("base32Hex()", "0123456789ABCDEFGHIJKLMNOPQRSTUV", c2);
        BASE16 = new Base16Encoding("base16()", "0123456789ABCDEF");
    }

    BaseEncoding() {
    }

    public static BaseEncoding base16() {
        return BASE16;
    }

    public static BaseEncoding base32() {
        return BASE32;
    }

    public static BaseEncoding base32Hex() {
        return BASE32_HEX;
    }

    public static BaseEncoding base64() {
        return BASE64;
    }

    public static BaseEncoding base64Url() {
        return BASE64_URL;
    }

    private static byte[] extract(byte[] byArray, int n2) {
        if (n2 == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    static Reader ignoringReader(final Reader reader, final String string2) {
        Preconditions.checkNotNull(reader);
        Preconditions.checkNotNull(string2);
        return new Reader(){

            @Override
            public void close() throws IOException {
                reader.close();
            }

            @Override
            public int read() throws IOException {
                int n2;
                while ((n2 = reader.read()) != -1 && string2.indexOf((char)n2) >= 0) {
                }
                return n2;
            }

            @Override
            public int read(char[] cArray, int n2, int n3) throws IOException {
                throw new UnsupportedOperationException();
            }
        };
    }

    static Appendable separatingAppendable(final Appendable appendable, final String string2, final int n2) {
        Preconditions.checkNotNull(appendable);
        Preconditions.checkNotNull(string2);
        boolean bl = n2 > 0;
        Preconditions.checkArgument(bl);
        return new Appendable(){
            int charsUntilSeparator;
            {
                this.charsUntilSeparator = n2;
            }

            @Override
            public Appendable append(char c2) throws IOException {
                if (this.charsUntilSeparator == 0) {
                    appendable.append(string2);
                    this.charsUntilSeparator = n2;
                }
                appendable.append(c2);
                --this.charsUntilSeparator;
                return this;
            }

            @Override
            public Appendable append(@NullableDecl CharSequence charSequence) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public Appendable append(@NullableDecl CharSequence charSequence, int n22, int n3) throws IOException {
                throw new UnsupportedOperationException();
            }
        };
    }

    static Writer separatingWriter(Writer writer, String string2, int n2) {
        return new Writer(BaseEncoding.separatingAppendable(writer, string2, n2), writer){
            final /* synthetic */ Writer val$delegate;
            final /* synthetic */ Appendable val$seperatingAppendable;
            {
                this.val$seperatingAppendable = appendable;
                this.val$delegate = writer;
            }

            @Override
            public void close() throws IOException {
                this.val$delegate.close();
            }

            @Override
            public void flush() throws IOException {
                this.val$delegate.flush();
            }

            @Override
            public void write(int n2) throws IOException {
                this.val$seperatingAppendable.append((char)n2);
            }

            @Override
            public void write(char[] cArray, int n2, int n3) throws IOException {
                throw new UnsupportedOperationException();
            }
        };
    }

    public abstract boolean canDecode(CharSequence var1);

    public final byte[] decode(CharSequence object) {
        try {
            object = this.decodeChecked((CharSequence)object);
            return object;
        }
        catch (DecodingException decodingException) {
            throw new IllegalArgumentException(decodingException);
        }
    }

    final byte[] decodeChecked(CharSequence object) throws DecodingException {
        CharSequence charSequence = this.trimTrailingPadding((CharSequence)object);
        object = new byte[this.maxDecodedSize(charSequence.length())];
        return BaseEncoding.extract((byte[])object, this.decodeTo((byte[])object, charSequence));
    }

    abstract int decodeTo(byte[] var1, CharSequence var2) throws DecodingException;

    public final ByteSource decodingSource(final CharSource charSource) {
        Preconditions.checkNotNull(charSource);
        return new ByteSource(){

            public InputStream openStream() throws IOException {
                return BaseEncoding.this.decodingStream(charSource.openStream());
            }
        };
    }

    public abstract InputStream decodingStream(Reader var1);

    public String encode(byte[] byArray) {
        return this.encode(byArray, 0, byArray.length);
    }

    public final String encode(byte[] byArray, int n2, int n3) {
        Preconditions.checkPositionIndexes(n2, n2 + n3, byArray.length);
        StringBuilder stringBuilder = new StringBuilder(this.maxEncodedSize(n3));
        try {
            this.encodeTo(stringBuilder, byArray, n2, n3);
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    abstract void encodeTo(Appendable var1, byte[] var2, int var3, int var4) throws IOException;

    public final ByteSink encodingSink(final CharSink charSink) {
        Preconditions.checkNotNull(charSink);
        return new ByteSink(){

            @Override
            public OutputStream openStream() throws IOException {
                return BaseEncoding.this.encodingStream(charSink.openStream());
            }
        };
    }

    public abstract OutputStream encodingStream(Writer var1);

    public abstract BaseEncoding lowerCase();

    abstract int maxDecodedSize(int var1);

    abstract int maxEncodedSize(int var1);

    public abstract BaseEncoding omitPadding();

    CharSequence trimTrailingPadding(CharSequence charSequence) {
        return Preconditions.checkNotNull(charSequence);
    }

    public abstract BaseEncoding upperCase();

    public abstract BaseEncoding withPadChar(char var1);

    public abstract BaseEncoding withSeparator(String var1, int var2);

    private static final class Alphabet {
        final int bitsPerChar;
        final int bytesPerChunk;
        private final char[] chars;
        final int charsPerChunk;
        private final byte[] decodabet;
        final int mask;
        private final String name;
        private final boolean[] validPadding;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        Alphabet(String object, char[] cArray) {
            this.name = (String)Preconditions.checkNotNull(object);
            this.chars = Preconditions.checkNotNull(cArray);
            try {
                this.bitsPerChar = IntMath.log2((int)cArray.length, (RoundingMode)RoundingMode.UNNECESSARY);
            }
            catch (ArithmeticException arithmeticException) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Illegal alphabet length ");
                ((StringBuilder)object).append(cArray.length);
                object = new IllegalArgumentException(((StringBuilder)object).toString(), arithmeticException);
                throw object;
            }
            int n2 = Math.min(8, Integer.lowestOneBit(this.bitsPerChar));
            try {
                this.charsPerChunk = 8 / n2;
                this.bytesPerChunk = this.bitsPerChar / n2;
            }
            catch (ArithmeticException arithmeticException) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Illegal alphabet ");
                ((StringBuilder)object).append(new String(cArray));
                throw new IllegalArgumentException(((StringBuilder)object).toString(), arithmeticException);
            }
            this.mask = cArray.length - 1;
            object = new byte[128];
            Arrays.fill((byte[])object, (byte)-1);
            int n3 = 0;
            for (n2 = 0; n2 < cArray.length; ++n2) {
                char c2 = cArray[n2];
                boolean bl = c2 < ((Object)object).length;
                Preconditions.checkArgument(bl, "Non-ASCII character: %s", c2);
                bl = object[c2] == -1;
                Preconditions.checkArgument(bl, "Duplicate character: %s", c2);
                object[c2] = (byte)n2;
            }
            this.decodabet = (byte[])object;
            object = new boolean[this.charsPerChunk];
            n2 = n3;
            while (true) {
                if (n2 >= this.bytesPerChunk) {
                    this.validPadding = (boolean[])object;
                    return;
                }
                object[IntMath.divide((int)(n2 * 8), (int)this.bitsPerChar, (RoundingMode)RoundingMode.CEILING)] = true;
                ++n2;
            }
        }

        private boolean hasLowerCase() {
            char[] cArray = this.chars;
            int n2 = cArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!Ascii.isLowerCase((char)cArray[i2])) continue;
                return true;
            }
            return false;
        }

        private boolean hasUpperCase() {
            char[] cArray = this.chars;
            int n2 = cArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!Ascii.isUpperCase((char)cArray[i2])) continue;
                return true;
            }
            return false;
        }

        boolean canDecode(char c2) {
            boolean bl = c2 <= '\u007f' && this.decodabet[c2] != -1;
            return bl;
        }

        int decode(char c2) throws DecodingException {
            if (c2 <= '\u007f') {
                byte by2 = this.decodabet[c2];
                if (by2 == -1) {
                    if (c2 > ' ' && c2 != '\u007f') {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("Unrecognized character: ");
                        stringBuilder.append(c2);
                        throw new DecodingException(stringBuilder.toString());
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Unrecognized character: 0x");
                    stringBuilder.append(Integer.toHexString(c2));
                    throw new DecodingException(stringBuilder.toString());
                }
                return by2;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Unrecognized character: 0x");
            stringBuilder.append(Integer.toHexString(c2));
            throw new DecodingException(stringBuilder.toString());
        }

        char encode(int n2) {
            return this.chars[n2];
        }

        public boolean equals(@NullableDecl Object object) {
            if (object instanceof Alphabet) {
                object = (Alphabet)object;
                return Arrays.equals(this.chars, ((Alphabet)object).chars);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.chars);
        }

        boolean isValidPaddingStartPosition(int n2) {
            return this.validPadding[n2 % this.charsPerChunk];
        }

        Alphabet lowerCase() {
            Object object;
            if (!this.hasUpperCase()) {
                return this;
            }
            Preconditions.checkState(this.hasLowerCase() ^ true, "Cannot call lowerCase() on a mixed-case alphabet");
            char[] cArray = new char[this.chars.length];
            for (int i2 = 0; i2 < ((char[])(object = this.chars)).length; ++i2) {
                cArray[i2] = Ascii.toLowerCase((char)object[i2]);
            }
            object = new StringBuilder();
            ((StringBuilder)object).append(this.name);
            ((StringBuilder)object).append(".lowerCase()");
            return new Alphabet(((StringBuilder)object).toString(), cArray);
        }

        public boolean matches(char c2) {
            byte[] byArray = this.decodabet;
            boolean bl = c2 < byArray.length && byArray[c2] != -1;
            return bl;
        }

        public String toString() {
            return this.name;
        }

        Alphabet upperCase() {
            Object object;
            if (!this.hasLowerCase()) {
                return this;
            }
            Preconditions.checkState(this.hasUpperCase() ^ true, "Cannot call upperCase() on a mixed-case alphabet");
            char[] cArray = new char[this.chars.length];
            for (int i2 = 0; i2 < ((char[])(object = this.chars)).length; ++i2) {
                cArray[i2] = Ascii.toUpperCase((char)object[i2]);
            }
            object = new StringBuilder();
            ((StringBuilder)object).append(this.name);
            ((StringBuilder)object).append(".upperCase()");
            return new Alphabet(((StringBuilder)object).toString(), cArray);
        }
    }

    static final class Base16Encoding
    extends StandardBaseEncoding {
        final char[] encoding = new char[512];

        private Base16Encoding(Alphabet alphabet) {
            super(alphabet, null);
            int n2 = alphabet.chars.length;
            boolean bl = n2 == 16;
            Preconditions.checkArgument(bl);
            for (int i2 = 0; i2 < 256; ++i2) {
                this.encoding[i2] = alphabet.encode(i2 >>> 4);
                this.encoding[i2 | 0x100] = alphabet.encode(i2 & 0xF);
            }
        }

        Base16Encoding(String string2, String string3) {
            this(new Alphabet(string2, string3.toCharArray()));
        }

        @Override
        int decodeTo(byte[] object, CharSequence charSequence) throws DecodingException {
            Preconditions.checkNotNull(object);
            if (charSequence.length() % 2 != 1) {
                int n2 = 0;
                int n3 = 0;
                while (n2 < charSequence.length()) {
                    object[n3] = (byte)(this.alphabet.decode(charSequence.charAt(n2)) << 4 | this.alphabet.decode(charSequence.charAt(n2 + 1)));
                    n2 += 2;
                    ++n3;
                }
                return n3;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Invalid input length ");
            ((StringBuilder)object).append(charSequence.length());
            object = new DecodingException(((StringBuilder)object).toString());
            throw object;
        }

        @Override
        void encodeTo(Appendable appendable, byte[] byArray, int n2, int n3) throws IOException {
            Preconditions.checkNotNull(appendable);
            Preconditions.checkPositionIndexes(n2, n2 + n3, byArray.length);
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = byArray[n2 + i2] & 0xFF;
                appendable.append(this.encoding[n4]);
                appendable.append(this.encoding[n4 | 0x100]);
            }
        }

        @Override
        BaseEncoding newInstance(Alphabet alphabet, @NullableDecl Character c2) {
            return new Base16Encoding(alphabet);
        }
    }

    static final class Base64Encoding
    extends StandardBaseEncoding {
        private Base64Encoding(Alphabet alphabet, @NullableDecl Character c2) {
            super(alphabet, c2);
            boolean bl = alphabet.chars.length == 64;
            Preconditions.checkArgument(bl);
        }

        Base64Encoding(String string2, String string3, @NullableDecl Character c2) {
            this(new Alphabet(string2, string3.toCharArray()), c2);
        }

        @Override
        int decodeTo(byte[] object, CharSequence charSequence) throws DecodingException {
            Preconditions.checkNotNull(object);
            charSequence = this.trimTrailingPadding(charSequence);
            if (this.alphabet.isValidPaddingStartPosition(charSequence.length())) {
                int n2 = 0;
                int n3 = 0;
                while (n2 < charSequence.length()) {
                    Alphabet alphabet = this.alphabet;
                    int n4 = n2 + 1;
                    n2 = alphabet.decode(charSequence.charAt(n2));
                    alphabet = this.alphabet;
                    int n5 = n4 + 1;
                    int n6 = n2 << 18 | alphabet.decode(charSequence.charAt(n4)) << 12;
                    n4 = n3 + 1;
                    object[n3] = (byte)(n6 >>> 16);
                    n3 = n4;
                    n2 = n5;
                    if (n5 >= charSequence.length()) continue;
                    alphabet = this.alphabet;
                    int n7 = n5 + 1;
                    n3 = n4 + 1;
                    object[n4] = (byte)((n6 |= alphabet.decode(charSequence.charAt(n5)) << 6) >>> 8 & 0xFF);
                    if (n7 < charSequence.length()) {
                        alphabet = this.alphabet;
                        n2 = n7 + 1;
                        n4 = alphabet.decode(charSequence.charAt(n7));
                        n5 = n3 + 1;
                        object[n3] = (byte)((n6 | n4) & 0xFF);
                        n3 = n5;
                        continue;
                    }
                    n2 = n7;
                }
                return n3;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Invalid input length ");
            ((StringBuilder)object).append(charSequence.length());
            object = new DecodingException(((StringBuilder)object).toString());
            throw object;
        }

        @Override
        void encodeTo(Appendable appendable, byte[] byArray, int n2, int n3) throws IOException {
            Preconditions.checkNotNull(appendable);
            int n4 = n2 + n3;
            Preconditions.checkPositionIndexes(n2, n4, byArray.length);
            while (n3 >= 3) {
                int n5 = n2 + 1;
                byte by2 = byArray[n2];
                n2 = n5 + 1;
                n5 = (by2 & 0xFF) << 16 | (byArray[n5] & 0xFF) << 8 | byArray[n2] & 0xFF;
                appendable.append(this.alphabet.encode(n5 >>> 18));
                appendable.append(this.alphabet.encode(n5 >>> 12 & 0x3F));
                appendable.append(this.alphabet.encode(n5 >>> 6 & 0x3F));
                appendable.append(this.alphabet.encode(n5 & 0x3F));
                n3 -= 3;
                ++n2;
            }
            if (n2 < n4) {
                this.encodeChunkTo(appendable, byArray, n2, n4 - n2);
            }
        }

        @Override
        BaseEncoding newInstance(Alphabet alphabet, @NullableDecl Character c2) {
            return new Base64Encoding(alphabet, c2);
        }
    }

    public static final class DecodingException
    extends IOException {
        DecodingException(String string2) {
            super(string2);
        }

        DecodingException(Throwable throwable) {
            super(throwable);
        }
    }

    static final class SeparatedBaseEncoding
    extends BaseEncoding {
        private final int afterEveryChars;
        private final BaseEncoding delegate;
        private final String separator;

        SeparatedBaseEncoding(BaseEncoding baseEncoding, String string2, int n2) {
            this.delegate = Preconditions.checkNotNull(baseEncoding);
            this.separator = Preconditions.checkNotNull(string2);
            this.afterEveryChars = n2;
            boolean bl = n2 > 0;
            Preconditions.checkArgument(bl, "Cannot add a separator after every %s chars", n2);
        }

        @Override
        public boolean canDecode(CharSequence charSequence) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = 0; i2 < charSequence.length(); ++i2) {
                char c2 = charSequence.charAt(i2);
                if (this.separator.indexOf(c2) >= 0) continue;
                stringBuilder.append(c2);
            }
            return this.delegate.canDecode(stringBuilder);
        }

        @Override
        int decodeTo(byte[] byArray, CharSequence charSequence) throws DecodingException {
            StringBuilder stringBuilder = new StringBuilder(charSequence.length());
            for (int i2 = 0; i2 < charSequence.length(); ++i2) {
                char c2 = charSequence.charAt(i2);
                if (this.separator.indexOf(c2) >= 0) continue;
                stringBuilder.append(c2);
            }
            return this.delegate.decodeTo(byArray, stringBuilder);
        }

        @Override
        public InputStream decodingStream(Reader reader) {
            return this.delegate.decodingStream(SeparatedBaseEncoding.ignoringReader(reader, this.separator));
        }

        @Override
        void encodeTo(Appendable appendable, byte[] byArray, int n2, int n3) throws IOException {
            this.delegate.encodeTo(SeparatedBaseEncoding.separatingAppendable(appendable, this.separator, this.afterEveryChars), byArray, n2, n3);
        }

        @Override
        public OutputStream encodingStream(Writer writer) {
            return this.delegate.encodingStream(SeparatedBaseEncoding.separatingWriter(writer, this.separator, this.afterEveryChars));
        }

        @Override
        public BaseEncoding lowerCase() {
            return this.delegate.lowerCase().withSeparator(this.separator, this.afterEveryChars);
        }

        @Override
        int maxDecodedSize(int n2) {
            return this.delegate.maxDecodedSize(n2);
        }

        @Override
        int maxEncodedSize(int n2) {
            n2 = this.delegate.maxEncodedSize(n2);
            return n2 + this.separator.length() * IntMath.divide((int)Math.max(0, n2 - 1), (int)this.afterEveryChars, (RoundingMode)RoundingMode.FLOOR);
        }

        @Override
        public BaseEncoding omitPadding() {
            return this.delegate.omitPadding().withSeparator(this.separator, this.afterEveryChars);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.delegate);
            stringBuilder.append(".withSeparator(\"");
            stringBuilder.append(this.separator);
            stringBuilder.append("\", ");
            stringBuilder.append(this.afterEveryChars);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        @Override
        CharSequence trimTrailingPadding(CharSequence charSequence) {
            return this.delegate.trimTrailingPadding(charSequence);
        }

        @Override
        public BaseEncoding upperCase() {
            return this.delegate.upperCase().withSeparator(this.separator, this.afterEveryChars);
        }

        @Override
        public BaseEncoding withPadChar(char c2) {
            return this.delegate.withPadChar(c2).withSeparator(this.separator, this.afterEveryChars);
        }

        @Override
        public BaseEncoding withSeparator(String string2, int n2) {
            throw new UnsupportedOperationException("Already have a separator");
        }
    }

    static class StandardBaseEncoding
    extends BaseEncoding {
        final Alphabet alphabet;
        @MonotonicNonNullDecl
        private transient BaseEncoding lowerCase;
        @NullableDecl
        final Character paddingChar;
        @MonotonicNonNullDecl
        private transient BaseEncoding upperCase;

        StandardBaseEncoding(Alphabet alphabet, @NullableDecl Character c2) {
            this.alphabet = Preconditions.checkNotNull(alphabet);
            boolean bl = c2 == null || !alphabet.matches(c2.charValue());
            Preconditions.checkArgument(bl, "Padding character %s was already in alphabet", (Object)c2);
            this.paddingChar = c2;
        }

        StandardBaseEncoding(String string2, String string3, @NullableDecl Character c2) {
            this(new Alphabet(string2, string3.toCharArray()), c2);
        }

        @Override
        public boolean canDecode(CharSequence charSequence) {
            Preconditions.checkNotNull(charSequence);
            charSequence = this.trimTrailingPadding(charSequence);
            if (!this.alphabet.isValidPaddingStartPosition(charSequence.length())) {
                return false;
            }
            for (int i2 = 0; i2 < charSequence.length(); ++i2) {
                if (this.alphabet.canDecode(charSequence.charAt(i2))) continue;
                return false;
            }
            return true;
        }

        @Override
        int decodeTo(byte[] object, CharSequence charSequence) throws DecodingException {
            Preconditions.checkNotNull(object);
            charSequence = this.trimTrailingPadding(charSequence);
            if (this.alphabet.isValidPaddingStartPosition(charSequence.length())) {
                int n2 = 0;
                for (int i2 = 0; i2 < charSequence.length(); i2 += this.alphabet.charsPerChunk) {
                    int n3;
                    int n4;
                    long l2 = 0L;
                    int n5 = 0;
                    for (n4 = 0; n4 < this.alphabet.charsPerChunk; ++n4) {
                        long l3 = l2 << this.alphabet.bitsPerChar;
                        n3 = n5;
                        l2 = l3;
                        if (i2 + n4 < charSequence.length()) {
                            l2 = l3 | (long)this.alphabet.decode(charSequence.charAt(n5 + i2));
                            n3 = n5 + 1;
                        }
                        n5 = n3;
                    }
                    n3 = this.alphabet.bytesPerChunk;
                    int n6 = this.alphabet.bitsPerChar;
                    n4 = (this.alphabet.bytesPerChunk - 1) * 8;
                    while (n4 >= n3 * 8 - n5 * n6) {
                        object[n2] = (byte)(l2 >>> n4 & 0xFFL);
                        n4 -= 8;
                        ++n2;
                    }
                }
                return n2;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Invalid input length ");
            ((StringBuilder)object).append(charSequence.length());
            object = new DecodingException(((StringBuilder)object).toString());
            throw object;
        }

        @Override
        public InputStream decodingStream(final Reader reader) {
            Preconditions.checkNotNull(reader);
            return new InputStream(){
                int bitBuffer = 0;
                int bitBufferLength = 0;
                boolean hitPadding = false;
                int readChars = 0;

                @Override
                public void close() throws IOException {
                    reader.close();
                }

                @Override
                public int read() throws IOException {
                    char c2;
                    block5: {
                        int n2;
                        while (true) {
                            if ((n2 = reader.read()) == -1) {
                                if (!this.hitPadding && !StandardBaseEncoding.this.alphabet.isValidPaddingStartPosition(this.readChars)) {
                                    StringBuilder stringBuilder = new StringBuilder();
                                    stringBuilder.append("Invalid input length ");
                                    stringBuilder.append(this.readChars);
                                    throw new DecodingException(stringBuilder.toString());
                                }
                                return -1;
                            }
                            ++this.readChars;
                            c2 = (char)n2;
                            if (StandardBaseEncoding.this.paddingChar != null && StandardBaseEncoding.this.paddingChar.charValue() == c2) {
                                if (!(this.hitPadding || this.readChars != 1 && StandardBaseEncoding.this.alphabet.isValidPaddingStartPosition(this.readChars - 1))) {
                                    StringBuilder stringBuilder = new StringBuilder();
                                    stringBuilder.append("Padding cannot start at index ");
                                    stringBuilder.append(this.readChars);
                                    throw new DecodingException(stringBuilder.toString());
                                }
                                this.hitPadding = true;
                                continue;
                            }
                            if (this.hitPadding) break block5;
                            this.bitBuffer <<= StandardBaseEncoding.this.alphabet.bitsPerChar;
                            n2 = this.bitBuffer;
                            this.bitBuffer = StandardBaseEncoding.this.alphabet.decode(c2) | n2;
                            this.bitBufferLength += StandardBaseEncoding.this.alphabet.bitsPerChar;
                            n2 = this.bitBufferLength;
                            if (n2 >= 8) break;
                        }
                        this.bitBufferLength = n2 - 8;
                        return this.bitBuffer >> this.bitBufferLength & 0xFF;
                    }
                    Serializable serializable = new StringBuilder();
                    serializable.append("Expected padding character but found '");
                    serializable.append(c2);
                    serializable.append("' at index ");
                    serializable.append(this.readChars);
                    serializable = new DecodingException(serializable.toString());
                    throw serializable;
                }
            };
        }

        void encodeChunkTo(Appendable appendable, byte[] byArray, int n2, int n3) throws IOException {
            Preconditions.checkNotNull(appendable);
            Preconditions.checkPositionIndexes(n2, n2 + n3, byArray.length);
            int n4 = this.alphabet.bytesPerChunk;
            int n5 = 0;
            boolean bl = n3 <= n4;
            Preconditions.checkArgument(bl);
            long l2 = 0L;
            for (n4 = 0; n4 < n3; ++n4) {
                l2 = (l2 | (long)(byArray[n2 + n4] & 0xFF)) << 8;
            }
            n4 = this.alphabet.bitsPerChar;
            for (n2 = n5; n2 < n3 * 8; n2 += this.alphabet.bitsPerChar) {
                n5 = (int)(l2 >>> (n3 + 1) * 8 - n4 - n2);
                int n6 = this.alphabet.mask;
                appendable.append(this.alphabet.encode(n5 & n6));
            }
            if (this.paddingChar != null) {
                while (n2 < this.alphabet.bytesPerChunk * 8) {
                    appendable.append(this.paddingChar.charValue());
                    n2 += this.alphabet.bitsPerChar;
                }
            }
        }

        @Override
        void encodeTo(Appendable appendable, byte[] byArray, int n2, int n3) throws IOException {
            Preconditions.checkNotNull(appendable);
            Preconditions.checkPositionIndexes(n2, n2 + n3, byArray.length);
            for (int i2 = 0; i2 < n3; i2 += this.alphabet.bytesPerChunk) {
                this.encodeChunkTo(appendable, byArray, n2 + i2, Math.min(this.alphabet.bytesPerChunk, n3 - i2));
            }
        }

        @Override
        public OutputStream encodingStream(final Writer writer) {
            Preconditions.checkNotNull(writer);
            return new OutputStream(){
                int bitBuffer = 0;
                int bitBufferLength = 0;
                int writtenChars = 0;

                @Override
                public void close() throws IOException {
                    if (this.bitBufferLength > 0) {
                        int n2 = this.bitBuffer;
                        int n3 = StandardBaseEncoding.this.alphabet.bitsPerChar;
                        int n4 = this.bitBufferLength;
                        int n5 = StandardBaseEncoding.this.alphabet.mask;
                        writer.write(StandardBaseEncoding.this.alphabet.encode(n2 << n3 - n4 & n5));
                        ++this.writtenChars;
                        if (StandardBaseEncoding.this.paddingChar != null) {
                            while (this.writtenChars % StandardBaseEncoding.this.alphabet.charsPerChunk != 0) {
                                writer.write(StandardBaseEncoding.this.paddingChar.charValue());
                                ++this.writtenChars;
                            }
                        }
                    }
                    writer.close();
                }

                @Override
                public void flush() throws IOException {
                    writer.flush();
                }

                @Override
                public void write(int n2) throws IOException {
                    this.bitBuffer <<= 8;
                    this.bitBuffer = n2 & 0xFF | this.bitBuffer;
                    this.bitBufferLength += 8;
                    while (this.bitBufferLength >= StandardBaseEncoding.this.alphabet.bitsPerChar) {
                        n2 = this.bitBuffer;
                        int n3 = this.bitBufferLength;
                        int n4 = StandardBaseEncoding.this.alphabet.bitsPerChar;
                        int n5 = StandardBaseEncoding.this.alphabet.mask;
                        writer.write(StandardBaseEncoding.this.alphabet.encode(n2 >> n3 - n4 & n5));
                        ++this.writtenChars;
                        this.bitBufferLength -= StandardBaseEncoding.this.alphabet.bitsPerChar;
                    }
                }
            };
        }

        public boolean equals(@NullableDecl Object object) {
            boolean bl;
            boolean bl2 = object instanceof StandardBaseEncoding;
            boolean bl3 = bl = false;
            if (bl2) {
                object = (StandardBaseEncoding)object;
                bl3 = bl;
                if (this.alphabet.equals(((StandardBaseEncoding)object).alphabet)) {
                    bl3 = bl;
                    if (Objects.equal(this.paddingChar, ((StandardBaseEncoding)object).paddingChar)) {
                        bl3 = true;
                    }
                }
            }
            return bl3;
        }

        public int hashCode() {
            return this.alphabet.hashCode() ^ Objects.hashCode(this.paddingChar);
        }

        @Override
        public BaseEncoding lowerCase() {
            BaseEncoding baseEncoding = this.lowerCase;
            Object object = baseEncoding;
            if (baseEncoding == null) {
                object = this.alphabet.lowerCase();
                object = object == this.alphabet ? this : this.newInstance((Alphabet)object, this.paddingChar);
                this.lowerCase = object;
            }
            return object;
        }

        @Override
        int maxDecodedSize(int n2) {
            return (int)(((long)this.alphabet.bitsPerChar * (long)n2 + 7L) / 8L);
        }

        @Override
        int maxEncodedSize(int n2) {
            return this.alphabet.charsPerChunk * IntMath.divide((int)n2, (int)this.alphabet.bytesPerChunk, (RoundingMode)RoundingMode.CEILING);
        }

        BaseEncoding newInstance(Alphabet alphabet, @NullableDecl Character c2) {
            return new StandardBaseEncoding(alphabet, c2);
        }

        @Override
        public BaseEncoding omitPadding() {
            BaseEncoding baseEncoding = this.paddingChar == null ? this : this.newInstance(this.alphabet, null);
            return baseEncoding;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("BaseEncoding.");
            stringBuilder.append(this.alphabet.toString());
            if (8 % this.alphabet.bitsPerChar != 0) {
                if (this.paddingChar == null) {
                    stringBuilder.append(".omitPadding()");
                } else {
                    stringBuilder.append(".withPadChar('");
                    stringBuilder.append(this.paddingChar);
                    stringBuilder.append("')");
                }
            }
            return stringBuilder.toString();
        }

        @Override
        CharSequence trimTrailingPadding(CharSequence charSequence) {
            int n2;
            Preconditions.checkNotNull(charSequence);
            Character c2 = this.paddingChar;
            if (c2 == null) {
                return charSequence;
            }
            char c3 = c2.charValue();
            for (n2 = charSequence.length() - 1; n2 >= 0 && charSequence.charAt(n2) == c3; --n2) {
            }
            return charSequence.subSequence(0, n2 + 1);
        }

        @Override
        public BaseEncoding upperCase() {
            BaseEncoding baseEncoding = this.upperCase;
            Object object = baseEncoding;
            if (baseEncoding == null) {
                object = this.alphabet.upperCase();
                object = object == this.alphabet ? this : this.newInstance((Alphabet)object, this.paddingChar);
                this.upperCase = object;
            }
            return object;
        }

        @Override
        public BaseEncoding withPadChar(char c2) {
            Character c3;
            if (8 % this.alphabet.bitsPerChar != 0 && ((c3 = this.paddingChar) == null || c3.charValue() != c2)) {
                return this.newInstance(this.alphabet, Character.valueOf(c2));
            }
            return this;
        }

        @Override
        public BaseEncoding withSeparator(String string2, int n2) {
            boolean bl = false;
            for (int i2 = 0; i2 < string2.length(); ++i2) {
                Preconditions.checkArgument(this.alphabet.matches(string2.charAt(i2)) ^ true, "Separator (%s) cannot contain alphabet characters", (Object)string2);
            }
            Character c2 = this.paddingChar;
            if (c2 != null) {
                if (string2.indexOf(c2.charValue()) < 0) {
                    bl = true;
                }
                Preconditions.checkArgument(bl, "Separator (%s) cannot contain padding character", (Object)string2);
            }
            return new SeparatedBaseEncoding(this, string2, n2);
        }
    }
}

