/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractHashFunction;
import com.google.common.hash.AbstractHasher;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.primitives.Ints;
import com.google.common.primitives.UnsignedBytes;
import com.google.errorprone.annotations.Immutable;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

@Immutable
final class Murmur3_32HashFunction
extends AbstractHashFunction
implements Serializable {
    private static final int C1 = -862048943;
    private static final int C2 = 461845907;
    private static final int CHUNK_SIZE = 4;
    static final HashFunction GOOD_FAST_HASH_32;
    static final HashFunction MURMUR3_32;
    private static final long serialVersionUID = 0L;
    private final int seed;

    static {
        MURMUR3_32 = new Murmur3_32HashFunction(0);
        GOOD_FAST_HASH_32 = new Murmur3_32HashFunction(Hashing.GOOD_FAST_HASH_SEED);
    }

    Murmur3_32HashFunction(int n2) {
        this.seed = n2;
    }

    private static long charToThreeUtf8Bytes(char c2) {
        return (c2 & 0x3F | 0x80) << 16 | ((c2 >>> 12 | 0x1E0) & 0xFF | (c2 >>> 6 & 0x3F | 0x80) << 8);
    }

    private static long charToTwoUtf8Bytes(char c2) {
        return (c2 & 0x3F | 0x80) << 8 | (c2 >>> 6 | 0x3C0) & 0xFF;
    }

    private static long codePointToFourUtf8Bytes(int n2) {
        return ((long)(n2 >>> 18) | 0xF0L) & 0xFFL | ((long)(n2 >>> 12 & 0x3F) | 0x80L) << 8 | ((long)(n2 >>> 6 & 0x3F) | 0x80L) << 16 | ((long)(n2 & 0x3F) | 0x80L) << 24;
    }

    private static HashCode fmix(int n2, int n3) {
        n2 ^= n3;
        n2 = (n2 ^ n2 >>> 16) * -2048144789;
        n2 = (n2 ^ n2 >>> 13) * -1028477387;
        return HashCode.fromInt(n2 ^ n2 >>> 16);
    }

    private static int getIntLittleEndian(byte[] byArray, int n2) {
        return Ints.fromBytes(byArray[n2 + 3], byArray[n2 + 2], byArray[n2 + 1], byArray[n2]);
    }

    private static int mixH1(int n2, int n3) {
        return Integer.rotateLeft(n2 ^ n3, 13) * 5 - 430675100;
    }

    private static int mixK1(int n2) {
        return Integer.rotateLeft(n2 * -862048943, 15) * 461845907;
    }

    @Override
    public int bits() {
        return 32;
    }

    public boolean equals(@NullableDecl Object object) {
        boolean bl;
        boolean bl2 = object instanceof Murmur3_32HashFunction;
        boolean bl3 = bl = false;
        if (bl2) {
            object = (Murmur3_32HashFunction)object;
            bl3 = bl;
            if (this.seed == ((Murmur3_32HashFunction)object).seed) {
                bl3 = true;
            }
        }
        return bl3;
    }

    @Override
    public HashCode hashBytes(byte[] byArray, int n2, int n3) {
        int n4;
        Preconditions.checkPositionIndexes(n2, n2 + n3, byArray.length);
        int n5 = this.seed;
        int n6 = 0;
        int n7 = 0;
        while ((n4 = n7 + 4) <= n3) {
            n5 = Murmur3_32HashFunction.mixH1(n5, Murmur3_32HashFunction.mixK1(Murmur3_32HashFunction.getIntLittleEndian(byArray, n7 + n2)));
            n7 = n4;
        }
        n4 = 0;
        while (n7 < n3) {
            n6 ^= UnsignedBytes.toInt((byte)byArray[n2 + n7]) << n4;
            ++n7;
            n4 += 8;
        }
        return Murmur3_32HashFunction.fmix(Murmur3_32HashFunction.mixK1(n6) ^ n5, n3);
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.seed;
    }

    @Override
    public HashCode hashInt(int n2) {
        n2 = Murmur3_32HashFunction.mixK1(n2);
        return Murmur3_32HashFunction.fmix(Murmur3_32HashFunction.mixH1(this.seed, n2), 4);
    }

    @Override
    public HashCode hashLong(long l2) {
        int n2 = (int)l2;
        int n3 = (int)(l2 >>> 32);
        n2 = Murmur3_32HashFunction.mixK1(n2);
        return Murmur3_32HashFunction.fmix(Murmur3_32HashFunction.mixH1(Murmur3_32HashFunction.mixH1(this.seed, n2), Murmur3_32HashFunction.mixK1(n3)), 8);
    }

    @Override
    public HashCode hashString(CharSequence charSequence, Charset charset) {
        if (Charsets.UTF_8.equals(charset)) {
            int n2;
            int n3;
            int n4 = charSequence.length();
            int n5 = this.seed;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            while ((n3 = n7 + 4) <= n4) {
                char c2 = charSequence.charAt(n7);
                char c3 = charSequence.charAt(n7 + 1);
                n2 = charSequence.charAt(n7 + 2);
                char c4 = charSequence.charAt(n7 + 3);
                if (c2 >= '\u0080' || c3 >= '\u0080' || n2 >= 128 || c4 >= '\u0080') break;
                n5 = Murmur3_32HashFunction.mixH1(n5, Murmur3_32HashFunction.mixK1(c3 << 8 | c2 | n2 << 16 | c4 << 24));
                n8 += 4;
                n7 = n3;
            }
            long l2 = 0L;
            n3 = n8;
            n2 = n5;
            n8 = n6;
            while (n7 < n4) {
                long l3;
                char c5 = charSequence.charAt(n7);
                if (c5 < '\u0080') {
                    l3 = l2 | (long)c5 << n8;
                    n8 += 8;
                    n5 = n3 + 1;
                } else if (c5 < '\u0800') {
                    l3 = l2 | Murmur3_32HashFunction.charToTwoUtf8Bytes(c5) << n8;
                    n8 += 16;
                    n5 = n3 + 2;
                } else if (c5 >= '\ud800' && c5 <= '\udfff') {
                    n5 = Character.codePointAt(charSequence, n7);
                    if (n5 == c5) {
                        return this.hashBytes(charSequence.toString().getBytes(charset));
                    }
                    ++n7;
                    l3 = l2 | Murmur3_32HashFunction.codePointToFourUtf8Bytes(n5) << n8;
                    n5 = n3 + 4;
                } else {
                    l3 = l2 | Murmur3_32HashFunction.charToThreeUtf8Bytes(c5) << n8;
                    n8 += 24;
                    n5 = n3 + 3;
                }
                n3 = n8;
                n6 = n2;
                l2 = l3;
                if (n8 >= 32) {
                    n6 = Murmur3_32HashFunction.mixH1(n2, Murmur3_32HashFunction.mixK1((int)l3));
                    l2 = l3 >>> 32;
                    n3 = n8 - 32;
                }
                ++n7;
                n8 = n3;
                n2 = n6;
                n3 = n5;
            }
            return Murmur3_32HashFunction.fmix(Murmur3_32HashFunction.mixK1((int)l2) ^ n2, n3);
        }
        return this.hashBytes(charSequence.toString().getBytes(charset));
    }

    @Override
    public HashCode hashUnencodedChars(CharSequence charSequence) {
        int n2;
        int n3 = this.seed;
        for (n2 = 1; n2 < charSequence.length(); n2 += 2) {
            n3 = Murmur3_32HashFunction.mixH1(n3, Murmur3_32HashFunction.mixK1(charSequence.charAt(n2 - 1) | charSequence.charAt(n2) << 16));
        }
        n2 = n3;
        if ((charSequence.length() & 1) == 1) {
            n2 = n3 ^ Murmur3_32HashFunction.mixK1(charSequence.charAt(charSequence.length() - 1));
        }
        return Murmur3_32HashFunction.fmix(n2, charSequence.length() * 2);
    }

    @Override
    public Hasher newHasher() {
        return new Murmur3_32Hasher(this.seed);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Hashing.murmur3_32(");
        stringBuilder.append(this.seed);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private static final class Murmur3_32Hasher
    extends AbstractHasher {
        private long buffer;
        private int h1;
        private boolean isDone;
        private int length;
        private int shift;

        Murmur3_32Hasher(int n2) {
            this.h1 = n2;
            this.length = 0;
            this.isDone = false;
        }

        private void update(int n2, long l2) {
            long l3 = this.buffer;
            int n3 = this.shift;
            this.buffer = (l2 & 0xFFFFFFFFL) << n3 | l3;
            this.shift = n3 + n2 * 8;
            this.length += n2;
            if (this.shift >= 32) {
                this.h1 = Murmur3_32HashFunction.mixH1(this.h1, Murmur3_32HashFunction.mixK1((int)this.buffer));
                this.buffer >>>= 32;
                this.shift -= 32;
            }
        }

        public HashCode hash() {
            Preconditions.checkState(this.isDone ^ true);
            this.isDone = true;
            this.h1 ^= Murmur3_32HashFunction.mixK1((int)this.buffer);
            return Murmur3_32HashFunction.fmix(this.h1, this.length);
        }

        public Hasher putByte(byte by2) {
            this.update(1, by2 & 0xFF);
            return this;
        }

        public Hasher putBytes(ByteBuffer byteBuffer) {
            ByteOrder byteOrder = byteBuffer.order();
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            while (byteBuffer.remaining() >= 4) {
                this.putInt(byteBuffer.getInt());
            }
            while (byteBuffer.hasRemaining()) {
                this.putByte(byteBuffer.get());
            }
            byteBuffer.order(byteOrder);
            return this;
        }

        public Hasher putBytes(byte[] byArray, int n2, int n3) {
            Preconditions.checkPositionIndexes(n2, n2 + n3, byArray.length);
            int n4 = 0;
            while (true) {
                int n5 = n4 + 4;
                if (n5 > n3) break;
                this.update(4, Murmur3_32HashFunction.getIntLittleEndian(byArray, n4 + n2));
                n4 = n5;
            }
            for (int i2 = n4; i2 < n3; ++i2) {
                this.putByte(byArray[n2 + i2]);
            }
            return this;
        }

        public Hasher putChar(char c2) {
            this.update(2, c2);
            return this;
        }

        public Hasher putInt(int n2) {
            this.update(4, n2);
            return this;
        }

        public Hasher putLong(long l2) {
            this.update(4, (int)l2);
            this.update(4, l2 >>> 32);
            return this;
        }

        public Hasher putString(CharSequence charSequence, Charset charset) {
            if (Charsets.UTF_8.equals(charset)) {
                int n2;
                int n3 = charSequence.length();
                int n4 = 0;
                while (true) {
                    int n5 = n4 + 4;
                    n2 = n4;
                    if (n5 > n3) break;
                    char c2 = charSequence.charAt(n4);
                    char c3 = charSequence.charAt(n4 + 1);
                    char c4 = charSequence.charAt(n4 + 2);
                    char c5 = charSequence.charAt(n4 + 3);
                    n2 = n4;
                    if (c2 >= '\u0080') break;
                    n2 = n4;
                    if (c3 >= '\u0080') break;
                    n2 = n4;
                    if (c4 >= '\u0080') break;
                    n2 = n4;
                    if (c5 >= '\u0080') break;
                    this.update(4, c3 << 8 | c2 | c4 << 16 | c5 << 24);
                    n4 = n5;
                }
                while (n2 < n3) {
                    char c6 = charSequence.charAt(n2);
                    if (c6 < '\u0080') {
                        this.update(1, c6);
                    } else if (c6 < '\u0800') {
                        this.update(2, Murmur3_32HashFunction.charToTwoUtf8Bytes(c6));
                    } else if (c6 >= '\ud800' && c6 <= '\udfff') {
                        n4 = Character.codePointAt(charSequence, n2);
                        if (n4 == c6) {
                            this.putBytes(charSequence.subSequence(n2, n3).toString().getBytes(charset));
                            return this;
                        }
                        ++n2;
                        this.update(4, Murmur3_32HashFunction.codePointToFourUtf8Bytes(n4));
                    } else {
                        this.update(3, Murmur3_32HashFunction.charToThreeUtf8Bytes(c6));
                    }
                    ++n2;
                }
                return this;
            }
            return super.putString(charSequence, charset);
        }
    }
}

