/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.hash.AbstractHashFunction;
import com.google.common.hash.AbstractStreamingHasher;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.primitives.UnsignedBytes;
import com.google.errorprone.annotations.Immutable;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

@Immutable
final class Murmur3_128HashFunction
extends AbstractHashFunction
implements Serializable {
    static final HashFunction GOOD_FAST_HASH_128;
    static final HashFunction MURMUR3_128;
    private static final long serialVersionUID = 0L;
    private final int seed;

    static {
        MURMUR3_128 = new Murmur3_128HashFunction(0);
        GOOD_FAST_HASH_128 = new Murmur3_128HashFunction(Hashing.GOOD_FAST_HASH_SEED);
    }

    Murmur3_128HashFunction(int n2) {
        this.seed = n2;
    }

    @Override
    public int bits() {
        return 128;
    }

    public boolean equals(@NullableDecl Object object) {
        boolean bl;
        boolean bl2 = object instanceof Murmur3_128HashFunction;
        boolean bl3 = bl = false;
        if (bl2) {
            object = (Murmur3_128HashFunction)object;
            bl3 = bl;
            if (this.seed == ((Murmur3_128HashFunction)object).seed) {
                bl3 = true;
            }
        }
        return bl3;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.seed;
    }

    @Override
    public Hasher newHasher() {
        return new Murmur3_128Hasher(this.seed);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Hashing.murmur3_128(");
        stringBuilder.append(this.seed);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private static final class Murmur3_128Hasher
    extends AbstractStreamingHasher {
        private static final long C1 = -8663945395140668459L;
        private static final long C2 = 5545529020109919103L;
        private static final int CHUNK_SIZE = 16;
        private long h1;
        private long h2;
        private int length;

        Murmur3_128Hasher(int n2) {
            super(16);
            long l2;
            this.h1 = l2 = (long)n2;
            this.h2 = l2;
            this.length = 0;
        }

        private void bmix64(long l2, long l3) {
            long l4 = this.h1;
            this.h1 = Murmur3_128Hasher.mixK1(l2) ^ l4;
            l4 = this.h1 = Long.rotateLeft(this.h1, 27);
            l2 = this.h2;
            this.h1 = l4 + l2;
            this.h1 = this.h1 * 5L + 1390208809L;
            this.h2 = Murmur3_128Hasher.mixK2(l3) ^ l2;
            this.h2 = Long.rotateLeft(this.h2, 31);
            this.h2 += this.h1;
            this.h2 = this.h2 * 5L + 944331445L;
        }

        private static long fmix64(long l2) {
            l2 = (l2 ^ l2 >>> 33) * -49064778989728563L;
            l2 = (l2 ^ l2 >>> 33) * -4265267296055464877L;
            return l2 ^ l2 >>> 33;
        }

        private static long mixK1(long l2) {
            return Long.rotateLeft(l2 * -8663945395140668459L, 31) * 5545529020109919103L;
        }

        private static long mixK2(long l2) {
            return Long.rotateLeft(l2 * 5545529020109919103L, 33) * -8663945395140668459L;
        }

        public HashCode makeHash() {
            long l2 = this.h1;
            int n2 = this.length;
            this.h1 = l2 ^ (long)n2;
            this.h2 ^= (long)n2;
            long l3 = this.h1;
            l2 = this.h2;
            l3 = this.h1 = l3 + l2;
            this.h2 = l2 + l3;
            this.h1 = Murmur3_128Hasher.fmix64(l3);
            this.h2 = Murmur3_128Hasher.fmix64(this.h2);
            l3 = this.h1;
            l2 = this.h2;
            this.h1 = l3 + l2;
            this.h2 = l2 + this.h1;
            return HashCode.fromBytesNoCopy(ByteBuffer.wrap(new byte[16]).order(ByteOrder.LITTLE_ENDIAN).putLong(this.h1).putLong(this.h2).array());
        }

        protected void process(ByteBuffer byteBuffer) {
            this.bmix64(byteBuffer.getLong(), byteBuffer.getLong());
            this.length += 16;
        }

        /*
         * Unable to fully structure code
         */
        protected void processRemaining(ByteBuffer var1_1) {
            block17: {
                block18: {
                    this.length += var1_1.remaining();
                    switch (var1_1.remaining()) {
                        default: {
                            throw new AssertionError((Object)"Should never get here.");
                        }
                        case 15: {
                            var2_2 = (long)UnsignedBytes.toInt((byte)var1_1.get(14)) << 48 ^ 0L;
                            ** GOTO lbl10
                        }
                        case 14: {
                            var2_2 = 0L;
lbl10:
                            // 2 sources

                            var2_2 ^= (long)UnsignedBytes.toInt((byte)var1_1.get(13)) << 40;
                            ** GOTO lbl14
                        }
                        case 13: {
                            var2_2 = 0L;
lbl14:
                            // 2 sources

                            var2_2 ^= (long)UnsignedBytes.toInt((byte)var1_1.get(12)) << 32;
                            ** GOTO lbl18
                        }
                        case 12: {
                            var2_2 = 0L;
lbl18:
                            // 2 sources

                            var2_2 ^= (long)UnsignedBytes.toInt((byte)var1_1.get(11)) << 24;
                            ** GOTO lbl22
                        }
                        case 11: {
                            var2_2 = 0L;
lbl22:
                            // 2 sources

                            var2_2 ^= (long)UnsignedBytes.toInt((byte)var1_1.get(10)) << 16;
                            ** GOTO lbl26
                        }
                        case 10: {
                            var2_2 = 0L;
lbl26:
                            // 2 sources

                            var2_2 ^= (long)UnsignedBytes.toInt((byte)var1_1.get(9)) << 8;
                            ** GOTO lbl30
                        }
                        case 9: {
                            var2_2 = 0L;
lbl30:
                            // 2 sources

                            var2_2 ^= (long)UnsignedBytes.toInt((byte)var1_1.get(8));
                            ** GOTO lbl34
                        }
                        case 8: {
                            var2_2 = 0L;
lbl34:
                            // 2 sources

                            var4_3 = var1_1.getLong() ^ 0L;
                            break block17;
                        }
                        case 7: {
                            var2_2 = (long)UnsignedBytes.toInt((byte)var1_1.get(6)) << 48 ^ 0L;
                            ** GOTO lbl41
                        }
                        case 6: {
                            var2_2 = 0L;
lbl41:
                            // 2 sources

                            var2_2 ^= (long)UnsignedBytes.toInt((byte)var1_1.get(5)) << 40;
                            ** GOTO lbl45
                        }
                        case 5: {
                            var2_2 = 0L;
lbl45:
                            // 2 sources

                            var2_2 ^= (long)UnsignedBytes.toInt((byte)var1_1.get(4)) << 32;
                            ** GOTO lbl49
                        }
                        case 4: {
                            var2_2 = 0L;
lbl49:
                            // 2 sources

                            var2_2 ^= (long)UnsignedBytes.toInt((byte)var1_1.get(3)) << 24;
                            ** GOTO lbl53
                        }
                        case 3: {
                            var2_2 = 0L;
lbl53:
                            // 2 sources

                            var2_2 ^= (long)UnsignedBytes.toInt((byte)var1_1.get(2)) << 16;
                            ** GOTO lbl57
                        }
                        case 2: {
                            var2_2 = 0L;
lbl57:
                            // 2 sources

                            var2_2 ^= (long)UnsignedBytes.toInt((byte)var1_1.get(1)) << 8;
                            break block18;
                        }
                        case 1: 
                    }
                    var2_2 = 0L;
                }
                var4_3 = (long)UnsignedBytes.toInt((byte)var1_1.get(0)) ^ var2_2;
                var2_2 = 0L;
            }
            var6_4 = this.h1;
            this.h1 = Murmur3_128Hasher.mixK1(var4_3) ^ var6_4;
            var4_3 = this.h2;
            this.h2 = Murmur3_128Hasher.mixK2(var2_2) ^ var4_3;
        }
    }
}

