/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractByteHasher;
import com.google.common.hash.AbstractHashFunction;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.errorprone.annotations.Immutable;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

@Immutable
final class MessageDigestHashFunction
extends AbstractHashFunction
implements Serializable {
    private final int bytes;
    private final MessageDigest prototype;
    private final boolean supportsClone;
    private final String toString;

    MessageDigestHashFunction(String string2, int n2, String string3) {
        this.toString = Preconditions.checkNotNull(string3);
        this.prototype = MessageDigestHashFunction.getMessageDigest(string2);
        int n3 = this.prototype.getDigestLength();
        boolean bl = n2 >= 4 && n2 <= n3;
        Preconditions.checkArgument(bl, "bytes (%s) must be >= 4 and < %s", n2, n3);
        this.bytes = n2;
        this.supportsClone = MessageDigestHashFunction.supportsClone(this.prototype);
    }

    MessageDigestHashFunction(String string2, String string3) {
        this.prototype = MessageDigestHashFunction.getMessageDigest(string2);
        this.bytes = this.prototype.getDigestLength();
        this.toString = Preconditions.checkNotNull(string3);
        this.supportsClone = MessageDigestHashFunction.supportsClone(this.prototype);
    }

    private static MessageDigest getMessageDigest(String object) {
        try {
            object = MessageDigest.getInstance((String)object);
            return object;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
    }

    private static boolean supportsClone(MessageDigest messageDigest) {
        try {
            messageDigest.clone();
            return true;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return false;
        }
    }

    @Override
    public int bits() {
        return this.bytes * 8;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Hasher newHasher() {
        if (!this.supportsClone) return new MessageDigestHasher(MessageDigestHashFunction.getMessageDigest(this.prototype.getAlgorithm()), this.bytes);
        try {
            return new MessageDigestHasher((MessageDigest)this.prototype.clone(), this.bytes);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return new MessageDigestHasher(MessageDigestHashFunction.getMessageDigest(this.prototype.getAlgorithm()), this.bytes);
        }
    }

    public String toString() {
        return this.toString;
    }

    Object writeReplace() {
        return new SerializedForm(this.prototype.getAlgorithm(), this.bytes, this.toString);
    }

    private static final class MessageDigestHasher
    extends AbstractByteHasher {
        private final int bytes;
        private final MessageDigest digest;
        private boolean done;

        private MessageDigestHasher(MessageDigest messageDigest, int n2) {
            this.digest = messageDigest;
            this.bytes = n2;
        }

        private void checkNotDone() {
            Preconditions.checkState(this.done ^ true, "Cannot re-use a Hasher after calling hash() on it");
        }

        public HashCode hash() {
            this.checkNotDone();
            this.done = true;
            HashCode hashCode = this.bytes == this.digest.getDigestLength() ? HashCode.fromBytesNoCopy(this.digest.digest()) : HashCode.fromBytesNoCopy(Arrays.copyOf(this.digest.digest(), this.bytes));
            return hashCode;
        }

        protected void update(byte by2) {
            this.checkNotDone();
            this.digest.update(by2);
        }

        protected void update(ByteBuffer byteBuffer) {
            this.checkNotDone();
            this.digest.update(byteBuffer);
        }

        protected void update(byte[] byArray, int n2, int n3) {
            this.checkNotDone();
            this.digest.update(byArray, n2, n3);
        }
    }

    private static final class SerializedForm
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final String algorithmName;
        private final int bytes;
        private final String toString;

        private SerializedForm(String string2, int n2, String string3) {
            this.algorithmName = string2;
            this.bytes = n2;
            this.toString = string3;
        }

        private Object readResolve() {
            return new MessageDigestHashFunction(this.algorithmName, this.bytes, this.toString);
        }
    }
}

