/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractCompositeHashFunction;
import com.google.common.hash.ChecksumHashFunction;
import com.google.common.hash.Crc32cHashFunction;
import com.google.common.hash.FarmHashFingerprint64;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.ImmutableSupplier;
import com.google.common.hash.MacHashFunction;
import com.google.common.hash.MessageDigestHashFunction;
import com.google.common.hash.Murmur3_128HashFunction;
import com.google.common.hash.Murmur3_32HashFunction;
import com.google.common.hash.SipHashFunction;
import com.google.errorprone.annotations.Immutable;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import javax.crypto.spec.SecretKeySpec;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Hashing {
    static final int GOOD_FAST_HASH_SEED = (int)System.currentTimeMillis();

    private Hashing() {
    }

    public static HashFunction adler32() {
        return ChecksumType.ADLER_32.hashFunction;
    }

    static int checkPositiveAndMakeMultipleOf32(int n2) {
        boolean bl = n2 > 0;
        Preconditions.checkArgument(bl, "Number of bits must be positive");
        return n2 + 31 & 0xFFFFFFE0;
    }

    public static HashCode combineOrdered(Iterable<HashCode> object) {
        Object object2 = object.iterator();
        Preconditions.checkArgument(object2.hasNext(), "Must be at least 1 hash code to combine.");
        object2 = new byte[object2.next().bits() / 8];
        Iterator<HashCode> iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            object = iterator2.next().asBytes();
            int n2 = ((Object)object).length;
            int n3 = ((Object)object2).length;
            boolean bl = n2 == n3;
            Preconditions.checkArgument(bl, "All hashcodes must have the same bit length.");
            for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                object2[i2] = (byte)(object2[i2] * 37 ^ object[i2]);
            }
        }
        return HashCode.fromBytesNoCopy((byte[])object2);
    }

    public static HashCode combineUnordered(Iterable<HashCode> object) {
        Object object2 = object.iterator();
        Preconditions.checkArgument(object2.hasNext(), "Must be at least 1 hash code to combine.");
        object2 = new byte[object2.next().bits() / 8];
        object = object.iterator();
        while (object.hasNext()) {
            byte[] byArray = ((HashCode)object.next()).asBytes();
            int n2 = byArray.length;
            int n3 = ((Object)object2).length;
            boolean bl = n2 == n3;
            Preconditions.checkArgument(bl, "All hashcodes must have the same bit length.");
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                object2[i2] = (byte)(object2[i2] + byArray[i2]);
            }
        }
        return HashCode.fromBytesNoCopy((byte[])object2);
    }

    public static HashFunction concatenating(HashFunction hashFunction, HashFunction hashFunction2, HashFunction ... hashFunctionArray) {
        ArrayList<HashFunction> arrayList = new ArrayList<HashFunction>();
        arrayList.add(hashFunction);
        arrayList.add(hashFunction2);
        arrayList.addAll(Arrays.asList(hashFunctionArray));
        return new ConcatenatedHashFunction(arrayList.toArray(new HashFunction[0]));
    }

    public static HashFunction concatenating(Iterable<HashFunction> object) {
        Preconditions.checkNotNull(object);
        ArrayList<HashFunction> arrayList = new ArrayList<HashFunction>();
        object = object.iterator();
        while (object.hasNext()) {
            arrayList.add((HashFunction)object.next());
        }
        boolean bl = arrayList.size() > 0;
        Preconditions.checkArgument(bl, "number of hash functions (%s) must be > 0", arrayList.size());
        return new ConcatenatedHashFunction(arrayList.toArray(new HashFunction[0]));
    }

    public static int consistentHash(long l2, int n2) {
        int n3 = 0;
        boolean bl = n2 > 0;
        Preconditions.checkArgument(bl, "buckets must be positive: %s", n2);
        LinearCongruentialGenerator linearCongruentialGenerator = new LinearCongruentialGenerator(l2);
        while (true) {
            double d2 = n3 + 1;
            double d3 = linearCongruentialGenerator.nextDouble();
            Double.isNaN(d2);
            int n4 = (int)(d2 / d3);
            if (n4 < 0 || n4 >= n2) break;
            n3 = n4;
        }
        return n3;
    }

    public static int consistentHash(HashCode hashCode, int n2) {
        return Hashing.consistentHash(hashCode.padToLong(), n2);
    }

    public static HashFunction crc32() {
        return ChecksumType.CRC_32.hashFunction;
    }

    public static HashFunction crc32c() {
        return Crc32cHashFunction.CRC_32_C;
    }

    public static HashFunction farmHashFingerprint64() {
        return FarmHashFingerprint64.FARMHASH_FINGERPRINT_64;
    }

    public static HashFunction goodFastHash(int n2) {
        if ((n2 = Hashing.checkPositiveAndMakeMultipleOf32(n2)) == 32) {
            return Murmur3_32HashFunction.GOOD_FAST_HASH_32;
        }
        if (n2 <= 128) {
            return Murmur3_128HashFunction.GOOD_FAST_HASH_128;
        }
        int n3 = (n2 + 127) / 128;
        HashFunction[] hashFunctionArray = new HashFunction[n3];
        hashFunctionArray[0] = Murmur3_128HashFunction.GOOD_FAST_HASH_128;
        int n4 = GOOD_FAST_HASH_SEED;
        for (n2 = 1; n2 < n3; ++n2) {
            hashFunctionArray[n2] = Hashing.murmur3_128(n4 += 1500450271);
        }
        return new ConcatenatedHashFunction(hashFunctionArray);
    }

    public static HashFunction hmacMd5(Key key) {
        return new MacHashFunction("HmacMD5", key, Hashing.hmacToString("hmacMd5", key));
    }

    public static HashFunction hmacMd5(byte[] byArray) {
        return Hashing.hmacMd5(new SecretKeySpec(Preconditions.checkNotNull(byArray), "HmacMD5"));
    }

    public static HashFunction hmacSha1(Key key) {
        return new MacHashFunction("HmacSHA1", key, Hashing.hmacToString("hmacSha1", key));
    }

    public static HashFunction hmacSha1(byte[] byArray) {
        return Hashing.hmacSha1(new SecretKeySpec(Preconditions.checkNotNull(byArray), "HmacSHA1"));
    }

    public static HashFunction hmacSha256(Key key) {
        return new MacHashFunction("HmacSHA256", key, Hashing.hmacToString("hmacSha256", key));
    }

    public static HashFunction hmacSha256(byte[] byArray) {
        return Hashing.hmacSha256(new SecretKeySpec(Preconditions.checkNotNull(byArray), "HmacSHA256"));
    }

    public static HashFunction hmacSha512(Key key) {
        return new MacHashFunction("HmacSHA512", key, Hashing.hmacToString("hmacSha512", key));
    }

    public static HashFunction hmacSha512(byte[] byArray) {
        return Hashing.hmacSha512(new SecretKeySpec(Preconditions.checkNotNull(byArray), "HmacSHA512"));
    }

    private static String hmacToString(String string2, Key key) {
        return String.format("Hashing.%s(Key[algorithm=%s, format=%s])", string2, key.getAlgorithm(), key.getFormat());
    }

    @Deprecated
    public static HashFunction md5() {
        return Md5Holder.MD5;
    }

    public static HashFunction murmur3_128() {
        return Murmur3_128HashFunction.MURMUR3_128;
    }

    public static HashFunction murmur3_128(int n2) {
        return new Murmur3_128HashFunction(n2);
    }

    public static HashFunction murmur3_32() {
        return Murmur3_32HashFunction.MURMUR3_32;
    }

    public static HashFunction murmur3_32(int n2) {
        return new Murmur3_32HashFunction(n2);
    }

    @Deprecated
    public static HashFunction sha1() {
        return Sha1Holder.SHA_1;
    }

    public static HashFunction sha256() {
        return Sha256Holder.SHA_256;
    }

    public static HashFunction sha384() {
        return Sha384Holder.SHA_384;
    }

    public static HashFunction sha512() {
        return Sha512Holder.SHA_512;
    }

    public static HashFunction sipHash24() {
        return SipHashFunction.SIP_HASH_24;
    }

    public static HashFunction sipHash24(long l2, long l3) {
        return new SipHashFunction(2, 4, l2, l3);
    }

    @Immutable
    static enum ChecksumType implements ImmutableSupplier<Checksum>
    {
        CRC_32("Hashing.crc32()"){

            @Override
            public Checksum get() {
                return new CRC32();
            }
        }
        ,
        ADLER_32("Hashing.adler32()"){

            @Override
            public Checksum get() {
                return new Adler32();
            }
        };

        public final HashFunction hashFunction;

        private ChecksumType(String string3) {
            this.hashFunction = new ChecksumHashFunction(this, 32, string3);
        }
    }

    private static final class ConcatenatedHashFunction
    extends AbstractCompositeHashFunction {
        private ConcatenatedHashFunction(HashFunction ... hashFunctionArray) {
            super(hashFunctionArray);
            for (HashFunction hashFunction : hashFunctionArray) {
                boolean bl = hashFunction.bits() % 8 == 0;
                Preconditions.checkArgument(bl, "the number of bits (%s) in hashFunction (%s) must be divisible by 8", hashFunction.bits(), (Object)hashFunction);
            }
        }

        @Override
        public int bits() {
            HashFunction[] hashFunctionArray = this.functions;
            int n2 = hashFunctionArray.length;
            int n3 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                n3 += hashFunctionArray[i2].bits();
            }
            return n3;
        }

        public boolean equals(@NullableDecl Object object) {
            if (object instanceof ConcatenatedHashFunction) {
                object = (ConcatenatedHashFunction)object;
                return Arrays.equals(this.functions, ((ConcatenatedHashFunction)object).functions);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.functions);
        }

        @Override
        HashCode makeHash(Hasher[] hasherArray) {
            byte[] byArray = new byte[this.bits() / 8];
            int n2 = hasherArray.length;
            int n3 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                HashCode hashCode = hasherArray[i2].hash();
                n3 += hashCode.writeBytesTo(byArray, n3, hashCode.bits() / 8);
            }
            return HashCode.fromBytesNoCopy(byArray);
        }
    }

    private static final class LinearCongruentialGenerator {
        private long state;

        public LinearCongruentialGenerator(long l2) {
            this.state = l2;
        }

        public double nextDouble() {
            this.state = this.state * 2862933555777941757L + 1L;
            double d2 = (int)(this.state >>> 33) + 1;
            Double.isNaN(d2);
            return d2 / 2.147483648E9;
        }
    }

    private static class Md5Holder {
        static final HashFunction MD5 = new MessageDigestHashFunction("MD5", "Hashing.md5()");

        private Md5Holder() {
        }
    }

    private static class Sha1Holder {
        static final HashFunction SHA_1 = new MessageDigestHashFunction("SHA-1", "Hashing.sha1()");

        private Sha1Holder() {
        }
    }

    private static class Sha256Holder {
        static final HashFunction SHA_256 = new MessageDigestHashFunction("SHA-256", "Hashing.sha256()");

        private Sha256Holder() {
        }
    }

    private static class Sha384Holder {
        static final HashFunction SHA_384 = new MessageDigestHashFunction("SHA-384", "Hashing.sha384()");

        private Sha384Holder() {
        }
    }

    private static class Sha512Holder {
        static final HashFunction SHA_512 = new MessageDigestHashFunction("SHA-512", "Hashing.sha512()");

        private Sha512Holder() {
        }
    }
}

