/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.common.primitives.UnsignedInts;
import java.io.Serializable;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class HashCode {
    private static final char[] hexDigits = "0123456789abcdef".toCharArray();

    HashCode() {
    }

    private static int decode(char c2) {
        if (c2 >= '0' && c2 <= '9') {
            return c2 - 48;
        }
        if (c2 >= 'a' && c2 <= 'f') {
            return c2 - 97 + 10;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Illegal hexadecimal character: ");
        stringBuilder.append(c2);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public static HashCode fromBytes(byte[] byArray) {
        int n2 = byArray.length;
        boolean bl = true;
        if (n2 < 1) {
            bl = false;
        }
        Preconditions.checkArgument(bl, "A HashCode must contain at least 1 byte.");
        return HashCode.fromBytesNoCopy((byte[])byArray.clone());
    }

    static HashCode fromBytesNoCopy(byte[] byArray) {
        return new BytesHashCode(byArray);
    }

    public static HashCode fromInt(int n2) {
        return new IntHashCode(n2);
    }

    public static HashCode fromLong(long l2) {
        return new LongHashCode(l2);
    }

    public static HashCode fromString(String string2) {
        int n2 = string2.length();
        boolean bl = true;
        boolean bl2 = n2 >= 2;
        Preconditions.checkArgument(bl2, "input string (%s) must have at least 2 characters", (Object)string2);
        bl2 = string2.length() % 2 == 0 ? bl : false;
        Preconditions.checkArgument(bl2, "input string (%s) must have an even number of characters", (Object)string2);
        byte[] byArray = new byte[string2.length() / 2];
        for (int i2 = 0; i2 < string2.length(); i2 += 2) {
            n2 = HashCode.decode(string2.charAt(i2));
            int n3 = HashCode.decode(string2.charAt(i2 + 1));
            byArray[i2 / 2] = (byte)((n2 << 4) + n3);
        }
        return HashCode.fromBytesNoCopy(byArray);
    }

    public abstract byte[] asBytes();

    public abstract int asInt();

    public abstract long asLong();

    public abstract int bits();

    public final boolean equals(@NullableDecl Object object) {
        boolean bl;
        boolean bl2 = object instanceof HashCode;
        boolean bl3 = bl = false;
        if (bl2) {
            object = (HashCode)object;
            bl3 = bl;
            if (this.bits() == ((HashCode)object).bits()) {
                bl3 = bl;
                if (this.equalsSameBits((HashCode)object)) {
                    bl3 = true;
                }
            }
        }
        return bl3;
    }

    abstract boolean equalsSameBits(HashCode var1);

    byte[] getBytesInternal() {
        return this.asBytes();
    }

    public final int hashCode() {
        if (this.bits() >= 32) {
            return this.asInt();
        }
        byte[] byArray = this.getBytesInternal();
        int n2 = byArray[0] & 0xFF;
        for (int i2 = 1; i2 < byArray.length; ++i2) {
            n2 |= (byArray[i2] & 0xFF) << i2 * 8;
        }
        return n2;
    }

    public abstract long padToLong();

    public final String toString() {
        byte[] byArray = this.getBytesInternal();
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        for (byte by2 : byArray) {
            stringBuilder.append(hexDigits[by2 >> 4 & 0xF]);
            stringBuilder.append(hexDigits[by2 & 0xF]);
        }
        return stringBuilder.toString();
    }

    public int writeBytesTo(byte[] byArray, int n2, int n3) {
        n3 = Ints.min(n3, this.bits() / 8);
        Preconditions.checkPositionIndexes(n2, n2 + n3, byArray.length);
        this.writeBytesToImpl(byArray, n2, n3);
        return n3;
    }

    abstract void writeBytesToImpl(byte[] var1, int var2, int var3);

    private static final class BytesHashCode
    extends HashCode
    implements Serializable {
        private static final long serialVersionUID = 0L;
        final byte[] bytes;

        BytesHashCode(byte[] byArray) {
            this.bytes = Preconditions.checkNotNull(byArray);
        }

        @Override
        public byte[] asBytes() {
            return (byte[])this.bytes.clone();
        }

        @Override
        public int asInt() {
            boolean bl = this.bytes.length >= 4;
            Preconditions.checkState(bl, "HashCode#asInt() requires >= 4 bytes (it only has %s bytes).", this.bytes.length);
            byte[] byArray = this.bytes;
            byte by2 = byArray[0];
            byte by3 = byArray[1];
            byte by4 = byArray[2];
            return (byArray[3] & 0xFF) << 24 | ((by3 & 0xFF) << 8 | by2 & 0xFF | (by4 & 0xFF) << 16);
        }

        @Override
        public long asLong() {
            boolean bl = this.bytes.length >= 8;
            Preconditions.checkState(bl, "HashCode#asLong() requires >= 8 bytes (it only has %s bytes).", this.bytes.length);
            return this.padToLong();
        }

        @Override
        public int bits() {
            return this.bytes.length * 8;
        }

        @Override
        boolean equalsSameBits(HashCode hashCode) {
            byte[] byArray;
            if (this.bytes.length != hashCode.getBytesInternal().length) {
                return false;
            }
            boolean bl = true;
            for (int i2 = 0; i2 < (byArray = this.bytes).length; ++i2) {
                boolean bl2 = byArray[i2] == hashCode.getBytesInternal()[i2];
                bl &= bl2;
            }
            return bl;
        }

        @Override
        byte[] getBytesInternal() {
            return this.bytes;
        }

        @Override
        public long padToLong() {
            long l2 = this.bytes[0] & 0xFF;
            for (int i2 = 1; i2 < Math.min(this.bytes.length, 8); ++i2) {
                l2 |= ((long)this.bytes[i2] & 0xFFL) << i2 * 8;
            }
            return l2;
        }

        @Override
        void writeBytesToImpl(byte[] byArray, int n2, int n3) {
            System.arraycopy(this.bytes, 0, byArray, n2, n3);
        }
    }

    private static final class IntHashCode
    extends HashCode
    implements Serializable {
        private static final long serialVersionUID = 0L;
        final int hash;

        IntHashCode(int n2) {
            this.hash = n2;
        }

        @Override
        public byte[] asBytes() {
            int n2 = this.hash;
            return new byte[]{(byte)n2, (byte)(n2 >> 8), (byte)(n2 >> 16), (byte)(n2 >> 24)};
        }

        @Override
        public int asInt() {
            return this.hash;
        }

        @Override
        public long asLong() {
            throw new IllegalStateException("this HashCode only has 32 bits; cannot create a long");
        }

        @Override
        public int bits() {
            return 32;
        }

        @Override
        boolean equalsSameBits(HashCode hashCode) {
            boolean bl = this.hash == hashCode.asInt();
            return bl;
        }

        @Override
        public long padToLong() {
            return UnsignedInts.toLong((int)this.hash);
        }

        @Override
        void writeBytesToImpl(byte[] byArray, int n2, int n3) {
            for (int i2 = 0; i2 < n3; ++i2) {
                byArray[n2 + i2] = (byte)(this.hash >> i2 * 8);
            }
        }
    }

    private static final class LongHashCode
    extends HashCode
    implements Serializable {
        private static final long serialVersionUID = 0L;
        final long hash;

        LongHashCode(long l2) {
            this.hash = l2;
        }

        @Override
        public byte[] asBytes() {
            long l2 = this.hash;
            return new byte[]{(byte)l2, (byte)(l2 >> 8), (byte)(l2 >> 16), (byte)(l2 >> 24), (byte)(l2 >> 32), (byte)(l2 >> 40), (byte)(l2 >> 48), (byte)(l2 >> 56)};
        }

        @Override
        public int asInt() {
            return (int)this.hash;
        }

        @Override
        public long asLong() {
            return this.hash;
        }

        @Override
        public int bits() {
            return 64;
        }

        @Override
        boolean equalsSameBits(HashCode hashCode) {
            boolean bl = this.hash == hashCode.asLong();
            return bl;
        }

        @Override
        public long padToLong() {
            return this.hash;
        }

        @Override
        void writeBytesToImpl(byte[] byArray, int n2, int n3) {
            for (int i2 = 0; i2 < n3; ++i2) {
                byArray[n2 + i2] = (byte)(this.hash >> i2 * 8);
            }
        }
    }
}

