/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Funnels {
    private Funnels() {
    }

    public static OutputStream asOutputStream(PrimitiveSink primitiveSink) {
        return new SinkAsStream(primitiveSink);
    }

    public static Funnel<byte[]> byteArrayFunnel() {
        return ByteArrayFunnel.INSTANCE;
    }

    public static Funnel<Integer> integerFunnel() {
        return IntegerFunnel.INSTANCE;
    }

    public static Funnel<Long> longFunnel() {
        return LongFunnel.INSTANCE;
    }

    public static <E> Funnel<Iterable<? extends E>> sequentialFunnel(Funnel<E> funnel) {
        return new SequentialFunnel<E>(funnel);
    }

    public static Funnel<CharSequence> stringFunnel(Charset charset) {
        return new StringCharsetFunnel(charset);
    }

    public static Funnel<CharSequence> unencodedCharsFunnel() {
        return UnencodedCharsFunnel.INSTANCE;
    }

    private static enum ByteArrayFunnel implements Funnel<byte[]>
    {
        INSTANCE;


        @Override
        public void funnel(byte[] byArray, PrimitiveSink primitiveSink) {
            primitiveSink.putBytes(byArray);
        }

        public String toString() {
            return "Funnels.byteArrayFunnel()";
        }
    }

    private static enum IntegerFunnel implements Funnel<Integer>
    {
        INSTANCE;


        @Override
        public void funnel(Integer n2, PrimitiveSink primitiveSink) {
            primitiveSink.putInt(n2.intValue());
        }

        public String toString() {
            return "Funnels.integerFunnel()";
        }
    }

    private static enum LongFunnel implements Funnel<Long>
    {
        INSTANCE;


        @Override
        public void funnel(Long l2, PrimitiveSink primitiveSink) {
            primitiveSink.putLong(l2.longValue());
        }

        public String toString() {
            return "Funnels.longFunnel()";
        }
    }

    private static class SequentialFunnel<E>
    implements Funnel<Iterable<? extends E>>,
    Serializable {
        private final Funnel<E> elementFunnel;

        SequentialFunnel(Funnel<E> funnel) {
            this.elementFunnel = Preconditions.checkNotNull(funnel);
        }

        public boolean equals(@NullableDecl Object object) {
            if (object instanceof SequentialFunnel) {
                object = (SequentialFunnel)object;
                return this.elementFunnel.equals(((SequentialFunnel)object).elementFunnel);
            }
            return false;
        }

        @Override
        public void funnel(Iterable<? extends E> iterable2, PrimitiveSink primitiveSink) {
            for (Iterable<E> iterable2 : iterable2) {
                this.elementFunnel.funnel(iterable2, primitiveSink);
            }
        }

        public int hashCode() {
            return SequentialFunnel.class.hashCode() ^ this.elementFunnel.hashCode();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Funnels.sequentialFunnel(");
            stringBuilder.append(this.elementFunnel);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }

    private static class SinkAsStream
    extends OutputStream {
        final PrimitiveSink sink;

        SinkAsStream(PrimitiveSink primitiveSink) {
            this.sink = Preconditions.checkNotNull(primitiveSink);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Funnels.asOutputStream(");
            stringBuilder.append(this.sink);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        @Override
        public void write(int n2) {
            this.sink.putByte((byte)n2);
        }

        @Override
        public void write(byte[] byArray) {
            this.sink.putBytes(byArray);
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) {
            this.sink.putBytes(byArray, n2, n3);
        }
    }

    private static class StringCharsetFunnel
    implements Funnel<CharSequence>,
    Serializable {
        private final Charset charset;

        StringCharsetFunnel(Charset charset) {
            this.charset = Preconditions.checkNotNull(charset);
        }

        public boolean equals(@NullableDecl Object object) {
            if (object instanceof StringCharsetFunnel) {
                object = (StringCharsetFunnel)object;
                return this.charset.equals(((StringCharsetFunnel)object).charset);
            }
            return false;
        }

        @Override
        public void funnel(CharSequence charSequence, PrimitiveSink primitiveSink) {
            primitiveSink.putString(charSequence, this.charset);
        }

        public int hashCode() {
            return StringCharsetFunnel.class.hashCode() ^ this.charset.hashCode();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Funnels.stringFunnel(");
            stringBuilder.append(this.charset.name());
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        Object writeReplace() {
            return new SerializedForm(this.charset);
        }

        private static class SerializedForm
        implements Serializable {
            private static final long serialVersionUID = 0L;
            private final String charsetCanonicalName;

            SerializedForm(Charset charset) {
                this.charsetCanonicalName = charset.name();
            }

            private Object readResolve() {
                return Funnels.stringFunnel(Charset.forName(this.charsetCanonicalName));
            }
        }
    }

    private static enum UnencodedCharsFunnel implements Funnel<CharSequence>
    {
        INSTANCE;


        @Override
        public void funnel(CharSequence charSequence, PrimitiveSink primitiveSink) {
            primitiveSink.putUnencodedChars(charSequence);
        }

        public String toString() {
            return "Funnels.unencodedCharsFunnel()";
        }
    }
}

