/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Hashing;
import com.google.common.hash.LongAddable;
import com.google.common.hash.LongAddables;
import com.google.common.math.LongMath;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLongArray;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

enum BloomFilterStrategies implements BloomFilter.Strategy
{
    MURMUR128_MITZ_32{

        @Override
        public <T> boolean mightContain(T t2, Funnel<? super T> funnel, int n2, LockFreeBitArray lockFreeBitArray) {
            long l2 = lockFreeBitArray.bitSize();
            long l3 = Hashing.murmur3_128().hashObject(t2, funnel).asLong();
            int n3 = (int)l3;
            int n4 = (int)(l3 >>> 32);
            for (int i2 = 1; i2 <= n2; ++i2) {
                int n5;
                int n6 = n5 = i2 * n4 + n3;
                if (n5 < 0) {
                    n6 = ~n5;
                }
                if (lockFreeBitArray.get((long)n6 % l2)) continue;
                return false;
            }
            return true;
        }

        @Override
        public <T> boolean put(T t2, Funnel<? super T> funnel, int n2, LockFreeBitArray lockFreeBitArray) {
            long l2 = lockFreeBitArray.bitSize();
            long l3 = Hashing.murmur3_128().hashObject(t2, funnel).asLong();
            int n3 = (int)l3;
            int n4 = (int)(l3 >>> 32);
            boolean bl = false;
            for (int i2 = 1; i2 <= n2; ++i2) {
                int n5;
                int n6 = n5 = i2 * n4 + n3;
                if (n5 < 0) {
                    n6 = ~n5;
                }
                bl |= lockFreeBitArray.set((long)n6 % l2);
            }
            return bl;
        }
    }
    ,
    MURMUR128_MITZ_64{

        private long lowerEight(byte[] byArray) {
            return Longs.fromBytes(byArray[7], byArray[6], byArray[5], byArray[4], byArray[3], byArray[2], byArray[1], byArray[0]);
        }

        private long upperEight(byte[] byArray) {
            return Longs.fromBytes(byArray[15], byArray[14], byArray[13], byArray[12], byArray[11], byArray[10], byArray[9], byArray[8]);
        }

        @Override
        public <T> boolean mightContain(T object, Funnel<? super T> funnel, int n2, LockFreeBitArray lockFreeBitArray) {
            long l2 = lockFreeBitArray.bitSize();
            object = Hashing.murmur3_128().hashObject(object, funnel).getBytesInternal();
            long l3 = this.lowerEight((byte[])object);
            long l4 = this.upperEight((byte[])object);
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!lockFreeBitArray.get((Long.MAX_VALUE & l3) % l2)) {
                    return false;
                }
                l3 += l4;
            }
            return true;
        }

        @Override
        public <T> boolean put(T object, Funnel<? super T> funnel, int n2, LockFreeBitArray lockFreeBitArray) {
            long l2 = lockFreeBitArray.bitSize();
            object = Hashing.murmur3_128().hashObject(object, funnel).getBytesInternal();
            long l3 = this.lowerEight((byte[])object);
            long l4 = this.upperEight((byte[])object);
            boolean bl = false;
            for (int i2 = 0; i2 < n2; ++i2) {
                bl |= lockFreeBitArray.set((Long.MAX_VALUE & l3) % l2);
                l3 += l4;
            }
            return bl;
        }
    };


    static final class LockFreeBitArray {
        private static final int LONG_ADDRESSABLE_BITS = 6;
        private final LongAddable bitCount;
        final AtomicLongArray data;

        LockFreeBitArray(long l2) {
            this(new long[Ints.checkedCast(LongMath.divide((long)l2, (long)64L, (RoundingMode)RoundingMode.CEILING))]);
        }

        LockFreeBitArray(long[] lArray) {
            int n2 = lArray.length;
            boolean bl = n2 > 0;
            Preconditions.checkArgument(bl, "data length is zero!");
            this.data = new AtomicLongArray(lArray);
            this.bitCount = LongAddables.create();
            long l2 = 0L;
            n2 = lArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                l2 += (long)Long.bitCount(lArray[i2]);
            }
            this.bitCount.add(l2);
        }

        public static long[] toPlainArray(AtomicLongArray atomicLongArray) {
            long[] lArray = new long[atomicLongArray.length()];
            for (int i2 = 0; i2 < lArray.length; ++i2) {
                lArray[i2] = atomicLongArray.get(i2);
            }
            return lArray;
        }

        long bitCount() {
            return this.bitCount.sum();
        }

        long bitSize() {
            return (long)this.data.length() * 64L;
        }

        LockFreeBitArray copy() {
            return new LockFreeBitArray(LockFreeBitArray.toPlainArray(this.data));
        }

        public boolean equals(@NullableDecl Object object) {
            if (object instanceof LockFreeBitArray) {
                object = (LockFreeBitArray)object;
                return Arrays.equals(LockFreeBitArray.toPlainArray(this.data), LockFreeBitArray.toPlainArray(((LockFreeBitArray)object).data));
            }
            return false;
        }

        boolean get(long l2) {
            long l3 = this.data.get((int)(l2 >>> 6));
            boolean bl = (1L << (int)l2 & l3) != 0L;
            return bl;
        }

        public int hashCode() {
            return Arrays.hashCode(LockFreeBitArray.toPlainArray(this.data));
        }

        void putAll(LockFreeBitArray lockFreeBitArray) {
            boolean bl = this.data.length() == lockFreeBitArray.data.length();
            Preconditions.checkArgument(bl, "BitArrays must be of equal length (%s != %s)", this.data.length(), lockFreeBitArray.data.length());
            for (int i2 = 0; i2 < this.data.length(); ++i2) {
                int n2;
                long l2;
                long l3;
                block2: {
                    long l4 = lockFreeBitArray.data.get(i2);
                    do {
                        if ((l3 = this.data.get(i2)) != (l2 = l3 | l4)) continue;
                        n2 = 0;
                        break block2;
                    } while (!this.data.compareAndSet(i2, l3, l2));
                    n2 = 1;
                }
                if (n2 == 0) continue;
                n2 = Long.bitCount(l2);
                int n3 = Long.bitCount(l3);
                this.bitCount.add((long)(n2 - n3));
            }
        }

        boolean set(long l2) {
            long l3;
            if (this.get(l2)) {
                return false;
            }
            int n2 = (int)(l2 >>> 6);
            int n3 = (int)l2;
            do {
                if ((l2 = this.data.get(n2)) != (l3 = l2 | 1L << n3)) continue;
                return false;
            } while (!this.data.compareAndSet(n2, l2, l3));
            this.bitCount.increment();
            return true;
        }
    }
}

