/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.hash.BloomFilterStrategies;
import com.google.common.hash.Funnel;
import com.google.common.math.DoubleMath;
import com.google.common.primitives.SignedBytes;
import com.google.common.primitives.UnsignedBytes;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.RoundingMode;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class BloomFilter<T>
implements Predicate<T>,
Serializable {
    private final BloomFilterStrategies.LockFreeBitArray bits;
    private final Funnel<? super T> funnel;
    private final int numHashFunctions;
    private final Strategy strategy;

    private BloomFilter(BloomFilterStrategies.LockFreeBitArray lockFreeBitArray, int n2, Funnel<? super T> funnel, Strategy strategy) {
        boolean bl = true;
        boolean bl2 = n2 > 0;
        Preconditions.checkArgument(bl2, "numHashFunctions (%s) must be > 0", n2);
        bl2 = n2 <= 255 ? bl : false;
        Preconditions.checkArgument(bl2, "numHashFunctions (%s) must be <= 255", n2);
        this.bits = Preconditions.checkNotNull(lockFreeBitArray);
        this.numHashFunctions = n2;
        this.funnel = Preconditions.checkNotNull(funnel);
        this.strategy = Preconditions.checkNotNull(strategy);
    }

    public static <T> BloomFilter<T> create(Funnel<? super T> funnel, int n2) {
        return BloomFilter.create(funnel, (long)n2);
    }

    public static <T> BloomFilter<T> create(Funnel<? super T> funnel, int n2, double d2) {
        return BloomFilter.create(funnel, (long)n2, d2);
    }

    public static <T> BloomFilter<T> create(Funnel<? super T> funnel, long l2) {
        return BloomFilter.create(funnel, l2, 0.03);
    }

    public static <T> BloomFilter<T> create(Funnel<? super T> funnel, long l2, double d2) {
        return BloomFilter.create(funnel, l2, d2, BloomFilterStrategies.MURMUR128_MITZ_64);
    }

    static <T> BloomFilter<T> create(Funnel<? super T> serializable, long l2, double d2, Strategy strategy) {
        Preconditions.checkNotNull(serializable);
        boolean bl = true;
        boolean bl2 = l2 >= 0L;
        Preconditions.checkArgument(bl2, "Expected insertions (%s) must be >= 0", l2);
        bl2 = d2 > 0.0;
        Preconditions.checkArgument(bl2, "False positive probability (%s) must be > 0.0", (Object)d2);
        bl2 = d2 < 1.0 ? bl : false;
        Preconditions.checkArgument(bl2, "False positive probability (%s) must be < 1.0", (Object)d2);
        Preconditions.checkNotNull(strategy);
        long l3 = l2;
        if (l2 == 0L) {
            l3 = 1L;
        }
        l2 = BloomFilter.optimalNumOfBits(l3, d2);
        int n2 = BloomFilter.optimalNumOfHashFunctions(l3, l2);
        try {
            BloomFilterStrategies.LockFreeBitArray lockFreeBitArray = new BloomFilterStrategies.LockFreeBitArray(l2);
            serializable = new BloomFilter<T>(lockFreeBitArray, n2, serializable, strategy);
            return serializable;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            serializable = new StringBuilder();
            ((StringBuilder)serializable).append("Could not create BloomFilter of ");
            ((StringBuilder)serializable).append(l2);
            ((StringBuilder)serializable).append(" bits");
            throw new IllegalArgumentException(((StringBuilder)serializable).toString(), illegalArgumentException);
        }
    }

    static long optimalNumOfBits(long l2, double d2) {
        double d3 = d2;
        if (d2 == 0.0) {
            d3 = Double.MIN_VALUE;
        }
        d2 = -l2;
        d3 = Math.log(d3);
        Double.isNaN(d2);
        return (long)(d2 * d3 / (Math.log(2.0) * Math.log(2.0)));
    }

    static int optimalNumOfHashFunctions(long l2, long l3) {
        double d2 = l3;
        double d3 = l2;
        Double.isNaN(d2);
        Double.isNaN(d3);
        return Math.max(1, (int)Math.round(d2 / d3 * Math.log(2.0)));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> BloomFilter<T> readFrom(InputStream bloomFilter, Funnel<? super T> serializable) throws IOException {
        IOException iOException;
        int n3;
        int n2;
        int n4;
        block9: {
            int n5;
            block8: {
                BloomFilterStrategies bloomFilterStrategies;
                int n6;
                Object object;
                Preconditions.checkNotNull(bloomFilter, "InputStream");
                Preconditions.checkNotNull(serializable, "Funnel");
                n5 = -1;
                try {
                    object = new DataInputStream((InputStream)((Object)bloomFilter));
                    n4 = ((DataInputStream)object).readByte();
                }
                catch (RuntimeException runtimeException) {
                    n2 = -1;
                    break block8;
                }
                try {
                    n3 = UnsignedBytes.toInt((byte)((DataInputStream)object).readByte());
                    n2 = n5;
                }
                catch (RuntimeException runtimeException) {
                    n2 = n4;
                    break block8;
                }
                try {
                    n2 = n6 = ((DataInputStream)object).readInt();
                    bloomFilterStrategies = BloomFilterStrategies.values()[n4];
                    n2 = n6;
                    bloomFilter = (BloomFilter<T>)new long[n6];
                    n5 = 0;
                    while (true) {
                        n2 = n6;
                        if (n5 >= ((Object)bloomFilter).length) break;
                        n2 = n6;
                        bloomFilter[n5] = ((DataInputStream)object).readLong();
                        ++n5;
                    }
                    n2 = n6;
                }
                catch (RuntimeException runtimeException) {
                    break block9;
                }
                {
                    n2 = n6;
                    object = new BloomFilterStrategies.LockFreeBitArray((long[])bloomFilter);
                    n2 = n6;
                    return new BloomFilter<T>((BloomFilterStrategies.LockFreeBitArray)object, n3, serializable, bloomFilterStrategies);
                }
            }
            n3 = -1;
            n4 = n2;
            n2 = n5;
        }
        serializable = new StringBuilder();
        ((StringBuilder)serializable).append("Unable to deserialize BloomFilter from InputStream. strategyOrdinal: ");
        ((StringBuilder)serializable).append(n4);
        ((StringBuilder)serializable).append(" numHashFunctions: ");
        ((StringBuilder)serializable).append(n3);
        ((StringBuilder)serializable).append(" dataLength: ");
        ((StringBuilder)serializable).append(n2);
        iOException = new IOException(((StringBuilder)serializable).toString(), iOException);
        throw iOException;
    }

    private Object writeReplace() {
        return new SerialForm(this);
    }

    @Override
    @Deprecated
    public boolean apply(T t2) {
        return this.mightContain(t2);
    }

    public long approximateElementCount() {
        long l2 = this.bits.bitSize();
        double d2 = this.bits.bitCount();
        double d3 = l2;
        Double.isNaN(d2);
        Double.isNaN(d3);
        double d4 = -Math.log1p(-(d2 / d3));
        Double.isNaN(d3);
        d2 = this.numHashFunctions;
        Double.isNaN(d2);
        return DoubleMath.roundToLong((double)(d4 * d3 / d2), (RoundingMode)RoundingMode.HALF_UP);
    }

    long bitSize() {
        return this.bits.bitSize();
    }

    public BloomFilter<T> copy() {
        return new BloomFilter<T>(this.bits.copy(), this.numHashFunctions, this.funnel, this.strategy);
    }

    @Override
    public boolean equals(@NullableDecl Object object) {
        boolean bl = true;
        if (object == this) {
            return true;
        }
        if (object instanceof BloomFilter) {
            object = (BloomFilter)object;
            if (!(this.numHashFunctions == ((BloomFilter)object).numHashFunctions && this.funnel.equals(((BloomFilter)object).funnel) && this.bits.equals(((BloomFilter)object).bits) && this.strategy.equals(((BloomFilter)object).strategy))) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public double expectedFpp() {
        double d2 = this.bits.bitCount();
        double d3 = this.bitSize();
        Double.isNaN(d2);
        Double.isNaN(d3);
        return Math.pow(d2 / d3, this.numHashFunctions);
    }

    public int hashCode() {
        return Objects.hashCode(this.numHashFunctions, this.funnel, this.strategy, this.bits);
    }

    public boolean isCompatible(BloomFilter<T> bloomFilter) {
        Preconditions.checkNotNull(bloomFilter);
        boolean bl = this != bloomFilter && this.numHashFunctions == bloomFilter.numHashFunctions && this.bitSize() == bloomFilter.bitSize() && this.strategy.equals(bloomFilter.strategy) && this.funnel.equals(bloomFilter.funnel);
        return bl;
    }

    public boolean mightContain(T t2) {
        return this.strategy.mightContain(t2, this.funnel, this.numHashFunctions, this.bits);
    }

    public boolean put(T t2) {
        return this.strategy.put(t2, this.funnel, this.numHashFunctions, this.bits);
    }

    public void putAll(BloomFilter<T> bloomFilter) {
        Preconditions.checkNotNull(bloomFilter);
        boolean bl = this != bloomFilter;
        Preconditions.checkArgument(bl, "Cannot combine a BloomFilter with itself.");
        bl = this.numHashFunctions == bloomFilter.numHashFunctions;
        Preconditions.checkArgument(bl, "BloomFilters must have the same number of hash functions (%s != %s)", this.numHashFunctions, bloomFilter.numHashFunctions);
        bl = this.bitSize() == bloomFilter.bitSize();
        Preconditions.checkArgument(bl, "BloomFilters must have the same size underlying bit arrays (%s != %s)", this.bitSize(), bloomFilter.bitSize());
        Preconditions.checkArgument(this.strategy.equals(bloomFilter.strategy), "BloomFilters must have equal strategies (%s != %s)", (Object)this.strategy, (Object)bloomFilter.strategy);
        Preconditions.checkArgument(this.funnel.equals(bloomFilter.funnel), "BloomFilters must have equal funnels (%s != %s)", this.funnel, bloomFilter.funnel);
        this.bits.putAll(bloomFilter.bits);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream = new DataOutputStream(outputStream);
        ((DataOutputStream)outputStream).writeByte(SignedBytes.checkedCast((long)this.strategy.ordinal()));
        ((DataOutputStream)outputStream).writeByte(UnsignedBytes.checkedCast((long)this.numHashFunctions));
        ((DataOutputStream)outputStream).writeInt(this.bits.data.length());
        for (int i2 = 0; i2 < this.bits.data.length(); ++i2) {
            ((DataOutputStream)outputStream).writeLong(this.bits.data.get(i2));
        }
    }

    private static class SerialForm<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final long[] data;
        final Funnel<? super T> funnel;
        final int numHashFunctions;
        final Strategy strategy;

        SerialForm(BloomFilter<T> bloomFilter) {
            this.data = BloomFilterStrategies.LockFreeBitArray.toPlainArray(((BloomFilter)bloomFilter).bits.data);
            this.numHashFunctions = ((BloomFilter)bloomFilter).numHashFunctions;
            this.funnel = ((BloomFilter)bloomFilter).funnel;
            this.strategy = ((BloomFilter)bloomFilter).strategy;
        }

        Object readResolve() {
            return new BloomFilter(new BloomFilterStrategies.LockFreeBitArray(this.data), this.numHashFunctions, this.funnel, this.strategy);
        }
    }

    static interface Strategy
    extends Serializable {
        public <T> boolean mightContain(T var1, Funnel<? super T> var2, int var3, BloomFilterStrategies.LockFreeBitArray var4);

        public int ordinal();

        public <T> boolean put(T var1, Funnel<? super T> var2, int var3, BloomFilterStrategies.LockFreeBitArray var4);
    }
}

