/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractHashFunction;
import com.google.common.hash.AbstractHasher;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.errorprone.annotations.Immutable;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Arrays;

@Immutable
abstract class AbstractNonStreamingHashFunction
extends AbstractHashFunction {
    AbstractNonStreamingHashFunction() {
    }

    @Override
    public HashCode hashBytes(ByteBuffer byteBuffer) {
        return this.newHasher(byteBuffer.remaining()).putBytes(byteBuffer).hash();
    }

    @Override
    public abstract HashCode hashBytes(byte[] var1, int var2, int var3);

    @Override
    public HashCode hashInt(int n2) {
        return this.hashBytes(ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(n2).array());
    }

    @Override
    public HashCode hashLong(long l2) {
        return this.hashBytes(ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(l2).array());
    }

    @Override
    public HashCode hashString(CharSequence charSequence, Charset charset) {
        return this.hashBytes(charSequence.toString().getBytes(charset));
    }

    @Override
    public HashCode hashUnencodedChars(CharSequence charSequence) {
        int n2 = charSequence.length();
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2 * 2).order(ByteOrder.LITTLE_ENDIAN);
        for (int i2 = 0; i2 < n2; ++i2) {
            byteBuffer.putChar(charSequence.charAt(i2));
        }
        return this.hashBytes(byteBuffer.array());
    }

    @Override
    public Hasher newHasher() {
        return this.newHasher(32);
    }

    @Override
    public Hasher newHasher(int n2) {
        boolean bl = n2 >= 0;
        Preconditions.checkArgument(bl);
        return new BufferingHasher(n2);
    }

    private final class BufferingHasher
    extends AbstractHasher {
        final ExposedByteArrayOutputStream stream;

        BufferingHasher(int n2) {
            this.stream = new ExposedByteArrayOutputStream(n2);
        }

        public HashCode hash() {
            return AbstractNonStreamingHashFunction.this.hashBytes(this.stream.byteArray(), 0, this.stream.length());
        }

        public Hasher putByte(byte by2) {
            this.stream.write(by2);
            return this;
        }

        public Hasher putBytes(ByteBuffer byteBuffer) {
            this.stream.write(byteBuffer);
            return this;
        }

        public Hasher putBytes(byte[] byArray, int n2, int n3) {
            this.stream.write(byArray, n2, n3);
            return this;
        }
    }

    private static final class ExposedByteArrayOutputStream
    extends ByteArrayOutputStream {
        ExposedByteArrayOutputStream(int n2) {
            super(n2);
        }

        byte[] byteArray() {
            return this.buf;
        }

        int length() {
            return this.count;
        }

        void write(ByteBuffer byteBuffer) {
            int n2 = byteBuffer.remaining();
            if (this.count + n2 > this.buf.length) {
                this.buf = Arrays.copyOf(this.buf, this.count + n2);
            }
            byteBuffer.get(this.buf, this.count, n2);
            this.count += n2;
        }
    }
}

