/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractHashFunction;
import com.google.common.hash.Funnel;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.errorprone.annotations.Immutable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

@Immutable
abstract class AbstractCompositeHashFunction
extends AbstractHashFunction {
    private static final long serialVersionUID = 0L;
    final HashFunction[] functions;

    AbstractCompositeHashFunction(HashFunction ... hashFunctionArray) {
        int n2 = hashFunctionArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Preconditions.checkNotNull(hashFunctionArray[i2]);
        }
        this.functions = hashFunctionArray;
    }

    private Hasher fromHashers(final Hasher[] hasherArray) {
        return new Hasher(){

            public HashCode hash() {
                return AbstractCompositeHashFunction.this.makeHash(hasherArray);
            }

            public Hasher putBoolean(boolean bl) {
                Hasher[] hasherArray2 = hasherArray;
                int n2 = hasherArray2.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    hasherArray2[i2].putBoolean(bl);
                }
                return this;
            }

            public Hasher putByte(byte by2) {
                Hasher[] hasherArray2 = hasherArray;
                int n2 = hasherArray2.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    hasherArray2[i2].putByte(by2);
                }
                return this;
            }

            public Hasher putBytes(ByteBuffer byteBuffer) {
                int n2 = byteBuffer.position();
                for (Hasher hasher : hasherArray) {
                    byteBuffer.position(n2);
                    hasher.putBytes(byteBuffer);
                }
                return this;
            }

            public Hasher putBytes(byte[] byArray) {
                Hasher[] hasherArray2 = hasherArray;
                int n2 = hasherArray2.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    hasherArray2[i2].putBytes(byArray);
                }
                return this;
            }

            public Hasher putBytes(byte[] byArray, int n2, int n3) {
                Hasher[] hasherArray2 = hasherArray;
                int n4 = hasherArray2.length;
                for (int i2 = 0; i2 < n4; ++i2) {
                    hasherArray2[i2].putBytes(byArray, n2, n3);
                }
                return this;
            }

            public Hasher putChar(char c2) {
                Hasher[] hasherArray2 = hasherArray;
                int n2 = hasherArray2.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    hasherArray2[i2].putChar(c2);
                }
                return this;
            }

            public Hasher putDouble(double d2) {
                Hasher[] hasherArray2 = hasherArray;
                int n2 = hasherArray2.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    hasherArray2[i2].putDouble(d2);
                }
                return this;
            }

            public Hasher putFloat(float f2) {
                Hasher[] hasherArray2 = hasherArray;
                int n2 = hasherArray2.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    hasherArray2[i2].putFloat(f2);
                }
                return this;
            }

            public Hasher putInt(int n2) {
                Hasher[] hasherArray2 = hasherArray;
                int n3 = hasherArray2.length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    hasherArray2[i2].putInt(n2);
                }
                return this;
            }

            public Hasher putLong(long l2) {
                Hasher[] hasherArray2 = hasherArray;
                int n2 = hasherArray2.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    hasherArray2[i2].putLong(l2);
                }
                return this;
            }

            public <T> Hasher putObject(T t2, Funnel<? super T> funnel) {
                Hasher[] hasherArray2 = hasherArray;
                int n2 = hasherArray2.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    hasherArray2[i2].putObject(t2, funnel);
                }
                return this;
            }

            public Hasher putShort(short s2) {
                Hasher[] hasherArray2 = hasherArray;
                int n2 = hasherArray2.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    hasherArray2[i2].putShort(s2);
                }
                return this;
            }

            public Hasher putString(CharSequence charSequence, Charset charset) {
                Hasher[] hasherArray2 = hasherArray;
                int n2 = hasherArray2.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    hasherArray2[i2].putString(charSequence, charset);
                }
                return this;
            }

            public Hasher putUnencodedChars(CharSequence charSequence) {
                Hasher[] hasherArray2 = hasherArray;
                int n2 = hasherArray2.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    hasherArray2[i2].putUnencodedChars(charSequence);
                }
                return this;
            }
        };
    }

    abstract HashCode makeHash(Hasher[] var1);

    @Override
    public Hasher newHasher() {
        Hasher[] hasherArray = new Hasher[this.functions.length];
        for (int i2 = 0; i2 < hasherArray.length; ++i2) {
            hasherArray[i2] = this.functions[i2].newHasher();
        }
        return this.fromHashers(hasherArray);
    }

    @Override
    public Hasher newHasher(int n2) {
        boolean bl = n2 >= 0;
        Preconditions.checkArgument(bl);
        Hasher[] hasherArray = new Hasher[this.functions.length];
        for (int i2 = 0; i2 < hasherArray.length; ++i2) {
            hasherArray[i2] = this.functions[i2].newHasher(n2);
        }
        return this.fromHashers(hasherArray);
    }
}

