/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.graph.BaseGraph;
import com.google.common.graph.Network;
import com.google.common.graph.SuccessorsFunction;
import com.google.common.graph.Traverser;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class Traverser<N> {
    private Traverser() {
    }

    public static <N> Traverser<N> forGraph(SuccessorsFunction<N> successorsFunction) {
        Preconditions.checkNotNull(successorsFunction);
        return new GraphTraverser<N>(successorsFunction);
    }

    public static <N> Traverser<N> forTree(SuccessorsFunction<N> successorsFunction) {
        Preconditions.checkNotNull(successorsFunction);
        if (successorsFunction instanceof BaseGraph) {
            Preconditions.checkArgument(((BaseGraph)successorsFunction).isDirected(), "Undirected graphs can never be trees.");
        }
        if (successorsFunction instanceof Network) {
            Preconditions.checkArgument(((Network)successorsFunction).isDirected(), "Undirected networks can never be trees.");
        }
        return new TreeTraverser<N>(successorsFunction);
    }

    public abstract Iterable<N> breadthFirst(Iterable<? extends N> var1);

    public abstract Iterable<N> breadthFirst(N var1);

    public abstract Iterable<N> depthFirstPostOrder(Iterable<? extends N> var1);

    public abstract Iterable<N> depthFirstPostOrder(N var1);

    public abstract Iterable<N> depthFirstPreOrder(Iterable<? extends N> var1);

    public abstract Iterable<N> depthFirstPreOrder(N var1);

    private static final class GraphTraverser<N>
    extends Traverser<N> {
        private final SuccessorsFunction<N> graph;

        GraphTraverser(SuccessorsFunction<N> successorsFunction) {
            this.graph = Preconditions.checkNotNull(successorsFunction);
        }

        private void checkThatNodeIsInGraph(N n2) {
            this.graph.successors(n2);
        }

        @Override
        public Iterable<N> breadthFirst(final Iterable<? extends N> iterable) {
            Preconditions.checkNotNull(iterable);
            if (Iterables.isEmpty(iterable)) {
                return ImmutableSet.of();
            }
            Iterator<N> iterator2 = iterable.iterator();
            while (iterator2.hasNext()) {
                this.checkThatNodeIsInGraph(iterator2.next());
            }
            return new Iterable<N>(){

                @Override
                public Iterator<N> iterator() {
                    return new BreadthFirstIterator(iterable);
                }
            };
        }

        @Override
        public Iterable<N> breadthFirst(N n2) {
            Preconditions.checkNotNull(n2);
            return this.breadthFirst((N)ImmutableSet.of(n2));
        }

        @Override
        public Iterable<N> depthFirstPostOrder(final Iterable<? extends N> iterable) {
            Preconditions.checkNotNull(iterable);
            if (Iterables.isEmpty(iterable)) {
                return ImmutableSet.of();
            }
            Iterator<N> iterator2 = iterable.iterator();
            while (iterator2.hasNext()) {
                this.checkThatNodeIsInGraph(iterator2.next());
            }
            return new Iterable<N>(){

                @Override
                public Iterator<N> iterator() {
                    return new DepthFirstIterator(iterable, Order.POSTORDER);
                }
            };
        }

        @Override
        public Iterable<N> depthFirstPostOrder(N n2) {
            Preconditions.checkNotNull(n2);
            return this.depthFirstPostOrder((N)ImmutableSet.of(n2));
        }

        @Override
        public Iterable<N> depthFirstPreOrder(final Iterable<? extends N> iterable) {
            Preconditions.checkNotNull(iterable);
            if (Iterables.isEmpty(iterable)) {
                return ImmutableSet.of();
            }
            Iterator<N> iterator2 = iterable.iterator();
            while (iterator2.hasNext()) {
                this.checkThatNodeIsInGraph(iterator2.next());
            }
            return new Iterable<N>(){

                @Override
                public Iterator<N> iterator() {
                    return new DepthFirstIterator(iterable, Order.PREORDER);
                }
            };
        }

        @Override
        public Iterable<N> depthFirstPreOrder(N n2) {
            Preconditions.checkNotNull(n2);
            return this.depthFirstPreOrder((N)ImmutableSet.of(n2));
        }

        private final class BreadthFirstIterator
        extends UnmodifiableIterator<N> {
            private final Queue<N> queue = new ArrayDeque();
            private final Set<N> visited = new HashSet();

            BreadthFirstIterator(Iterable<? extends N> object) {
                object = object.iterator();
                while (object.hasNext()) {
                    GraphTraverser.this = object.next();
                    if (!this.visited.add(GraphTraverser.this)) continue;
                    this.queue.add(GraphTraverser.this);
                }
            }

            @Override
            public boolean hasNext() {
                return this.queue.isEmpty() ^ true;
            }

            @Override
            public N next() {
                Object n2 = this.queue.remove();
                for (Object n3 : GraphTraverser.this.graph.successors(n2)) {
                    if (!this.visited.add(n3)) continue;
                    this.queue.add(n3);
                }
                return n2;
            }
        }

        private final class DepthFirstIterator
        extends AbstractIterator<N> {
            private final Order order;
            private final Deque<com.google.common.graph.Traverser$GraphTraverser$DepthFirstIterator.NodeAndSuccessors> stack = new ArrayDeque<com.google.common.graph.Traverser$GraphTraverser$DepthFirstIterator.NodeAndSuccessors>();
            private final Set<N> visited = new HashSet();

            DepthFirstIterator(Iterable<? extends N> iterable, Order order) {
                this.stack.push((com.google.common.graph.Traverser$GraphTraverser$DepthFirstIterator.NodeAndSuccessors)new NodeAndSuccessors(null, iterable));
                this.order = order;
            }

            @Override
            protected N computeNext() {
                NodeAndSuccessors nodeAndSuccessors;
                boolean bl;
                do {
                    boolean bl2;
                    block7: {
                        boolean bl3;
                        block6: {
                            if (this.stack.isEmpty()) {
                                return this.endOfData();
                            }
                            nodeAndSuccessors = (NodeAndSuccessors)this.stack.getFirst();
                            boolean bl4 = this.visited.add(nodeAndSuccessors.node);
                            boolean bl5 = nodeAndSuccessors.successorIterator.hasNext();
                            bl3 = true;
                            bl2 = bl5 ^ true;
                            if (!bl4) break block6;
                            bl = bl3;
                            if (this.order == Order.PREORDER) break block7;
                        }
                        bl = bl2 && this.order == Order.POSTORDER ? bl3 : false;
                    }
                    if (bl2) {
                        this.stack.pop();
                        continue;
                    }
                    Object n2 = nodeAndSuccessors.successorIterator.next();
                    if (this.visited.contains(n2)) continue;
                    this.stack.push((com.google.common.graph.Traverser$GraphTraverser$DepthFirstIterator.NodeAndSuccessors)this.withSuccessors(n2));
                } while (!bl || nodeAndSuccessors.node == null);
                return nodeAndSuccessors.node;
            }

            com.google.common.graph.Traverser$GraphTraverser$DepthFirstIterator.NodeAndSuccessors withSuccessors(N n2) {
                return new NodeAndSuccessors(n2, GraphTraverser.this.graph.successors(n2));
            }

            private final class NodeAndSuccessors {
                @NullableDecl
                final N node;
                final Iterator<? extends N> successorIterator;

                NodeAndSuccessors(N n2, Iterable<? extends N> iterable) {
                    this.node = n2;
                    this.successorIterator = iterable.iterator();
                }
            }
        }
    }

    private static enum Order {
        PREORDER,
        POSTORDER;

    }

    private static final class TreeTraverser<N>
    extends Traverser<N> {
        private final SuccessorsFunction<N> tree;

        TreeTraverser(SuccessorsFunction<N> successorsFunction) {
            this.tree = Preconditions.checkNotNull(successorsFunction);
        }

        private void checkThatNodeIsInTree(N n2) {
            this.tree.successors(n2);
        }

        @Override
        public Iterable<N> breadthFirst(final Iterable<? extends N> iterable) {
            Preconditions.checkNotNull(iterable);
            if (Iterables.isEmpty(iterable)) {
                return ImmutableSet.of();
            }
            Iterator<N> iterator2 = iterable.iterator();
            while (iterator2.hasNext()) {
                this.checkThatNodeIsInTree(iterator2.next());
            }
            return new Iterable<N>(){

                @Override
                public Iterator<N> iterator() {
                    return new BreadthFirstIterator(iterable);
                }
            };
        }

        @Override
        public Iterable<N> breadthFirst(N n2) {
            Preconditions.checkNotNull(n2);
            return this.breadthFirst((N)ImmutableSet.of(n2));
        }

        @Override
        public Iterable<N> depthFirstPostOrder(final Iterable<? extends N> iterable) {
            Preconditions.checkNotNull(iterable);
            if (Iterables.isEmpty(iterable)) {
                return ImmutableSet.of();
            }
            Iterator<N> iterator2 = iterable.iterator();
            while (iterator2.hasNext()) {
                this.checkThatNodeIsInTree(iterator2.next());
            }
            return new Iterable<N>(){

                @Override
                public Iterator<N> iterator() {
                    return new DepthFirstPostOrderIterator(iterable);
                }
            };
        }

        @Override
        public Iterable<N> depthFirstPostOrder(N n2) {
            Preconditions.checkNotNull(n2);
            return this.depthFirstPostOrder((N)ImmutableSet.of(n2));
        }

        @Override
        public Iterable<N> depthFirstPreOrder(final Iterable<? extends N> iterable) {
            Preconditions.checkNotNull(iterable);
            if (Iterables.isEmpty(iterable)) {
                return ImmutableSet.of();
            }
            Iterator<N> iterator2 = iterable.iterator();
            while (iterator2.hasNext()) {
                this.checkThatNodeIsInTree(iterator2.next());
            }
            return new Iterable<N>(){

                @Override
                public Iterator<N> iterator() {
                    return new DepthFirstPreOrderIterator(iterable);
                }
            };
        }

        @Override
        public Iterable<N> depthFirstPreOrder(N n2) {
            Preconditions.checkNotNull(n2);
            return this.depthFirstPreOrder((N)ImmutableSet.of(n2));
        }

        private final class BreadthFirstIterator
        extends UnmodifiableIterator<N> {
            private final Queue<N> queue = new ArrayDeque();

            BreadthFirstIterator(Iterable<? extends N> object) {
                object = object.iterator();
                while (object.hasNext()) {
                    TreeTraverser.this = object.next();
                    this.queue.add(TreeTraverser.this);
                }
            }

            @Override
            public boolean hasNext() {
                return this.queue.isEmpty() ^ true;
            }

            @Override
            public N next() {
                Object n2 = this.queue.remove();
                Iterables.addAll(this.queue, TreeTraverser.this.tree.successors(n2));
                return n2;
            }
        }

        private final class DepthFirstPostOrderIterator
        extends AbstractIterator<N> {
            private final ArrayDeque<com.google.common.graph.Traverser$TreeTraverser$DepthFirstPostOrderIterator.NodeAndChildren> stack = new ArrayDeque();

            DepthFirstPostOrderIterator(Iterable<? extends N> iterable) {
                this.stack.addLast((com.google.common.graph.Traverser$TreeTraverser$DepthFirstPostOrderIterator.NodeAndChildren)new NodeAndChildren(null, iterable));
            }

            @Override
            protected N computeNext() {
                while (!this.stack.isEmpty()) {
                    NodeAndChildren nodeAndChildren = (NodeAndChildren)this.stack.getLast();
                    if (nodeAndChildren.childIterator.hasNext()) {
                        nodeAndChildren = nodeAndChildren.childIterator.next();
                        this.stack.addLast((com.google.common.graph.Traverser$TreeTraverser$DepthFirstPostOrderIterator.NodeAndChildren)this.withChildren(nodeAndChildren));
                        continue;
                    }
                    this.stack.removeLast();
                    if (nodeAndChildren.node == null) continue;
                    return nodeAndChildren.node;
                }
                return this.endOfData();
            }

            com.google.common.graph.Traverser$TreeTraverser$DepthFirstPostOrderIterator.NodeAndChildren withChildren(N n2) {
                return new NodeAndChildren(n2, TreeTraverser.this.tree.successors(n2));
            }

            private final class NodeAndChildren {
                final Iterator<? extends N> childIterator;
                @NullableDecl
                final N node;

                NodeAndChildren(N n2, Iterable<? extends N> iterable) {
                    this.node = n2;
                    this.childIterator = iterable.iterator();
                }
            }
        }

        private final class DepthFirstPreOrderIterator
        extends UnmodifiableIterator<N> {
            private final Deque<Iterator<? extends N>> stack = new ArrayDeque();

            DepthFirstPreOrderIterator(Iterable<? extends N> iterable) {
                this.stack.addLast(iterable.iterator());
            }

            @Override
            public boolean hasNext() {
                return this.stack.isEmpty() ^ true;
            }

            @Override
            public N next() {
                Iterator<Object> iterator2 = this.stack.getLast();
                Object n2 = Preconditions.checkNotNull(iterator2.next());
                if (!iterator2.hasNext()) {
                    this.stack.removeLast();
                }
                if ((iterator2 = TreeTraverser.this.tree.successors(n2).iterator()).hasNext()) {
                    this.stack.addLast(iterator2);
                }
                return n2;
            }
        }
    }
}

